/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs.index;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.repository.sfs.index.CompactFileIndex;
import org.netbeans.modules.cnd.repository.sfs.index.FileIndex;
import org.netbeans.modules.cnd.repository.sfs.index.SimpleFileIndex;
import org.netbeans.modules.cnd.repository.support.AbstractObjectFactory;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

public class FileIndexFactory
extends AbstractObjectFactory {
    private static FileIndexFactory theFactory;
    private static final Object lock;
    private static final int FIRST_INDEX = 0;
    private static final int FILE_INDEX_SIMPLE = 0;
    private static final int FILE_INDEX_COMPACT = 1;
    public static final int LAST_INDEX = 1;

    protected FileIndexFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileIndexFactory getDefaultFactory() {
        Object object = lock;
        synchronized (object) {
            if (theFactory == null) {
                theFactory = new FileIndexFactory();
            }
        }
        return theFactory;
    }

    public void writeIndex(FileIndex fileIndex, DataOutput dataOutput) throws IOException {
        assert (fileIndex instanceof SelfPersistent);
        super.writeSelfPersistent((SelfPersistent)fileIndex, dataOutput);
    }

    public FileIndex readIndex(DataInput dataInput) throws IOException {
        assert (dataInput != null);
        SelfPersistent selfPersistent = super.readSelfPersistent(dataInput);
        assert (selfPersistent instanceof FileIndex);
        return (FileIndex)selfPersistent;
    }

    protected int getHandler(Object object) {
        int n;
        if (object instanceof SimpleFileIndex) {
            n = 0;
        } else if (object instanceof CompactFileIndex) {
            n = 1;
        } else {
            throw new IllegalArgumentException("The Index is an instance of the unknown final class " + object.getClass().getName());
        }
        return n;
    }

    protected SelfPersistent createObject(int n, DataInput dataInput) throws IOException {
        SelfPersistent selfPersistent;
        switch (n) {
            case 0: {
                selfPersistent = new SimpleFileIndex(dataInput);
                break;
            }
            case 1: {
                selfPersistent = new CompactFileIndex(dataInput);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown hander for index was provided: " + n);
            }
        }
        return selfPersistent;
    }

    static {
        lock = new Object();
    }
}

