/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemoryCache {
    private static final boolean STATISTIC = false;
    private static final int SLICE_SIZE = 19;
    private final SlicedMap cache = new SlicedMap();
    private final Lock refQueueLock = new ReentrantLock();
    private final ReferenceQueue refQueue = new ReferenceQueue();
    private int readCnt = 0;
    private int readHitCnt = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hang(Key key, Persistent persistent) {
        Slice slice = this.cache.getSilce(key);
        slice.w.lock();
        try {
            slice.storage.put(key, persistent);
        }
        finally {
            slice.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Key key, Persistent persistent, boolean bl) {
        Slice slice = this.cache.getSilce(key);
        SoftValue softValue = new SoftValue(persistent, key, this.refQueue);
        slice.w.lock();
        try {
            slice.storage.put(key, softValue);
        }
        finally {
            slice.w.unlock();
        }
        if (!bl) {
            this.processQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Persistent get(Key key) {
        Object v;
        Slice slice = this.cache.getSilce(key);
        slice.r.lock();
        try {
            v = slice.storage.get(key);
        }
        finally {
            slice.r.unlock();
        }
        if (v instanceof Persistent) {
            return (Persistent)v;
        }
        if (v instanceof SoftReference) {
            Persistent persistent = (Persistent)((SoftReference)v).get();
            return persistent;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Key key) {
        Slice slice = this.cache.getSilce(key);
        slice.w.lock();
        try {
            slice.storage.remove(key);
        }
        finally {
            slice.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSoftRefs() {
        this.processQueue();
        for (int i = 0; i < 19; ++i) {
            HashSet hashSet;
            Slice slice = this.cache.getSilce(i);
            slice.r.lock();
            try {
                hashSet = new HashSet(slice.storage.keySet());
            }
            finally {
                slice.r.unlock();
            }
            for (Key key : hashSet) {
                slice.w.lock();
                try {
                    Object v = slice.storage.get(key);
                    if (v == null || v instanceof Persistent) continue;
                    slice.storage.remove(key);
                }
                finally {
                    slice.w.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processQueue() {
        if (this.refQueueLock.tryLock()) {
            try {
                SoftValue softValue;
                while ((softValue = (SoftValue)this.refQueue.poll()) != null) {
                    Slice slice = this.cache.getSilce(softValue.key);
                    slice.w.lock();
                    try {
                        Object v = slice.storage.get(softValue.key);
                        if (v == null || !(v instanceof SoftReference) || ((SoftReference)v).get() != null) continue;
                        Object v2 = slice.storage.remove(softValue.key);
                        assert (v == v2);
                    }
                    finally {
                        slice.w.unlock();
                    }
                }
            }
            finally {
                this.refQueueLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Pair<Key, Persistent>> clearHungObjects() {
        this.processQueue();
        ArrayList<Pair<Key, Persistent>> arrayList = new ArrayList<Pair<Key, Persistent>>();
        for (int i = 0; i < 19; ++i) {
            HashSet hashSet;
            Slice slice = this.cache.getSilce(i);
            slice.r.lock();
            try {
                hashSet = new HashSet(slice.storage.keySet());
            }
            finally {
                slice.r.unlock();
            }
            for (Key key : hashSet) {
                Object v;
                slice.r.lock();
                try {
                    v = slice.storage.get(key);
                }
                finally {
                    slice.r.unlock();
                }
                if (!(v instanceof Persistent)) continue;
                arrayList.add(new Pair<Key, Persistent>(key, (Persistent)v));
                slice.w.lock();
                try {
                    slice.storage.remove(key);
                }
                finally {
                    slice.w.unlock();
                }
            }
        }
        return arrayList;
    }

    private void printStatistics(String string) {
        int n = this.readCnt == 0 ? 0 : this.readHitCnt * 100 / this.readCnt;
        System.out.printf("\n\nMemory cache statistics %s: %d reads,  %d hits (%d%%)\n\n", string, this.readCnt, this.readHitCnt, n);
    }

    private static final class SlicedMap {
        private final Slice[] slices = new Slice[19];

        private SlicedMap() {
            for (int i = 0; i < 19; ++i) {
                this.slices[i] = new Slice();
            }
        }

        private Slice getSilce(Key key) {
            int n = key.hashCode() % 19;
            if (n < 0) {
                n += 19;
            }
            return this.slices[n];
        }

        private Slice getSilce(int n) {
            return this.slices[n];
        }
    }

    private static final class Slice {
        private final Map<Key, Object> storage = new HashMap<Key, Object>(256);
        private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
        private final Lock w = this.cacheLock.writeLock();
        private final Lock r = this.cacheLock.readLock();

        private Slice() {
        }
    }

    private static class SoftValue
    extends SoftReference {
        private final Key key;

        private SoftValue(Object object, Key key, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.key = key;
        }
    }
}

