/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collections;
import java.util.LinkedHashMap;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.databinding.MidpDatabindingSupport;
import org.netbeans.modules.vmd.midp.propertyeditors.DatabindingElement;
import org.netbeans.modules.vmd.midp.propertyeditors.DatabindingElementUI;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertyEditorString
extends PropertyEditorUserCode
implements PropertyEditorElement {
    public static final int DEPENDENCE_NONE = 0;
    public static final int DEPENDENCE_TEXT_BOX = 1;
    public static final int DEPENDENCE_TEXT_FIELD = 2;
    private CustomEditor customEditor;
    private JRadioButton radioButton;
    private int dependence;
    private String comment;
    private String defaultValue;
    private boolean useTextArea;
    private TypeID parentTypeID;
    private String label;
    private DatabindingElement databindingElement;

    protected PropertyEditorString(String string, int n, boolean bl, String string2, TypeID typeID, boolean bl2) {
        super(NbBundle.getMessage(PropertyEditorString.class, (String)"LBL_STRING_STR"));
        this.comment = string;
        this.dependence = n;
        this.useTextArea = bl;
        this.label = string2;
        this.parentTypeID = typeID;
        this.initComponents();
        if (bl2) {
            LinkedHashMap<PropertyEditorElement, Integer> linkedHashMap = new LinkedHashMap<PropertyEditorElement, Integer>(2);
            this.databindingElement = new DatabindingElement(this);
            linkedHashMap.put(this, null);
            linkedHashMap.put(this.databindingElement, new Integer(-1));
            this.initElements(linkedHashMap);
        } else {
            this.initElements(Collections.singleton(this));
        }
    }

    private PropertyEditorString(String string, int n, String string2, String string3, boolean bl) {
        this(string, n, true, string3, null, bl);
        this.defaultValue = string2;
    }

    public static final PropertyEditorString createInstanceWithDatabinding(String string, int n, String string2, String string3) {
        return new PropertyEditorString(string, n, string2, string3, true);
    }

    public static final PropertyEditorString createInstanceWithDatabinding(String string, int n, boolean bl, String string2, TypeID typeID) {
        return new PropertyEditorString(string, n, bl, string2, typeID, true);
    }

    public static final PropertyEditorString createInstance(String string) {
        return new PropertyEditorString(null, 0, true, string, null, false);
    }

    public static final PropertyEditorString createInstanceWithDatabinding(String string) {
        return new PropertyEditorString(null, 0, true, string, null, true);
    }

    public static final PropertyEditorString createInstance(int n, String string) {
        return new PropertyEditorString(null, n, true, string, null, false);
    }

    public static final PropertyEditorString createInstanceWithDatabinding(int n, String string) {
        return new PropertyEditorString(null, n, true, string, null, true);
    }

    public static final PropertyEditorString createInstance(String string, TypeID typeID) {
        return new PropertyEditorString(null, 0, true, string, typeID, false);
    }

    public static final PropertyEditorString createTextFieldInstance(String string) {
        return new PropertyEditorString(null, 0, false, string, null, false);
    }

    public static final PropertyEditorString createInstanceWithDefaultValue(String string, String string2) {
        return new PropertyEditorString(null, 0, string, string2, false);
    }

    public static final PropertyEditorString createInstanceWithComment(String string, String string2) {
        return new PropertyEditorString(string, 0, null, string2, false);
    }

    public void cleanUp(DesignComponent designComponent) {
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.radioButton = null;
        this.parentTypeID = null;
        if (this.databindingElement != null) {
            this.databindingElement.clean(designComponent);
            this.databindingElement = null;
        }
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)this.label);
        this.radioButton.getAccessibleContext().setAccessibleName(this.radioButton.getText());
        this.radioButton.getAccessibleContext().setAccessibleDescription(this.radioButton.getText());
        this.customEditor = new CustomEditor(this.comment);
    }

    public Object getDefaultValue() {
        if (this.defaultValue == null) {
            return super.getDefaultValue();
        }
        return MidpTypes.createStringValue(this.defaultValue);
    }

    public JComponent getCustomEditorComponent() {
        return this.customEditor.getComponent();
    }

    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    public boolean isInitiallySelected() {
        return this.databindingElement == null;
    }

    public boolean isVerticallyResizable() {
        return this.useTextArea;
    }

    public String getAsText() {
        if (this.component == null || this.getPropertyNames() == null) {
            return null;
        }
        String string = MidpDatabindingSupport.getDatabaindingAsText((DesignComponent)this.component.get(), (String)this.getPropertyNames().get(0));
        if (string != null) {
            return string;
        }
        String string2 = super.getAsText();
        if (string2 != null) {
            return string2;
        }
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        return (String)propertyValue.getPrimitiveValue();
    }

    public void setTextForPropertyValue(String string) {
        this.saveValue(string);
    }

    public String getTextForPropertyValue() {
        return null;
    }

    public boolean canWrite() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return super.canWrite();
    }

    public Boolean canEditAsText() {
        if (MidpDatabindingSupport.getDatabaindingAsText((DesignComponent)this.component.get(), (String)this.getPropertyNames().get(0)) != null) {
            return false;
        }
        return super.canEditAsText();
    }

    public boolean supportsCustomEditor() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return super.supportsCustomEditor();
    }

    public void updateState(PropertyValue propertyValue) {
        DesignComponent designComponent = (DesignComponent)this.component.get();
        if (this.databindingElement != null) {
            this.databindingElement.updateDesignComponent(designComponent);
        }
        if (this.isCurrentValueANull() || propertyValue == null) {
            this.customEditor.setText(null);
        } else if (MidpDatabindingSupport.getDatabaindingAsText((DesignComponent)this.component.get(), (String)this.getPropertyNames().get(0)) != null) {
            ((DatabindingElementUI)this.databindingElement.getCustomEditorComponent()).updateComponent(designComponent);
        } else {
            this.customEditor.setText((String)propertyValue.getPrimitiveValue());
        }
        if (!this.isCurrentValueAUserCodeType()) {
            this.radioButton.setSelected(true);
            this.radioButton.requestFocus();
        }
    }

    public boolean executeInsideWriteTransaction() {
        if (this.component == null || this.component.get() == null) {
            return true;
        }
        DesignComponent designComponent = (DesignComponent)this.component.get();
        DesignComponent designComponent2 = MidpDatabindingSupport.getConnector(designComponent, (String)this.getPropertyNames().get(0));
        if (this.databindingElement != null && designComponent2 != null) {
            return false;
        }
        return super.isExecuteInsideWriteTransactionUsed();
    }

    public boolean isExecuteInsideWriteTransactionUsed() {
        if (this.component == null || this.component.get() == null) {
            return false;
        }
        DesignComponent designComponent = (DesignComponent)this.component.get();
        DesignComponent designComponent2 = MidpDatabindingSupport.getConnector(designComponent, (String)this.getPropertyNames().get(0));
        if (this.databindingElement != null && designComponent2 != null) {
            return true;
        }
        return super.isExecuteInsideWriteTransactionUsed();
    }

    private void saveValue(String string) {
        super.setValue((Object)MidpTypes.createStringValue(string));
        if (this.component == null || this.component.get() == null) {
            return;
        }
        final DesignComponent designComponent = (DesignComponent)this.component.get();
        final int n = string.length();
        switch (this.dependence) {
            case 1: {
                designComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

                    public void run() {
                        PropertyValue propertyValue = designComponent.readProperty("maxSize");
                        if (MidpTypes.getInteger(propertyValue) < n) {
                            designComponent.writeProperty("maxSize", MidpTypes.createIntegerValue(n));
                        }
                    }
                });
                break;
            }
            case 2: {
                designComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

                    public void run() {
                        PropertyValue propertyValue = designComponent.readProperty("maxSize");
                        if (MidpTypes.getInteger(propertyValue) < n) {
                            designComponent.writeProperty("maxSize", MidpTypes.createIntegerValue(n));
                        }
                    }
                });
            }
        }
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
        }
        DesignComponent designComponent = (DesignComponent)this.component.get();
        if (this.databindingElement != null && this.databindingElement.getRadioButton().isSelected()) {
            ((DatabindingElementUI)this.databindingElement.getCustomEditorComponent()).saveToModel(designComponent);
        } else if (this.databindingElement != null) {
            ((DatabindingElementUI)this.databindingElement.getCustomEditorComponent()).resetValuesInModel(designComponent);
        }
    }

    private boolean isWriteableByParentType() {
        if (this.component == null || this.component.get() == null) {
            return false;
        }
        if (this.parentTypeID != null) {
            final DesignComponent designComponent = (DesignComponent)this.component.get();
            final DesignComponent[] designComponentArray = new DesignComponent[1];
            designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    designComponentArray[0] = designComponent.getParentComponent();
                }
            });
            if (designComponentArray[0] != null && this.parentTypeID.equals((Object)designComponentArray[0].getType())) {
                return false;
            }
        }
        return true;
    }

    private class CustomEditor
    implements DocumentListener {
        private JPanel panel;
        private JTextComponent editorPane;
        private String comment;

        public CustomEditor(String string) {
            this.comment = string;
            this.initComponents();
        }

        void cleanUp() {
            if (this.editorPane != null && this.editorPane.getDocument() != null) {
                this.editorPane.getDocument().removeDocumentListener(this);
            }
            this.editorPane = null;
            this.panel.removeAll();
            this.panel = null;
        }

        private void initComponents() {
            JComponent jComponent;
            this.panel = new JPanel(new GridBagLayout());
            if (PropertyEditorString.this.useTextArea) {
                this.editorPane = new JTextArea();
                jComponent = new JScrollPane();
                ((JScrollPane)jComponent).setViewportView(this.editorPane);
                ((JScrollPane)jComponent).setPreferredSize(new Dimension(400, 100));
            } else {
                this.editorPane = new JTextField();
                jComponent = this.editorPane;
            }
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)PropertyEditorString.this.label);
            this.editorPane.getAccessibleContext().setAccessibleName(jLabel.getText());
            this.editorPane.getAccessibleContext().setAccessibleDescription(jLabel.getText());
            jLabel = null;
            this.editorPane.getDocument().addDocumentListener(this);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.panel.add((Component)jComponent, gridBagConstraints);
            if (this.comment != null) {
                JLabel jLabel2 = new JLabel(this.comment);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.ipadx = 1;
                gridBagConstraints.ipady = 10;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                this.panel.add((Component)jLabel2, gridBagConstraints);
            }
        }

        public JComponent getComponent() {
            return this.panel;
        }

        public void setText(String string) {
            this.editorPane.setText(string);
        }

        public String getText() {
            return this.editorPane.getText();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.editorPane.hasFocus()) {
                PropertyEditorString.this.radioButton.setSelected(true);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.editorPane.hasFocus()) {
                PropertyEditorString.this.radioButton.setSelected(true);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

