/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.resources.FontCD;
import org.netbeans.modules.vmd.midp.propertyeditors.MidpPropertyEditorSupport;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyEditorComboBox
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private final Map<String, PropertyValue> values;
    private String[] tags;
    private String valueLabel;
    private TypeID typeID;
    private TypeID enableTypeID;
    private CustomEditor customEditor;
    private JRadioButton radioButton;
    private static String[] USERCODE_TAGS = new String[]{PropertyEditorUserCode.USER_CODE_TEXT};

    @Override
    public void cleanUp(DesignComponent designComponent) {
        super.cleanUp(designComponent);
        this.typeID = null;
        this.tags = null;
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.radioButton = null;
        this.enableTypeID = null;
    }

    private PropertyEditorComboBox(Map<String, PropertyValue> map, TypeID typeID, TypeID typeID2, String string, String string2) {
        super(string2);
        this.values = map;
        this.typeID = typeID;
        this.enableTypeID = typeID2;
        this.valueLabel = string;
        this.createTags();
        this.initComponents();
        this.initElements(Collections.singleton(this));
    }

    public static PropertyEditorComboBox createInstance(Map<String, PropertyValue> map, TypeID typeID, String string, String string2) {
        return PropertyEditorComboBox.createInstance(map, typeID, null, string, string2);
    }

    public static PropertyEditorComboBox createInstance(Map<String, PropertyValue> map, TypeID typeID, TypeID typeID2, String string, String string2) {
        if (map == null) {
            throw new IllegalArgumentException("Argument values can't be null");
        }
        for (String string3 : map.keySet()) {
            PropertyValue propertyValue = map.get(string3);
            if (propertyValue != null) continue;
            throw new IllegalArgumentException("PropertyValue for " + string3 + " key can't be null");
        }
        PropertyEditorComboBox propertyEditorComboBox = new PropertyEditorComboBox(map, typeID, typeID2, string, string2);
        return propertyEditorComboBox;
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)this.valueLabel);
        this.radioButton.getAccessibleContext().setAccessibleName(this.radioButton.getText());
        this.radioButton.getAccessibleContext().setAccessibleDescription(this.radioButton.getText());
        this.customEditor = new CustomEditor();
        this.customEditor.updateModel();
    }

    @Override
    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    @Override
    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    @Override
    public boolean isInitiallySelected() {
        return true;
    }

    @Override
    public boolean isVerticallyResizable() {
        return false;
    }

    @Override
    public String getAsText() {
        String string = super.getAsText();
        if (string != null) {
            return string;
        }
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        for (String string2 : this.values.keySet()) {
            PropertyValue propertyValue2 = this.values.get(string2);
            if (!propertyValue.getPrimitiveValue().equals(propertyValue2.getPrimitiveValue())) continue;
            return string2;
        }
        return NbBundle.getMessage(PropertyEditorComboBox.class, (String)"LBL_MULTIPLE");
    }

    @Override
    public void setTextForPropertyValue(String string) {
        this.saveValue(string);
    }

    @Override
    public String getTextForPropertyValue() {
        return null;
    }

    @Override
    public void updateState(PropertyValue propertyValue) {
        if (!this.isCurrentValueANull() && propertyValue != null) {
            this.customEditor.setValue(propertyValue);
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue(String string) {
        PropertyValue propertyValue;
        if (string.length() > 0 && (propertyValue = this.values.get(string)) != null) {
            super.setValue((Object)propertyValue);
        }
    }

    @Override
    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
        }
    }

    public String[] getTags() {
        if (this.isCurrentValueAUserCodeType()) {
            return USERCODE_TAGS;
        }
        return this.tags;
    }

    private void createTags() {
        int n = 0;
        this.tags = new String[this.values.size()];
        for (String string : this.values.keySet()) {
            this.tags[n++] = string;
        }
    }

    @Override
    public Boolean canEditAsText() {
        return null;
    }

    @Override
    public boolean canWrite() {
        final boolean[] blArray = new boolean[]{true};
        if (!MidpPropertyEditorSupport.singleSelectionEditAsTextOnly()) {
            blArray[0] = false;
        } else if (this.enableTypeID != null && this.enableTypeID == FontCD.TYPEID && this.component != null && this.component.get() != null) {
            final DesignComponent designComponent = (DesignComponent)this.component.get();
            designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    int n = MidpTypes.getInteger(designComponent.readProperty("fontKind"));
                    blArray[0] = n == 1;
                }
            });
        }
        return blArray[0];
    }

    private class CustomEditor
    extends JPanel
    implements ActionListener {
        private JComboBox combobox;

        void cleanUp() {
            this.combobox.removeActionListener(this);
            this.combobox = null;
            this.removeAll();
        }

        public CustomEditor() {
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.combobox = new JComboBox();
            this.combobox.setModel(new DefaultComboBoxModel());
            this.combobox.addActionListener(this);
            this.combobox.getAccessibleContext().setAccessibleName(PropertyEditorComboBox.this.radioButton.getAccessibleContext().getAccessibleName());
            this.combobox.getAccessibleContext().setAccessibleDescription(PropertyEditorComboBox.this.radioButton.getAccessibleContext().getAccessibleDescription());
            this.add((Component)this.combobox, "Center");
        }

        public void setValue(PropertyValue propertyValue) {
            for (String string : PropertyEditorComboBox.this.values.keySet()) {
                if (!((PropertyValue)PropertyEditorComboBox.this.values.get(string)).getPrimitiveValue().equals(propertyValue.getPrimitiveValue())) continue;
                this.combobox.setSelectedItem(string);
                break;
            }
        }

        public String getText() {
            return (String)this.combobox.getSelectedItem();
        }

        public void updateModel() {
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.combobox.getModel();
            defaultComboBoxModel.removeAllElements();
            for (String string : PropertyEditorComboBox.this.tags) {
                defaultComboBoxModel.addElement(string);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PropertyEditorComboBox.this.radioButton.setSelected(true);
        }
    }
}

