/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.properties.DesignPropertyEditor;
import org.netbeans.modules.vmd.api.properties.GroupPropertyEditor;
import org.netbeans.modules.vmd.api.properties.GroupValue;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.util.NbBundle;

public class PropertyEditorArrayInteger
extends GroupPropertyEditor
implements ExPropertyEditor {
    private static String ERROR_WARNING = NbBundle.getMessage(PropertyEditorArrayInteger.class, (String)"MSG_ILLEGAL_FORMATING");
    private WeakReference<DesignComponent> component;
    private Object parentTypeID;

    public static DesignPropertyEditor create() {
        return new PropertyEditorArrayInteger();
    }

    public static DesignPropertyEditor create(TypeID typeID) {
        return new PropertyEditorArrayInteger(typeID);
    }

    private PropertyEditorArrayInteger() {
    }

    private PropertyEditorArrayInteger(TypeID typeID) {
        this.parentTypeID = typeID;
    }

    public void cleanUp(DesignComponent designComponent) {
        super.cleanUp(designComponent);
        this.component = null;
        this.parentTypeID = null;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public String getAsText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        GroupValue groupValue = this.getValue();
        Iterator<String> iterator = Arrays.asList(this.getValue().getPropertyNames()).iterator();
        while (iterator.hasNext()) {
            PropertyValue propertyValue = (PropertyValue)groupValue.getValue(iterator.next());
            stringBuffer.append(propertyValue.getPrimitiveValue());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public void setAsText(String string) {
        String string2 = this.decodeValuesFromText(string);
        if (string2 == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)(ERROR_WARNING + ' ' + string)));
        } else {
            GroupValue groupValue = this.getValue();
            Iterator<String> iterator = Arrays.asList(groupValue.getPropertyNames()).iterator();
            for (String string3 : string2.split(",")) {
                groupValue.putValue(iterator.next(), (Object)MidpTypes.createIntegerValue(Integer.parseInt(string3)));
            }
            this.setValue(groupValue);
        }
    }

    private String decodeValuesFromText(String string) {
        string = string.trim().replaceAll(Pattern.compile("[\\[$\\]]").pattern(), "");
        if (Pattern.compile("[^0123456789,]").matcher(string).find() || string.split(",").length != this.getValue().getPropertyNames().length) {
            return null;
        }
        return string;
    }

    public Boolean canEditAsText() {
        return true;
    }

    public boolean canWrite() {
        if (this.component.get() == null) {
            return super.canWrite();
        }
        final DesignComponent[] designComponentArray = new DesignComponent[1];
        ((DesignComponent)this.component.get()).getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                designComponentArray[0] = ((DesignComponent)PropertyEditorArrayInteger.this.component.get()).getParentComponent();
            }
        });
        if (this.parentTypeID != null && designComponentArray[0] != null && designComponentArray[0].getType().equals(this.parentTypeID)) {
            return false;
        }
        return super.canWrite();
    }

    public void init(DesignComponent designComponent) {
        this.component = new WeakReference<DesignComponent>(designComponent);
    }

    public void customEditorResetToDefaultButtonPressed() {
        if (!(this.getValue() instanceof GroupValue)) {
            throw new IllegalArgumentException();
        }
        GroupValue groupValue = this.getValue();
        for (String string : groupValue.getPropertyNames()) {
            ((DesignComponent)this.component.get()).writeProperty(string, MidpTypes.createIntegerValue(0));
        }
    }
}

