/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.common.project.classpath.ClassPathSupport;
import org.netbeans.modules.j2ee.common.project.ui.ClassPathUiSupport;
import org.netbeans.modules.j2ee.common.project.ui.EditMediator;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.spi.java.project.support.ui.SharableLibrariesUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CustomizerLibraries
extends JPanel
implements HelpCtx.Provider,
ListDataListener {
    private EarProjectProperties uiProperties;
    private boolean isSharable;
    private JButton jButtonAddJar;
    private JButton jButtonAddLib;
    private JButton jButtonAddProject;
    private JButton jButtonEdit;
    private JButton jButtonMoveDown;
    private JButton jButtonMoveUp;
    private JButton jButtonRemove;
    private JLabel jLabelEmbeddedCP;
    private JLabel jLabelErrorMessage;
    private JList jListCp;
    private JScrollPane jScrollPane2;
    private JButton librariesBrowse;
    private JTextField librariesLocation;
    private JLabel sharedLibrariesLabel;

    public CustomizerLibraries(EarProjectProperties earProjectProperties) {
        this.uiProperties = earProjectProperties;
        this.initComponents();
        this.jListCp.setModel(earProjectProperties.DEBUG_CLASSPATH_MODEL);
        this.jListCp.setCellRenderer(earProjectProperties.CLASS_PATH_LIST_RENDERER);
        EditMediator.register((Project)earProjectProperties.getProject(), (AntProjectHelper)earProjectProperties.getProject().getAntProjectHelper(), (ReferenceHelper)earProjectProperties.getProject().getReferenceHelper(), (EditMediator.ListComponent)EditMediator.createListComponent((JList)this.jListCp), (ButtonModel)this.jButtonAddJar.getModel(), (ButtonModel)this.jButtonAddLib.getModel(), (ButtonModel)this.jButtonAddProject.getModel(), (ButtonModel)this.jButtonRemove.getModel(), (ButtonModel)this.jButtonMoveUp.getModel(), (ButtonModel)this.jButtonMoveDown.getModel(), (ButtonModel)this.jButtonEdit.getModel(), (Document)earProjectProperties.SHARED_LIBRARIES_MODEL, null, (String[])new String[]{"j2ee_ear_archive", "jar", "folder"}, (FileFilter)EditMediator.JAR_ZIP_FILTER, (int)2);
        this.librariesLocation.setDocument(earProjectProperties.SHARED_LIBRARIES_MODEL);
        this.testBroken();
        earProjectProperties.DEBUG_CLASSPATH_MODEL.addListDataListener(this);
        this.isSharable = earProjectProperties.getProject().getAntProjectHelper().isSharableProject();
        if (!this.isSharable) {
            this.sharedLibrariesLabel.setEnabled(false);
            this.librariesLocation.setEnabled(false);
            this.librariesBrowse.setText(NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_CustomizeLibraries_MakeSharable"));
        } else {
            this.librariesLocation.setText(earProjectProperties.getProject().getAntProjectHelper().getLibrariesLocation());
        }
    }

    private void testBroken() {
        DefaultListModel[] defaultListModelArray = new DefaultListModel[]{this.uiProperties.DEBUG_CLASSPATH_MODEL};
        boolean bl = false;
        for (int i = 0; i < defaultListModelArray.length; ++i) {
            Iterator iterator = ClassPathUiSupport.getIterator((DefaultListModel)defaultListModelArray[i]);
            while (iterator.hasNext()) {
                if (!((ClassPathSupport.Item)iterator.next()).isBroken()) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        if (bl) {
            this.jLabelErrorMessage.setText(NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_CustomizeLibraries_Libraries_Error"));
        } else {
            this.jLabelErrorMessage.setText(" ");
        }
    }

    private static String[] splitPath(String string) {
        int n = Math.max(string.lastIndexOf(47), string.lastIndexOf(92));
        if (n == -1) {
            return new String[]{string, null};
        }
        return new String[]{string.substring(0, n), string.substring(n + 1)};
    }

    private void switchLibrary() {
        LibraryManager libraryManager;
        Object object;
        DefaultListModel[] defaultListModelArray;
        String string = this.librariesLocation.getText();
        if (string.trim().length() > -1) {
            try {
                defaultListModelArray = FileUtil.toFile((FileObject)this.uiProperties.getProject().getProjectDirectory());
                File file = FileUtil.normalizeFile((File)PropertyUtils.resolveFile((File)defaultListModelArray, (String)string));
                object = file.toURI().toURL();
                libraryManager = LibraryManager.forLocation((URL)object);
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
                libraryManager = LibraryManager.getDefault();
            }
        } else {
            libraryManager = LibraryManager.getDefault();
        }
        defaultListModelArray = new DefaultListModel[]{this.uiProperties.DEBUG_CLASSPATH_MODEL};
        for (int i = 0; i < defaultListModelArray.length; ++i) {
            object = ClassPathUiSupport.getIterator((DefaultListModel)defaultListModelArray[i]);
            while (object.hasNext()) {
                ClassPathSupport.Item item = (ClassPathSupport.Item)object.next();
                if (item.getType() != 1) continue;
                item.reassignLibraryManager(libraryManager);
            }
        }
        this.jListCp.repaint();
        this.testBroken();
    }

    private void initComponents() {
        this.jLabelEmbeddedCP = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jListCp = new JList();
        this.jButtonAddJar = new JButton();
        this.jButtonAddLib = new JButton();
        this.jButtonAddProject = new JButton();
        this.jButtonRemove = new JButton();
        this.sharedLibrariesLabel = new JLabel();
        this.librariesLocation = new JTextField();
        this.librariesBrowse = new JButton();
        this.jButtonEdit = new JButton();
        this.jButtonMoveUp = new JButton();
        this.jButtonMoveDown = new JButton();
        this.jLabelErrorMessage = new JLabel();
        this.jLabelEmbeddedCP.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.jLabelEmbeddedCP, (String)NbBundle.getBundle(CustomizerLibraries.class).getString("LBL_CustomizerRun_EmbeddedClasspathElements_JLabel"));
        this.jLabelEmbeddedCP.setVerticalAlignment(1);
        this.jScrollPane2.setPreferredSize(new Dimension(252, 202));
        this.jScrollPane2.setViewportView(this.jListCp);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonAddJar, (String)NbBundle.getBundle(CustomizerLibraries.class).getString("LBL_CustomizeEAR_AddJar_JButton"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonAddLib, (String)NbBundle.getBundle(CustomizerLibraries.class).getString("LBL_CustomizeCompile_Classpath_AddLibrary_JButton"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonAddProject, (String)NbBundle.getBundle(CustomizerLibraries.class).getString("LBL_CustomizeCompile_Classpath_AddProject_JButton"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonRemove, (String)NbBundle.getBundle(CustomizerLibraries.class).getString("LBL_CustomizeCompile_Classpath_Remove_JButton"));
        Mnemonics.setLocalizedText((JLabel)this.sharedLibrariesLabel, (String)MessageFormat.format(NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_CustomizeGeneral_SharedLibraries"), new Object[0]));
        this.librariesLocation.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.librariesBrowse, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_CustomizerLibraries_Browse_JButton"));
        this.librariesBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerLibraries.this.librariesBrowseActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonEdit, (String)NbBundle.getBundle(CustomizerLibraries.class).getString("LBL_CustomizeCompile_Classpath_Edit_JButton"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonMoveUp, (String)NbBundle.getBundle(CustomizerLibraries.class).getString("LBL_CustomizeCompile_Classpath_MoveUp_JButton"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonMoveDown, (String)NbBundle.getBundle(CustomizerLibraries.class).getString("LBL_CustomizeCompile_Classpath_MoveDown_JButton"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelErrorMessage, (String)" ");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabelEmbeddedCP).addContainerGap()).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.sharedLibrariesLabel).addPreferredGap(0).add((Component)this.librariesLocation, -1, 333, Short.MAX_VALUE)).add((Component)this.jScrollPane2, -1, 414, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add(2, (Component)this.librariesBrowse, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonAddProject, -1, 119, Short.MAX_VALUE).add(2, (Component)this.jButtonAddLib, -1, 119, Short.MAX_VALUE).add(2, (Component)this.jButtonAddJar, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonEdit, -1, 119, Short.MAX_VALUE).add(2, (Component)this.jButtonRemove, -1, 119, Short.MAX_VALUE).add(2, (Component)this.jButtonMoveUp, -1, 119, Short.MAX_VALUE).add(2, (Component)this.jButtonMoveDown, -1, 119, Short.MAX_VALUE))).add((Component)this.jLabelErrorMessage, -1, 539, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.sharedLibrariesLabel).add((Component)this.librariesLocation, -2, -1, -2).add((Component)this.librariesBrowse)).addPreferredGap(0).add((Component)this.jLabelEmbeddedCP).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jButtonAddProject).addPreferredGap(0).add((Component)this.jButtonAddLib).addPreferredGap(0).add((Component)this.jButtonAddJar).addPreferredGap(1).add((Component)this.jButtonEdit).addPreferredGap(1).add((Component)this.jButtonRemove).addPreferredGap(1).add((Component)this.jButtonMoveUp).addPreferredGap(0).add((Component)this.jButtonMoveDown)).add((Component)this.jScrollPane2, -1, 271, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jLabelErrorMessage)));
    }

    private void librariesBrowseActionPerformed(ActionEvent actionEvent) {
        if (!this.isSharable) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            this.collectLibs(this.uiProperties.DEBUG_CLASSPATH_MODEL, arrayList, arrayList2);
            this.collectLibs(this.uiProperties.EAR_CONTENT_ADDITIONAL_MODEL.getDefaultListModel(), arrayList, arrayList2);
            arrayList.add("CopyLibs");
            boolean bl = SharableLibrariesUtils.showMakeSharableWizard((AntProjectHelper)this.uiProperties.getProject().getAntProjectHelper(), (ReferenceHelper)this.uiProperties.getProject().getReferenceHelper(), arrayList, arrayList2);
            if (bl) {
                this.isSharable = true;
                this.sharedLibrariesLabel.setEnabled(true);
                this.librariesLocation.setEnabled(true);
                this.librariesLocation.setText(this.uiProperties.getProject().getAntProjectHelper().getLibrariesLocation());
                Mnemonics.setLocalizedText((AbstractButton)this.librariesBrowse, (String)NbBundle.getMessage(CustomizerLibraries.class, (String)"LBL_CustomizerLibraries_Browse_JButton"));
                this.updateJars(this.uiProperties.DEBUG_CLASSPATH_MODEL);
                this.switchLibrary();
            }
        } else {
            File file = FileUtil.toFile((FileObject)this.uiProperties.getProject().getProjectDirectory());
            String[] stringArray = CustomizerLibraries.splitPath(this.librariesLocation.getText().trim());
            String string = SharableLibrariesUtils.browseForLibraryLocation((String)stringArray[0], (Component)this, (File)file);
            if (string != null) {
                this.librariesLocation.setText(stringArray[1] != null ? string + File.separator + stringArray[1] : string + File.separator + "nblibraries.properties");
                this.switchLibrary();
            }
        }
    }

    private void collectLibs(DefaultListModel defaultListModel, List<String> list, List<String> list2) {
        for (int i = 0; i < defaultListModel.size(); ++i) {
            ClassPathSupport.Item item = (ClassPathSupport.Item)defaultListModel.get(i);
            if (item.getType() == 1 && !item.isBroken() && !list.contains(item.getLibrary().getName())) {
                list.add(item.getLibrary().getName());
            }
            if (item.getType() != 0 || item.getReference() == null || item.getVariableBasedProperty() != null || list2.contains(item.getReference())) continue;
            list2.add(item.getReference());
        }
    }

    private void updateJars(DefaultListModel defaultListModel) {
        for (int i = 0; i < defaultListModel.size(); ++i) {
            ClassPathSupport.Item item = (ClassPathSupport.Item)defaultListModel.get(i);
            if (item.getType() != 0 || item.getReference() == null) continue;
            item.updateJarReference(this.uiProperties.getProject().getAntProjectHelper());
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerLibraries.class);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.testBroken();
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.testBroken();
    }
}

