/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.panels;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.profiler.attach.panels.ManualIntegrationPanel;
import org.netbeans.modules.profiler.attach.panels.components.StepsPanelComponent;
import org.netbeans.modules.profiler.attach.providers.TargetPlatformEnum;
import org.netbeans.modules.profiler.attach.spi.IntegrationProvider;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ManualIntegrationPanelUI
extends JPanel
implements ListDataListener {
    private ManualIntegrationPanel.Model model;
    private DefaultListModel listModel = null;
    private JComboBox comboJvms;
    private JButton generateRemotePack;
    private JTextArea label;
    private StepsPanelComponent stepsPanel;

    ManualIntegrationPanelUI(ManualIntegrationPanel.Model model) {
        this.model = model;
        this.initComponents();
    }

    private void initComponents() {
        this.generateRemotePack = new JButton();
        this.stepsPanel = new StepsPanelComponent();
        this.label = new JTextArea();
        this.comboJvms = new JComboBox();
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setMaximumSize(new Dimension(800, 600));
        this.setMinimumSize(new Dimension(200, 300));
        this.setPreferredSize(new Dimension(500, 400));
        Mnemonics.setLocalizedText((AbstractButton)this.generateRemotePack, (String)NbBundle.getMessage(ManualIntegrationPanelUI.class, (String)"ManualIntegrationPanelUI.generateRemotePack.text"));
        this.generateRemotePack.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ManualIntegrationPanelUI.this.generateRemotePackActionPerformed(actionEvent);
            }
        });
        this.stepsPanel.setTitle(NbBundle.getMessage(ManualIntegrationPanelUI.class, (String)"ManualIntegrationStepsWizardPanelUI_ManualIntegrationHintMsg"));
        this.label.setEditable(false);
        this.label.setLineWrap(true);
        this.label.setText(NbBundle.getMessage(ManualIntegrationPanelUI.class, (String)"TargetJVMWizardPanelUI_SelectJvmString"));
        this.label.setWrapStyleWord(true);
        this.label.setDisabledTextColor(UIManager.getDefaults().getColor("Label.foreground"));
        this.label.setEnabled(false);
        this.label.setMinimumSize(new Dimension(0, 0));
        this.label.setOpaque(false);
        this.comboJvms.setModel(new DefaultComboBoxModel<String>(new String[]{"Java"}));
        this.comboJvms.setMaximumSize(new Dimension(470, 24));
        this.comboJvms.setMinimumSize(new Dimension(200, 24));
        this.comboJvms.setPreferredSize(new Dimension(466, 24));
        this.comboJvms.getModel().addListDataListener(this);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.label, -1, 472, Short.MAX_VALUE).add((Component)this.comboJvms, 0, 472, Short.MAX_VALUE).add((Component)this.stepsPanel, -1, 472, Short.MAX_VALUE).add(2, (Component)this.generateRemotePack)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.label, -2, -1, -2).addPreferredGap(0).add((Component)this.comboJvms, -2, -1, -2).addPreferredGap(1).add((Component)this.stepsPanel, -1, 272, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.generateRemotePack).addContainerGap()));
        this.comboJvms.getAccessibleContext().setAccessibleDescription("null");
    }

    private void generateRemotePackActionPerformed(ActionEvent actionEvent) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    JFileChooser jFileChooser = new JFileChooser();
                    File file = new File(System.getProperty("java.io.tmpdir"));
                    jFileChooser.setDialogTitle(ResourceBundle.getBundle("org/netbeans/modules/profiler/attach/panels/Bundle").getString("ManualIntegrationPanelUI_ChooseRemotePackDestination"));
                    jFileChooser.setAcceptAllFileFilterUsed(false);
                    jFileChooser.setFileSelectionMode(1);
                    jFileChooser.setSelectedFile(file);
                    jFileChooser.setCurrentDirectory(file);
                    jFileChooser.setMultiSelectionEnabled(false);
                    if ((1 & jFileChooser.showSaveDialog(ManualIntegrationPanelUI.this)) == 0) {
                        String string = ManualIntegrationPanelUI.this.model.exportRemotePack(jFileChooser.getSelectedFile().getAbsolutePath());
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)(ResourceBundle.getBundle("org/netbeans/modules/profiler/attach/panels/Bundle").getString("ManualIntegrationPanelUI_RemotePackSavedAs") + string), 1));
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        });
    }

    public ComboBoxModel getJvmListModel() {
        return new DefaultComboBoxModel(){

            public Object getElementAt(int n) {
                return ManualIntegrationPanelUI.this.model.getSupportedJvms() != null ? ManualIntegrationPanelUI.this.model.getSupportedJvms().get(n) : null;
            }

            public Object getSelectedItem() {
                return ManualIntegrationPanelUI.this.model.getJvm();
            }

            public int getSize() {
                return ManualIntegrationPanelUI.this.model.getSupportedJvms() != null ? ManualIntegrationPanelUI.this.model.getSupportedJvms().size() : 0;
            }

            public void setSelectedItem(Object object) {
                ManualIntegrationPanelUI.this.model.setJvm((TargetPlatformEnum)object);
                ManualIntegrationPanelUI.this.showIntegrationHints();
            }
        };
    }

    public void refresh() {
        List list = this.model.getSupportedJvms();
        TargetPlatformEnum targetPlatformEnum = TargetPlatformEnum.JDK5;
        if (this.model.getJvm() == null || !list.contains(this.model.getJvm())) {
            if (!list.contains(targetPlatformEnum)) {
                targetPlatformEnum = (TargetPlatformEnum)list.get(0);
            }
        } else {
            targetPlatformEnum = this.model.getJvm();
        }
        ((DefaultComboBoxModel)this.comboJvms.getModel()).removeAllElements();
        Iterator iterator = this.model.getSupportedJvms().iterator();
        while (iterator.hasNext()) {
            ((DefaultComboBoxModel)this.comboJvms.getModel()).addElement(iterator.next());
        }
        this.comboJvms.setSelectedItem(targetPlatformEnum);
        this.showIntegrationHints();
        this.label.setText(MessageFormat.format(NbBundle.getMessage(ManualIntegrationPanel.class, (String)"TargetJVMWizardPanelUI_SelectJvmString"), this.model.getApplication()));
        this.generateRemotePack.setVisible(this.model.isRemote());
    }

    private void showIntegrationHints() {
        IntegrationProvider.IntegrationHints integrationHints = this.model.getIntegrationHints();
        this.stepsPanel.setTitle(MessageFormat.format(NbBundle.getMessage(ManualIntegrationPanel.class, (String)"ManualIntegrationStepsWizardPanelUI_ManualIntegrationHintMsg"), this.model.getApplication()));
        this.stepsPanel.setSteps(this.model.getIntegrationHints());
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.model.setJvm((TargetPlatformEnum)this.comboJvms.getSelectedItem());
        this.showIntegrationHints();
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }
}

