/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.panels;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.profiler.attach.panels.AttachSettingsPanel;
import org.netbeans.modules.profiler.attach.panels.components.ButtonGroupEx;
import org.netbeans.modules.profiler.attach.panels.components.ResizableHintPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AttachSettingsPanelUI
extends JPanel {
    private final String SELECT_GROUP_TITLE = NbBundle.getMessage(this.getClass(), (String)"AttachWizard_SelectTargetTypeForceString");
    private final String SELECT_TARGET_TITLE = NbBundle.getMessage(this.getClass(), (String)"AttachWizard_SelectTargetForceString");
    private JPanel blankPanel;
    private JRadioButton buttonDirect;
    private JRadioButton buttonDynamic16;
    private JRadioButton buttonLocal;
    private JRadioButton buttonRemote;
    private JComboBox comboGroups;
    private JComboBox comboTargets;
    private ButtonGroupEx groupInvocation;
    private ButtonGroupEx groupMethod;
    private ResizableHintPanel hintPanel;
    private JPanel jPanel1;
    private JLabel labelTargetName;
    private JLabel labelTargetType;
    private JPanel panelDetails;
    private JPanel panelInvocation;
    private JPanel panelMethod;
    private JPanel panelType;
    private AttachSettingsPanel.PanelModel model;

    public AttachSettingsPanelUI(AttachSettingsPanel.PanelModel panelModel) {
        this.model = panelModel;
        this.initComponents();
        this.loadModel();
    }

    private void initComponents() {
        this.groupMethod = new ButtonGroupEx();
        this.groupInvocation = new ButtonGroupEx();
        this.panelType = new JPanel();
        this.labelTargetType = new JLabel();
        this.comboGroups = new JComboBox();
        this.labelTargetName = new JLabel();
        this.comboTargets = new JComboBox();
        this.panelDetails = new JPanel();
        this.panelMethod = new JPanel();
        this.buttonLocal = new JRadioButton();
        this.buttonRemote = new JRadioButton();
        this.blankPanel = new JPanel();
        this.panelInvocation = new JPanel();
        this.buttonDirect = new JRadioButton();
        this.buttonDynamic16 = new JRadioButton();
        this.hintPanel = new ResizableHintPanel();
        this.jPanel1 = new JPanel();
        this.setMaximumSize(new Dimension(800, 600));
        this.setMinimumSize(new Dimension(400, 300));
        this.setPreferredSize(new Dimension(500, 400));
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/profiler/attach/panels/Bundle");
        this.panelType.setBorder(BorderFactory.createTitledBorder(null, resourceBundle.getString("TargetTypeWizardPanelUI_SelectAttachTargetString"), 0, 0, UIManager.getFont("TitledBorder.font").deriveFont(1)));
        this.labelTargetType.setLabelFor(this.comboGroups);
        Mnemonics.setLocalizedText((JLabel)this.labelTargetType, (String)resourceBundle.getString("TargetTypeWizardPanelUI_TargetTypeString"));
        this.comboGroups.setModel(this.getGroupsModel());
        this.comboGroups.setMaximumSize(new Dimension(130, 24));
        this.comboGroups.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttachSettingsPanelUI.this.comboGroupsActionPerformed(actionEvent);
            }
        });
        this.labelTargetName.setLabelFor(this.comboTargets);
        Mnemonics.setLocalizedText((JLabel)this.labelTargetName, (String)resourceBundle.getString("TargetTypeWizardPanelUI_TargetNameTypeString"));
        this.comboTargets.setModel(this.getTargetsModel(true));
        this.comboTargets.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttachSettingsPanelUI.this.comboTargetsActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.panelType);
        this.panelType.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.labelTargetType).addPreferredGap(0, 377, -2)).add((Component)this.comboGroups, 0, 452, Short.MAX_VALUE).add((Component)this.comboTargets, 0, 452, Short.MAX_VALUE).add((Component)this.labelTargetName)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.labelTargetType).addPreferredGap(0).add((Component)this.comboGroups, -2, -1, -2).add(14, 14, 14).add((Component)this.labelTargetName).addPreferredGap(0).add((Component)this.comboTargets, -2, -1, -2).addContainerGap(20, Short.MAX_VALUE)));
        this.comboGroups.getAccessibleContext().setAccessibleName("null");
        this.comboGroups.getAccessibleContext().setAccessibleDescription("null");
        this.comboTargets.getAccessibleContext().setAccessibleDescription("null");
        this.panelDetails.setLayout(new BoxLayout(this.panelDetails, 2));
        this.panelMethod.setBorder(BorderFactory.createTitledBorder(null, resourceBundle.getString("AttachWizard_AttachMethodString"), 0, 0, UIManager.getFont("TitledBorder.font").deriveFont(1)));
        this.groupMethod.add(this.buttonLocal);
        this.buttonLocal.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonLocal, (String)resourceBundle.getString("TargetSettingsWizardPanelUI_LocalRadioName"));
        this.buttonLocal.setToolTipText("null");
        this.buttonLocal.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonLocal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttachSettingsPanelUI.this.buttonLocalActionPerformed(actionEvent);
            }
        });
        this.groupMethod.add(this.buttonRemote);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonRemote, (String)resourceBundle.getString("TargetSettingsWizardPanelUI_RemoteRadioName"));
        this.buttonRemote.setToolTipText("null");
        this.buttonRemote.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonRemote.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttachSettingsPanelUI.this.buttonRemoteActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)this.panelMethod);
        this.panelMethod.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.buttonLocal).add((Component)this.buttonRemote)).addContainerGap(100, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.buttonLocal).addPreferredGap(0).add((Component)this.buttonRemote).add(0, 18, Short.MAX_VALUE)));
        this.panelDetails.add(this.panelMethod);
        this.blankPanel.setMaximumSize(new Dimension(80, 10));
        this.blankPanel.setMinimumSize(new Dimension(20, 10));
        this.blankPanel.setPreferredSize(new Dimension(20, 10));
        GroupLayout groupLayout3 = new GroupLayout((Container)this.blankPanel);
        this.blankPanel.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(0, 20, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add(0, 10, Short.MAX_VALUE));
        this.panelDetails.add(this.blankPanel);
        this.panelInvocation.setBorder(BorderFactory.createTitledBorder(null, resourceBundle.getString("AttachWizard_AttachInvocationString"), 0, 0, UIManager.getFont("TitledBorder.font").deriveFont(1)));
        this.groupInvocation.add(this.buttonDirect);
        this.buttonDirect.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonDirect, (String)resourceBundle.getString("TargetSettingsWizardPanelUI_DirectRadioName"));
        this.buttonDirect.setToolTipText("null");
        this.buttonDirect.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonDirect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttachSettingsPanelUI.this.buttonDirectActionPerformed(actionEvent);
            }
        });
        this.groupInvocation.add(this.buttonDynamic16);
        Mnemonics.setLocalizedText((AbstractButton)this.buttonDynamic16, (String)NbBundle.getMessage(AttachSettingsPanelUI.class, (String)"TargetSettingsWizardPanelUI_Dynamic16RadioName"));
        this.buttonDynamic16.setToolTipText("null");
        this.buttonDynamic16.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.buttonDynamic16.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AttachSettingsPanelUI.this.buttonDynamic16ActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout4 = new GroupLayout((Container)this.panelInvocation);
        this.panelInvocation.setLayout((LayoutManager)groupLayout4);
        groupLayout4.setHorizontalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((Component)this.buttonDirect).add((Component)this.buttonDynamic16)).addContainerGap(100, Short.MAX_VALUE)));
        groupLayout4.setVerticalGroup((GroupLayout.Group)groupLayout4.createParallelGroup(1).add((GroupLayout.Group)groupLayout4.createSequentialGroup().addContainerGap().add((Component)this.buttonDirect).addPreferredGap(0).add((Component)this.buttonDynamic16).addContainerGap(18, Short.MAX_VALUE)));
        this.panelDetails.add(this.panelInvocation);
        this.hintPanel.setMaximumSize(new Dimension(500, 150));
        this.hintPanel.setMinimumSize(new Dimension(0, 0));
        this.hintPanel.setPreferredSize(new Dimension(500, 80));
        GroupLayout groupLayout5 = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout5);
        groupLayout5.setHorizontalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add(0, 476, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup((GroupLayout.Group)groupLayout5.createParallelGroup(1).add(0, 29, Short.MAX_VALUE));
        GroupLayout groupLayout6 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout6);
        groupLayout6.setHorizontalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((GroupLayout.Group)groupLayout6.createSequentialGroup().add((GroupLayout.Group)groupLayout6.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout6.createSequentialGroup().addContainerGap().add((Component)this.panelType, -1, -1, Short.MAX_VALUE)).add(2, (GroupLayout.Group)groupLayout6.createSequentialGroup().add(13, 13, 13).add((Component)this.panelDetails, -1, 475, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout6.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE))).add(12, 12, 12)).add((Component)this.hintPanel, -1, -1, Short.MAX_VALUE));
        groupLayout6.setVerticalGroup((GroupLayout.Group)groupLayout6.createParallelGroup(1).add((GroupLayout.Group)groupLayout6.createSequentialGroup().addContainerGap().add((Component)this.panelType, -2, -1, -2).addPreferredGap(0).add((Component)this.panelDetails, -2, 99, -2).addPreferredGap(0).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.hintPanel, -1, 126, Short.MAX_VALUE)));
        this.hintPanel.getAccessibleContext().setAccessibleName("null");
    }

    private void buttonDynamic16ActionPerformed(ActionEvent actionEvent) {
        this.model.setDynamicAttach16(this.buttonDynamic16.isEnabled());
        this.loadModel();
    }

    private void buttonDirectActionPerformed(ActionEvent actionEvent) {
        this.model.setDirectAttach(this.buttonDirect.isEnabled());
        this.loadModel();
    }

    private void buttonRemoteActionPerformed(ActionEvent actionEvent) {
        this.model.setRemote(this.buttonRemote.isEnabled());
        this.loadModel();
    }

    private void buttonLocalActionPerformed(ActionEvent actionEvent) {
        this.model.setLocal(this.buttonLocal.isEnabled());
        this.loadModel();
    }

    private void comboTargetsActionPerformed(ActionEvent actionEvent) {
        if (!((ForceSelectionComboBoxModel)this.comboTargets.getModel()).isSelectionMade()) {
            return;
        }
        this.model.setTarget((AttachSettingsPanel.Target)this.comboTargets.getSelectedItem());
        this.loadModel();
    }

    private void comboGroupsActionPerformed(ActionEvent actionEvent) {
        if (!((ForceSelectionComboBoxModel)this.comboGroups.getModel()).isSelectionMade()) {
            return;
        }
        if (this.model.getTargetGroup() != null && this.comboGroups.getSelectedItem() != null && this.model.getTargetGroup().equals(this.comboGroups.getSelectedItem())) {
            return;
        }
        this.model.setTargetGroup((AttachSettingsPanel.TargetGroup)this.comboGroups.getSelectedItem());
        if (this.model.getTargetGroup().isSingular()) {
            this.comboTargets.setModel(this.getTargetsModel(false));
            this.comboTargets.getModel().setSelectedItem(this.model.getTargetGroup().getTargets()[0]);
            this.model.setTarget((AttachSettingsPanel.Target)this.comboTargets.getModel().getSelectedItem());
        } else {
            this.comboTargets.setModel(this.getTargetsModel(true));
            this.comboTargets.getModel().setSelectedItem(null);
            this.model.setTarget(null);
        }
        this.loadModel();
    }

    void init() {
        this.loadModel();
    }

    void applyCombos() {
        AttachSettingsPanel.Target target = this.model.getTarget();
        this.comboTargets.setModel(this.getTargetsModel(true));
        this.comboGroups.setSelectedItem(this.model.getTargetGroup());
        this.comboTargets.setSelectedItem(target);
    }

    void loadModel() {
        boolean bl;
        AttachSettingsPanel.Target target = this.model.getTarget();
        if (this.model.getTargetGroup() != null && !this.model.getTargetGroup().isNull() && !this.model.getTargetGroup().isSingular()) {
            Mnemonics.setLocalizedText((JLabel)this.labelTargetName, (String)MessageFormat.format(NbBundle.getBundle(AttachSettingsPanel.class).getString("TargetTypeWizardPanelUI_TargetNameTypeString"), this.model.getTargetGroup().getName()));
            this.labelTargetName.setVisible(true);
            this.comboTargets.setVisible(true);
        } else {
            this.labelTargetName.setVisible(false);
            this.comboTargets.setVisible(false);
        }
        if (this.model.getTarget() == null) {
            this.panelDetails.setVisible(false);
            this.hintPanel.setVisible(false);
            return;
        }
        this.panelDetails.setVisible(true);
        this.hintPanel.setVisible(true);
        boolean bl2 = target.supportsRemoteProfiling() && this.model.isRemote();
        boolean bl3 = target.supportsLocalProfiling() && this.model.isLocal() || !target.supportsRemoteProfiling();
        boolean bl4 = target.supportsDirectAttach();
        boolean bl5 = target.supportsDynamicAttach() && this.model.isLocal() && this.isDynamicAttachSupported();
        boolean bl6 = bl4 && this.model.isDirectAttach() || !bl5 && this.model.isDynamicAttach16();
        boolean bl7 = bl5 && this.model.isDynamicAttach16() && this.model.isLocal();
        this.buttonRemote.setSelected(bl2);
        this.buttonLocal.setSelected(bl3);
        this.buttonRemote.setEnabled(target.supportsRemoteProfiling());
        this.buttonLocal.setEnabled(target.supportsLocalProfiling());
        this.buttonDynamic16.setEnabled(bl5);
        this.buttonDirect.setEnabled(bl4);
        boolean bl8 = this.buttonLocal.isEnabled() || this.buttonRemote.isEnabled();
        boolean bl9 = bl = bl4 || bl5;
        if (!bl8) {
            this.groupMethod.clearSelection();
        }
        if (!bl) {
            this.groupInvocation.clearSelection();
        } else {
            this.buttonDynamic16.setSelected(bl7);
            this.buttonDirect.setSelected(bl6);
        }
        if (bl6) {
            this.model.setDirectAttach(bl6);
        }
        if (bl7) {
            this.model.setDynamicAttach16(bl7);
        }
        this.hintPanel.setHint(this.model.getHints());
    }

    public ComboBoxModel getGroupsModel() {
        return new ForceSelectionComboBoxModel(this.SELECT_GROUP_TITLE, this.model.getTargetGroups());
    }

    public ComboBoxModel getTargetsModel(boolean bl) {
        if (bl) {
            return new ForceSelectionComboBoxModel(this.SELECT_TARGET_TITLE, this.model.getTargetGroup() != null ? this.model.getTargetGroup().getTargets() : new Object[]{});
        }
        return new ForceSelectionComboBoxModel(this.model.getTargetGroup().getTargets());
    }

    private boolean isDynamicAttachSupported() {
        try {
            Class.forName("sun.jvmstat.monitor.MonitoredHost");
            Class.forName("com.sun.tools.attach.VirtualMachine");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    private class ForceSelectionComboBoxModel
    extends DefaultComboBoxModel {
        private String firstLine;
        private boolean internalChange;
        private Object selectedItem;

        public ForceSelectionComboBoxModel(Object[] objectArray) {
            super(objectArray);
            this.firstLine = "";
            this.internalChange = false;
        }

        public ForceSelectionComboBoxModel(String string, Object[] objectArray) {
            super(objectArray);
            this.firstLine = "";
            this.internalChange = false;
            this.insertElementAt(string, 0);
            this.firstLine = string;
            this.selectedItem = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSelectedItem(Object object) {
            if (this.internalChange) {
                return;
            }
            if (object == null || object.equals(this.firstLine)) {
                this.selectedItem = null;
                return;
            }
            if (this.getElementAt(0).equals(this.firstLine)) {
                try {
                    this.internalChange = true;
                    this.removeElementAt(0);
                }
                finally {
                    this.internalChange = false;
                }
            }
            this.selectedItem = object;
            super.setSelectedItem(object);
        }

        public Object getSelectedItem() {
            if (this.selectedItem == null && this.getSize() > 0 && this.getElementAt(0).equals(this.firstLine)) {
                return this.firstLine;
            }
            return super.getSelectedItem();
        }

        public boolean isSelectionMade() {
            return this.selectedItem != null;
        }
    }
}

