/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.awt.TextComponent;
import java.awt.event.TextListener;
import java.util.Hashtable;
import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.TextDriver;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.Operator;

public class TextComponentOperator
extends ComponentOperator
implements Timeoutable,
Outputable {
    public static final String TEXT_DPROP = "Text";
    private static final long PUSH_KEY_TIMEOUT = 0L;
    private static final long BETWEEN_KEYS_TIMEOUT = 0L;
    private static final long CHANGE_CARET_POSITION_TIMEOUT = 60000L;
    private static final long TYPE_TEXT_TIMEOUT = 60000L;
    private Timeouts timeouts;
    private TestOut output;
    private TextDriver driver = DriverManager.getTextDriver(this.getClass());
    static /* synthetic */ Class class$java$awt$TextComponent;

    public TextComponentOperator(TextComponent textComponent) {
        super(textComponent);
    }

    public TextComponentOperator(ContainerOperator containerOperator, ComponentChooser componentChooser, int n) {
        this((TextComponent)containerOperator.waitSubComponent(new TextComponentFinder(componentChooser), n));
        this.copyEnvironment(containerOperator);
    }

    public TextComponentOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        this(containerOperator, componentChooser, 0);
    }

    public TextComponentOperator(ContainerOperator containerOperator, String string, int n) {
        this((TextComponent)TextComponentOperator.waitComponent(containerOperator, (ComponentChooser)new TextComponentByTextFinder(string, containerOperator.getComparator()), n));
        this.copyEnvironment(containerOperator);
    }

    public TextComponentOperator(ContainerOperator containerOperator, String string) {
        this(containerOperator, string, 0);
    }

    public TextComponentOperator(ContainerOperator containerOperator, int n) {
        this((TextComponent)TextComponentOperator.waitComponent(containerOperator, (ComponentChooser)new TextComponentFinder(), n));
        this.copyEnvironment(containerOperator);
    }

    public TextComponentOperator(ContainerOperator containerOperator) {
        this(containerOperator, 0);
    }

    public static TextComponent findTextComponent(Container container, ComponentChooser componentChooser, int n) {
        return (TextComponent)TextComponentOperator.findComponent(container, new TextComponentFinder(componentChooser), n);
    }

    public static TextComponent findTextComponent(Container container, ComponentChooser componentChooser) {
        return TextComponentOperator.findTextComponent(container, componentChooser, 0);
    }

    public static TextComponent findTextComponent(Container container, String string, boolean bl, boolean bl2, int n) {
        return TextComponentOperator.findTextComponent(container, new TextComponentByTextFinder(string, new Operator.DefaultStringComparator(bl, bl2)), n);
    }

    public static TextComponent findTextComponent(Container container, String string, boolean bl, boolean bl2) {
        return TextComponentOperator.findTextComponent(container, string, bl, bl2, 0);
    }

    public static TextComponent waitTextComponent(Container container, ComponentChooser componentChooser, int n) {
        return (TextComponent)TextComponentOperator.waitComponent(container, (ComponentChooser)new TextComponentFinder(componentChooser), n);
    }

    public static TextComponent waitTextComponent(Container container, ComponentChooser componentChooser) {
        return TextComponentOperator.waitTextComponent(container, componentChooser, 0);
    }

    public static TextComponent waitTextComponent(Container container, String string, boolean bl, boolean bl2, int n) {
        return TextComponentOperator.waitTextComponent(container, new TextComponentByTextFinder(string, new Operator.DefaultStringComparator(bl, bl2)), n);
    }

    public static TextComponent waitTextComponent(Container container, String string, boolean bl, boolean bl2) {
        return TextComponentOperator.waitTextComponent(container, string, bl, bl2, 0);
    }

    public void setTimeouts(Timeouts timeouts) {
        super.setTimeouts(timeouts);
        this.timeouts = timeouts;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void copyEnvironment(Operator operator) {
        super.copyEnvironment(operator);
        this.driver = (TextDriver)DriverManager.getDriver("drivers.text", this.getClass(), operator.getProperties());
    }

    public void changeCaretPosition(final int n) {
        this.makeComponentVisible();
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                TextComponentOperator.this.driver.changeCaretPosition(TextComponentOperator.this, n);
                return null;
            }

            public String getDescription() {
                return "Caret moving";
            }
        }, this.getTimeouts().getTimeout("TextComponentOperator.ChangeCaretPositionTimeout"));
    }

    public void selectText(final int n, final int n2) {
        this.makeComponentVisible();
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                TextComponentOperator.this.driver.selectText(TextComponentOperator.this, n, n2);
                return null;
            }

            public String getDescription() {
                return "Text selecting";
            }
        }, this.getTimeouts().getTimeout("TextComponentOperator.TypeTextTimeout"));
    }

    public int getPositionByText(String string, int n) {
        String string2 = this.getText();
        int n2 = 0;
        int n3 = 0;
        while ((n2 = string2.indexOf(string, n2)) >= 0) {
            if (n3 == n) {
                return n2;
            }
            ++n3;
            n2 += string.length();
        }
        return -1;
    }

    public int getPositionByText(String string) {
        return this.getPositionByText(string, 0);
    }

    public void clearText() {
        this.output.printLine("Clearing text in text component\n    : " + this.toStringSource());
        this.output.printGolden("Clearing text in text component");
        this.makeComponentVisible();
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                TextComponentOperator.this.driver.clearText(TextComponentOperator.this);
                return null;
            }

            public String getDescription() {
                return "Text clearing";
            }
        }, this.getTimeouts().getTimeout("TextComponentOperator.TypeTextTimeout"));
    }

    public void typeText(final String string, final int n) {
        this.output.printLine("Typing text \"" + string + "\" from " + Integer.toString(n) + " position " + "in text component\n    : " + this.toStringSource());
        this.output.printGolden("Typing text \"" + string + "\" in text component");
        this.makeComponentVisible();
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                TextComponentOperator.this.driver.typeText(TextComponentOperator.this, string, n);
                return null;
            }

            public String getDescription() {
                return "Text typing";
            }
        }, this.getTimeouts().getTimeout("TextComponentOperator.TypeTextTimeout"));
    }

    public void typeText(String string) {
        this.typeText(string, this.getCaretPosition());
    }

    public void enterText(final String string) {
        this.makeComponentVisible();
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                TextComponentOperator.this.driver.enterText(TextComponentOperator.this, string);
                return null;
            }

            public String getDescription() {
                return "Text entering";
            }
        }, this.getTimeouts().getTimeout("TextComponentOperator.TypeTextTimeout"));
    }

    public Hashtable getDump() {
        Hashtable hashtable = super.getDump();
        hashtable.put(TEXT_DPROP, ((TextComponent)this.getSource()).getText());
        return hashtable;
    }

    public void addTextListener(final TextListener textListener) {
        this.runMapping(new Operator.MapVoidAction("addTextListener"){

            public void map() {
                ((TextComponent)TextComponentOperator.this.getSource()).addTextListener(textListener);
            }
        });
    }

    public int getCaretPosition() {
        return this.runMapping(new Operator.MapIntegerAction("getCaretPosition"){

            public int map() {
                return ((TextComponent)TextComponentOperator.this.getSource()).getCaretPosition();
            }
        });
    }

    public String getSelectedText() {
        return (String)this.runMapping(new Operator.MapAction("getSelectedText"){

            public Object map() {
                return ((TextComponent)TextComponentOperator.this.getSource()).getSelectedText();
            }
        });
    }

    public int getSelectionEnd() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectionEnd"){

            public int map() {
                return ((TextComponent)TextComponentOperator.this.getSource()).getSelectionEnd();
            }
        });
    }

    public int getSelectionStart() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectionStart"){

            public int map() {
                return ((TextComponent)TextComponentOperator.this.getSource()).getSelectionStart();
            }
        });
    }

    public String getText() {
        return (String)this.runMapping(new Operator.MapAction("getText"){

            public Object map() {
                return ((TextComponent)TextComponentOperator.this.getSource()).getText();
            }
        });
    }

    public boolean isEditable() {
        return this.runMapping(new Operator.MapBooleanAction("isEditable"){

            public boolean map() {
                return ((TextComponent)TextComponentOperator.this.getSource()).isEditable();
            }
        });
    }

    public void removeTextListener(final TextListener textListener) {
        this.runMapping(new Operator.MapVoidAction("removeTextListener"){

            public void map() {
                ((TextComponent)TextComponentOperator.this.getSource()).removeTextListener(textListener);
            }
        });
    }

    public void select(final int n, final int n2) {
        this.runMapping(new Operator.MapVoidAction("select"){

            public void map() {
                ((TextComponent)TextComponentOperator.this.getSource()).select(n, n2);
            }
        });
    }

    public void selectAll() {
        this.runMapping(new Operator.MapVoidAction("selectAll"){

            public void map() {
                ((TextComponent)TextComponentOperator.this.getSource()).selectAll();
            }
        });
    }

    public void setCaretPosition(final int n) {
        this.runMapping(new Operator.MapVoidAction("setCaretPosition"){

            public void map() {
                ((TextComponent)TextComponentOperator.this.getSource()).setCaretPosition(n);
            }
        });
    }

    public void setEditable(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setEditable"){

            public void map() {
                ((TextComponent)TextComponentOperator.this.getSource()).setEditable(bl);
            }
        });
    }

    public void setSelectionEnd(final int n) {
        this.runMapping(new Operator.MapVoidAction("setSelectionEnd"){

            public void map() {
                ((TextComponent)TextComponentOperator.this.getSource()).setSelectionEnd(n);
            }
        });
    }

    public void setSelectionStart(final int n) {
        this.runMapping(new Operator.MapVoidAction("setSelectionStart"){

            public void map() {
                ((TextComponent)TextComponentOperator.this.getSource()).setSelectionStart(n);
            }
        });
    }

    public void setText(final String string) {
        this.runMapping(new Operator.MapVoidAction("setText"){

            public void map() {
                ((TextComponent)TextComponentOperator.this.getSource()).setText(string);
            }
        });
    }

    protected TextDriver getTextDriver() {
        return this.driver;
    }

    static {
        Timeouts.initDefault("TextComponentOperator.PushKeyTimeout", 0L);
        Timeouts.initDefault("TextComponentOperator.BetweenKeysTimeout", 0L);
        Timeouts.initDefault("TextComponentOperator.ChangeCaretPositionTimeout", 60000L);
        Timeouts.initDefault("TextComponentOperator.TypeTextTimeout", 60000L);
    }

    public static class TextComponentFinder
    extends Operator.Finder {
        public TextComponentFinder(ComponentChooser componentChooser) {
            super(class$java$awt$TextComponent == null ? (class$java$awt$TextComponent = TextComponentOperator.class$("java.awt.TextComponent")) : class$java$awt$TextComponent, componentChooser);
        }

        public TextComponentFinder() {
            super(class$java$awt$TextComponent == null ? (class$java$awt$TextComponent = TextComponentOperator.class$("java.awt.TextComponent")) : class$java$awt$TextComponent);
        }
    }

    public static class TextComponentByTextFinder
    implements ComponentChooser {
        String label;
        Operator.StringComparator comparator;

        public TextComponentByTextFinder(String string, Operator.StringComparator stringComparator) {
            this.label = string;
            this.comparator = stringComparator;
        }

        public TextComponentByTextFinder(String string) {
            this(string, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component component) {
            if (component instanceof TextComponent && ((TextComponent)component).getText() != null) {
                return this.comparator.equals(((TextComponent)component).getText(), this.label);
            }
            return false;
        }

        public String getDescription() {
            return "TextComponent with text \"" + this.label + "\"";
        }
    }
}

