/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.List;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.MultiSelListDriver;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.Operator;

public class ListOperator
extends ComponentOperator
implements Outputable {
    public static final String ITEM_PREFIX_DPROP = "Item";
    public static final String SELECTED_ITEM_PREFIX_DPROP = "SelectedItem";
    private TestOut output;
    private MultiSelListDriver driver = DriverManager.getMultiSelListDriver(this.getClass());
    static /* synthetic */ Class class$java$awt$List;

    public ListOperator(List list) {
        super(list);
    }

    public ListOperator(ContainerOperator containerOperator, ComponentChooser componentChooser, int n) {
        this((List)containerOperator.waitSubComponent(new ListFinder(componentChooser), n));
        this.copyEnvironment(containerOperator);
    }

    public ListOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        this(containerOperator, componentChooser, 0);
    }

    public ListOperator(ContainerOperator containerOperator, String string, int n, int n2) {
        this((List)ListOperator.waitComponent(containerOperator, (ComponentChooser)new ListByItemFinder(string, n, containerOperator.getComparator()), n2));
        this.copyEnvironment(containerOperator);
    }

    public ListOperator(ContainerOperator containerOperator, String string, int n) {
        this(containerOperator, string, -1, n);
    }

    public ListOperator(ContainerOperator containerOperator, String string) {
        this(containerOperator, string, 0);
    }

    public ListOperator(ContainerOperator containerOperator, int n) {
        this((List)ListOperator.waitComponent(containerOperator, (ComponentChooser)new ListFinder(), n));
        this.copyEnvironment(containerOperator);
    }

    public ListOperator(ContainerOperator containerOperator) {
        this(containerOperator, 0);
    }

    public static List findList(Container container, ComponentChooser componentChooser, int n) {
        return (List)ListOperator.findComponent(container, new ListFinder(componentChooser), n);
    }

    public static List findList(Container container, ComponentChooser componentChooser) {
        return ListOperator.findList(container, componentChooser, 0);
    }

    public void setOutput(TestOut testOut) {
        super.setOutput(testOut.createErrorOutput());
        this.output = testOut;
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void copyEnvironment(Operator operator) {
        super.copyEnvironment(operator);
        this.driver = (MultiSelListDriver)DriverManager.getDriver("drivers.multisellist", this.getClass(), operator.getProperties());
    }

    private int findItemIndex(String string, Operator.StringComparator stringComparator, int n) {
        int n2 = 0;
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!stringComparator.equals(this.getItem(i), string)) continue;
            if (n2 == n) {
                return i;
            }
            ++n2;
        }
        return -1;
    }

    public int findItemIndex(String string, int n) {
        return this.findItemIndex(string, this.getComparator(), n);
    }

    public int findItemIndex(String string) {
        return this.findItemIndex(string, 0);
    }

    private void selectItem(String string, Operator.StringComparator stringComparator, int n) {
        this.selectItem(this.findItemIndex(string, stringComparator, n));
    }

    public void selectItem(String string, int n) {
        this.selectItem(string, this.getComparator(), n);
    }

    public void selectItem(String string) {
        this.selectItem(string, 0);
    }

    public void selectItem(int n) {
        this.output.printLine("Select " + Integer.toString(n) + "`th item in list\n    : " + this.toStringSource());
        this.output.printGolden("Select " + Integer.toString(n) + "`th item in list");
        this.driver.selectItem(this, n);
        if (this.getVerification()) {
            this.waitItemSelection(n, true);
        }
    }

    public void selectItems(int n, int n2) {
        this.output.printLine("Select items from " + Integer.toString(n) + "`th to " + Integer.toString(n) + "'th in list\n    : " + this.toStringSource());
        this.output.printGolden("Select items from " + Integer.toString(n) + "`th to " + Integer.toString(n) + "'th");
        this.driver.selectItems(this, new int[]{n, n2});
        if (this.getVerification()) {
            this.waitItemsSelection(n, n2, true);
        }
    }

    public void waitItemsSelection(final int n, final int n2, final boolean bl) {
        this.getOutput().printLine("Wait items to be " + (bl ? "" : "un") + "selected in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait items to be " + (bl ? "" : "un") + "selected");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                int[] nArray = ListOperator.this.getSelectedIndexes();
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] >= n && nArray[i] <= n2) continue;
                    return false;
                }
                return true;
            }

            public String getDescription() {
                return "Items has been " + (bl ? "" : "un") + "selected";
            }
        });
    }

    public void waitItemSelection(int n, boolean bl) {
        this.waitItemsSelection(n, n, bl);
    }

    public Hashtable getDump() {
        Hashtable hashtable = super.getDump();
        this.addToDump(hashtable, ITEM_PREFIX_DPROP, ((List)this.getSource()).getItems());
        this.addToDump(hashtable, SELECTED_ITEM_PREFIX_DPROP, ((List)this.getSource()).getSelectedItems());
        return hashtable;
    }

    public void addActionListener(final ActionListener actionListener) {
        this.runMapping(new Operator.MapVoidAction("addActionListener"){

            public void map() {
                ((List)ListOperator.this.getSource()).addActionListener(actionListener);
            }
        });
    }

    public void addItemListener(final ItemListener itemListener) {
        this.runMapping(new Operator.MapVoidAction("addItemListener"){

            public void map() {
                ((List)ListOperator.this.getSource()).addItemListener(itemListener);
            }
        });
    }

    public void deselect(final int n) {
        this.runMapping(new Operator.MapVoidAction("deselect"){

            public void map() {
                ((List)ListOperator.this.getSource()).deselect(n);
            }
        });
    }

    public String getItem(final int n) {
        return (String)this.runMapping(new Operator.MapAction("getItem"){

            public Object map() {
                return ((List)ListOperator.this.getSource()).getItem(n);
            }
        });
    }

    public int getItemCount() {
        return this.runMapping(new Operator.MapIntegerAction("getItemCount"){

            public int map() {
                return ((List)ListOperator.this.getSource()).getItemCount();
            }
        });
    }

    public String[] getItems() {
        return (String[])this.runMapping(new Operator.MapAction("getItems"){

            public Object map() {
                return ((List)ListOperator.this.getSource()).getItems();
            }
        });
    }

    public Dimension getMinimumSize(final int n) {
        return (Dimension)this.runMapping(new Operator.MapAction("getMinimumSize"){

            public Object map() {
                return ((List)ListOperator.this.getSource()).getMinimumSize(n);
            }
        });
    }

    public Dimension getPreferredSize(final int n) {
        return (Dimension)this.runMapping(new Operator.MapAction("getPreferredSize"){

            public Object map() {
                return ((List)ListOperator.this.getSource()).getPreferredSize(n);
            }
        });
    }

    public int getRows() {
        return this.runMapping(new Operator.MapIntegerAction("getRows"){

            public int map() {
                return ((List)ListOperator.this.getSource()).getRows();
            }
        });
    }

    public int getSelectedIndex() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectedIndex"){

            public int map() {
                return ((List)ListOperator.this.getSource()).getSelectedIndex();
            }
        });
    }

    public int[] getSelectedIndexes() {
        return (int[])this.runMapping(new Operator.MapAction("getSelectedIndexes"){

            public Object map() {
                return ((List)ListOperator.this.getSource()).getSelectedIndexes();
            }
        });
    }

    public String getSelectedItem() {
        return (String)this.runMapping(new Operator.MapAction("getSelectedItem"){

            public Object map() {
                return ((List)ListOperator.this.getSource()).getSelectedItem();
            }
        });
    }

    public String[] getSelectedItems() {
        return (String[])this.runMapping(new Operator.MapAction("getSelectedItems"){

            public Object map() {
                return ((List)ListOperator.this.getSource()).getSelectedItems();
            }
        });
    }

    public Object[] getSelectedObjects() {
        return (Object[])this.runMapping(new Operator.MapAction("getSelectedObjects"){

            public Object map() {
                return ((List)ListOperator.this.getSource()).getSelectedObjects();
            }
        });
    }

    public int getVisibleIndex() {
        return this.runMapping(new Operator.MapIntegerAction("getVisibleIndex"){

            public int map() {
                return ((List)ListOperator.this.getSource()).getVisibleIndex();
            }
        });
    }

    public boolean isIndexSelected(final int n) {
        return this.runMapping(new Operator.MapBooleanAction("isIndexSelected"){

            public boolean map() {
                return ((List)ListOperator.this.getSource()).isIndexSelected(n);
            }
        });
    }

    public boolean isMultipleMode() {
        return this.runMapping(new Operator.MapBooleanAction("isMultipleMode"){

            public boolean map() {
                return ((List)ListOperator.this.getSource()).isMultipleMode();
            }
        });
    }

    public void makeVisible(final int n) {
        this.runMapping(new Operator.MapVoidAction("makeVisible"){

            public void map() {
                ((List)ListOperator.this.getSource()).makeVisible(n);
            }
        });
    }

    public void remove(final int n) {
        this.runMapping(new Operator.MapVoidAction("remove"){

            public void map() {
                ((List)ListOperator.this.getSource()).remove(n);
            }
        });
    }

    public void remove(final String string) {
        this.runMapping(new Operator.MapVoidAction("remove"){

            public void map() {
                ((List)ListOperator.this.getSource()).remove(string);
            }
        });
    }

    public void removeActionListener(final ActionListener actionListener) {
        this.runMapping(new Operator.MapVoidAction("removeActionListener"){

            public void map() {
                ((List)ListOperator.this.getSource()).removeActionListener(actionListener);
            }
        });
    }

    public void removeAll() {
        this.runMapping(new Operator.MapVoidAction("removeAll"){

            public void map() {
                ((List)ListOperator.this.getSource()).removeAll();
            }
        });
    }

    public void removeItemListener(final ItemListener itemListener) {
        this.runMapping(new Operator.MapVoidAction("removeItemListener"){

            public void map() {
                ((List)ListOperator.this.getSource()).removeItemListener(itemListener);
            }
        });
    }

    public void replaceItem(final String string, final int n) {
        this.runMapping(new Operator.MapVoidAction("replaceItem"){

            public void map() {
                ((List)ListOperator.this.getSource()).replaceItem(string, n);
            }
        });
    }

    public void select(final int n) {
        this.runMapping(new Operator.MapVoidAction("select"){

            public void map() {
                ((List)ListOperator.this.getSource()).select(n);
            }
        });
    }

    public void setMultipleMode(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setMultipleMode"){

            public void map() {
                ((List)ListOperator.this.getSource()).setMultipleMode(bl);
            }
        });
    }

    public static class ListFinder
    extends Operator.Finder {
        public ListFinder(ComponentChooser componentChooser) {
            super(class$java$awt$List == null ? (class$java$awt$List = ListOperator.class$("java.awt.List")) : class$java$awt$List, componentChooser);
        }

        public ListFinder() {
            super(class$java$awt$List == null ? (class$java$awt$List = ListOperator.class$("java.awt.List")) : class$java$awt$List);
        }
    }

    public static class ListByItemFinder
    implements ComponentChooser {
        String label;
        int itemIndex;
        Operator.StringComparator comparator;

        public ListByItemFinder(String string, int n, Operator.StringComparator stringComparator) {
            this.label = string;
            this.itemIndex = n;
            this.comparator = stringComparator;
        }

        public ListByItemFinder(String string, int n) {
            this(string, n, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component component) {
            if (component instanceof List) {
                if (this.label == null) {
                    return true;
                }
                if (((List)component).getItemCount() > this.itemIndex) {
                    int n = this.itemIndex;
                    if (n == -1 && (n = ((List)component).getSelectedIndex()) == -1) {
                        return false;
                    }
                    return this.comparator.equals(((List)component).getItem(n), this.label);
                }
            }
            return false;
        }

        public String getDescription() {
            return "List with text \"" + this.label + "\" in " + new Integer(this.itemIndex).toString() + "'th item";
        }
    }
}

