/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Container;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.BoundedRangeModel;
import javax.swing.JSlider;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SliderUI;
import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.ScrollDriver;
import org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.Operator;

public class JSliderOperator
extends JComponentOperator
implements Timeoutable,
Outputable {
    private static final long ONE_SCROLL_CLICK_TIMEOUT = 0L;
    private static final long WHOLE_SCROLL_TIMEOUT = 60000L;
    private static final long SCROLLING_DELTA = 0L;
    private ScrollDriver driver = DriverManager.getScrollDriver(this.getClass());
    public static final String MINIMUM_DPROP = "Minimum";
    public static final String MAXIMUM_DPROP = "Maximum";
    public static final String VALUE_DPROP = "Value";
    public static final String ORIENTATION_DPROP = "Orientation";
    public static final String HORIZONTAL_ORIENTATION_DPROP_VALUE = "HORIZONTAL";
    public static final String VERTICAL_ORIENTATION_DPROP_VALUE = "VERTICAL";
    public static final String IS_INVERTED_DPROP = "Inverted";
    public static final int CLICK_SCROLL_MODEL = 1;
    public static final int PUSH_AND_WAIT_SCROLL_MODEL = 2;
    private Timeouts timeouts;
    private TestOut output;
    private JButtonOperator minButtOperator;
    private JButtonOperator maxButtOperator;
    private int scrollModel = 1;
    static /* synthetic */ Class class$javax$swing$JSlider;

    public JSliderOperator(JSlider jSlider) {
        super(jSlider);
    }

    public JSliderOperator(ContainerOperator containerOperator, ComponentChooser componentChooser, int n) {
        this((JSlider)containerOperator.waitSubComponent(new JSliderFinder(componentChooser), n));
        this.copyEnvironment(containerOperator);
    }

    public JSliderOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        this(containerOperator, componentChooser, 0);
    }

    public JSliderOperator(ContainerOperator containerOperator, int n) {
        this((JSlider)JSliderOperator.waitComponent(containerOperator, (ComponentChooser)new JSliderFinder(), n));
        this.copyEnvironment(containerOperator);
    }

    public JSliderOperator(ContainerOperator containerOperator) {
        this(containerOperator, 0);
    }

    public static JSlider findJSlider(Container container, ComponentChooser componentChooser, int n) {
        return (JSlider)JSliderOperator.findComponent(container, new JSliderFinder(componentChooser), n);
    }

    public static JSlider findJSlider(Container container, ComponentChooser componentChooser) {
        return JSliderOperator.findJSlider(container, componentChooser, 0);
    }

    public static JSlider findJSlider(Container container, int n) {
        return JSliderOperator.findJSlider(container, ComponentSearcher.getTrueChooser(Integer.toString(n) + "'th JSlider instance"), n);
    }

    public static JSlider findJSlider(Container container) {
        return JSliderOperator.findJSlider(container, 0);
    }

    public static JSlider waitJSlider(Container container, ComponentChooser componentChooser, int n) {
        return (JSlider)JSliderOperator.waitComponent(container, (ComponentChooser)new JSliderFinder(componentChooser), n);
    }

    public static JSlider waitJSlider(Container container, ComponentChooser componentChooser) {
        return JSliderOperator.waitJSlider(container, componentChooser, 0);
    }

    public static JSlider waitJSlider(Container container, int n) {
        return JSliderOperator.waitJSlider(container, ComponentSearcher.getTrueChooser(Integer.toString(n) + "'th JSlider instance"), n);
    }

    public static JSlider waitJSlider(Container container) {
        return JSliderOperator.waitJSlider(container, 0);
    }

    public void setScrollModel(int n) {
        this.scrollModel = n;
    }

    public int getScrollModel() {
        return this.scrollModel;
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        super.setTimeouts(timeouts);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void scrollTo(final ScrollAdjuster scrollAdjuster) {
        this.makeComponentVisible();
        this.produceTimeRestricted(new Action(){

            public Object launch(Object object) {
                JSliderOperator.this.driver.scroll(JSliderOperator.this, scrollAdjuster);
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("JSliderOperator.WholeScrollTimeout"));
    }

    public void scrollToValue(int n) {
        this.output.printTrace("Move JSlider to " + Integer.toString(n) + " value\n" + this.toStringSource());
        this.output.printGolden("Move JSlider to " + Integer.toString(n) + " value");
        this.scrollTo(new ValueScrollAdjuster(n));
    }

    public void scrollToMaximum() {
        this.output.printTrace("Move JSlider to maximum value\n" + this.toStringSource());
        this.output.printGolden("Move JSlider to maximum value");
        this.scrollToValue(this.getMaximum());
    }

    public void scrollToMinimum() {
        this.output.printTrace("Move JSlider to minimum value\n" + this.toStringSource());
        this.output.printGolden("Move JSlider to minimum value");
        this.scrollToValue(this.getMinimum());
    }

    public Hashtable getDump() {
        Hashtable hashtable = super.getDump();
        hashtable.put(MINIMUM_DPROP, Integer.toString(((JSlider)this.getSource()).getMinimum()));
        hashtable.put(MAXIMUM_DPROP, Integer.toString(((JSlider)this.getSource()).getMaximum()));
        hashtable.put(ORIENTATION_DPROP, ((JSlider)this.getSource()).getOrientation() == 0 ? HORIZONTAL_ORIENTATION_DPROP_VALUE : VERTICAL_ORIENTATION_DPROP_VALUE);
        hashtable.put(IS_INVERTED_DPROP, ((JSlider)this.getSource()).getInverted() ? "true" : "false");
        hashtable.put(VALUE_DPROP, Integer.toString(((JSlider)this.getSource()).getValue()));
        return hashtable;
    }

    public void addChangeListener(final ChangeListener changeListener) {
        this.runMapping(new Operator.MapVoidAction("addChangeListener"){

            public void map() {
                ((JSlider)JSliderOperator.this.getSource()).addChangeListener(changeListener);
            }
        });
    }

    public Hashtable createStandardLabels(final int n) {
        return (Hashtable)this.runMapping(new Operator.MapAction("createStandardLabels"){

            public Object map() {
                return ((JSlider)JSliderOperator.this.getSource()).createStandardLabels(n);
            }
        });
    }

    public Hashtable createStandardLabels(final int n, final int n2) {
        return (Hashtable)this.runMapping(new Operator.MapAction("createStandardLabels"){

            public Object map() {
                return ((JSlider)JSliderOperator.this.getSource()).createStandardLabels(n, n2);
            }
        });
    }

    public int getExtent() {
        return this.runMapping(new Operator.MapIntegerAction("getExtent"){

            public int map() {
                return ((JSlider)JSliderOperator.this.getSource()).getExtent();
            }
        });
    }

    public boolean getInverted() {
        return this.runMapping(new Operator.MapBooleanAction("getInverted"){

            public boolean map() {
                return ((JSlider)JSliderOperator.this.getSource()).getInverted();
            }
        });
    }

    public Dictionary getLabelTable() {
        return (Dictionary)this.runMapping(new Operator.MapAction("getLabelTable"){

            public Object map() {
                return ((JSlider)JSliderOperator.this.getSource()).getLabelTable();
            }
        });
    }

    public int getMajorTickSpacing() {
        return this.runMapping(new Operator.MapIntegerAction("getMajorTickSpacing"){

            public int map() {
                return ((JSlider)JSliderOperator.this.getSource()).getMajorTickSpacing();
            }
        });
    }

    public int getMaximum() {
        return this.runMapping(new Operator.MapIntegerAction("getMaximum"){

            public int map() {
                return ((JSlider)JSliderOperator.this.getSource()).getMaximum();
            }
        });
    }

    public int getMinimum() {
        return this.runMapping(new Operator.MapIntegerAction("getMinimum"){

            public int map() {
                return ((JSlider)JSliderOperator.this.getSource()).getMinimum();
            }
        });
    }

    public int getMinorTickSpacing() {
        return this.runMapping(new Operator.MapIntegerAction("getMinorTickSpacing"){

            public int map() {
                return ((JSlider)JSliderOperator.this.getSource()).getMinorTickSpacing();
            }
        });
    }

    public BoundedRangeModel getModel() {
        return (BoundedRangeModel)this.runMapping(new Operator.MapAction("getModel"){

            public Object map() {
                return ((JSlider)JSliderOperator.this.getSource()).getModel();
            }
        });
    }

    public int getOrientation() {
        return this.runMapping(new Operator.MapIntegerAction("getOrientation"){

            public int map() {
                return ((JSlider)JSliderOperator.this.getSource()).getOrientation();
            }
        });
    }

    public boolean getPaintLabels() {
        return this.runMapping(new Operator.MapBooleanAction("getPaintLabels"){

            public boolean map() {
                return ((JSlider)JSliderOperator.this.getSource()).getPaintLabels();
            }
        });
    }

    public boolean getPaintTicks() {
        return this.runMapping(new Operator.MapBooleanAction("getPaintTicks"){

            public boolean map() {
                return ((JSlider)JSliderOperator.this.getSource()).getPaintTicks();
            }
        });
    }

    public boolean getPaintTrack() {
        return this.runMapping(new Operator.MapBooleanAction("getPaintTrack"){

            public boolean map() {
                return ((JSlider)JSliderOperator.this.getSource()).getPaintTrack();
            }
        });
    }

    public boolean getSnapToTicks() {
        return this.runMapping(new Operator.MapBooleanAction("getSnapToTicks"){

            public boolean map() {
                return ((JSlider)JSliderOperator.this.getSource()).getSnapToTicks();
            }
        });
    }

    public SliderUI getUI() {
        return (SliderUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((JSlider)JSliderOperator.this.getSource()).getUI();
            }
        });
    }

    public int getValue() {
        return this.runMapping(new Operator.MapIntegerAction("getValue"){

            public int map() {
                return ((JSlider)JSliderOperator.this.getSource()).getValue();
            }
        });
    }

    public boolean getValueIsAdjusting() {
        return this.runMapping(new Operator.MapBooleanAction("getValueIsAdjusting"){

            public boolean map() {
                return ((JSlider)JSliderOperator.this.getSource()).getValueIsAdjusting();
            }
        });
    }

    public void removeChangeListener(final ChangeListener changeListener) {
        this.runMapping(new Operator.MapVoidAction("removeChangeListener"){

            public void map() {
                ((JSlider)JSliderOperator.this.getSource()).removeChangeListener(changeListener);
            }
        });
    }

    public void setExtent(final int n) {
        this.runMapping(new Operator.MapVoidAction("setExtent"){

            public void map() {
                ((JSlider)JSliderOperator.this.getSource()).setExtent(n);
            }
        });
    }

    public void setInverted(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setInverted"){

            public void map() {
                ((JSlider)JSliderOperator.this.getSource()).setInverted(bl);
            }
        });
    }

    public void setLabelTable(final Dictionary dictionary) {
        this.runMapping(new Operator.MapVoidAction("setLabelTable"){

            public void map() {
                ((JSlider)JSliderOperator.this.getSource()).setLabelTable(dictionary);
            }
        });
    }

    public void setMajorTickSpacing(final int n) {
        this.runMapping(new Operator.MapVoidAction("setMajorTickSpacing"){

            public void map() {
                ((JSlider)JSliderOperator.this.getSource()).setMajorTickSpacing(n);
            }
        });
    }

    public void setMaximum(final int n) {
        this.runMapping(new Operator.MapVoidAction("setMaximum"){

            public void map() {
                ((JSlider)JSliderOperator.this.getSource()).setMaximum(n);
            }
        });
    }

    public void setMinimum(final int n) {
        this.runMapping(new Operator.MapVoidAction("setMinimum"){

            public void map() {
                ((JSlider)JSliderOperator.this.getSource()).setMinimum(n);
            }
        });
    }

    public void setMinorTickSpacing(final int n) {
        this.runMapping(new Operator.MapVoidAction("setMinorTickSpacing"){

            public void map() {
                ((JSlider)JSliderOperator.this.getSource()).setMinorTickSpacing(n);
            }
        });
    }

    public void setModel(final BoundedRangeModel boundedRangeModel) {
        this.runMapping(new Operator.MapVoidAction("setModel"){

            public void map() {
                ((JSlider)JSliderOperator.this.getSource()).setModel(boundedRangeModel);
            }
        });
    }

    public void setOrientation(final int n) {
        this.runMapping(new Operator.MapVoidAction("setOrientation"){

            public void map() {
                ((JSlider)JSliderOperator.this.getSource()).setOrientation(n);
            }
        });
    }

    public void setPaintLabels(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setPaintLabels"){

            public void map() {
                ((JSlider)JSliderOperator.this.getSource()).setPaintLabels(bl);
            }
        });
    }

    public void setPaintTicks(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setPaintTicks"){

            public void map() {
                ((JSlider)JSliderOperator.this.getSource()).setPaintTicks(bl);
            }
        });
    }

    public void setPaintTrack(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setPaintTrack"){

            public void map() {
                ((JSlider)JSliderOperator.this.getSource()).setPaintTrack(bl);
            }
        });
    }

    public void setSnapToTicks(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setSnapToTicks"){

            public void map() {
                ((JSlider)JSliderOperator.this.getSource()).setSnapToTicks(bl);
            }
        });
    }

    public void setUI(final SliderUI sliderUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            public void map() {
                ((JSlider)JSliderOperator.this.getSource()).setUI(sliderUI);
            }
        });
    }

    public void setValue(final int n) {
        this.runMapping(new Operator.MapVoidAction("setValue"){

            public void map() {
                ((JSlider)JSliderOperator.this.getSource()).setValue(n);
            }
        });
    }

    public void setValueIsAdjusting(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setValueIsAdjusting"){

            public void map() {
                ((JSlider)JSliderOperator.this.getSource()).setValueIsAdjusting(bl);
            }
        });
    }

    static {
        Timeouts.initDefault("JSliderOperator.OneScrollClickTimeout", 0L);
        Timeouts.initDefault("JSliderOperator.WholeScrollTimeout", 60000L);
        Timeouts.initDefault("JSliderOperator.ScrollingDelta", 0L);
    }

    private class ValueScrollAdjuster
    implements ScrollAdjuster {
        int value;

        public ValueScrollAdjuster(int n) {
            this.value = n;
        }

        public int getScrollDirection() {
            if (JSliderOperator.this.getValue() == this.value) {
                return 0;
            }
            return JSliderOperator.this.getValue() < this.value ? 1 : -1;
        }

        public int getScrollOrientation() {
            return JSliderOperator.this.getOrientation();
        }

        public String getDescription() {
            return "Scroll to " + Integer.toString(this.value) + " value";
        }
    }

    public static class JSliderFinder
    extends Operator.Finder {
        public JSliderFinder(ComponentChooser componentChooser) {
            super(class$javax$swing$JSlider == null ? (class$javax$swing$JSlider = JSliderOperator.class$("javax.swing.JSlider")) : class$javax$swing$JSlider, componentChooser);
        }

        public JSliderFinder() {
            super(class$javax$swing$JSlider == null ? (class$javax$swing$JSlider = JSliderOperator.class$("javax.swing.JSlider")) : class$javax$swing$JSlider);
        }
    }
}

