/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.WindowWaiter;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.ListDriver;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.EmptyVisualizer;

public class JComboBoxOperator
extends JComponentOperator
implements Timeoutable,
Outputable {
    public static final String TEXT_DPROP = "Text";
    public static final String ITEM_PREFIX_DPROP = "Item";
    private static final long BEFORE_SELECTING_TIMEOUT = 0L;
    private static final long WAIT_LIST_TIMEOUT = 60000L;
    private TestOut output;
    private Timeouts timeouts;
    private ComponentSearcher searcher;
    private JButtonOperator button;
    private JTextFieldOperator text;
    ListDriver driver = DriverManager.getListDriver(this.getClass());
    static /* synthetic */ Class class$javax$swing$JComboBox;

    public JComboBoxOperator(JComboBox jComboBox) {
        super(jComboBox);
    }

    public JComboBoxOperator(ContainerOperator containerOperator, ComponentChooser componentChooser, int n) {
        this((JComboBox)containerOperator.waitSubComponent(new JComboBoxFinder(componentChooser), n));
        this.copyEnvironment(containerOperator);
    }

    public JComboBoxOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        this(containerOperator, componentChooser, 0);
    }

    public JComboBoxOperator(ContainerOperator containerOperator, String string, int n) {
        this((JComboBox)JComboBoxOperator.waitComponent(containerOperator, (ComponentChooser)new JComboBoxByItemFinder(string, -1, containerOperator.getComparator()), n));
        this.copyEnvironment(containerOperator);
    }

    public JComboBoxOperator(ContainerOperator containerOperator, String string) {
        this(containerOperator, string, 0);
    }

    public JComboBoxOperator(ContainerOperator containerOperator, int n) {
        this((JComboBox)JComboBoxOperator.waitComponent(containerOperator, (ComponentChooser)new JComboBoxFinder(), n));
        this.copyEnvironment(containerOperator);
    }

    public JComboBoxOperator(ContainerOperator containerOperator) {
        this(containerOperator, 0);
    }

    public static JComboBox findJComboBox(Container container, ComponentChooser componentChooser, int n) {
        return (JComboBox)JComboBoxOperator.findComponent(container, new JComboBoxFinder(componentChooser), n);
    }

    public static JComboBox findJComboBox(Container container, ComponentChooser componentChooser) {
        return JComboBoxOperator.findJComboBox(container, componentChooser, 0);
    }

    public static JComboBox findJComboBox(Container container, String string, boolean bl, boolean bl2, int n, int n2) {
        return JComboBoxOperator.findJComboBox(container, new JComboBoxByItemFinder(string, n, new Operator.DefaultStringComparator(bl, bl2)), n2);
    }

    public static JComboBox findJComboBox(Container container, String string, boolean bl, boolean bl2, int n) {
        return JComboBoxOperator.findJComboBox(container, string, bl, bl2, n, 0);
    }

    public static JComboBox waitJComboBox(Container container, ComponentChooser componentChooser, int n) {
        return (JComboBox)JComboBoxOperator.waitComponent(container, (ComponentChooser)new JComboBoxFinder(componentChooser), n);
    }

    public static JComboBox waitJComboBox(Container container, ComponentChooser componentChooser) {
        return JComboBoxOperator.waitJComboBox(container, componentChooser, 0);
    }

    public static JComboBox waitJComboBox(Container container, String string, boolean bl, boolean bl2, int n, int n2) {
        return JComboBoxOperator.waitJComboBox(container, new JComboBoxByItemFinder(string, n, new Operator.DefaultStringComparator(bl, bl2)), n2);
    }

    public static JComboBox waitJComboBox(Container container, String string, boolean bl, boolean bl2, int n) {
        return JComboBoxOperator.waitJComboBox(container, string, bl, bl2, n, 0);
    }

    public void setTimeouts(Timeouts timeouts) {
        super.setTimeouts(timeouts);
        this.timeouts = timeouts;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut testOut) {
        super.setOutput(testOut);
        this.output = testOut;
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void copyEnvironment(Operator operator) {
        super.copyEnvironment(operator);
        this.driver = (ListDriver)DriverManager.getDriver("drivers.list", this.getClass(), operator.getProperties());
    }

    public JButton findJButton() {
        return (JButton)this.waitSubComponent(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return component instanceof JButton;
            }

            public String getDescription() {
                return "Button for combobox popup menu opening";
            }
        });
    }

    public JTextField findJTextField() {
        return (JTextField)this.waitSubComponent(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return component instanceof JTextField;
            }

            public String getDescription() {
                return "ComboBox's text field";
            }
        });
    }

    public JButtonOperator getButton() {
        if (this.button == null) {
            this.button = new JButtonOperator(this.findJButton());
            this.button.copyEnvironment(this);
            this.button.setOutput(this.getOutput().createErrorOutput());
        }
        return this.button;
    }

    public JTextFieldOperator getTextField() {
        if (((JComboBox)this.getSource()).isEditable()) {
            this.text = new JTextFieldOperator(this.findJTextField());
            this.text.copyEnvironment(this);
            this.text.setOutput(this.getOutput().createErrorOutput());
        }
        return this.text;
    }

    public JList waitList() {
        ListWater listWater = new ListWater();
        listWater.setOutput(this.output.createErrorOutput());
        Timeouts timeouts = this.timeouts.cloneThis();
        timeouts.setTimeout("Waiter.WaitingTime", timeouts.getTimeout("JComboBoxOperator.WaitListTimeout"));
        listWater.setTimeouts(timeouts);
        try {
            return (JList)listWater.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            this.output.printStackTrace(interruptedException);
            return null;
        }
    }

    public void pushComboButton() {
        this.makeComponentVisible();
        this.getButton().push();
    }

    public int findItemIndex(String string, Operator.StringComparator stringComparator) {
        ComboBoxModel comboBoxModel = this.getModel();
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            if (!stringComparator.equals(comboBoxModel.getElementAt(i).toString(), string)) continue;
            return i;
        }
        return -1;
    }

    public int waitItem(final String string, final Operator.StringComparator stringComparator) {
        this.getOutput().printLine("Wait item \"" + string + "\" available in combo box \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait item \"" + string + "\" available in combo box.");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return JComboBoxOperator.this.findItemIndex(string, stringComparator) > -1;
            }

            public String getDescription() {
                return "Item \"" + string + "\" available in combo box.";
            }
        });
        return this.findItemIndex(string, stringComparator);
    }

    public int waitItem(final int n) {
        this.getOutput().printLine("Wait item of index \"" + n + "\" available in combo box \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait item of index \"" + n + "\" available in combo box.");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return JComboBoxOperator.this.getModel().getSize() > n;
            }

            public String getDescription() {
                return "Item \"" + n + "\" available in combo box.";
            }
        });
        return n;
    }

    public void selectItem(String string, Operator.StringComparator stringComparator) {
        this.output.printLine("Select \"" + string + "\" item in combobox\n    : " + this.toStringSource());
        this.output.printGolden("Select \"" + string + "\" item in combobox");
        this.selectItem(this.waitItem(string, stringComparator));
    }

    public void selectItem(String string, boolean bl, boolean bl2) {
        this.selectItem(string, new Operator.DefaultStringComparator(bl, bl2));
    }

    public void selectItem(String string) {
        this.selectItem(string, this.getComparator());
    }

    public void selectItem(int n) {
        this.output.printLine("Select " + Integer.toString(n) + "'th item in combobox\n    : " + this.toStringSource());
        this.output.printGolden("Select " + Integer.toString(n) + "'th item in combobox");
        try {
            this.waitComponentEnabled();
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Interrupted", interruptedException);
        }
        this.driver.selectItem(this, this.waitItem(n));
        if (this.getVerification()) {
            this.waitItemSelected(n);
        }
    }

    public void typeText(String string) {
        this.makeComponentVisible();
        JTextFieldOperator jTextFieldOperator = this.getTextField();
        jTextFieldOperator.copyEnvironment(this);
        jTextFieldOperator.setVisualizer(new EmptyVisualizer());
        jTextFieldOperator.typeText(string);
    }

    public void clearText() {
        this.makeComponentVisible();
        JTextFieldOperator jTextFieldOperator = this.getTextField();
        jTextFieldOperator.copyEnvironment(this);
        jTextFieldOperator.setVisualizer(new EmptyVisualizer());
        jTextFieldOperator.clearText();
    }

    public void enterText(String string) {
        this.makeComponentVisible();
        JTextFieldOperator jTextFieldOperator = this.getTextField();
        jTextFieldOperator.copyEnvironment(this);
        jTextFieldOperator.setVisualizer(new EmptyVisualizer());
        jTextFieldOperator.enterText(string);
    }

    public void waitItemSelected(final int n) {
        this.getOutput().printLine("Wait " + Integer.toString(n) + "'th item to be selected in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait " + Integer.toString(n) + "'th item to be selected");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return JComboBoxOperator.this.getSelectedIndex() == n;
            }

            public String getDescription() {
                return "Has " + Integer.toString(n) + "'th item selected";
            }
        });
    }

    public void waitItemSelected(String string) {
        this.getOutput().printLine("Wait \"" + string + "\" item to be selected in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("WaitWait \"" + string + "\" item to be selected");
        this.waitState(new JComboBoxByItemFinder(string, -1, this.getComparator()));
    }

    public Hashtable getDump() {
        Hashtable hashtable = super.getDump();
        if (((JComboBox)this.getSource()).getSelectedItem() != null && ((JComboBox)this.getSource()).getSelectedItem().toString() != null) {
            hashtable.put(TEXT_DPROP, ((JComboBox)this.getSource()).getSelectedItem().toString());
        }
        Object[] objectArray = new String[((JComboBox)this.getSource()).getItemCount()];
        for (int i = 0; i < ((JComboBox)this.getSource()).getItemCount(); ++i) {
            if (((JComboBox)this.getSource()).getItemAt(i) == null || ((JComboBox)this.getSource()).getItemAt(i).toString() == null) continue;
            objectArray[i] = ((JComboBox)this.getSource()).getItemAt(i).toString();
        }
        this.addToDump(hashtable, ITEM_PREFIX_DPROP, objectArray);
        return hashtable;
    }

    public void actionPerformed(final ActionEvent actionEvent) {
        this.runMapping(new Operator.MapVoidAction("actionPerformed"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).actionPerformed(actionEvent);
            }
        });
    }

    public void addActionListener(final ActionListener actionListener) {
        this.runMapping(new Operator.MapVoidAction("addActionListener"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).addActionListener(actionListener);
            }
        });
    }

    public void addItem(final Object object) {
        this.runMapping(new Operator.MapVoidAction("addItem"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).addItem(object);
            }
        });
    }

    public void addItemListener(final ItemListener itemListener) {
        this.runMapping(new Operator.MapVoidAction("addItemListener"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).addItemListener(itemListener);
            }
        });
    }

    public void configureEditor(final ComboBoxEditor comboBoxEditor, final Object object) {
        this.runMapping(new Operator.MapVoidAction("configureEditor"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).configureEditor(comboBoxEditor, object);
            }
        });
    }

    public void contentsChanged(final ListDataEvent listDataEvent) {
        this.runMapping(new Operator.MapVoidAction("contentsChanged"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).contentsChanged(listDataEvent);
            }
        });
    }

    public String getActionCommand() {
        return (String)this.runMapping(new Operator.MapAction("getActionCommand"){

            public Object map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getActionCommand();
            }
        });
    }

    public ComboBoxEditor getEditor() {
        return (ComboBoxEditor)this.runMapping(new Operator.MapAction("getEditor"){

            public Object map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getEditor();
            }
        });
    }

    public Object getItemAt(final int n) {
        return this.runMapping(new Operator.MapAction("getItemAt"){

            public Object map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getItemAt(n);
            }
        });
    }

    public int getItemCount() {
        return this.runMapping(new Operator.MapIntegerAction("getItemCount"){

            public int map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getItemCount();
            }
        });
    }

    public JComboBox.KeySelectionManager getKeySelectionManager() {
        return (JComboBox.KeySelectionManager)this.runMapping(new Operator.MapAction("getKeySelectionManager"){

            public Object map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getKeySelectionManager();
            }
        });
    }

    public int getMaximumRowCount() {
        return this.runMapping(new Operator.MapIntegerAction("getMaximumRowCount"){

            public int map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getMaximumRowCount();
            }
        });
    }

    public ComboBoxModel getModel() {
        return (ComboBoxModel)this.runMapping(new Operator.MapAction("getModel"){

            public Object map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getModel();
            }
        });
    }

    public ListCellRenderer getRenderer() {
        return (ListCellRenderer)this.runMapping(new Operator.MapAction("getRenderer"){

            public Object map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getRenderer();
            }
        });
    }

    public int getSelectedIndex() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectedIndex"){

            public int map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getSelectedIndex();
            }
        });
    }

    public Object getSelectedItem() {
        return this.runMapping(new Operator.MapAction("getSelectedItem"){

            public Object map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getSelectedItem();
            }
        });
    }

    public Object[] getSelectedObjects() {
        return (Object[])this.runMapping(new Operator.MapAction("getSelectedObjects"){

            public Object map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getSelectedObjects();
            }
        });
    }

    public ComboBoxUI getUI() {
        return (ComboBoxUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).getUI();
            }
        });
    }

    public void hidePopup() {
        this.runMapping(new Operator.MapVoidAction("hidePopup"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).hidePopup();
            }
        });
    }

    public void insertItemAt(final Object object, final int n) {
        this.runMapping(new Operator.MapVoidAction("insertItemAt"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).insertItemAt(object, n);
            }
        });
    }

    public void intervalAdded(final ListDataEvent listDataEvent) {
        this.runMapping(new Operator.MapVoidAction("intervalAdded"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).intervalAdded(listDataEvent);
            }
        });
    }

    public void intervalRemoved(final ListDataEvent listDataEvent) {
        this.runMapping(new Operator.MapVoidAction("intervalRemoved"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).intervalRemoved(listDataEvent);
            }
        });
    }

    public boolean isEditable() {
        return this.runMapping(new Operator.MapBooleanAction("isEditable"){

            public boolean map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).isEditable();
            }
        });
    }

    public boolean isLightWeightPopupEnabled() {
        return this.runMapping(new Operator.MapBooleanAction("isLightWeightPopupEnabled"){

            public boolean map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).isLightWeightPopupEnabled();
            }
        });
    }

    public boolean isPopupVisible() {
        return this.runMapping(new Operator.MapBooleanAction("isPopupVisible"){

            public boolean map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).isPopupVisible();
            }
        });
    }

    public void processKeyEvent(final KeyEvent keyEvent) {
        this.runMapping(new Operator.MapVoidAction("processKeyEvent"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).processKeyEvent(keyEvent);
            }
        });
    }

    public void removeActionListener(final ActionListener actionListener) {
        this.runMapping(new Operator.MapVoidAction("removeActionListener"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).removeActionListener(actionListener);
            }
        });
    }

    public void removeAllItems() {
        this.runMapping(new Operator.MapVoidAction("removeAllItems"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).removeAllItems();
            }
        });
    }

    public void removeItem(final Object object) {
        this.runMapping(new Operator.MapVoidAction("removeItem"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).removeItem(object);
            }
        });
    }

    public void removeItemAt(final int n) {
        this.runMapping(new Operator.MapVoidAction("removeItemAt"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).removeItemAt(n);
            }
        });
    }

    public void removeItemListener(final ItemListener itemListener) {
        this.runMapping(new Operator.MapVoidAction("removeItemListener"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).removeItemListener(itemListener);
            }
        });
    }

    public boolean selectWithKeyChar(final char c) {
        return this.runMapping(new Operator.MapBooleanAction("selectWithKeyChar"){

            public boolean map() {
                return ((JComboBox)JComboBoxOperator.this.getSource()).selectWithKeyChar(c);
            }
        });
    }

    public void setActionCommand(final String string) {
        this.runMapping(new Operator.MapVoidAction("setActionCommand"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setActionCommand(string);
            }
        });
    }

    public void setEditable(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setEditable"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setEditable(bl);
            }
        });
    }

    public void setEditor(final ComboBoxEditor comboBoxEditor) {
        this.runMapping(new Operator.MapVoidAction("setEditor"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setEditor(comboBoxEditor);
            }
        });
    }

    public void setKeySelectionManager(final JComboBox.KeySelectionManager keySelectionManager) {
        this.runMapping(new Operator.MapVoidAction("setKeySelectionManager"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setKeySelectionManager(keySelectionManager);
            }
        });
    }

    public void setLightWeightPopupEnabled(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setLightWeightPopupEnabled"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setLightWeightPopupEnabled(bl);
            }
        });
    }

    public void setMaximumRowCount(final int n) {
        this.runMapping(new Operator.MapVoidAction("setMaximumRowCount"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setMaximumRowCount(n);
            }
        });
    }

    public void setModel(final ComboBoxModel comboBoxModel) {
        this.runMapping(new Operator.MapVoidAction("setModel"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setModel(comboBoxModel);
            }
        });
    }

    public void setPopupVisible(final boolean bl) {
        this.runMapping(new Operator.MapVoidAction("setPopupVisible"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setPopupVisible(bl);
            }
        });
    }

    public void setRenderer(final ListCellRenderer listCellRenderer) {
        this.runMapping(new Operator.MapVoidAction("setRenderer"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setRenderer(listCellRenderer);
            }
        });
    }

    public void setSelectedIndex(final int n) {
        this.runMapping(new Operator.MapVoidAction("setSelectedIndex"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setSelectedIndex(n);
            }
        });
    }

    public void setSelectedItem(final Object object) {
        this.runMapping(new Operator.MapVoidAction("setSelectedItem"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setSelectedItem(object);
            }
        });
    }

    public void setUI(final ComboBoxUI comboBoxUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).setUI(comboBoxUI);
            }
        });
    }

    public void showPopup() {
        this.runMapping(new Operator.MapVoidAction("showPopup"){

            public void map() {
                ((JComboBox)JComboBoxOperator.this.getSource()).showPopup();
            }
        });
    }

    private void init() {
        if (this.button == null) {
            this.button = new JButtonOperator(this.findJButton());
            this.button.copyEnvironment(this);
            this.button.setOutput(this.getOutput().createErrorOutput());
            if (((JComboBox)this.getSource()).isEditable()) {
                this.text = new JTextFieldOperator(this.findJTextField());
                this.text.copyEnvironment(this);
                this.text.setOutput(this.getOutput().createErrorOutput());
            }
        }
    }

    static {
        Timeouts.initDefault("JComboBoxOperator.BeforeSelectingTimeout", 0L);
        Timeouts.initDefault("JComboBoxOperator.WaitListTimeout", 60000L);
    }

    private class ListWater
    extends Waiter {
        ComponentChooser cChooser;
        ComponentChooser pChooser;

        public ListWater() {
            this.cChooser = new ComponentChooser(){

                public boolean checkComponent(Component component) {
                    if (component instanceof JList) {
                        Container container = (Container)component;
                        while ((container = container.getParent()) != null) {
                            if (!(container instanceof ComboPopup)) continue;
                            return true;
                        }
                    }
                    return false;
                }

                public String getDescription() {
                    return "Popup menu";
                }
            };
            this.pChooser = new PopupWindowChooser(this.cChooser);
        }

        public Object actionProduced(Object object) {
            Window window = null;
            window = this.pChooser.checkComponent(JComboBoxOperator.this.getWindow()) ? JComboBoxOperator.this.getWindow() : WindowWaiter.getWindow(JComboBoxOperator.this.getWindow(), this.pChooser);
            if (window != null) {
                ComponentSearcher componentSearcher = new ComponentSearcher(window);
                componentSearcher.setOutput(TestOut.getNullOutput());
                return componentSearcher.findComponent(this.cChooser);
            }
            return null;
        }

        public String getDescription() {
            return "Wait popup expanded";
        }
    }

    private class PopupWindowChooser
    implements ComponentChooser {
        ComponentChooser pChooser;

        public PopupWindowChooser(ComponentChooser componentChooser) {
            this.pChooser = componentChooser;
        }

        public boolean checkComponent(Component component) {
            ComponentSearcher componentSearcher = new ComponentSearcher((Container)component);
            componentSearcher.setOutput(TestOut.getNullOutput());
            return componentSearcher.findComponent(this.pChooser) != null;
        }

        public String getDescription() {
            return "Popup window";
        }
    }

    public static class JComboBoxFinder
    extends Operator.Finder {
        public JComboBoxFinder(ComponentChooser componentChooser) {
            super(class$javax$swing$JComboBox == null ? (class$javax$swing$JComboBox = JComboBoxOperator.class$("javax.swing.JComboBox")) : class$javax$swing$JComboBox, componentChooser);
        }

        public JComboBoxFinder() {
            super(class$javax$swing$JComboBox == null ? (class$javax$swing$JComboBox = JComboBoxOperator.class$("javax.swing.JComboBox")) : class$javax$swing$JComboBox);
        }
    }

    public static class JComboBoxByItemFinder
    implements ComponentChooser {
        String label;
        int itemIndex;
        Operator.StringComparator comparator;

        public JComboBoxByItemFinder(String string, int n, Operator.StringComparator stringComparator) {
            this.label = string;
            this.itemIndex = n;
            this.comparator = stringComparator;
        }

        public JComboBoxByItemFinder(String string, int n) {
            this(string, n, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component component) {
            if (component instanceof JComboBox) {
                if (this.label == null) {
                    return true;
                }
                if (((JComboBox)component).getModel().getSize() > this.itemIndex) {
                    int n = this.itemIndex;
                    if (n == -1 && (n = ((JComboBox)component).getSelectedIndex()) == -1) {
                        return false;
                    }
                    return this.comparator.equals(((JComboBox)component).getModel().getElementAt(n).toString(), this.label);
                }
            }
            return false;
        }

        public String getDescription() {
            return "JComboBox with text \"" + this.label + "\" in " + new Integer(this.itemIndex).toString() + "'th item";
        }
    }
}

