/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.scrolling;

import java.awt.Point;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.drivers.scrolling.AbstractScrollDriver;
import org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JSliderOperator;

public class JSliderAPIDriver
extends AbstractScrollDriver {
    private static final int SMALL_INCREMENT = 1;
    private QueueTool queueTool = new QueueTool();

    public JSliderAPIDriver() {
        super(new String[]{"org.netbeans.jemmy.operators.JSliderOperator"});
    }

    public void scrollToMinimum(ComponentOperator componentOperator, int n) {
        ((JSliderOperator)componentOperator).setValue(((JSliderOperator)componentOperator).getMinimum());
    }

    public void scrollToMaximum(ComponentOperator componentOperator, int n) {
        ((JSliderOperator)componentOperator).setValue(((JSliderOperator)componentOperator).getMaximum());
    }

    protected void step(ComponentOperator componentOperator, ScrollAdjuster scrollAdjuster) {
        JSliderOperator jSliderOperator = (JSliderOperator)componentOperator;
        int n = -1;
        if (scrollAdjuster.getScrollDirection() == -1) {
            n = jSliderOperator.getValue() > jSliderOperator.getMinimum() + this.getUnitIncrement(jSliderOperator) ? jSliderOperator.getValue() - this.getUnitIncrement(jSliderOperator) : jSliderOperator.getMinimum();
        } else if (scrollAdjuster.getScrollDirection() == 1) {
            n = jSliderOperator.getValue() < jSliderOperator.getMaximum() - this.getUnitIncrement(jSliderOperator) ? jSliderOperator.getValue() + this.getUnitIncrement(jSliderOperator) : jSliderOperator.getMaximum();
        }
        this.setValue(componentOperator, n);
    }

    private void setValue(ComponentOperator componentOperator, int n) {
        if (n != -1) {
            ((JSliderOperator)componentOperator).setValue(n);
        }
    }

    protected Timeout getScrollDeltaTimeout(ComponentOperator componentOperator) {
        return componentOperator.getTimeouts().create("JSliderOperator.ScrollingDelta");
    }

    protected void jump(ComponentOperator componentOperator, ScrollAdjuster scrollAdjuster) {
        JSliderOperator jSliderOperator = (JSliderOperator)componentOperator;
        int n = -1;
        if (scrollAdjuster.getScrollDirection() == -1) {
            n = jSliderOperator.getValue() > jSliderOperator.getMinimum() + this.getBlockIncrement(jSliderOperator) ? jSliderOperator.getValue() - this.getBlockIncrement(jSliderOperator) : jSliderOperator.getMinimum();
        } else if (scrollAdjuster.getScrollDirection() == 1) {
            n = jSliderOperator.getValue() < jSliderOperator.getMaximum() - this.getBlockIncrement(jSliderOperator) ? jSliderOperator.getValue() + this.getBlockIncrement(jSliderOperator) : jSliderOperator.getMaximum();
        }
        this.setValue(componentOperator, n);
    }

    protected void startPushAndWait(ComponentOperator componentOperator, int n, int n2) {
    }

    protected void stopPushAndWait(ComponentOperator componentOperator, int n, int n2) {
    }

    protected Point startDragging(ComponentOperator componentOperator) {
        return null;
    }

    protected void drop(ComponentOperator componentOperator, Point point) {
    }

    protected void drag(ComponentOperator componentOperator, Point point) {
    }

    protected boolean canDragAndDrop(ComponentOperator componentOperator) {
        return false;
    }

    protected boolean canJump(ComponentOperator componentOperator) {
        return this.isSmallIncrement((JSliderOperator)componentOperator);
    }

    protected boolean canPushAndWait(ComponentOperator componentOperator) {
        return false;
    }

    protected int getDragAndDropStepLength(ComponentOperator componentOperator) {
        return 1;
    }

    private int getUnitIncrement(JSliderOperator jSliderOperator) {
        return jSliderOperator.getMinorTickSpacing() == 0 ? 1 : jSliderOperator.getMinorTickSpacing();
    }

    private int getBlockIncrement(JSliderOperator jSliderOperator) {
        return jSliderOperator.getMajorTickSpacing() == 0 ? 1 : jSliderOperator.getMajorTickSpacing();
    }

    private boolean isSmallIncrement(JSliderOperator jSliderOperator) {
        return jSliderOperator.getMajorTickSpacing() <= 1 && jSliderOperator.getMajorTickSpacing() <= 1;
    }
}

