/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.menus;

import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.LightSupportiveDriver;
import org.netbeans.jemmy.drivers.MenuDriver;
import org.netbeans.jemmy.drivers.MouseDriver;
import org.netbeans.jemmy.drivers.PathChooser;
import org.netbeans.jemmy.operators.AbstractButtonOperator;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JMenuBarOperator;
import org.netbeans.jemmy.operators.JMenuItemOperator;
import org.netbeans.jemmy.operators.JMenuOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;

public class DefaultJMenuDriver
extends LightSupportiveDriver
implements MenuDriver {
    public DefaultJMenuDriver() {
        super(new String[]{"org.netbeans.jemmy.operators.JMenuOperator", "org.netbeans.jemmy.operators.JMenuBarOperator", "org.netbeans.jemmy.operators.JPopupMenuOperator"});
    }

    public Object pushMenu(ComponentOperator componentOperator, PathChooser pathChooser) {
        this.checkSupported(componentOperator);
        if (componentOperator instanceof JMenuBarOperator || componentOperator instanceof JPopupMenuOperator) {
            JMenuItemOperator jMenuItemOperator;
            JMenuItem jMenuItem = componentOperator instanceof JMenuBarOperator ? this.waitItem(componentOperator, (JMenuBar)componentOperator.getSource(), pathChooser, 0) : this.waitItem(componentOperator, (JPopupMenu)componentOperator.getSource(), pathChooser, 0);
            if (jMenuItem instanceof JMenu) {
                jMenuItemOperator = new JMenuOperator((JMenu)jMenuItem);
            } else if (jMenuItem instanceof JMenuItem) {
                jMenuItemOperator = new JMenuItemOperator(jMenuItem);
            } else {
                return null;
            }
            ((AbstractButtonOperator)jMenuItemOperator).copyEnvironment(componentOperator);
            return this.push(jMenuItemOperator, null, componentOperator instanceof JMenuBarOperator ? (JMenuBar)componentOperator.getSource() : null, pathChooser, 1, true);
        }
        return this.push(componentOperator, null, null, pathChooser, 0, true);
    }

    protected Object push(ComponentOperator componentOperator, ComponentOperator componentOperator2, JMenuBar jMenuBar, PathChooser pathChooser, int n, boolean bl) {
        try {
            componentOperator.waitComponentVisible(true);
            componentOperator.waitComponentEnabled();
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Interrupted!", interruptedException);
        }
        MouseDriver mouseDriver = DriverManager.getMouseDriver(componentOperator);
        this.smartMove(componentOperator2, componentOperator);
        if (n > pathChooser.getDepth() - 1) {
            if (!(componentOperator instanceof JMenuOperator) || jMenuBar == null || DefaultJMenuDriver.getSelectedElement(jMenuBar) == null) {
                DriverManager.getButtonDriver(componentOperator).push(componentOperator);
            }
            return componentOperator.getSource();
        }
        if (bl && !((JMenuOperator)componentOperator).isPopupMenuVisible() && (jMenuBar == null || DefaultJMenuDriver.getSelectedElement(jMenuBar) == null)) {
            DriverManager.getButtonDriver(componentOperator).push(componentOperator);
        }
        componentOperator.getTimeouts().sleep("JMenuOperator.WaitBeforePopupTimeout");
        JMenuItem jMenuItem = this.waitItem(componentOperator, this.waitPopupMenu(componentOperator), pathChooser, n);
        mouseDriver.exitMouse(componentOperator);
        if (jMenuItem instanceof JMenu) {
            JMenuOperator jMenuOperator = new JMenuOperator((JMenu)jMenuItem);
            jMenuOperator.copyEnvironment(componentOperator);
            return this.push(jMenuOperator, componentOperator, null, pathChooser, n + 1, false);
        }
        JMenuItemOperator jMenuItemOperator = new JMenuItemOperator(jMenuItem);
        jMenuItemOperator.copyEnvironment(componentOperator);
        try {
            jMenuItemOperator.waitComponentEnabled();
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Interrupted!", interruptedException);
        }
        this.smartMove(componentOperator, jMenuItemOperator);
        DriverManager.getButtonDriver(componentOperator).push(jMenuItemOperator);
        return jMenuItem;
    }

    private void smartMove(ComponentOperator componentOperator, ComponentOperator componentOperator2) {
        long l;
        if (componentOperator == null) {
            componentOperator2.enterMouse();
            return;
        }
        long l2 = (long)componentOperator.getSource().getLocationOnScreen().getX();
        long l3 = l2 + (long)componentOperator.getSource().getWidth();
        long l4 = (long)componentOperator.getSource().getLocationOnScreen().getY();
        long l5 = l4 + (long)componentOperator.getSource().getHeight();
        long l6 = (long)componentOperator2.getSource().getLocationOnScreen().getX();
        long l7 = l6 + (long)componentOperator2.getSource().getWidth();
        long l8 = (long)componentOperator2.getSource().getLocationOnScreen().getY();
        long l9 = l8 + (long)componentOperator2.getSource().getHeight();
        long l10 = l2 > l6 ? l2 : l6;
        long l11 = l3 < l7 ? l3 : l7;
        long l12 = l4 > l8 ? l4 : l8;
        long l13 = l = l5 < l9 ? l5 : l9;
        if (l10 < l11) {
            componentOperator.moveMouse((int)((l11 - l10) / 2L - l2), componentOperator.getCenterY());
            componentOperator2.moveMouse((int)((l11 - l10) / 2L - l6), componentOperator2.getCenterY());
            componentOperator2.enterMouse();
            return;
        }
        if (l12 < l) {
            componentOperator.moveMouse(componentOperator.getCenterX(), (int)((l - l12) / 2L - l4));
            componentOperator2.moveMouse(componentOperator.getCenterX(), (int)((l - l12) / 2L - l8));
            componentOperator2.enterMouse();
            return;
        }
        componentOperator2.enterMouse();
    }

    protected JPopupMenu waitPopupMenu(final ComponentOperator componentOperator) {
        return (JPopupMenu)JPopupMenuOperator.waitJPopupMenu(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return component == ((JMenuOperator)componentOperator).getPopupMenu() && component.isShowing();
            }

            public String getDescription() {
                return ((JMenuOperator)componentOperator).getText() + "'s popup";
            }
        }).getSource();
    }

    protected JMenuItem waitItem(ComponentOperator componentOperator, MenuElement menuElement, PathChooser pathChooser, int n) {
        Waiter waiter = new Waiter(new JMenuItemWaiter(menuElement, pathChooser, n));
        waiter.setOutput(componentOperator.getOutput().createErrorOutput());
        waiter.setTimeouts(componentOperator.getTimeouts());
        try {
            return (JMenuItem)waiter.waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Waiting has been interrupted", interruptedException);
        }
    }

    public static Object getSelectedElement(JMenuBar jMenuBar) {
        MenuElement[] menuElementArray = jMenuBar.getSubElements();
        for (int i = 0; i < menuElementArray.length; ++i) {
            if (!(menuElementArray[i] instanceof JMenu) || !((JMenu)menuElementArray[i]).isPopupMenuVisible()) continue;
            return menuElementArray[i];
        }
        return null;
    }

    private class JMenuItemWaiter
    implements Waitable {
        MenuElement cont;
        PathChooser chooser;
        int depth;

        public JMenuItemWaiter(MenuElement menuElement, PathChooser pathChooser, int n) {
            this.cont = menuElement;
            this.chooser = pathChooser;
            this.depth = n;
        }

        public Object actionProduced(Object object) {
            if (!((Component)((Object)this.cont)).isShowing()) {
                return null;
            }
            MenuElement[] menuElementArray = this.cont.getSubElements();
            for (int i = 0; i < menuElementArray.length; ++i) {
                if (!((Component)((Object)menuElementArray[i])).isShowing() || !((Component)((Object)menuElementArray[i])).isEnabled() || !this.chooser.checkPathComponent(this.depth, menuElementArray[i])) continue;
                return menuElementArray[i];
            }
            return null;
        }

        public String getDescription() {
            return "";
        }
    }
}

