/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers;

import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.drivers.ButtonDriver;
import org.netbeans.jemmy.drivers.DefaultDriverInstaller;
import org.netbeans.jemmy.drivers.Driver;
import org.netbeans.jemmy.drivers.FocusDriver;
import org.netbeans.jemmy.drivers.FrameDriver;
import org.netbeans.jemmy.drivers.InputDriverInstaller;
import org.netbeans.jemmy.drivers.InternalFrameDriver;
import org.netbeans.jemmy.drivers.KeyDriver;
import org.netbeans.jemmy.drivers.LightDriver;
import org.netbeans.jemmy.drivers.ListDriver;
import org.netbeans.jemmy.drivers.MenuDriver;
import org.netbeans.jemmy.drivers.MouseDriver;
import org.netbeans.jemmy.drivers.MultiSelListDriver;
import org.netbeans.jemmy.drivers.OrderedListDriver;
import org.netbeans.jemmy.drivers.ScrollDriver;
import org.netbeans.jemmy.drivers.TableDriver;
import org.netbeans.jemmy.drivers.TextDriver;
import org.netbeans.jemmy.drivers.TreeDriver;
import org.netbeans.jemmy.drivers.WindowDriver;
import org.netbeans.jemmy.operators.ComponentOperator;

public class DriverManager {
    public static final String DRIVER_ID = "drivers.";
    public static final String TREE_DRIVER_ID = "drivers.tree";
    public static final String TEXT_DRIVER_ID = "drivers.text";
    public static final String KEY_DRIVER_ID = "drivers.key";
    public static final String MOUSE_DRIVER_ID = "drivers.mouse";
    public static final String SCROLL_DRIVER_ID = "drivers.scroll";
    public static final String BUTTON_DRIVER_ID = "drivers.button";
    public static final String LIST_DRIVER_ID = "drivers.list";
    public static final String MULTISELLIST_DRIVER_ID = "drivers.multisellist";
    public static final String ORDEREDLIST_DRIVER_ID = "drivers.orderedlist";
    public static final String TABLE_DRIVER_ID = "drivers.table";
    public static final String WINDOW_DRIVER_ID = "drivers.window";
    public static final String FRAME_DRIVER_ID = "drivers.frame";
    public static final String INTERNAL_FRAME_DRIVER_ID = "drivers.internal_frame";
    public static final String FOCUS_DRIVER_ID = "drivers.focus";
    public static final String MENU_DRIVER_ID = "drivers.menu";
    static /* synthetic */ Class class$org$netbeans$jemmy$operators$ComponentOperator;

    private DriverManager() {
    }

    public static Object getDriver(String string, Class clazz, JemmyProperties jemmyProperties) {
        Object object = DriverManager.getADriver(string, clazz, jemmyProperties);
        if (object == null) {
            return DriverManager.getDriver(string, clazz);
        }
        return object;
    }

    public static Object getDriver(String string, ComponentOperator componentOperator) {
        return DriverManager.getDriver(string, componentOperator.getClass(), componentOperator.getProperties());
    }

    public static Object getDriver(String string, Class clazz) {
        Object object = DriverManager.getADriver(string, clazz, JemmyProperties.getProperties());
        if (object == null) {
            throw new JemmyException("No \"" + string + "\" driver registered for " + clazz.getName() + " class!");
        }
        return object;
    }

    public static void setDriver(String string, Object object, Class clazz) {
        JemmyProperties.setCurrentProperty(DriverManager.makeID(string, clazz), object);
        if (Boolean.getBoolean("drivers.trace_output")) {
            JemmyProperties.getCurrentOutput().printLine("Installing " + object.getClass().getName() + " drifer for " + clazz.getName() + " operators.");
        }
    }

    public static void setDriver(String string, Object object, String string2) {
        JemmyProperties.setCurrentProperty(DriverManager.makeID(string, string2), object);
        if (Boolean.getBoolean("drivers.trace_output")) {
            JemmyProperties.getCurrentOutput().printLine("Installing " + object.getClass().getName() + " drifer for " + string2 + " operators.");
        }
    }

    public static void setDriver(String string, Driver driver) {
        Class[] classArray = driver.getSupported();
        for (int i = 0; i < classArray.length; ++i) {
            DriverManager.setDriver(string, (Object)driver, classArray[i]);
        }
    }

    public static void setDriver(String string, LightDriver lightDriver) {
        String[] stringArray = lightDriver.getSupported();
        for (int i = 0; i < stringArray.length; ++i) {
            DriverManager.setDriver(string, (Object)lightDriver, stringArray[i]);
        }
    }

    public static void removeDriver(String string, Class clazz) {
        JemmyProperties.removeCurrentProperty(DriverManager.makeID(string, clazz));
        if (Boolean.getBoolean("drivers.trace_output")) {
            JemmyProperties.getCurrentOutput().printLine("Uninstalling a drifer for " + clazz.getName() + " operators.");
        }
    }

    public static void removeDriver(String string, String string2) {
        JemmyProperties.removeCurrentProperty(DriverManager.makeID(string, string2));
        if (Boolean.getBoolean("drivers.trace_output")) {
            JemmyProperties.getCurrentOutput().printLine("Uninstalling a drifer for " + string2 + " operators.");
        }
    }

    public static void removeDriver(String string, Class[] classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            DriverManager.removeDriver(string, classArray[i]);
        }
    }

    public static void removeDriver(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            DriverManager.removeDriver(string, stringArray[i]);
        }
    }

    public static void removeDrivers(String string) {
        String[] stringArray = JemmyProperties.getCurrentKeys();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string)) continue;
            JemmyProperties.removeCurrentProperty(stringArray[i]);
        }
    }

    public static TreeDriver getTreeDriver(Class clazz) {
        return (TreeDriver)DriverManager.getDriver(TREE_DRIVER_ID, clazz);
    }

    public static TreeDriver getTreeDriver(ComponentOperator componentOperator) {
        return (TreeDriver)DriverManager.getDriver(TREE_DRIVER_ID, componentOperator.getClass());
    }

    public static void setTreeDriver(TreeDriver treeDriver) {
        DriverManager.setDriver(TREE_DRIVER_ID, treeDriver);
    }

    public static TextDriver getTextDriver(Class clazz) {
        return (TextDriver)DriverManager.getDriver(TEXT_DRIVER_ID, clazz);
    }

    public static TextDriver getTextDriver(ComponentOperator componentOperator) {
        return (TextDriver)DriverManager.getDriver(TEXT_DRIVER_ID, componentOperator.getClass());
    }

    public static void setTextDriver(TextDriver textDriver) {
        DriverManager.setDriver(TEXT_DRIVER_ID, textDriver);
    }

    public static KeyDriver getKeyDriver(Class clazz) {
        return (KeyDriver)DriverManager.getDriver(KEY_DRIVER_ID, clazz);
    }

    public static KeyDriver getKeyDriver(ComponentOperator componentOperator) {
        return (KeyDriver)DriverManager.getDriver(KEY_DRIVER_ID, componentOperator.getClass());
    }

    public static void setKeyDriver(KeyDriver keyDriver) {
        DriverManager.setDriver(KEY_DRIVER_ID, keyDriver);
    }

    public static MouseDriver getMouseDriver(Class clazz) {
        return (MouseDriver)DriverManager.getDriver(MOUSE_DRIVER_ID, clazz);
    }

    public static MouseDriver getMouseDriver(ComponentOperator componentOperator) {
        return (MouseDriver)DriverManager.getDriver(MOUSE_DRIVER_ID, componentOperator.getClass());
    }

    public static void setMouseDriver(MouseDriver mouseDriver) {
        DriverManager.setDriver(MOUSE_DRIVER_ID, mouseDriver);
    }

    public static ScrollDriver getScrollDriver(Class clazz) {
        return (ScrollDriver)DriverManager.getDriver(SCROLL_DRIVER_ID, clazz);
    }

    public static ScrollDriver getScrollDriver(ComponentOperator componentOperator) {
        return (ScrollDriver)DriverManager.getDriver(SCROLL_DRIVER_ID, componentOperator.getClass());
    }

    public static void setScrollDriver(ScrollDriver scrollDriver) {
        DriverManager.setDriver(SCROLL_DRIVER_ID, scrollDriver);
    }

    public static ButtonDriver getButtonDriver(Class clazz) {
        return (ButtonDriver)DriverManager.getDriver(BUTTON_DRIVER_ID, clazz);
    }

    public static ButtonDriver getButtonDriver(ComponentOperator componentOperator) {
        return (ButtonDriver)DriverManager.getDriver(BUTTON_DRIVER_ID, componentOperator.getClass());
    }

    public static void setButtonDriver(ButtonDriver buttonDriver) {
        DriverManager.setDriver(BUTTON_DRIVER_ID, buttonDriver);
    }

    public static ListDriver getListDriver(Class clazz) {
        return (ListDriver)DriverManager.getDriver(LIST_DRIVER_ID, clazz);
    }

    public static ListDriver getListDriver(ComponentOperator componentOperator) {
        return (ListDriver)DriverManager.getDriver(LIST_DRIVER_ID, componentOperator.getClass());
    }

    public static void setListDriver(ListDriver listDriver) {
        DriverManager.setDriver(LIST_DRIVER_ID, listDriver);
    }

    public static MultiSelListDriver getMultiSelListDriver(Class clazz) {
        return (MultiSelListDriver)DriverManager.getDriver(MULTISELLIST_DRIVER_ID, clazz);
    }

    public static MultiSelListDriver getMultiSelListDriver(ComponentOperator componentOperator) {
        return (MultiSelListDriver)DriverManager.getDriver(MULTISELLIST_DRIVER_ID, componentOperator.getClass());
    }

    public static void setMultiSelListDriver(MultiSelListDriver multiSelListDriver) {
        DriverManager.setDriver(MULTISELLIST_DRIVER_ID, multiSelListDriver);
    }

    public static OrderedListDriver getOrderedListDriver(Class clazz) {
        return (OrderedListDriver)DriverManager.getDriver(ORDEREDLIST_DRIVER_ID, clazz);
    }

    public static OrderedListDriver getOrderedListDriver(ComponentOperator componentOperator) {
        return (OrderedListDriver)DriverManager.getDriver(ORDEREDLIST_DRIVER_ID, componentOperator.getClass());
    }

    public static void setOrderedListDriver(OrderedListDriver orderedListDriver) {
        DriverManager.setDriver(ORDEREDLIST_DRIVER_ID, orderedListDriver);
    }

    public static TableDriver getTableDriver(Class clazz) {
        return (TableDriver)DriverManager.getDriver(TABLE_DRIVER_ID, clazz);
    }

    public static TableDriver getTableDriver(ComponentOperator componentOperator) {
        return (TableDriver)DriverManager.getDriver(TABLE_DRIVER_ID, componentOperator.getClass());
    }

    public static void setTableDriver(TableDriver tableDriver) {
        DriverManager.setDriver(TABLE_DRIVER_ID, tableDriver);
    }

    public static WindowDriver getWindowDriver(Class clazz) {
        return (WindowDriver)DriverManager.getDriver(WINDOW_DRIVER_ID, clazz);
    }

    public static WindowDriver getWindowDriver(ComponentOperator componentOperator) {
        return (WindowDriver)DriverManager.getDriver(WINDOW_DRIVER_ID, componentOperator.getClass());
    }

    public static void setWindowDriver(WindowDriver windowDriver) {
        DriverManager.setDriver(WINDOW_DRIVER_ID, windowDriver);
    }

    public static FrameDriver getFrameDriver(Class clazz) {
        return (FrameDriver)DriverManager.getDriver(FRAME_DRIVER_ID, clazz);
    }

    public static FrameDriver getFrameDriver(ComponentOperator componentOperator) {
        return (FrameDriver)DriverManager.getDriver(FRAME_DRIVER_ID, componentOperator.getClass());
    }

    public static void setFrameDriver(FrameDriver frameDriver) {
        DriverManager.setDriver(FRAME_DRIVER_ID, frameDriver);
    }

    public static InternalFrameDriver getInternalFrameDriver(Class clazz) {
        return (InternalFrameDriver)DriverManager.getDriver(INTERNAL_FRAME_DRIVER_ID, clazz);
    }

    public static InternalFrameDriver getInternalFrameDriver(ComponentOperator componentOperator) {
        return (InternalFrameDriver)DriverManager.getDriver(INTERNAL_FRAME_DRIVER_ID, componentOperator.getClass());
    }

    public static void setInternalFrameDriver(InternalFrameDriver internalFrameDriver) {
        DriverManager.setDriver(INTERNAL_FRAME_DRIVER_ID, internalFrameDriver);
    }

    public static FocusDriver getFocusDriver(Class clazz) {
        return (FocusDriver)DriverManager.getDriver(FOCUS_DRIVER_ID, clazz);
    }

    public static FocusDriver getFocusDriver(ComponentOperator componentOperator) {
        return (FocusDriver)DriverManager.getDriver(FOCUS_DRIVER_ID, componentOperator.getClass());
    }

    public static void setFocusDriver(FocusDriver focusDriver) {
        DriverManager.setDriver(FOCUS_DRIVER_ID, focusDriver);
    }

    public static MenuDriver getMenuDriver(Class clazz) {
        return (MenuDriver)DriverManager.getDriver(MENU_DRIVER_ID, clazz);
    }

    public static MenuDriver getMenuDriver(ComponentOperator componentOperator) {
        return (MenuDriver)DriverManager.getDriver(MENU_DRIVER_ID, componentOperator.getClass());
    }

    public static void setMenuDriver(MenuDriver menuDriver) {
        DriverManager.setDriver(MENU_DRIVER_ID, menuDriver);
    }

    static void setDriver(String string, Object object) {
        if (object instanceof Driver) {
            DriverManager.setDriver(string, (Driver)object);
        } else if (object instanceof LightDriver) {
            DriverManager.setDriver(string, (LightDriver)object);
        } else {
            throw new JemmyException("Driver is neither Driver nor LightDriver " + object.toString());
        }
    }

    private static String makeID(String string, Class clazz) {
        return DriverManager.makeID(string, clazz.getName());
    }

    private static String makeID(String string, String string2) {
        return string + "." + string2;
    }

    private static Object getADriver(String string, Class clazz, JemmyProperties jemmyProperties) {
        Class clazz2 = clazz;
        do {
            Object object;
            if ((object = jemmyProperties.getProperty(DriverManager.makeID(string, clazz2))) == null) continue;
            return object;
        } while ((class$org$netbeans$jemmy$operators$ComponentOperator == null ? DriverManager.class$("org.netbeans.jemmy.operators.ComponentOperator") : class$org$netbeans$jemmy$operators$ComponentOperator).isAssignableFrom(clazz2 = clazz2.getSuperclass()));
        return null;
    }

    static {
        new InputDriverInstaller().install();
        new DefaultDriverInstaller().install();
    }
}

