/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.netbeans.jemmy.Timeout;

public class Timeouts {
    private static final long DELTA_TIME = 100L;
    private static Timeouts defaults;
    private Hashtable timeouts = new Hashtable();
    private static double timeoutsScale;

    public Timeouts() {
        this.setTimeout("Timeouts.DeltaTimeout", 100L);
        try {
            this.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setDefault(String string, long l) {
        defaults.setTimeout(string, l);
    }

    public static void initDefault(String string, long l) {
        defaults.initTimeout(string, l);
    }

    public static long getDefault(String string) {
        return defaults.getTimeout(string);
    }

    public static boolean containsDefault(String string) {
        return defaults.contains(string);
    }

    public void loadDefaults(InputStream inputStream) throws IOException {
        defaults.load(inputStream);
    }

    public void loadDefaults(String string) throws FileNotFoundException, IOException {
        defaults.load(string);
    }

    public void loadDefaults() throws FileNotFoundException, IOException {
        defaults.load();
    }

    public Timeout create(String string) {
        return new Timeout(string, this.getTimeout(string));
    }

    public Timeout createDelta() {
        return this.create("Timeouts.DeltaTimeout");
    }

    public boolean contains(String string) {
        return this.timeouts.containsKey(string);
    }

    public long setTimeout(String string, long l) {
        long l2 = -1L;
        if (this.contains(string)) {
            l2 = this.getTimeout(string);
            this.timeouts.remove(string);
        }
        this.timeouts.put(string, new Long(l));
        return l2;
    }

    public long getTimeout(String string) {
        long l;
        if (this.contains(string) && this.timeouts.get(string) != null) {
            l = (Long)this.timeouts.get(string);
            l = (long)((double)l * Timeouts.getTimeoutsScale());
        } else {
            l = this != defaults ? Timeouts.getDefault(string) : -1L;
        }
        return l;
    }

    public long getDeltaTimeout() {
        return this.getTimeout("Timeouts.DeltaTimeout");
    }

    public long initTimeout(String string, long l) {
        long l2 = this.getTimeout(string);
        if (!this.contains(string)) {
            this.setTimeout(string, l);
        }
        return l2;
    }

    public Timeouts cloneThis() {
        Timeouts timeouts = new Timeouts();
        Enumeration enumeration = this.timeouts.keys();
        String string = "";
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            timeouts.setTimeout(string, this.getTimeout(string));
        }
        return timeouts;
    }

    public void eSleep(String string) throws InterruptedException {
        if (this.contains(string) || defaults.contains(string)) {
            Thread.currentThread();
            Thread.sleep(this.getTimeout(string));
        }
    }

    public void sleep(String string) {
        this.create(string).sleep();
    }

    public void print(PrintWriter printWriter) {
        Enumeration enumeration = this.timeouts.keys();
        String string = "";
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            printWriter.println(string + " = " + Long.toString(this.getTimeout(string)));
        }
        printWriter.println("Default values:");
        enumeration = Timeouts.defaults.timeouts.keys();
        string = "";
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (this.contains(string)) continue;
            printWriter.println(string + " = " + Long.toString(Timeouts.getDefault(string)));
        }
    }

    public void print(PrintStream printStream) {
        this.print(new PrintWriter(printStream));
        Timeouts timeouts = new Timeouts();
    }

    public void load(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        Enumeration<?> enumeration = properties.propertyNames();
        long l = -1L;
        String string = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            l = -1L;
            l = new Long(properties.getProperty(string));
            this.setTimeout(string, l);
        }
    }

    public void load(String string) throws FileNotFoundException, IOException {
        this.load(new FileInputStream(string));
    }

    public void load() throws FileNotFoundException, IOException {
        if (System.getProperty("jemmy.timeouts") != null && !System.getProperty("jemmy.timeouts").equals("")) {
            this.load(System.getProperty("jemmy.timeouts"));
        }
    }

    public void loadDebugTimeouts() throws IOException {
        this.load(this.getClass().getClassLoader().getResourceAsStream("org/netbeans/jemmy/debug.timeouts"));
    }

    public static double getTimeoutsScale() {
        if (timeoutsScale == -1.0) {
            String string = System.getProperty("jemmy.timeouts.scale", "1");
            try {
                timeoutsScale = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                timeoutsScale = 1.0;
            }
        }
        if (timeoutsScale < 0.0) {
            timeoutsScale = 1.0;
        }
        return timeoutsScale;
    }

    static void resetTimeoutScale() {
        timeoutsScale = -1.0;
    }

    static {
        timeoutsScale = -1.0;
        defaults = new Timeouts();
    }
}

