/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy;

import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;

public class ActionProducer
extends Thread
implements Action,
Waitable,
Timeoutable {
    private static final long ACTION_TIMEOUT = 10000L;
    private Action action;
    private boolean needWait = true;
    private Object parameter;
    private boolean finished;
    private Object result = null;
    private Timeouts timeouts;
    private Waiter waiter = new Waiter(this);
    private TestOut output;
    private Throwable exception;

    public ActionProducer(Action action) {
        this.action = action;
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
        this.setOutput(JemmyProperties.getProperties().getOutput());
        this.finished = false;
        this.exception = null;
    }

    public ActionProducer(Action action, boolean bl) {
        this.action = action;
        this.needWait = bl;
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
        this.setOutput(JemmyProperties.getProperties().getOutput());
        this.finished = false;
        this.exception = null;
    }

    protected ActionProducer() {
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
        this.setOutput(JemmyProperties.getProperties().getOutput());
        this.finished = false;
        this.exception = null;
    }

    protected ActionProducer(boolean bl) {
        this.needWait = bl;
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
        this.setOutput(JemmyProperties.getProperties().getOutput());
        this.finished = false;
        this.exception = null;
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut testOut) {
        this.output = testOut;
        this.waiter.setOutput(this.output);
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setActionPriority(int n) {
        int n2 = n < 1 ? 1 : (n > 10 ? 10 : n);
        try {
            this.setPriority(n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public Object getResult() {
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFinished() {
        ActionProducer actionProducer = this;
        synchronized (actionProducer) {
            return this.finished;
        }
    }

    public Object launch(Object object) {
        return null;
    }

    public String getDescription() {
        if (this.action != null) {
            return this.action.getDescription();
        }
        return "Unknown action";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object produceAction(Object object) throws InterruptedException {
        this.parameter = object;
        Object object2 = this;
        synchronized (object2) {
            this.finished = false;
        }
        this.start();
        if (this.needWait) {
            object2 = this.timeouts.cloneThis();
            ((Timeouts)object2).setTimeout("Waiter.WaitingTime", this.timeouts.getTimeout("ActionProducer.MaxActionTime"));
            this.waiter.setTimeouts((Timeouts)object2);
            try {
                this.waiter.waitAction(null);
            }
            catch (TimeoutExpiredException timeoutExpiredException) {
                this.output.printError("Timeout for \"" + this.getDescription() + "\" action has been expired. Thread has been interrupted.");
                this.interrupt();
                throw timeoutExpiredException;
            }
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        this.result = null;
        try {
            this.result = this.launchAction(this.parameter);
        }
        catch (Throwable throwable) {
            this.exception = throwable;
        }
        ActionProducer actionProducer = this;
        synchronized (actionProducer) {
            this.finished = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object actionProduced(Object object) {
        ActionProducer actionProducer = this;
        synchronized (actionProducer) {
            if (this.finished) {
                if (this.result == null) {
                    return new Integer(0);
                }
                return this.result;
            }
            return null;
        }
    }

    private Object launchAction(Object object) {
        if (this.action != null) {
            return this.action.launch(object);
        }
        return this.launch(object);
    }

    static {
        Timeouts.initDefault("ActionProducer.MaxActionTime", 10000L);
    }
}

