/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.extexecution.api.ExecutionDescriptor;
import org.netbeans.modules.extexecution.api.ExecutionService;
import org.netbeans.modules.extexecution.api.input.InputProcessor;
import org.netbeans.modules.extexecution.api.input.InputProcessors;
import org.netbeans.modules.extexecution.api.input.LineProcessor;
import org.netbeans.modules.groovy.grails.api.ExecutionSupport;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grails.api.GrailsRuntime;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.SourceCategory;
import org.netbeans.modules.groovy.grailsproject.actions.RefreshProjectRunnable;
import org.netbeans.modules.groovy.grailsproject.ui.wizards.GetArtifactNameStep;
import org.netbeans.modules.groovy.grailsproject.ui.wizards.GrailsArtifacts;
import org.netbeans.modules.groovy.grailsproject.ui.wizards.NewGrailsProjectWizardIterator;
import org.netbeans.modules.groovy.grailsproject.ui.wizards.ProgressSnooper;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewArtifactWizardIterator
implements WizardDescriptor.InstantiatingIterator<WizardDescriptor>,
WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
    private GetArtifactNameStep pls = null;
    private boolean serverRunning = false;
    private boolean serverConfigured = true;
    private WizardDescriptor wizard;
    private SourceCategory sourceCategory;
    private String serverCommand;
    private String artifactName = "";
    private GrailsProject project;
    private final Logger LOG = Logger.getLogger(NewArtifactWizardIterator.class.getName());

    public static NewArtifactWizardIterator create() {
        return new NewArtifactWizardIterator();
    }

    public NewArtifactWizardIterator(GrailsProject grailsProject, SourceCategory sourceCategory, String string) {
        this.project = grailsProject;
        this.sourceCategory = sourceCategory;
        this.artifactName = string;
    }

    private NewArtifactWizardIterator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set instantiate(final ProgressHandle progressHandle) throws IOException {
        String string;
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        this.serverRunning = true;
        progressHandle.start(100);
        try {
            object = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
            string = object.getDisplayName() + " (" + this.serverCommand + ")";
            Callable callable = ExecutionSupport.getInstance().createSimpleCommand(this.serverCommand, GrailsProjectConfig.forProject((Project)this.project), new String[]{this.pls.getArtifactName()});
            ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().frontWindow(true).inputVisible(true);
            executionDescriptor = executionDescriptor.outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

                public InputProcessor newInputProcessor() {
                    return InputProcessors.bridge((LineProcessor)new ProgressSnooper(progressHandle, 100, 2));
                }
            });
            executionDescriptor = executionDescriptor.postExecution((Runnable)new RefreshProjectRunnable(this.project));
            ExecutionService executionService = ExecutionService.newService((Callable)callable, (ExecutionDescriptor)executionDescriptor, (String)string);
            Future future = executionService.run();
            try {
                future.get();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {
                Exceptions.printStackTrace((Throwable)executionException.getCause());
            }
        }
        finally {
            progressHandle.progress(100);
        }
        this.serverRunning = false;
        this.LOG.log(Level.FINEST, "Artifact Name: " + this.pls.getFileName());
        object = new File(this.pls.getFileName());
        if (object != null) {
            this.LOG.log(Level.FINEST, "Created File: " + ((File)object).getAbsolutePath());
            this.project.getProjectDirectory().getFileSystem().refresh(true);
            object = FileUtil.normalizeFile((File)object);
            string = FileUtil.toFileObject((File)object);
            if (string == null) {
                this.LOG.log(Level.WARNING, "Problem creating FileObject(null): " + ((File)object).getAbsolutePath());
            }
            hashSet.add(string);
        }
        return hashSet;
    }

    public Set instantiate() throws IOException {
        HashSet hashSet = new HashSet();
        return hashSet;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        FileObject fileObject = Templates.getTemplate((WizardDescriptor)wizardDescriptor);
        this.wizard = wizardDescriptor;
        if (this.sourceCategory == null) {
            this.sourceCategory = GrailsArtifacts.getCategoryForTemplate(fileObject);
        }
        if (this.project == null) {
            this.project = (GrailsProject)Templates.getProject((WizardDescriptor)wizardDescriptor);
        }
        this.serverCommand = this.sourceCategory.getCommand();
        if (!GrailsRuntime.getInstance().isConfigured()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(NewArtifactWizardIterator.class, (String)"NewGrailsProjectWizardIterator.NoGrailsServerConfigured"));
            this.serverConfigured = false;
        }
        this.pls = new GetArtifactNameStep(this.serverRunning, this.serverConfigured, this.project, this.sourceCategory);
        Component component = this.pls.getComponent();
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", 1);
            String string = GrailsArtifacts.getWizardTitle(this.sourceCategory);
            jComponent.putClientProperty("WizardPanel_contentData", new String[]{NbBundle.getMessage(NewGrailsProjectWizardIterator.class, (String)"LBL_ChooseFileType"), string});
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.pls;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(NewArtifactWizardIterator.class, (String)"LAB_IteratorName"), 1, 1);
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void nextPanel() {
    }

    public void previousPanel() {
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }
}

