/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.classpath;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.groovy.grailsproject.classpath.SourceRoots;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProjectClassPathImplementation
implements ClassPathImplementation {
    private List<PathResourceImplementation> resources;
    private final File projectRoot;

    public ProjectClassPathImplementation(FileObject fileObject) {
        this.projectRoot = FileUtil.toFile((FileObject)fileObject);
    }

    public synchronized List<PathResourceImplementation> getResources() {
        if (this.resources == null) {
            this.resources = this.getPath();
        }
        return this.resources;
    }

    private List<PathResourceImplementation> getPath() {
        ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
        ProjectClassPathImplementation.addLibs(this.projectRoot, arrayList);
        File file = new File(this.projectRoot, "plugins");
        if (file.isDirectory()) {
            for (String string : file.list()) {
                File file2 = new File(file, string);
                if (!file2.isDirectory()) continue;
                ProjectClassPathImplementation.addLibs(file2, arrayList);
                ProjectClassPathImplementation.addSources(file2, arrayList);
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static void addLibs(File file, List<PathResourceImplementation> list) {
        File[] fileArray = new File(file, "lib").listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                try {
                    URL uRL;
                    if (!file2.isFile() || !FileUtil.isArchiveFile((URL)(uRL = file2.toURI().toURL()))) continue;
                    uRL = FileUtil.getArchiveRoot((URL)uRL);
                    list.add(ClassPathSupport.createResource((URL)uRL));
                }
                catch (MalformedURLException malformedURLException) {
                    assert (false) : malformedURLException;
                }
            }
        }
    }

    private static void addSources(File file, List<PathResourceImplementation> list) {
        SourceRoots sourceRoots = new SourceRoots(FileUtil.toFileObject((File)file));
        for (URL uRL : sourceRoots.getRootURLs()) {
            list.add(ClassPathSupport.createResource((URL)uRL));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }
}

