/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.groovy.editor.NbUtilities;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.actions.GotoControllerAction;
import org.netbeans.modules.groovy.grailsproject.actions.GotoDomainClassAction;
import org.netbeans.modules.groovy.grailsproject.actions.GotoViewAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public class NavigationSupport {
    public static boolean isActionEnabled(AbstractAction abstractAction) {
        JTextComponent jTextComponent = Utilities.getFocusedComponent();
        String string = NavigationSupport.getTargetFilename(abstractAction, jTextComponent);
        return string != null && new File(string).canRead();
    }

    private static DataObject getDataObjectFromComponent(JTextComponent jTextComponent) {
        Logger logger = Logger.getLogger(NavigationSupport.class.getName());
        logger.setLevel(Level.OFF);
        if (jTextComponent == null) {
            logger.log(Level.FINEST, "JTextComponent == null");
            return null;
        }
        Document document = jTextComponent.getDocument();
        if (document == null) {
            logger.log(Level.FINEST, "Document == null");
            return null;
        }
        return NbEditorUtilities.getDataObject((Document)document);
    }

    private static GrailsProject getOwningProject(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project instanceof GrailsProject) {
            return (GrailsProject)project;
        }
        return null;
    }

    private static String getTargetFilename(AbstractAction abstractAction, JTextComponent jTextComponent) {
        String string;
        Object object;
        Logger logger = Logger.getLogger(NavigationSupport.class.getName());
        logger.setLevel(Level.OFF);
        logger.log(Level.FINEST, "openArtifact()");
        DataObject dataObject = NavigationSupport.getDataObjectFromComponent(jTextComponent);
        if (dataObject == null) {
            logger.log(Level.FINEST, "DataObject == null");
            return null;
        }
        String string2 = dataObject.getName();
        FileObject fileObject = dataObject.getPrimaryFile();
        if (fileObject == null) {
            logger.log(Level.FINEST, "FileObject == null");
            return null;
        }
        logger.log(Level.FINEST, "Source Name : {0}", string2);
        GrailsProject grailsProject = NavigationSupport.getOwningProject(fileObject);
        if (grailsProject == null) {
            logger.log(Level.FINEST, "Not a grails-project");
            return null;
        }
        String string3 = fileObject.getMIMEType();
        if (!string3.equals("text/x-groovy") && !string3.equals("application/x-gsp")) {
            logger.log(Level.FINEST, "Not a groovy mimetype : {0}", string3);
            return null;
        }
        if (string3.equals("application/x-gsp")) {
            object = fileObject.getParent().getName();
            string = ((String)object).substring(0, 1).toUpperCase() + ((String)object).substring(1);
        } else {
            string = string2;
        }
        object = NavigationSupport.actionToType(abstractAction);
        return NavigationSupport.getTargetPath((ActionType)((Object)object), grailsProject, string);
    }

    public static void openArtifact(AbstractAction abstractAction, JTextComponent jTextComponent) {
        Logger logger = Logger.getLogger(NavigationSupport.class.getName());
        logger.setLevel(Level.OFF);
        String string = NavigationSupport.getTargetFilename(abstractAction, jTextComponent);
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(string)));
        if (fileObject != null && fileObject.isValid()) {
            logger.log(Level.FINEST, "Open File : {0}", FileUtil.getFileDisplayName((FileObject)fileObject));
            NbUtilities.open((FileObject)fileObject, (int)1, (String)"");
        } else {
            logger.log(Level.FINEST, "File is either null or invalid : {0}", string);
        }
    }

    private static String getTargetPath(ActionType actionType, GrailsProject grailsProject, String string) {
        String string2 = "grails-app";
        String string3 = FileUtil.getFileDisplayName((FileObject)grailsProject.getProjectDirectory()) + File.separator + string2 + File.separator;
        if (string.endsWith("Controller")) {
            string = string.replaceAll("Controller$", "");
        }
        switch (actionType) {
            case CONTROLLER: {
                return string3 + "controllers" + File.separator + string + "Controller.groovy";
            }
            case DOMAIN: {
                return string3 + "domain" + File.separator + string + ".groovy";
            }
            case VIEW: {
                return string3 + "views" + File.separator + string.toLowerCase() + File.separator + "show.gsp";
            }
        }
        return "";
    }

    private static ActionType actionToType(AbstractAction abstractAction) {
        if (abstractAction instanceof GotoDomainClassAction) {
            return ActionType.DOMAIN;
        }
        if (abstractAction instanceof GotoViewAction) {
            return ActionType.VIEW;
        }
        if (abstractAction instanceof GotoControllerAction) {
            return ActionType.CONTROLLER;
        }
        return ActionType.NONE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ActionType {
        DOMAIN,
        VIEW,
        CONTROLLER,
        NONE;

    }
}

