/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.classview;

import java.awt.BorderLayout;
import java.io.ObjectStreamException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmModelStateListener;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.classview.ClassView;
import org.netbeans.modules.cnd.classview.Diagnostic;
import org.netbeans.modules.cnd.classview.resources.I18n;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ClassViewTopComponent
extends TopComponent
implements CsmModelListener,
CsmModelStateListener {
    static final long serialVersionUID = 420172427347975689L;
    private static final String PREFERRED_ID = "classview";
    public static transient ClassViewTopComponent DEFAULT;
    public static final String OPENED_PREFERENCE = "ClassViewWasOpened";
    private transient ClassView view;
    private transient boolean modelOn = true;
    public static final String ICON_PATH = "org/netbeans/modules/cnd/classview/resources/class_view.png";
    private boolean isAutoMode = false;

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public static synchronized ClassViewTopComponent findDefault() {
        if (DEFAULT == null) {
            TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
            if (DEFAULT == null) {
                ErrorManager.getDefault().log(16, "Cannot find ClassView component. It will not be located properly in the window system.");
                ClassViewTopComponent.getDefault();
            }
        }
        return DEFAULT;
    }

    public static synchronized ClassViewTopComponent getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new ClassViewTopComponent();
        }
        return DEFAULT;
    }

    public Object readResolve() throws ObjectStreamException {
        if (DEFAULT == null) {
            DEFAULT = this;
        }
        return this;
    }

    public int getPersistenceType() {
        return 0;
    }

    protected void componentOpened() {
        if (Diagnostic.DEBUG) {
            Diagnostic.trace("ClassesTC: componentOpened()");
        }
        if (this.view == null) {
            this.view = new ClassView();
            this.setLayout(new BorderLayout());
            this.setToolTipText(I18n.getMessage("ClassViewTitle"));
            this.setName(I18n.getMessage("ClassViewTooltip"));
            this.setIcon(Utilities.loadImage((String)ICON_PATH));
        }
        this.view.startup();
        this.addRemoveModelListeners(true);
        if (CsmModelAccessor.getModel().projects().isEmpty()) {
            this.removeAll();
            this.add(this.createEmptyContent(), "Center");
        } else {
            this.add(this.view, "Center");
        }
    }

    public void closeImplicit() {
        this.isAutoMode = true;
        this.close();
    }

    public void selectInClasses(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        if (this.view != null) {
            this.view.selectInClasses(csmOffsetableDeclaration);
        }
    }

    protected void componentClosed() {
        if (Diagnostic.DEBUG) {
            Diagnostic.trace("ClassesTC: componentClosed()");
        }
        if (!this.isAutoMode) {
            Preferences preferences = NbPreferences.forModule(ClassViewTopComponent.class);
            preferences.putBoolean(OPENED_PREFERENCE, true);
        }
        this.isAutoMode = false;
        this.addRemoveModelListeners(false);
        if (this.view != null) {
            this.view.shutdown();
        }
    }

    protected void componentActivated() {
        if (Diagnostic.DEBUG) {
            Diagnostic.trace("ClassesTC: componentActivated()");
        }
        super.componentActivated();
        this.view.requestFocus();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("UsingClassView");
    }

    private void addRemoveModelListeners(boolean bl) {
        if (bl) {
            CsmListeners.getDefault().addModelListener((CsmModelListener)this);
            CsmListeners.getDefault().addModelStateListener((CsmModelStateListener)this);
        } else {
            CsmListeners.getDefault().removeModelListener((CsmModelListener)this);
            CsmListeners.getDefault().removeModelStateListener((CsmModelStateListener)this);
        }
    }

    public void modelStateChanged(CsmModelState csmModelState, CsmModelState csmModelState2) {
        switch (csmModelState) {
            case ON: {
                this.modelOn = true;
                break;
            }
            case CLOSING: {
                this.modelOn = false;
                if (!Diagnostic.DEBUG) break;
                Diagnostic.trace("ClassesTC: model switched off");
            }
        }
    }

    public void projectOpened(CsmProject csmProject) {
        if (!this.modelOn) {
            return;
        }
        if (this.view != null) {
            this.view.projectOpened(csmProject);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ClassViewTopComponent.this.removeAll();
                    ClassViewTopComponent.this.add(ClassViewTopComponent.this.view, "Center");
                    ClassViewTopComponent.this.validate();
                }
            });
        }
    }

    public void projectClosed(CsmProject csmProject) {
        if (!this.modelOn) {
            return;
        }
        if (this.view != null) {
            this.view.projectClosed(csmProject);
        }
        if (CsmModelAccessor.getModel().projects().isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ClassViewTopComponent.this.removeAll();
                    ClassViewTopComponent.this.add(ClassViewTopComponent.this.createEmptyContent(), "Center");
                    ClassViewTopComponent.this.validate();
                }
            });
        }
    }

    private JComponent createEmptyContent() {
        JButton jButton = new JButton(I18n.getMessage("NoProjectOpen"));
        jButton.setEnabled(false);
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setBackground(new JTextArea().getBackground());
        return jButton;
    }

    public void modelChanged(CsmChangeEvent csmChangeEvent) {
        if (!this.modelOn) {
            return;
        }
        if (this.view != null) {
            this.view.modelChanged(csmChangeEvent);
        }
    }
}

