/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.javascript.ui;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.javascript.JsElementCtx;
import org.netbeans.modules.refactoring.javascript.RetoucheUtils;
import org.netbeans.modules.refactoring.javascript.api.WhereUsedQueryConstants;
import org.netbeans.modules.refactoring.javascript.ui.WhereUsedPanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.napi.gsfret.source.ClasspathInfo;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class WhereUsedQueryUI
implements RefactoringUI {
    private WhereUsedQuery query = null;
    private final String name;
    private WhereUsedPanel panel;
    private final JsElementCtx element;
    private ElementKind kind;
    private AbstractRefactoring delegate;
    private ResourceBundle bundle;

    public WhereUsedQueryUI(JsElementCtx jsElementCtx, CompilationInfo compilationInfo) {
        this.query = new WhereUsedQuery(Lookups.singleton((Object)jsElementCtx));
        ClasspathInfo classpathInfo = RetoucheUtils.getClasspathInfoFor(jsElementCtx);
        if (classpathInfo != null) {
            this.query.getContext().add((Object)classpathInfo);
        }
        this.element = jsElementCtx;
        this.name = jsElementCtx.getName();
        this.kind = jsElementCtx.getKind();
    }

    public WhereUsedQueryUI(JsElementCtx jsElementCtx, String string, AbstractRefactoring abstractRefactoring) {
        this.delegate = abstractRefactoring;
        this.element = jsElementCtx;
        this.name = string;
    }

    public boolean isQuery() {
        return true;
    }

    public CustomRefactoringPanel getPanel(ChangeListener changeListener) {
        if (this.panel == null) {
            this.panel = new WhereUsedPanel(this.name, this.element, changeListener);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.query.putValue((Object)"SEARCH_IN_COMMENTS", (Object)this.panel.isSearchInComments());
        if (this.kind == ElementKind.METHOD) {
            this.setForMethod();
            return this.query.checkParameters();
        }
        if (this.kind == ElementKind.MODULE || this.kind == ElementKind.CLASS) {
            this.setForClass();
            return this.query.checkParameters();
        }
        return null;
    }

    private void setForMethod() {
        if (this.panel.isMethodFromBaseClass()) {
            this.query.setRefactoringSource(Lookups.singleton((Object)this.panel.getBaseMethod()));
        } else {
            this.query.setRefactoringSource(Lookups.singleton((Object)this.element));
        }
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS, (Object)this.panel.isMethodOverriders());
        this.query.putValue((Object)"FIND_REFERENCES", (Object)this.panel.isMethodFindUsages());
    }

    private void setForClass() {
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES, (Object)this.panel.isClassSubTypes());
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES, (Object)this.panel.isClassSubTypesDirectOnly());
        this.query.putValue((Object)"FIND_REFERENCES", (Object)this.panel.isClassFindUsages());
    }

    public Problem checkParameters() {
        if (this.kind == ElementKind.METHOD) {
            this.setForMethod();
            return this.query.fastCheckParameters();
        }
        if (this.kind == ElementKind.CLASS || this.kind == ElementKind.MODULE) {
            this.setForClass();
            return this.query.fastCheckParameters();
        }
        return null;
    }

    public AbstractRefactoring getRefactoring() {
        return this.query != null ? this.query : this.delegate;
    }

    public String getDescription() {
        if (this.panel != null) {
            if (this.kind == ElementKind.MODULE || this.kind == ElementKind.CLASS) {
                if (!this.panel.isClassFindUsages()) {
                    if (!this.panel.isClassSubTypesDirectOnly()) {
                        return this.getString("DSC_WhereUsedFindAllSubTypes", this.name);
                    }
                    return this.getString("DSC_WhereUsedFindDirectSubTypes", this.name);
                }
            } else if (this.kind == ElementKind.METHOD) {
                String string = null;
                if (this.panel.isMethodFindUsages()) {
                    string = this.getString("DSC_FindUsages");
                }
                if (this.panel.isMethodOverriders()) {
                    string = string != null ? string + " " + this.getString("DSC_And") + " " : "";
                    string = string + this.getString("DSC_WhereUsedMethodOverriders");
                }
                string = string + " " + this.getString("DSC_WhereUsedOf", this.panel.getMethodDeclaringClass() + '.' + this.name);
                return string;
            }
        }
        return this.getString("DSC_WhereUsed", this.name);
    }

    private String getString(String string) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(WhereUsedQueryUI.class);
        }
        return this.bundle.getString(string);
    }

    private String getString(String string, String string2) {
        return new MessageFormat(this.getString(string)).format(new Object[]{string2});
    }

    public String getName() {
        return new MessageFormat(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_WhereUsed")).format(new Object[]{this.name});
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }
}

