/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.javascript.ui;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.mozilla.nb.javascript.Node;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.javascript.editing.AstElement;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.Element;
import org.netbeans.modules.javascript.editing.JsAnalyzer;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.JsUtils;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.refactoring.javascript.JsElementCtx;
import org.netbeans.modules.refactoring.javascript.RetoucheUtils;
import org.netbeans.modules.refactoring.javascript.ui.RenameRefactoringUI;
import org.netbeans.modules.refactoring.javascript.ui.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class RefactoringActionsProvider
extends ActionsImplementationProvider {
    private static boolean isFindUsages;

    public void doRename(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        final Dictionary dictionary = (Dictionary)lookup.lookup(Dictionary.class);
        Runnable runnable = RefactoringActionsProvider.isFromEditor(editorCookie) ? new TextComponentTask(editorCookie){

            protected RefactoringUI createRefactoringUI(JsElementCtx jsElementCtx, int n, int n2, org.netbeans.napi.gsfret.source.CompilationInfo compilationInfo) {
                return new RenameRefactoringUI(jsElementCtx, compilationInfo);
            }
        } : new NodeToFileObjectTask(lookup.lookupAll(org.openide.nodes.Node.class)){

            @Override
            protected RefactoringUI createRefactoringUI(FileObject[] fileObjectArray, Collection<JsElementCtx> collection) {
                String string = RefactoringActionsProvider.getName(dictionary);
                if (string != null) {
                    if (this.pkg[0] != null) {
                        return new RenameRefactoringUI(this.pkg[0], string);
                    }
                    return new RenameRefactoringUI(fileObjectArray[0], string, collection == null || collection.isEmpty() ? null : collection.iterator().next(), this.cinfo == null ? null : (org.netbeans.napi.gsfret.source.CompilationInfo)this.cinfo.get());
                }
                if (this.pkg[0] != null) {
                    return new RenameRefactoringUI(this.pkg[0]);
                }
                return new RenameRefactoringUI(fileObjectArray[0], collection == null || collection.isEmpty() ? null : collection.iterator().next(), this.cinfo == null ? null : (org.netbeans.napi.gsfret.source.CompilationInfo)this.cinfo.get());
            }
        };
        runnable.run();
    }

    public boolean canRename(Lookup lookup) {
        Collection collection = lookup.lookupAll(org.openide.nodes.Node.class);
        if (collection.size() != 1) {
            return false;
        }
        org.openide.nodes.Node node = (org.openide.nodes.Node)collection.iterator().next();
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return false;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        if (this.isOutsideJs(lookup, fileObject)) {
            return false;
        }
        return RetoucheUtils.isRefactorable(fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOutsideJs(Lookup lookup, FileObject fileObject) {
        EditorCookie editorCookie;
        if (!JsUtils.isJsFile((FileObject)fileObject) && !JsUtils.isJsonFile((FileObject)fileObject) && RefactoringActionsProvider.isFromEditor(editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class))) {
            JEditorPane jEditorPane = editorCookie.getOpenedPanes()[0];
            Document document = jEditorPane.getDocument();
            if (!(document instanceof BaseDocument)) {
                return true;
            }
            BaseDocument baseDocument = (BaseDocument)document;
            baseDocument.readLock();
            try {
                int n = jEditorPane.getCaretPosition();
                if (LexUtilities.getToken((BaseDocument)((BaseDocument)document), (int)n) == null) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                baseDocument.readUnlock();
            }
        }
        return false;
    }

    public boolean canCopy(Lookup lookup) {
        return false;
    }

    public boolean canFindUsages(Lookup lookup) {
        Collection collection = lookup.lookupAll(org.openide.nodes.Node.class);
        if (collection.size() != 1) {
            return false;
        }
        org.openide.nodes.Node node = (org.openide.nodes.Node)collection.iterator().next();
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return false;
        }
        FileObject fileObject = dataObject.getPrimaryFile();
        if (RetoucheUtils.isJsFile(fileObject) && this.isOutsideJs(lookup, fileObject)) {
            return false;
        }
        return dataObject != null && RetoucheUtils.isJsFile(fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFindUsages(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        Runnable runnable = RefactoringActionsProvider.isFromEditor(editorCookie) ? new TextComponentTask(editorCookie){

            protected RefactoringUI createRefactoringUI(JsElementCtx jsElementCtx, int n, int n2, org.netbeans.napi.gsfret.source.CompilationInfo compilationInfo) {
                return new WhereUsedQueryUI(jsElementCtx, compilationInfo);
            }
        } : new NodeToElementTask(lookup.lookupAll(org.openide.nodes.Node.class)){

            protected RefactoringUI createRefactoringUI(JsElementCtx jsElementCtx, org.netbeans.napi.gsfret.source.CompilationInfo compilationInfo) {
                return new WhereUsedQueryUI(jsElementCtx, compilationInfo);
            }
        };
        try {
            isFindUsages = true;
            runnable.run();
        }
        finally {
            isFindUsages = false;
        }
    }

    public boolean canDelete(Lookup lookup) {
        return false;
    }

    static String getName(Dictionary dictionary) {
        if (dictionary == null) {
            return null;
        }
        return (String)dictionary.get("name");
    }

    public boolean canMove(Lookup lookup) {
        return false;
    }

    public void doMove(Lookup lookup) {
    }

    static boolean isFromEditor(EditorCookie editorCookie) {
        return editorCookie != null && editorCookie.getOpenedPanes() != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class NodeToFileObjectTask
    implements Runnable,
    CancellableTask<CompilationController> {
        private Collection<? extends org.openide.nodes.Node> nodes;
        private RefactoringUI ui;
        public NonRecursiveFolder[] pkg;
        public WeakReference<org.netbeans.napi.gsfret.source.CompilationInfo> cinfo;
        Collection<JsElementCtx> handles = new ArrayList<JsElementCtx>();

        public NodeToFileObjectTask(Collection<? extends org.openide.nodes.Node> collection) {
            this.nodes = collection;
        }

        public void cancel() {
        }

        public void run(CompilationController compilationController) throws Exception {
            JsAnalyzer.AnalysisResult analysisResult;
            List list;
            JsParseResult jsParseResult;
            compilationController.toPhase(Phase.ELEMENTS_RESOLVED);
            Node node = AstUtilities.getRoot((CompilationInfo)compilationController);
            if (node != null && (jsParseResult = AstUtilities.getParseResult((CompilationInfo)compilationController)) != null && (list = (analysisResult = jsParseResult.getStructure()).getElements()).size() > 0) {
                AstElement astElement = (AstElement)list.get(0);
                Node node2 = astElement.getNode();
                JsElementCtx jsElementCtx = new JsElementCtx(node, node2, (Element)astElement, compilationController.getFileObject(), (org.netbeans.napi.gsfret.source.CompilationInfo)compilationController);
                jsElementCtx.setNames(astElement.getFqn(), astElement.getName());
                this.handles.add(jsElementCtx);
            }
            this.cinfo = new WeakReference<CompilationController>(compilationController);
        }

        @Override
        public void run() {
            FileObject[] fileObjectArray = new FileObject[this.nodes.size()];
            this.pkg = new NonRecursiveFolder[fileObjectArray.length];
            int n = 0;
            for (org.openide.nodes.Node node : this.nodes) {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (dataObject == null) continue;
                fileObjectArray[n] = dataObject.getPrimaryFile();
                Source source = RetoucheUtils.getSource(fileObjectArray[n]);
                if (source == null) continue;
                assert (source != null);
                try {
                    source.runUserActionTask((CancellableTask)this, false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                this.pkg[n++] = (NonRecursiveFolder)node.getLookup().lookup(NonRecursiveFolder.class);
            }
            UI.openRefactoringUI((RefactoringUI)this.createRefactoringUI(fileObjectArray, this.handles));
        }

        protected abstract RefactoringUI createRefactoringUI(FileObject[] var1, Collection<JsElementCtx> var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class NodeToElementTask
    implements Runnable,
    CancellableTask<CompilationController> {
        private org.openide.nodes.Node node;
        private RefactoringUI ui;

        public NodeToElementTask(Collection<? extends org.openide.nodes.Node> collection) {
            assert (collection.size() == 1);
            this.node = collection.iterator().next();
        }

        public void cancel() {
        }

        public void run(CompilationController compilationController) throws Exception {
            compilationController.toPhase(Phase.ELEMENTS_RESOLVED);
            Node node = AstUtilities.getRoot((CompilationInfo)compilationController);
            if (node != null) {
                AstElement astElement = AstElement.getElement((CompilationInfo)compilationController, (Node)node);
                JsElementCtx jsElementCtx = new JsElementCtx(node, node, (Element)astElement, compilationController.getFileObject(), (org.netbeans.napi.gsfret.source.CompilationInfo)compilationController);
                this.ui = this.createRefactoringUI(jsElementCtx, (org.netbeans.napi.gsfret.source.CompilationInfo)compilationController);
            }
        }

        @Override
        public final void run() {
            DataObject dataObject = (DataObject)this.node.getCookie(DataObject.class);
            Source source = RetoucheUtils.getSource(dataObject.getPrimaryFile());
            assert (source != null);
            try {
                source.runUserActionTask((CancellableTask)this, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            UI.openRefactoringUI((RefactoringUI)this.ui);
        }

        protected abstract RefactoringUI createRefactoringUI(JsElementCtx var1, org.netbeans.napi.gsfret.source.CompilationInfo var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class TextComponentTask
    implements Runnable,
    CancellableTask<CompilationController> {
        private JTextComponent textC;
        private int caret;
        private int start;
        private int end;
        private RefactoringUI ui;

        public TextComponentTask(EditorCookie editorCookie) {
            this.textC = editorCookie.getOpenedPanes()[0];
            this.caret = this.textC.getCaretPosition();
            this.start = this.textC.getSelectionStart();
            this.end = this.textC.getSelectionEnd();
            assert (this.caret != -1);
            assert (this.start != -1);
            assert (this.end != -1);
        }

        public void cancel() {
        }

        public void run(CompilationController compilationController) throws Exception {
            compilationController.toPhase(Phase.RESOLVED);
            Node node = AstUtilities.getRoot((CompilationInfo)compilationController);
            if (node == null) {
                System.out.println("FAILURE - can't refactor uncompileable sources");
                return;
            }
            JsElementCtx jsElementCtx = new JsElementCtx((org.netbeans.napi.gsfret.source.CompilationInfo)compilationController, this.caret);
            if (jsElementCtx.getSimpleName() == null) {
                return;
            }
            this.ui = this.createRefactoringUI(jsElementCtx, this.start, this.end, (org.netbeans.napi.gsfret.source.CompilationInfo)compilationController);
        }

        @Override
        public final void run() {
            Object object;
            Source source;
            FileObject fileObject = null;
            try {
                source = RetoucheUtils.getSource(this.textC.getDocument());
                source.runUserActionTask((CancellableTask)this, false);
                object = source.getFileObjects();
                if (object.size() > 0) {
                    fileObject = (FileObject)object.iterator().next();
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return;
            }
            source = TopComponent.getRegistry().getActivated();
            if (this.ui != null) {
                if (fileObject != null && (object = RetoucheUtils.getClasspathInfoFor(fileObject)) == null) {
                    JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)"ERR_CannotFindClasspath"));
                    return;
                }
                UI.openRefactoringUI((RefactoringUI)this.ui, (TopComponent)source);
            } else {
                object = "ERR_CannotRenameLoc";
                if (isFindUsages) {
                    object = "ERR_CannotFindUsages";
                }
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(RefactoringActionsProvider.class, (String)object));
            }
        }

        protected abstract RefactoringUI createRefactoringUI(JsElementCtx var1, int var2, int var3, org.netbeans.napi.gsfret.source.CompilationInfo var4);
    }
}

