/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.javascript;

import java.awt.Color;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.StyleConstants;
import org.mozilla.nb.javascript.Node;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.api.classpath.GlobalPathRegistry;
import org.netbeans.modules.gsfpath.spi.classpath.support.ClassPathSupport;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.netbeans.modules.refactoring.javascript.JsElementCtx;
import org.netbeans.napi.gsfret.source.ClasspathInfo;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.SourceUtils;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetoucheUtils {
    private RetoucheUtils() {
    }

    public static boolean isJsFile(FileObject fileObject) {
        return LanguageRegistry.getInstance().isRelevantFor(fileObject, "text/javascript");
    }

    public static Source createSource(ClasspathInfo classpathInfo, FileObject fileObject) {
        if (RetoucheUtils.isJsFile(fileObject)) {
            return Source.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[]{fileObject});
        }
        return null;
    }

    public static Source getSource(FileObject fileObject) {
        Source source = Source.forFileObject((FileObject)fileObject);
        return source;
    }

    public static Source getSource(Document document) {
        Source source = Source.forDocument((Document)document);
        return source;
    }

    public static BaseDocument getDocument(CompilationInfo compilationInfo, FileObject fileObject) {
        BaseDocument baseDocument = null;
        if (compilationInfo != null) {
            baseDocument = (BaseDocument)compilationInfo.getDocument();
        }
        if (baseDocument == null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie != null) {
                    baseDocument = (BaseDocument)editorCookie.openDocument();
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return baseDocument;
    }

    public static String[] getNodeNames(Node node) {
        String string = null;
        String string2 = null;
        int n = node.getType();
        if (n == 37 || n == 30) {
            string = AstUtilities.getCallName((Node)node, (boolean)true);
            string2 = AstUtilities.getCallName((Node)node, (boolean)false);
        } else if (node instanceof Node.StringNode) {
            string = node.getString();
        } else if (node.getType() == 105) {
            string = AstUtilities.getFunctionFqn((Node)node, null);
            if (string != null && string.indexOf(46) != -1) {
                string = string.substring(string.indexOf(46) + 1);
            }
        } else {
            return new String[]{null, null};
        }
        if (string2 == null) {
            string2 = string;
        }
        return new String[]{string, string2};
    }

    public static CloneableEditorSupport findCloneableEditorSupport(CompilationInfo compilationInfo) {
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)compilationInfo.getFileObject());
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        return RetoucheUtils.findCloneableEditorSupport(dataObject);
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dataObject) {
        Node.Cookie cookie = dataObject.getCookie(OpenCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        cookie = dataObject.getCookie(EditorCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        return null;
    }

    public static String htmlize(String string) {
        try {
            return XMLUtil.toElementContent((String)string);
        }
        catch (CharConversionException charConversionException) {
            Exceptions.printStackTrace((Throwable)charConversionException);
            return string;
        }
    }

    public static String getHtml(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)string, (Language)JsTokenId.language());
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)"text/javascript"));
        FontColorSettings fontColorSettings = (FontColorSettings)lookup.lookup(FontColorSettings.class);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            String string2 = token.id().name();
            AttributeSet attributeSet = fontColorSettings.getTokenFontColors(string2);
            if (attributeSet == null) {
                string2 = token.id().primaryCategory();
                if (string2 == null) {
                    string2 = "whitespace";
                }
                attributeSet = fontColorSettings.getTokenFontColors(string2);
            }
            String string3 = RetoucheUtils.htmlize(((Object)token.text()).toString());
            stringBuffer.append(RetoucheUtils.color(string3, attributeSet));
        }
        return stringBuffer.toString();
    }

    private static String color(String string, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return string;
        }
        if (string.trim().length() == 0) {
            return Utilities.replaceString((String)Utilities.replaceString((String)string, (String)" ", (String)"&nbsp;"), (String)"\n", (String)"<br>");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (StyleConstants.isBold(attributeSet)) {
            stringBuffer.insert(0, "<b>");
            stringBuffer.append("</b>");
        }
        if (StyleConstants.isItalic(attributeSet)) {
            stringBuffer.insert(0, "<i>");
            stringBuffer.append("</i>");
        }
        if (StyleConstants.isStrikeThrough(attributeSet)) {
            stringBuffer.insert(0, "<s>");
            stringBuffer.append("</s>");
        }
        stringBuffer.insert(0, "<font color=" + RetoucheUtils.getHTMLColor(StyleConstants.getForeground(attributeSet)) + ">");
        stringBuffer.append("</font>");
        return stringBuffer.toString();
    }

    private static String getHTMLColor(Color color) {
        String string = "0" + Integer.toHexString(color.getRed());
        string = string.substring(string.length() - 2);
        String string2 = "0" + Integer.toHexString(color.getGreen());
        string2 = string2.substring(string2.length() - 2);
        String string3 = "0" + Integer.toHexString(color.getBlue());
        string3 = string3.substring(string3.length() - 2);
        String string4 = "#" + string + string2 + string3;
        return string4;
    }

    public static boolean isFileInOpenProject(FileObject fileObject) {
        assert (fileObject != null);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (project != projectArray[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isOnSourceClasspath(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (project != projectArray[i]) continue;
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("generic");
            for (int j = 0; j < sourceGroupArray.length; ++j) {
                if (fileObject == sourceGroupArray[j].getRootFolder()) {
                    return true;
                }
                if (!FileUtil.isParentOf((FileObject)sourceGroupArray[j].getRootFolder(), (FileObject)fileObject)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isClasspathRoot(FileObject fileObject) {
        FileObject fileObject2;
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath != null && (fileObject2 = classPath.findOwnerRoot(fileObject)) != null) {
            return fileObject.equals(fileObject2);
        }
        return false;
    }

    public static boolean isRefactorable(FileObject fileObject) {
        return RetoucheUtils.isJsFile(fileObject) && RetoucheUtils.isFileInOpenProject(fileObject) && RetoucheUtils.isOnSourceClasspath(fileObject);
    }

    public static String getPackageName(FileObject fileObject) {
        assert (fileObject.isFolder()) : "argument must be folder";
        return ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").getResourceName(fileObject, '.', false);
    }

    public static FileObject getClassPathRoot(URL uRL) throws IOException {
        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
        File file = FileUtil.normalizeFile((File)new File(uRL.getPath()));
        while (fileObject == null) {
            fileObject = FileUtil.toFileObject((File)file);
            file = file.getParentFile();
        }
        return ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").findOwnerRoot(fileObject);
    }

    public static ElementKind getElementKind(JsElementCtx jsElementCtx) {
        return jsElementCtx.getKind();
    }

    public static ClasspathInfo getClasspathInfoFor(FileObject ... classPath) {
        Project project;
        ClassPath fileObject22;
        assert (((ClassPath)classPath).length > 0);
        HashSet<URL> hashSet = new HashSet<URL>();
        for (ClassPath fileObject22 : classPath) {
            project = null;
            if (fileObject22 != null) {
                project = FileOwnerQuery.getOwner((FileObject)fileObject22);
            }
            if (project != null) {
                ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject22, (String)"classpath/source");
                if (classPath2 == null) {
                    return null;
                }
                FileObject fileObject3 = classPath2.findOwnerRoot((FileObject)fileObject22);
                if (fileObject3 != null) {
                    URL uRL = URLMapper.findURL((FileObject)fileObject3, (int)0);
                    hashSet.addAll(SourceUtils.getDependentRoots((URL)uRL));
                    SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("generic");
                    int n = sourceGroupArray.length;
                    for (int i = 0; i < n; ++i) {
                        SourceGroup sourceGroup = sourceGroupArray[i];
                        hashSet.add(URLMapper.findURL((FileObject)sourceGroup.getRootFolder(), (int)0));
                    }
                    continue;
                }
                hashSet.add(URLMapper.findURL((FileObject)fileObject22.getParent(), (int)0));
                continue;
            }
            for (FileObject fileObject3 : GlobalPathRegistry.getDefault().getPaths("classpath/source")) {
                for (FileObject fileObject : fileObject3.getRoots()) {
                    hashSet.add(URLMapper.findURL((FileObject)fileObject, (int)0));
                }
            }
        }
        ClassPath classPath3 = ClassPathSupport.createClassPath((URL[])hashSet.toArray(new URL[hashSet.size()]));
        ClassPath classPath4 = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        ClassPath classPath5 = classPath[0] != null ? ClassPath.getClassPath((FileObject)classPath[0], (String)"classpath/boot") : classPath4;
        ClassPath classPath2 = fileObject22 = classPath[0] != null ? ClassPath.getClassPath((FileObject)classPath[0], (String)"classpath/compile") : classPath4;
        if (classPath5 == null || fileObject22 == null) {
            return null;
        }
        project = ClasspathInfo.create((ClassPath)classPath5, (ClassPath)fileObject22, (ClassPath)classPath3);
        return project;
    }

    public static ClasspathInfo getClasspathInfoFor(JsElementCtx jsElementCtx) {
        return RetoucheUtils.getClasspathInfoFor(jsElementCtx.getFileObject());
    }

    public static List<FileObject> getJsFilesInProject(FileObject fileObject) {
        ClasspathInfo classpathInfo = RetoucheUtils.getClasspathInfoFor(fileObject);
        ClassPath classPath = classpathInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(100);
        for (ClassPath.Entry entry : classPath.entries()) {
            FileObject fileObject2 = entry.getRoot();
            String string = fileObject2.getName();
            if (string.equals("vendor") || string.equals("script")) continue;
            RetoucheUtils.addJsFiles(arrayList, fileObject2);
        }
        return arrayList;
    }

    private static void addJsFiles(List<FileObject> list, FileObject fileObject) {
        if (fileObject.isFolder()) {
            for (FileObject fileObject2 : fileObject.getChildren()) {
                RetoucheUtils.addJsFiles(list, fileObject2);
            }
        } else if (RetoucheUtils.isJsFile(fileObject)) {
            list.add(fileObject);
        }
    }
}

