/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject.ui.wizards;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.HashSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.AppClientSourceRootsUi;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class FolderList
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String PROP_FILES = "files";
    public static final String PROP_LAST_USED_DIR = "lastUsedDir";
    private String fcMessage;
    private File projectFolder;
    private File lastUsedFolder;
    private FolderList relatedFolderList;
    private JButton addButton;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton removeButton;
    private JList roots;

    public FolderList(String string, char c, String string2, String string3, char c2, String string4, char c3, String string5) {
        this.fcMessage = string3;
        this.initComponents();
        this.jLabel1.setText(string);
        this.jLabel1.setDisplayedMnemonic(c);
        this.roots.getAccessibleContext().setAccessibleDescription(string2);
        this.roots.setCellRenderer(new Renderer());
        this.roots.setModel(new DefaultListModel());
        this.roots.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    FolderList.this.removeButton.setEnabled(FolderList.this.roots.getSelectedIndices().length != 0);
                }
            }
        });
        this.addButton.getAccessibleContext().setAccessibleDescription(string4);
        this.addButton.setMnemonic(c2);
        this.removeButton.getAccessibleContext().setAccessibleDescription(string5);
        this.removeButton.setMnemonic(c3);
        this.removeButton.setEnabled(false);
    }

    public void setProjectFolder(File file) {
        this.projectFolder = file;
    }

    public void setRelatedFolderList(FolderList folderList) {
        this.relatedFolderList = folderList;
    }

    public File[] getFiles() {
        Object[] objectArray = ((DefaultListModel)this.roots.getModel()).toArray();
        File[] fileArray = new File[objectArray.length];
        System.arraycopy(objectArray, 0, fileArray, 0, objectArray.length);
        return fileArray;
    }

    public void setFiles(File[] fileArray) {
        DefaultListModel defaultListModel = (DefaultListModel)this.roots.getModel();
        defaultListModel.clear();
        for (int i = 0; i < fileArray.length; ++i) {
            defaultListModel.addElement(fileArray[i]);
        }
        if (fileArray.length > 0) {
            this.roots.setSelectedIndex(0);
        }
    }

    public void setLastUsedDir(File file) {
        if (this.lastUsedFolder == null ? file != null : !this.lastUsedFolder.equals(file)) {
            File file2 = this.lastUsedFolder;
            this.lastUsedFolder = file;
            this.firePropertyChange(PROP_LAST_USED_DIR, file2, this.lastUsedFolder);
        }
    }

    public File getLastUsedDir() {
        return this.lastUsedFolder;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.roots = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.roots);
        this.jLabel1.setText("jLabel1");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.roots);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.addButton.setText(NbBundle.getMessage(FolderList.class, (String)"CTL_AddFolder"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FolderList.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FolderList.class, (String)"AD_AddFolder"));
        this.removeButton.setText(NbBundle.getMessage(FolderList.class, (String)"CTL_RemoveFolder"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FolderList.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FolderList.class, (String)"AD_RemoveFolder"));
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.roots.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            ((DefaultListModel)this.roots.getModel()).removeElement(objectArray[i]);
        }
        this.firePropertyChange(PROP_FILES, null, null);
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setDialogTitle(this.fcMessage);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(true);
        if (this.lastUsedFolder != null && this.lastUsedFolder.isDirectory()) {
            jFileChooser.setCurrentDirectory(this.lastUsedFolder);
        } else if (this.projectFolder != null && this.projectFolder.isDirectory()) {
            jFileChooser.setCurrentDirectory(this.projectFolder);
        }
        if (jFileChooser.showOpenDialog(this) == 0) {
            File[] fileArray = jFileChooser.getSelectedFiles();
            int[] nArray = new int[fileArray.length];
            DefaultListModel defaultListModel = (DefaultListModel)this.roots.getModel();
            HashSet<File> hashSet = new HashSet<File>();
            File[] fileArray2 = this.relatedFolderList == null ? new File[]{} : this.relatedFolderList.getFiles();
            int n = 0;
            int n2 = defaultListModel.size();
            while (n < fileArray.length) {
                File file = FileUtil.normalizeFile((File)fileArray[n]);
                if (!FolderList.isValidRoot(file, fileArray2, this.projectFolder)) {
                    hashSet.add(file);
                } else {
                    int n3 = defaultListModel.indexOf(file);
                    if (n3 == -1) {
                        defaultListModel.addElement(file);
                        nArray[n] = n2;
                    } else {
                        nArray[n] = n3;
                    }
                }
                ++n;
                ++n2;
            }
            this.roots.setSelectedIndices(nArray);
            this.firePropertyChange(PROP_FILES, null, null);
            File file = jFileChooser.getCurrentDirectory();
            if (file != null) {
                this.setLastUsedDir(FileUtil.normalizeFile((File)file));
            }
            if (hashSet.size() > 0) {
                AppClientSourceRootsUi.showIllegalRootsDialog(hashSet);
            }
        }
    }

    static boolean isValidRoot(File file, File[] fileArray, File file2) {
        Project project = FileOwnerQuery.getOwner((URI)file.toURI());
        if (project != null && !file.getAbsolutePath().startsWith(file2.getAbsolutePath() + File.separatorChar)) {
            Sources sources = (Sources)project.getLookup().lookup(Sources.class);
            if (sources == null) {
                return false;
            }
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
            SourceGroup[] sourceGroupArray2 = sources.getSourceGroups("java");
            SourceGroup[] sourceGroupArray3 = new SourceGroup[sourceGroupArray.length + sourceGroupArray2.length];
            System.arraycopy(sourceGroupArray, 0, sourceGroupArray3, 0, sourceGroupArray.length);
            System.arraycopy(sourceGroupArray2, 0, sourceGroupArray3, sourceGroupArray.length, sourceGroupArray2.length);
            FileObject fileObject = project.getProjectDirectory();
            FileObject fileObject2 = FileUtil.toFileObject((File)file);
            if (fileObject == null || fileObject2 == null) {
                return false;
            }
            for (int i = 0; i < sourceGroupArray3.length; ++i) {
                FileObject fileObject3 = sourceGroupArray3[i].getRootFolder();
                if (fileObject2.equals(fileObject3)) {
                    return false;
                }
                if (fileObject.equals(fileObject3) || !FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject2)) continue;
                return false;
            }
            return true;
        }
        return !FolderList.contains(file, fileArray);
    }

    private static boolean contains(File file, File[] fileArray) {
        String string = file.getAbsolutePath();
        for (int i = 0; i < fileArray.length; ++i) {
            String string2 = fileArray[i].getAbsolutePath();
            if (!string2.equals(string) && !string.startsWith(string2 + File.separatorChar)) continue;
            return true;
        }
        return false;
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private Renderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            File file = (File)object;
            Project project = FileOwnerQuery.getOwner((URI)file.toURI());
            String string = file.getAbsolutePath();
            Component component = super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            return component;
        }
    }
}

