/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cplusplus;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.Language;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.Filter;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.cnd.editor.cplusplus.CCKit;
import org.netbeans.modules.cnd.editor.cplusplus.CCTokenContext;
import org.netbeans.modules.cnd.editor.cplusplus.CSyntax;
import org.netbeans.modules.cnd.editor.spi.cplusplus.CCSyntaxSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CKit
extends CCKit {
    private static String START_BLOCK_COMMENT = "/*";
    private static String END_BLOCK_COMMENT = "*/";
    private static String insertStartCommentString = START_BLOCK_COMMENT + "\n";
    private static String insertEndCommentString = END_BLOCK_COMMENT + "\n";

    @Override
    public String getContentType() {
        return "text/x-c";
    }

    @Override
    public Syntax createSyntax(Document document) {
        return new CSyntax();
    }

    @Override
    protected Language<CppTokenId> getLanguage() {
        return CppTokenId.languageC();
    }

    @Override
    protected Filter<CppTokenId> getFilter() {
        return CndLexerUtilities.getGccCFilter();
    }

    @Override
    protected Action getCommentAction() {
        return new CCommentAction();
    }

    @Override
    protected Action getUncommentAction() {
        return new CUncommentAction();
    }

    @Override
    protected Action getToggleCommentAction() {
        return new CToggleCommentAction();
    }

    private static final class CToggleCommentAction
    extends ExtKit.ToggleCommentAction {
        private CToggleCommentAction() {
            super("//");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (this.allComments(jTextComponent)) {
                CUncommentAction.doCStyleUncomment(jTextComponent);
            } else {
                CCommentAction.doCStyleComment(jTextComponent);
            }
        }

        private boolean allComments(final JTextComponent jTextComponent) {
            final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            final boolean[] blArray = new boolean[]{false};
            baseDocument.runAtomic(new Runnable(){

                public void run() {
                    Caret caret = jTextComponent.getCaret();
                    TokenItem tokenItem = null;
                    try {
                        int n;
                        int n2;
                        if (Utilities.isSelectionShowing((Caret)caret)) {
                            n2 = jTextComponent.getSelectionStart();
                            n = jTextComponent.getSelectionEnd();
                            if (n > 0 && Utilities.getRowStart((BaseDocument)baseDocument, (int)n) == n) {
                                --n;
                            }
                        } else {
                            n = n2 = jTextComponent.getSelectionStart();
                        }
                        CCSyntaxSupport cCSyntaxSupport = (CCSyntaxSupport)Utilities.getSyntaxSupport((JTextComponent)jTextComponent);
                        for (tokenItem = cCSyntaxSupport.getTokenChain(n2, n); tokenItem != null && tokenItem.getOffset() < n && tokenItem.getTokenID() == CCTokenContext.WHITESPACE; tokenItem = tokenItem.getNext()) {
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        jTextComponent.getToolkit().beep();
                    }
                    blArray[0] = tokenItem != null && tokenItem.getTokenID() == CCTokenContext.BLOCK_COMMENT;
                }
            });
            return blArray[0];
        }
    }

    private static final class CUncommentAction
    extends ExtKit.UncommentAction {
        private CUncommentAction() {
            super("//");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            CUncommentAction.doCStyleUncomment(jTextComponent);
        }

        private static void doCStyleUncomment(final JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                baseDocument.runAtomic(new Runnable(){

                    public void run() {
                        Caret caret = jTextComponent.getCaret();
                        try {
                            TokenItem tokenItem;
                            int n;
                            int n2;
                            if (Utilities.isSelectionShowing((Caret)caret)) {
                                n2 = jTextComponent.getSelectionStart();
                                n = jTextComponent.getSelectionEnd();
                                if (n > 0 && Utilities.getRowStart((BaseDocument)baseDocument, (int)n) == n) {
                                    --n;
                                }
                            } else {
                                n = n2 = jTextComponent.getSelectionStart();
                            }
                            CCSyntaxSupport cCSyntaxSupport = (CCSyntaxSupport)Utilities.getSyntaxSupport((JTextComponent)jTextComponent);
                            for (tokenItem = cCSyntaxSupport.getTokenChain(n2, n); tokenItem != null && tokenItem.getOffset() < n && tokenItem.getTokenID() == CCTokenContext.WHITESPACE; tokenItem = tokenItem.getNext()) {
                            }
                            if (tokenItem != null && tokenItem.getTokenID() == CCTokenContext.BLOCK_COMMENT) {
                                int n3 = tokenItem.getOffset();
                                int n4 = n3 + tokenItem.getImage().length();
                                int n5 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n3);
                                int n6 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n5);
                                String string = baseDocument.getText(n5, n6 - n5);
                                if (!START_BLOCK_COMMENT.equals(string.trim())) {
                                    n5 = n3;
                                    n6 = n5 + START_BLOCK_COMMENT.length();
                                } else {
                                    n6 = n6 < baseDocument.getLength() - 1 ? n6 + 1 : baseDocument.getLength();
                                }
                                int n7 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n4);
                                int n8 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n7);
                                String string2 = baseDocument.getText(n7, n8 - n7);
                                if (!END_BLOCK_COMMENT.equals(string2.trim())) {
                                    n8 = n4;
                                    n7 = n8 - END_BLOCK_COMMENT.length();
                                } else {
                                    n8 = n8 < baseDocument.getLength() - 1 ? n8 + 1 : baseDocument.getLength();
                                }
                                baseDocument.remove(n7, n8 - n7);
                                baseDocument.remove(n5, n6 - n5);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            jTextComponent.getToolkit().beep();
                        }
                    }
                });
            }
        }
    }

    private static final class CCommentAction
    extends ExtKit.CommentAction {
        private CCommentAction() {
            super("//");
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            CCommentAction.doCStyleComment(jTextComponent);
        }

        private static void doCStyleComment(final JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                baseDocument.runAtomic(new Runnable(){

                    public void run() {
                        Caret caret = jTextComponent.getCaret();
                        try {
                            int n;
                            int n2;
                            String string = insertEndCommentString;
                            if (Utilities.isSelectionShowing((Caret)caret)) {
                                n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)jTextComponent.getSelectionStart());
                                n = jTextComponent.getSelectionEnd();
                                if (n > 0 && Utilities.getRowStart((BaseDocument)baseDocument, (int)n) == n) {
                                    --n;
                                }
                                int n3 = Utilities.getRowCount((BaseDocument)baseDocument, (int)n2, (int)n);
                                n = Utilities.getRowStart((BaseDocument)baseDocument, (int)n2, (int)n3);
                            } else {
                                n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)jTextComponent.getSelectionStart());
                                n = Utilities.getRowStart((BaseDocument)baseDocument, (int)n2, (int)1);
                                if (n == -1) {
                                    n = baseDocument.getLength();
                                    string = "\n" + insertEndCommentString;
                                }
                            }
                            baseDocument.insertString(n, string, null);
                            baseDocument.insertString(n2, insertStartCommentString, null);
                        }
                        catch (BadLocationException badLocationException) {
                            jTextComponent.getToolkit().beep();
                        }
                    }
                });
            }
        }
    }
}

