/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.OverviewFactory;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.PagesMultiViewElement;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.NodeSectionPanel;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.SectionPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class OverviewMultiViewElement
extends ToolBarMultiViewElement
implements PropertyChangeListener {
    private SectionView view;
    private ToolBarDesignEditor comp;
    private DDDataObject dObj;
    private WebApp webApp;
    private OverviewFactory factory;
    private boolean needInit = true;
    private int index;
    private RequestProcessor.Task repaintingTask;
    private static final String OVERVIEW_MV_ID = "dd_multiviewOverview";
    private static final String HELP_ID_PREFIX = "dd_multiview_overview_";

    public OverviewMultiViewElement(DDDataObject dDDataObject, int n) {
        super((XmlMultiViewDataObject)dDDataObject);
        this.dObj = dDDataObject;
        this.index = n;
        this.comp = new ToolBarDesignEditor();
        this.factory = new OverviewFactory(this.comp, dDDataObject);
        this.setVisualEditor(this.comp);
        this.repaintingTask = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        OverviewMultiViewElement.this.repaintView();
                    }
                });
            }
        });
    }

    public SectionView getSectionView() {
        return this.view;
    }

    public void componentShowing() {
        super.componentShowing();
        this.dObj.setLastOpenView(this.index);
        if (this.needInit || !this.dObj.isDocumentParseable()) {
            this.repaintView();
            this.needInit = false;
        }
    }

    private void repaintView() {
        this.webApp = this.dObj.getWebApp();
        this.view = new OverView(this.webApp);
        this.comp.setContentView((PanelView)this.view);
        Object object = this.comp.getLastActive();
        if (object != null) {
            this.view.openPanel(object);
        } else {
            this.view.openPanel((Object)"overview");
        }
        this.view.checkValidity();
        this.dObj.checkParseable();
    }

    public void componentOpened() {
        super.componentOpened();
        this.dObj.getWebApp().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void componentClosed() {
        super.componentClosed();
        this.dObj.getWebApp().removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        if (!(this.dObj.isChangedFromUI() || (string = propertyChangeEvent.getPropertyName()).indexOf("/WebApp/DisplayName") < 0 && string.indexOf("/WebApp/Description") < 0 && string.indexOf("Distributable") <= 0 && string.indexOf("ContextParam") <= 0 && string.indexOf("Listener") <= 0 && string.indexOf("SessionConfig") <= 0)) {
            MultiViewPerspective multiViewPerspective = this.dObj.getSelectedPerspective();
            if (multiViewPerspective != null && OVERVIEW_MV_ID.equals(multiViewPerspective.preferredID())) {
                this.repaintingTask.schedule(100);
            } else {
                this.needInit = true;
            }
        }
    }

    private class ListenersNode
    extends AbstractNode {
        ListenersNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage(PagesMultiViewElement.class, (String)"TTL_Listeners"));
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/class.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_overview_listenersNode");
        }
    }

    private class ContextParamsNode
    extends AbstractNode {
        ContextParamsNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage(PagesMultiViewElement.class, (String)"TTL_ContextParams"));
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/paramsNode.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_overview_contextParamsNode");
        }
    }

    private class OverviewNode
    extends AbstractNode {
        OverviewNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage(PagesMultiViewElement.class, (String)"TTL_Overview"));
            this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ddloaders/web/multiview/resources/class.gif");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dd_multiview_overview_overviewNode");
        }
    }

    class OverView
    extends SectionView {
        private Node overviewNode;
        private Node contextParamsNode;
        private Node listenersNode;

        OverView(WebApp webApp) {
            super((InnerPanelFactory)OverviewMultiViewElement.this.factory);
            this.overviewNode = new OverviewNode();
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, this.overviewNode, (Object)"overview"));
            this.contextParamsNode = new ContextParamsNode();
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, this.contextParamsNode, (Object)"context_params"));
            this.listenersNode = new ListenersNode();
            this.addSection((NodeSectionPanel)new SectionPanel((SectionView)this, this.listenersNode, (Object)"listeners"));
            Children.Array array = new Children.Array();
            array.add(new Node[]{this.overviewNode, this.contextParamsNode, this.listenersNode});
            AbstractNode abstractNode = new AbstractNode((Children)array);
            this.setRoot((Node)abstractNode);
        }

        Node getOverviewNode() {
            return this.overviewNode;
        }

        Node getContextParamsNode() {
            return this.contextParamsNode;
        }

        Node getListenersNode() {
            return this.listenersNode;
        }
    }
}

