/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.util.ArrayList;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIManager;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.ui.BrowseFolders;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class Utils {
    public static final String ICON_BASE_DD_VALID = "org/netbeans/modules/j2ee/ddloaders/resources/DDValidIcon";
    public static final String ICON_BASE_DD_INVALID = "org/netbeans/modules/j2ee/ddloaders/resources/DDInvalidIcon";
    public static final String ICON_BASE_EJB_MODULE_NODE = "org/netbeans/modules/j2ee/ddloaders/resources/EjbModuleNodeIcon";
    public static final String ICON_BASE_ENTERPRISE_JAVA_BEANS_NODE = "org/netbeans/modules/j2ee/ddloaders/resources/EjbContainerNodeIcon";
    public static final String ICON_BASE_SESSION_NODE = "org/netbeans/modules/j2ee/ddloaders/resources/SessionNodeIcon";
    public static final String ICON_BASE_ENTITY_NODE = "org/netbeans/modules/j2ee/ddloaders/resources/EntityNodeIcon";
    public static final String ICON_BASE_MESSAGE_DRIVEN_NODE = "org/netbeans/modules/j2ee/ddloaders/resources/MessageNodeIcon";
    public static final String ICON_BASE_MISC_NODE = "org/netbeans/modules/j2ee/ddloaders/resources/MiscNodeIcon";
    private static BrowseFolders.FileObjectFilter imageFileFilter = new BrowseFolders.FileObjectFilter(){

        public boolean accept(FileObject fileObject) {
            return fileObject.getMIMEType().startsWith("image/");
        }
    };

    public static String browseIcon(EjbJarMultiViewDataObject ejbJarMultiViewDataObject) {
        String string;
        FileObject fileObject = BrowseFolders.showDialog(ejbJarMultiViewDataObject.getSourceGroups(), imageFileFilter);
        if (fileObject != null) {
            FileObject fileObject2 = ejbJarMultiViewDataObject.getProjectDirectory();
            string = FileUtil.getRelativePath((FileObject)fileObject2, (FileObject)fileObject);
        } else {
            string = null;
        }
        return string;
    }

    public static Color getErrorColor() {
        Color color = UIManager.getColor("nb.errorForeground");
        return color == null ? new Color(89, 79, 191) : color;
    }

    public static JTree findTreeComponent(Component component) {
        if (component instanceof JTree) {
            return (JTree)component;
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                JTree jTree = Utils.findTreeComponent(componentArray[i]);
                if (jTree == null) continue;
                return jTree;
            }
        }
        return null;
    }

    public static void scrollToVisible(JComponent jComponent) {
        org.netbeans.modules.xml.multiview.Utils.scrollToVisible((JComponent)jComponent);
    }

    public static String getBundleMessage(String string) {
        return NbBundle.getMessage(Utils.class, (String)string);
    }

    public static String getBundleMessage(String string, Object object) {
        return NbBundle.getMessage(Utils.class, (String)string, (Object)object);
    }

    public static String getBundleMessage(String string, Object object, Object object2) {
        return NbBundle.getMessage(Utils.class, (String)string, (Object)object, (Object)object2);
    }

    public static String getBundleMessage(String string, Object object, Object object2, Object object3) {
        return NbBundle.getMessage(Utils.class, (String)string, (Object)object, (Object)object2, (Object)object3);
    }

    public static boolean isJavaIdentifier(String string) {
        return Utilities.isJavaIdentifier((String)string);
    }

    public static boolean isValidPackageName(String string) {
        String[] stringArray = string.split("[.]");
        if (stringArray.length == 0) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (Utils.isJavaIdentifier(stringArray[i])) continue;
            return false;
        }
        return string.charAt(string.length() - 1) != '.';
    }

    public static void removeClass(ClassPath classPath, String string) {
        FileObject fileObject = Utils.getSourceFile(classPath, string);
        if (fileObject != null) {
            // empty if block
        }
    }

    public static FileObject getPackageFile(ClassPath classPath, String string) {
        return classPath.findResource(Utils.packageToPath(string));
    }

    private static String packageToPath(String string) {
        return string.replace('.', '/');
    }

    public static String getPackage(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return "";
        }
        return string.substring(0, n);
    }

    public static void notifyError(Exception exception) {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)exception.getMessage(), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    public static FileObject getSourceFile(ClassPath classPath, String string) {
        return classPath.findResource(Utils.packageToPath(string) + ".java");
    }

    public static String getEjbDisplayName(Ejb ejb) {
        String string = ejb.getDefaultDisplayName();
        if (string == null && (string = ejb.getEjbName()) == null) {
            string = " ";
        }
        return string;
    }

    public static void openEditorFor(FileObject fileObject, final String string) {
        EjbJar ejbJar = EjbJar.getEjbJar((FileObject)fileObject);
        if (ejbJar == null) {
            Utils.displaySourceNotFoundDialog();
            return;
        }
        MetadataModel metadataModel = ejbJar.getMetadataModel();
        try {
            FileObject fileObject2 = (FileObject)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, FileObject>(){

                public FileObject run(EjbJarMetadata ejbJarMetadata) throws Exception {
                    return ejbJarMetadata.findResource(string.replace('.', '/') + ".java");
                }
            });
            final ArrayList arrayList = new ArrayList(1);
            if (fileObject2 != null) {
                JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject2);
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                        if (typeElement != null) {
                            arrayList.add(ElementHandle.create((Element)typeElement));
                        }
                    }
                }, false);
            }
            if (!arrayList.isEmpty()) {
                ElementOpen.open((FileObject)fileObject2, (ElementHandle)((ElementHandle)arrayList.get(0)));
            } else {
                Utils.displaySourceNotFoundDialog();
            }
        }
        catch (MetadataModelException metadataModelException) {
            Exceptions.printStackTrace((Throwable)metadataModelException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private static void displaySourceNotFoundDialog() {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(Utils.class, (String)"MSG_sourceNotFound")));
    }

    public static void runInAwtDispatchThread(Runnable runnable) {
        org.netbeans.modules.xml.multiview.Utils.runInAwtDispatchThread((Runnable)runnable);
    }
}

