/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2se.selector;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.modules.profiler.selector.spi.SelectionTreeBuilder;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.IconResource;
import org.netbeans.modules.profiler.selector.spi.nodes.ProjectNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ProjectPackages;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionTreeBuilderImpl
implements SelectionTreeBuilder {
    private static final String SOURCES_STRING = NbBundle.getMessage(SelectionTreeBuilderImpl.class, (String)"SelectionTreeBuilderImpl_SourcesString");
    private static final String LIBRARIES_STRING = NbBundle.getMessage(SelectionTreeBuilderImpl.class, (String)"SelectionTreeBuilderImpl_LibrariesString");

    public boolean isDefault() {
        return true;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"BuilderDisplayName");
    }

    public String getID() {
        return "PACKAGE";
    }

    public boolean isPreferred(Project project) {
        return false;
    }

    public List<SelectorNode> buildSelectionTree(Project project, final boolean bl) {
        ArrayList<SelectorNode> arrayList = new ArrayList<SelectorNode>();
        ProjectNode projectNode = new ProjectNode(project, bl){

            protected SelectorChildren getChildren() {
                return new Children(bl);
            }
        };
        arrayList.add((SelectorNode)projectNode);
        return arrayList;
    }

    public boolean supports(Project project) {
        return true;
    }

    public String toString() {
        return this.getDisplayName();
    }

    private class SourcesNode
    extends ContainerNode {
        private final boolean includeSubprojects;

        public SourcesNode(boolean bl, ContainerNode containerNode) {
            super(SOURCES_STRING, (Icon)IconResource.PACKAGE_ICON, containerNode);
            this.includeSubprojects = bl;
        }

        protected SelectorChildren getChildren() {
            return new ProjectPackages(ProjectPackages.PackageType.Source, this.includeSubprojects);
        }
    }

    private class LibrariesNode
    extends ContainerNode {
        private final boolean includeSubprojects;

        public LibrariesNode(boolean bl, ContainerNode containerNode) {
            super(LIBRARIES_STRING, (Icon)IconResource.LIBRARIES_ICON, containerNode);
            this.includeSubprojects = bl;
        }

        protected SelectorChildren getChildren() {
            return new ProjectPackages(ProjectPackages.PackageType.Libraries, this.includeSubprojects);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Children
    extends SelectorChildren<ProjectNode> {
        private final boolean includeSubprojects;

        public Children(boolean bl) {
            this.includeSubprojects = bl;
        }

        protected List<SelectorNode> prepareChildren(ProjectNode projectNode) {
            ArrayList<SelectorNode> arrayList = new ArrayList<SelectorNode>(2);
            arrayList.add((SelectorNode)new SourcesNode(this.includeSubprojects, (ContainerNode)projectNode));
            arrayList.add((SelectorNode)new LibrariesNode(this.includeSubprojects, (ContainerNode)projectNode));
            return arrayList;
        }
    }
}

