/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2se;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.modules.profiler.AbstractProjectTypeProfiler;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.utils.AppletSupport;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;

public final class J2SEProjectTypeProfiler
extends AbstractProjectTypeProfiler {
    private static final String MODIFY_BUILDSCRIPT_CAPTION = NbBundle.getMessage(J2SEProjectTypeProfiler.class, (String)"J2SEProjectTypeProfiler_ModifyBuildScriptCaption");
    private static final String MODIFY_BUILDSCRIPT_MSG = NbBundle.getMessage(J2SEProjectTypeProfiler.class, (String)"J2SEProjectTypeProfiler_ModifyBuildScriptMsg");
    private static final String REGENERATE_BUILDSCRIPT_MSG = NbBundle.getMessage(J2SEProjectTypeProfiler.class, (String)"J2SEProjectTypeProfiler_RegenerateBuildScriptMsg");
    private static final String CANNOT_FIND_BUILDSCRIPT_MSG = NbBundle.getMessage(J2SEProjectTypeProfiler.class, (String)"J2SEProjectTypeProfiler_CannotFindBuildScriptMsg");
    private static final String CANNOT_BACKUP_BUILDSCRIPT_MSG = NbBundle.getMessage(J2SEProjectTypeProfiler.class, (String)"J2SEProjectTypeProfiler_CannotBackupBuildScriptMsg");
    private static final String MODIFY_BUILDSCRIPT_MANUALLY_MSG = NbBundle.getMessage(J2SEProjectTypeProfiler.class, (String)"J2SEProjectTypeProfiler_ModifyBuildScriptManuallyMsg");
    private static final String PROJECT_CATEGORY = NbBundle.getMessage(J2SEProjectTypeProfiler.class, (String)"J2SEProjectTypeProfiler_ProjectCategory");
    private static final String LISTENERS_CATEGORY = NbBundle.getMessage(J2SEProjectTypeProfiler.class, (String)"J2SEProjectTypeProfiler_ListenersCategory");
    private static final String PAINTERS_CATEGORY = NbBundle.getMessage(J2SEProjectTypeProfiler.class, (String)"J2SEProjectTypeProfiler_PaintersCategory");
    private static final String IO_CATEGORY = NbBundle.getMessage(J2SEProjectTypeProfiler.class, (String)"J2SEProjectTypeProfiler_IoCategory");
    private static final String FILES_CATEGORY = NbBundle.getMessage(J2SEProjectTypeProfiler.class, (String)"J2SEProjectTypeProfiler_FilesCategory");
    private static final String SOCKETS_CATEGORY = NbBundle.getMessage(J2SEProjectTypeProfiler.class, (String)"J2SEProjectTypeProfiler_SocketsCategory");
    public static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.profiler.j2se");
    private static final String J2SE_PROJECT_NAMESPACE_40 = "http://www.netbeans.org/ns/j2se-project/1";
    private static final String J2SE_PROJECT_NAMESPACE_41 = "http://www.netbeans.org/ns/j2se-project/2";
    private static final String J2SE_PROJECT_NAMESPACE_50 = "http://www.netbeans.org/ns/j2se-project/3";
    private static final String STANDARD_IMPORT_STRING = "<import file=\"nbproject/build-impl.xml\"/>";
    private static final String PROFILER_IMPORT_STRING = "<import file=\"nbproject/profiler-build-impl.xml\"/>";
    private static final String PROFILE_VERSION_ATTRIBUTE = "version";
    private static final String VERSION_NUMBER = "0.9.1";
    private String mainClassSetManually = null;

    public boolean isFileObjectSupported(Project project, FileObject fileObject) {
        if (!"java".equals(fileObject.getExt()) && !"class".equals(fileObject.getExt())) {
            return false;
        }
        return SourceUtils.isRunnable((FileObject)fileObject);
    }

    public String getProfilerTargetName(Project project, FileObject fileObject, int n, FileObject fileObject2) {
        switch (n) {
            case 1: {
                return "profile";
            }
            case 2: {
                if (SourceUtils.isApplet((FileObject)fileObject2)) {
                    return "profile-applet";
                }
                return "profile-single";
            }
            case 3: {
                return null;
            }
            case 4: {
                return "profile-test-single";
            }
        }
        return null;
    }

    public boolean isProfilingSupported(Project project) {
        AuxiliaryConfiguration auxiliaryConfiguration = ProjectUtils.getAuxiliaryConfiguration((Project)project);
        Element element = auxiliaryConfiguration.getConfigurationFragment("data", J2SE_PROJECT_NAMESPACE_40, true);
        if (element == null) {
            element = auxiliaryConfiguration.getConfigurationFragment("data", J2SE_PROJECT_NAMESPACE_41, true);
        }
        if (element == null) {
            element = auxiliaryConfiguration.getConfigurationFragment("data", J2SE_PROJECT_NAMESPACE_50, true);
        }
        return element != null;
    }

    public JavaPlatform getProjectJavaPlatform(Project project) {
        PropertyEvaluator propertyEvaluator = this.getProjectProperties(project);
        String string = propertyEvaluator.getProperty("platform.active");
        if (string == null) {
            return null;
        }
        JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
        if (string.equals("default_platform")) {
            return javaPlatformManager.getDefaultPlatform();
        }
        JavaPlatform[] javaPlatformArray = javaPlatformManager.getPlatforms(null, new Specification("j2se", null));
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            JavaPlatform javaPlatform = javaPlatformArray[i];
            String string2 = (String)javaPlatform.getProperties().get("platform.ant.name");
            if (!string2.equals(string)) continue;
            return javaPlatform;
        }
        return null;
    }

    public boolean checkProjectCanBeProfiled(Project project, FileObject fileObject) {
        if (fileObject == null) {
            PropertyEvaluator propertyEvaluator = this.getProjectProperties(project);
            String string = propertyEvaluator.getProperty("main.class");
            if (string == null || "".equals(string) || SourceUtils.findFileObjectByClassName((String)string, (Project)project) == null) {
                this.mainClassSetManually = ProjectUtilities.selectMainClass((Project)project, null, (String)ProjectUtilities.getProjectName((Project)project), (int)-1);
                if (this.mainClassSetManually == null) {
                    return false;
                }
            }
            return true;
        }
        return this.isFileObjectSupported(project, fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkProjectIsModifiedForProfiler(Project project) {
        if (ProjectUtilities.isProfilerIntegrated((Project)project)) {
            return true;
        }
        String string = ProjectUtils.getInformation((Project)project).getDisplayName();
        String string2 = MessageFormat.format(MODIFY_BUILDSCRIPT_CAPTION, string);
        String string3 = MessageFormat.format(MODIFY_BUILDSCRIPT_MSG, string, "build-before-profiler.xml");
        if (ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor((Object)string3, string2, 2, 1, new Object[]{NotifyDescriptor.OK_OPTION, NotifyDescriptor.CANCEL_OPTION}, NotifyDescriptor.OK_OPTION)) != NotifyDescriptor.OK_OPTION) {
            return false;
        }
        GeneratedFilesHelper generatedFilesHelper = new GeneratedFilesHelper(project.getProjectDirectory());
        int n = generatedFilesHelper.getBuildScriptState("nbproject/profiler-build-impl.xml", J2SEProjectTypeProfiler.class.getResource("profiler-build-impl.xsl"));
        if ((n & 2) != 0 || (n & 0x10) != 0) {
            try {
                if ((n & 4) != 0 && ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)MessageFormat.format(REGENERATE_BUILDSCRIPT_MSG, "profiler-build-impl.xml"), 2)) != NotifyDescriptor.OK_OPTION) {
                    return false;
                }
                generatedFilesHelper.generateBuildScriptFromStylesheet("nbproject/profiler-build-impl.xml", J2SEProjectTypeProfiler.class.getResource("profiler-build-impl.xsl"));
            }
            catch (IOException iOException) {
                err.notify(16, (Throwable)iOException);
                return false;
            }
        }
        Element element = XMLUtil.createDocument((String)"ignore", null, null, null).createElementNS("http://www.netbeans.org/ns/profiler/1", "data");
        element.setAttribute(PROFILE_VERSION_ATTRIBUTE, VERSION_NUMBER);
        ProjectUtils.getAuxiliaryConfiguration((Project)project).putConfigurationFragment(element, false);
        try {
            ProjectManager.getDefault().saveProject(project);
        }
        catch (IOException iOException) {
            err.notify((Throwable)iOException);
            ProfilerLogger.log((Exception)iOException);
            return false;
        }
        String string4 = ProjectUtilities.getProjectBuildScript((Project)project);
        if (string4 == null) {
            ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(CANNOT_FIND_BUILDSCRIPT_MSG, "build.xml"), 0));
            return false;
        }
        if (!ProjectUtilities.backupBuildScript((Project)project) && ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)CANNOT_BACKUP_BUILDSCRIPT_MSG, 2, 2)) != NotifyDescriptor.OK_OPTION) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer(string4.length() + 200);
        int n2 = string4.indexOf(STANDARD_IMPORT_STRING);
        if (n2 == -1) {
            ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)MessageFormat.format(MODIFY_BUILDSCRIPT_MANUALLY_MSG, "build.xml", PROFILER_IMPORT_STRING), 2));
            return false;
        }
        String string5 = "";
        for (int i = n2 - 1; i >= 0; --i) {
            if (string4.charAt(i) == ' ') {
                string5 = " " + string5;
                continue;
            }
            if (string4.charAt(i) != '\t') break;
            string5 = "\t" + string5;
        }
        stringBuffer.append(string4.substring(0, n2 + STANDARD_IMPORT_STRING.length() + 1));
        stringBuffer.append("\n");
        stringBuffer.append(string5);
        stringBuffer.append(PROFILER_IMPORT_STRING);
        stringBuffer.append(string4.substring(n2 + STANDARD_IMPORT_STRING.length() + 1));
        FileObject fileObject = ProjectUtilities.findBuildFile((Project)project);
        FileLock fileLock = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            fileLock = fileObject.lock();
            outputStreamWriter = new OutputStreamWriter(fileObject.getOutputStream(fileLock), "UTF-8");
            outputStreamWriter.write(stringBuffer.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            ProfilerLogger.log((Exception)fileNotFoundException);
            err.notify((Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            ProfilerLogger.log((Exception)iOException);
            err.notify((Throwable)iOException);
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    public void configurePropertiesForProfiling(Properties properties, Project project, FileObject fileObject) {
        if (fileObject == null) {
            if (this.mainClassSetManually != null) {
                properties.put("main.class", this.mainClassSetManually);
                this.mainClassSetManually = null;
            }
        } else {
            String string;
            if (SourceUtils.isApplet((FileObject)fileObject)) {
                string = properties.getProperty("run.jvmargs");
                URL uRL = null;
                if (string == null || string.indexOf("java.security.policy") <= 0) {
                    PropertyEvaluator propertyEvaluator = this.getProjectProperties(project);
                    String string2 = propertyEvaluator.getProperty("build.dir");
                    FileObject fileObject2 = ProjectUtilities.getOrCreateBuildFolder((Project)project, (String)string2);
                    AppletSupport.generateSecurityPolicy((FileObject)project.getProjectDirectory(), (FileObject)fileObject2);
                    if (string == null || string.length() == 0) {
                        properties.setProperty("run.jvmargs", "-Djava.security.policy=" + FileUtil.toFile((FileObject)fileObject2).getPath() + File.separator + "applet.policy");
                    } else {
                        properties.setProperty("run.jvmargs", string + " -Djava.security.policy=" + FileUtil.toFile((FileObject)fileObject2).getPath() + File.separator + "applet.policy");
                    }
                }
                if ((uRL = fileObject.existsExt("html") || fileObject.existsExt("HTML") ? ProjectUtilities.copyAppletHTML((Project)project, (PropertyEvaluator)this.getProjectProperties(project), (FileObject)fileObject, (String)"html") : ProjectUtilities.generateAppletHTML((Project)project, (PropertyEvaluator)this.getProjectProperties(project), (FileObject)fileObject)) == null) {
                    return;
                }
                properties.setProperty("applet.url", uRL.toString());
            } else {
                string = SourceUtils.getToplevelClassName((FileObject)fileObject);
                properties.setProperty("profile.class", string);
            }
            string = FileUtil.getRelativePath((FileObject)ProjectUtilities.getRootOf((FileObject[])ProjectUtilities.getSourceRoots((Project)project), (FileObject)fileObject), (FileObject)fileObject);
            properties.setProperty("javac.includes", string);
        }
    }

    public void setupProjectSessionSettings(Project project, SessionSettings sessionSettings) {
        String string;
        PropertyEvaluator propertyEvaluator = this.getProjectProperties(project);
        if (this.mainClassSetManually == null) {
            string = propertyEvaluator.getProperty("main.class");
            sessionSettings.setMainClass(string != null ? string : "");
        } else {
            sessionSettings.setMainClass(this.mainClassSetManually);
        }
        string = propertyEvaluator.getProperty("application.args");
        sessionSettings.setMainArgs(string != null ? string : "");
        String string2 = propertyEvaluator.getProperty("run.classpath");
        sessionSettings.setMainClassPath(string2 != null ? string2 : "");
        String string3 = propertyEvaluator.getProperty("run.jvmargs");
        sessionSettings.setJVMArgs(string3 != null ? string3 : "");
    }

    public boolean supportsSettingsOverride() {
        return true;
    }

    public boolean supportsUnintegrate(Project project) {
        return true;
    }

    public void unintegrateProfiler(Project project) {
        ProjectUtilities.unintegrateProfiler((Project)project);
    }

    private PropertyEvaluator getProjectProperties(Project project) {
        final Properties properties = new Properties();
        final Properties properties2 = new Properties();
        final Properties properties3 = new Properties();
        final Properties properties4 = new Properties();
        final FileObject fileObject = project.getProjectDirectory().getFileObject("nbproject/private/private.properties");
        final FileObject fileObject2 = project.getProjectDirectory().getFileObject("nbproject/project.properties");
        final File file = InstalledFileLocator.getDefault().locate("build.properties", null, false);
        final FileObject fileObject3 = project.getProjectDirectory().getFileObject("nbproject/private/config.properties");
        final FileObject fileObject4 = project.getProjectDirectory().getFileObject("nbproject/configs");
        ProjectManager.mutex().readAccess(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block30: {
                    InputStream inputStream;
                    if (fileObject != null) {
                        try {
                            inputStream = fileObject.getInputStream();
                            try {
                                properties.load(inputStream);
                            }
                            finally {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            err.notify(1, (Throwable)iOException);
                        }
                    }
                    if (fileObject2 != null) {
                        try {
                            inputStream = fileObject2.getInputStream();
                            try {
                                properties2.load(inputStream);
                            }
                            finally {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            err.notify(1, (Throwable)iOException);
                        }
                    }
                    if (file != null) {
                        try {
                            inputStream = new BufferedInputStream(new FileInputStream(file));
                            try {
                                properties3.load(inputStream);
                            }
                            finally {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            err.notify(1, (Throwable)iOException);
                        }
                    }
                    if (fileObject4 != null && fileObject3 != null) {
                        try {
                            inputStream = fileObject3.getInputStream();
                            Properties properties5 = new Properties();
                            try {
                                FileObject fileObject5;
                                properties5.load(inputStream);
                                String string = properties5.getProperty("config");
                                if (string == null || string.length() <= 0 || (fileObject5 = fileObject4.getFileObject(string + ".properties")) == null) break block30;
                                InputStream inputStream2 = fileObject5.getInputStream();
                                try {
                                    properties4.load(inputStream2);
                                }
                                finally {
                                    inputStream2.close();
                                }
                            }
                            finally {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {
                            err.notify(1, (Throwable)iOException);
                        }
                    }
                }
            }
        });
        PropertyEvaluator propertyEvaluator = PropertyUtils.sequentialPropertyEvaluator(null, (PropertyProvider[])new PropertyProvider[]{new MyPropertyProvider(properties4), new MyPropertyProvider(properties), new MyPropertyProvider(properties3), new MyPropertyProvider(properties2)});
        return propertyEvaluator;
    }

    private static class MyPropertyProvider
    implements PropertyProvider {
        private Properties props;

        private MyPropertyProvider(Properties properties) {
            this.props = properties;
        }

        public Map getProperties() {
            return this.props;
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }
}

