/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.mapper.view;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JTree;
import org.netbeans.modules.soa.mapper.basicmapper.util.MapperUtilities;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.xpath.XPathPredicateExpression;
import org.netbeans.modules.xslt.mapper.model.FindUsedPredicateNodesVisitor;
import org.netbeans.modules.xslt.mapper.model.PredicatedAxiComponent;
import org.netbeans.modules.xslt.mapper.model.SourceTreeModel;
import org.netbeans.modules.xslt.mapper.model.nodes.Node;
import org.netbeans.modules.xslt.mapper.model.nodes.NodeFactory;
import org.netbeans.modules.xslt.mapper.model.nodes.TreeNode;
import org.netbeans.modules.xslt.mapper.model.targettree.PredicatedSchemaNode;
import org.netbeans.modules.xslt.mapper.model.targettree.SchemaNode;
import org.netbeans.modules.xslt.mapper.view.XsltMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicateManager {
    private XsltMapper myMapper;
    private LinkedList<CachedPredicate> myPredicates;

    public PredicateManager(XsltMapper xsltMapper) {
        this.myMapper = xsltMapper;
        this.myPredicates = new LinkedList();
    }

    public TreeNode getPredicatedNode(TreeNode treeNode, XPathPredicateExpression[] xPathPredicateExpressionArray) {
        assert (treeNode instanceof SchemaNode);
        AXIComponent aXIComponent = treeNode.getType();
        CachedPredicate object2 = null;
        for (CachedPredicate object3 : this.myPredicates) {
            if (!object3.hasSameParams(aXIComponent, xPathPredicateExpressionArray) || !object3.hasSameLocation(treeNode)) continue;
            object2 = object3;
            break;
        }
        if (object2 == null) {
            return null;
        }
        PredicatedAxiComponent predicatedAxiComponent = object2.getPComponent();
        TreeNode treeNode2 = treeNode.getParent();
        if (treeNode2 == null) {
            return null;
        }
        for (TreeNode treeNode3 : treeNode2.getChildren()) {
            PredicatedAxiComponent predicatedAxiComponent2;
            if (!(treeNode3 instanceof PredicatedSchemaNode) || !(predicatedAxiComponent2 = ((PredicatedSchemaNode)treeNode3).getPredicatedAxiComp()).equals(predicatedAxiComponent)) continue;
            return treeNode3;
        }
        return null;
    }

    public Collection<PredicatedSchemaNode> getPredicatedNodes(TreeNode treeNode) {
        assert (treeNode instanceof SchemaNode);
        TreeNode treeNode2 = treeNode.getParent();
        LinkedList<PredicatedSchemaNode> linkedList = new LinkedList<PredicatedSchemaNode>();
        if (treeNode2 != null) {
            for (TreeNode treeNode3 : treeNode2.getChildren()) {
                if (!(treeNode3 instanceof PredicatedSchemaNode)) continue;
                linkedList.add((PredicatedSchemaNode)treeNode3);
            }
        }
        return linkedList;
    }

    public Collection<PredicatedSchemaNode> createPredicatedNodes(TreeNode treeNode) {
        assert (treeNode instanceof SchemaNode);
        AXIComponent aXIComponent = treeNode.getType();
        LinkedList<CachedPredicate> linkedList = new LinkedList<CachedPredicate>();
        for (CachedPredicate object : this.myPredicates) {
            if (!object.getType().equals(aXIComponent) || !object.hasSameLocation(treeNode)) continue;
            linkedList.add(object);
        }
        LinkedList linkedList2 = new LinkedList();
        for (CachedPredicate cachedPredicate : linkedList) {
            Node node = NodeFactory.createNode(cachedPredicate.getPComponent(), this.myMapper);
            assert (node instanceof PredicatedSchemaNode);
            linkedList2.add((PredicatedSchemaNode)node);
        }
        return linkedList2;
    }

    public PredicatedSchemaNode createPredicatedNode(TreeNode treeNode, XPathPredicateExpression[] xPathPredicateExpressionArray) {
        assert (treeNode instanceof SchemaNode);
        AXIComponent aXIComponent = treeNode.getType();
        PredicatedAxiComponent predicatedAxiComponent = new PredicatedAxiComponent(aXIComponent, xPathPredicateExpressionArray);
        CachedPredicate cachedPredicate = new CachedPredicate(predicatedAxiComponent, treeNode);
        cachedPredicate.setPersistent(true);
        if (!this.addPredicate(cachedPredicate)) {
            return null;
        }
        TreeNode treeNode2 = treeNode.getParent();
        Node node = NodeFactory.createNode(predicatedAxiComponent, this.myMapper);
        assert (node instanceof PredicatedSchemaNode);
        ((PredicatedSchemaNode)node).setParent(treeNode2);
        JTree jTree = this.myMapper.getMapperViewManager().getSourceView().getTree();
        assert (jTree != null);
        SourceTreeModel sourceTreeModel = (SourceTreeModel)jTree.getModel();
        treeNode2.reload();
        sourceTreeModel.fireTreeChanged(TreeNode.getTreePath(treeNode2));
        return (PredicatedSchemaNode)node;
    }

    public void addPredicate(List list) {
        CachedPredicate cachedPredicate = new CachedPredicate(list);
        cachedPredicate.setPersistent(false);
        if (!this.addPredicate(cachedPredicate)) {
            return;
        }
        TreeNode treeNode = this.lookForParentTreeNode(cachedPredicate);
        treeNode.reload();
        JTree jTree = this.myMapper.getMapperViewManager().getSourceView().getTree();
        assert (jTree != null);
        SourceTreeModel sourceTreeModel = (SourceTreeModel)jTree.getModel();
        sourceTreeModel.fireTreeChanged(TreeNode.getTreePath(treeNode));
    }

    private boolean addPredicate(CachedPredicate cachedPredicate) {
        for (CachedPredicate cachedPredicate2 : this.myPredicates) {
            if (!cachedPredicate2.equals(cachedPredicate)) continue;
            return false;
        }
        this.myPredicates.add(cachedPredicate);
        return true;
    }

    public boolean modifyPredicate(PredicatedSchemaNode predicatedSchemaNode, XPathPredicateExpression[] xPathPredicateExpressionArray) {
        PredicatedAxiComponent predicatedAxiComponent = predicatedSchemaNode.getPredicatedAxiComp();
        for (CachedPredicate cachedPredicate : this.myPredicates) {
            if (!cachedPredicate.hasSameParams(predicatedAxiComponent) || !cachedPredicate.hasSameLocation(predicatedSchemaNode)) continue;
            String string = cachedPredicate.getPComponent().getPredicatesText();
            cachedPredicate.getPComponent().setPredicates(xPathPredicateExpressionArray);
            cachedPredicate.setPersistent(true);
            String string2 = cachedPredicate.getPComponent().getPredicatesText();
            TreeNode treeNode = predicatedSchemaNode.getParent();
            treeNode.reload();
            JTree jTree = this.myMapper.getMapperViewManager().getSourceView().getTree();
            assert (jTree != null);
            SourceTreeModel sourceTreeModel = (SourceTreeModel)jTree.getModel();
            sourceTreeModel.fireTreeChanged(TreeNode.getTreePath(treeNode));
            this.myMapper.getMapperViewManager().postMapperEvent(MapperUtilities.getMapperEvent((Object)this, (Object)predicatedSchemaNode.getMapperNode(), (String)"MapperEvt.ReqUpdateNode", (String)("Predicate is modeified. Location: " + cachedPredicate.locationToString() + " Old: " + string + " New: " + string2)));
            return true;
        }
        return false;
    }

    public boolean deletePredicate(PredicatedSchemaNode predicatedSchemaNode) {
        PredicatedAxiComponent predicatedAxiComponent = predicatedSchemaNode.getPredicatedAxiComp();
        for (CachedPredicate cachedPredicate : this.myPredicates) {
            if (!cachedPredicate.hasSameParams(predicatedAxiComponent) || !cachedPredicate.hasSameLocation(predicatedSchemaNode)) continue;
            this.myPredicates.remove(cachedPredicate);
            TreeNode treeNode = predicatedSchemaNode.getParent();
            treeNode.reload();
            JTree jTree = this.myMapper.getMapperViewManager().getSourceView().getTree();
            assert (jTree != null);
            SourceTreeModel sourceTreeModel = (SourceTreeModel)jTree.getModel();
            sourceTreeModel.fireTreeChanged(TreeNode.getTreePath(treeNode));
            return true;
        }
        return false;
    }

    public void clearTemporaryPredicates() {
        TreeNode treeNode = (TreeNode)this.myMapper.getMapperViewManager().getDestView().getTree().getModel().getRoot();
        if (treeNode == null) {
            return;
        }
        FindUsedPredicateNodesVisitor findUsedPredicateNodesVisitor = new FindUsedPredicateNodesVisitor();
        treeNode.accept(findUsedPredicateNodesVisitor);
        ListIterator listIterator = this.myPredicates.listIterator();
        while (listIterator.hasNext()) {
            CachedPredicate cachedPredicate = (CachedPredicate)listIterator.next();
            PredicatedSchemaNode predicatedSchemaNode = cachedPredicate.findNode(this.myMapper);
            if (predicatedSchemaNode == null) {
                listIterator.remove();
                continue;
            }
            if (cachedPredicate.isPersistent() || findUsedPredicateNodesVisitor.getResultList().contains(predicatedSchemaNode)) continue;
            listIterator.remove();
            TreeNode treeNode2 = predicatedSchemaNode.getParent();
            treeNode2.reload();
            JTree jTree = this.myMapper.getMapperViewManager().getSourceView().getTree();
            assert (jTree != null);
            SourceTreeModel sourceTreeModel = (SourceTreeModel)jTree.getModel();
            sourceTreeModel.fireTreeChanged(TreeNode.getTreePath(treeNode2));
        }
    }

    public static String toString(XPathPredicateExpression[] xPathPredicateExpressionArray) {
        if (xPathPredicateExpressionArray != null && xPathPredicateExpressionArray.length != 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (XPathPredicateExpression xPathPredicateExpression : xPathPredicateExpressionArray) {
                stringBuilder.append("[").append(xPathPredicateExpression.getExpressionString()).append("]");
            }
            return stringBuilder.toString();
        }
        return "";
    }

    private TreeNode lookForParentTreeNode(CachedPredicate cachedPredicate) {
        ListIterator listIterator;
        Object e;
        JTree jTree = this.myMapper.getMapperViewManager().getSourceView().getTree();
        SourceTreeModel sourceTreeModel = (SourceTreeModel)jTree.getModel();
        LinkedList linkedList = cachedPredicate.getLocationPath();
        assert (!linkedList.isEmpty());
        TreeNode treeNode = (TreeNode)sourceTreeModel.getRoot();
        if (!this.isCompatible(treeNode, e = (listIterator = linkedList.listIterator()).next())) {
            return null;
        }
        TreeNode treeNode2 = treeNode;
        PredicatedAxiComponent predicatedAxiComponent = cachedPredicate.getPComponent();
        while (listIterator.hasNext() && treeNode2 != null && (e = listIterator.next()) != predicatedAxiComponent) {
            TreeNode treeNode3 = null;
            for (TreeNode treeNode4 : treeNode2.getChildren()) {
                if (!this.isCompatible(treeNode4, e)) continue;
                treeNode3 = treeNode4;
                break;
            }
            if (treeNode3 == null) {
                return null;
            }
            treeNode2 = treeNode3;
        }
        return treeNode2;
    }

    private boolean isCompatible(TreeNode treeNode, Object object) {
        if (object instanceof PredicatedAxiComponent) {
            if (treeNode instanceof PredicatedSchemaNode && ((PredicatedSchemaNode)treeNode).getPredicatedAxiComp().equals(object)) {
                return true;
            }
        } else if (object instanceof AXIComponent) {
            if (treeNode instanceof SchemaNode && treeNode.getType().equals(object)) {
                return true;
            }
        } else assert (false) : "Incompatible data object";
        return false;
    }

    public static class CachedPredicate {
        private LinkedList myLocationPath;
        private boolean isPersistent;

        public static LinkedList buildLocationPathList(PredicatedAxiComponent predicatedAxiComponent, TreeNode treeNode) {
            LinkedList<Object> linkedList = new LinkedList<Object>();
            linkedList.add(predicatedAxiComponent);
            for (TreeNode treeNode2 = treeNode.getParent(); treeNode2 != null; treeNode2 = treeNode2.getParent()) {
                Object object = treeNode2.getDataObject();
                assert (object != null);
                if (!(object instanceof AXIComponent) && !(object instanceof PredicatedAxiComponent)) break;
                linkedList.addFirst(object);
            }
            return linkedList;
        }

        public CachedPredicate(PredicatedAxiComponent predicatedAxiComponent, TreeNode treeNode) {
            this(CachedPredicate.buildLocationPathList(predicatedAxiComponent, treeNode));
        }

        public CachedPredicate(List list) {
            this.myLocationPath = list instanceof LinkedList ? (LinkedList)list : new LinkedList(list);
        }

        public boolean isPersistent() {
            return this.isPersistent;
        }

        public void setPersistent(boolean bl) {
            this.isPersistent = bl;
        }

        public AXIComponent getType() {
            return this.getPComponent().getType();
        }

        public PredicatedAxiComponent getPComponent() {
            return (PredicatedAxiComponent)this.myLocationPath.getLast();
        }

        public LinkedList getLocationPath() {
            return this.myLocationPath;
        }

        public boolean hasSameParams(AXIComponent aXIComponent, XPathPredicateExpression[] xPathPredicateExpressionArray) {
            PredicatedAxiComponent predicatedAxiComponent = this.getPComponent();
            return predicatedAxiComponent.getType().equals(aXIComponent) && predicatedAxiComponent.hasSamePredicates(xPathPredicateExpressionArray);
        }

        public boolean hasSameParams(PredicatedAxiComponent predicatedAxiComponent) {
            PredicatedAxiComponent predicatedAxiComponent2 = this.getPComponent();
            return predicatedAxiComponent2.equals(predicatedAxiComponent);
        }

        public boolean hasSameLocation(TreeNode treeNode) {
            ListIterator listIterator = this.myLocationPath.listIterator(this.myLocationPath.size() - 1);
            for (TreeNode treeNode2 = treeNode.getParent(); listIterator.hasPrevious() && treeNode2 != null; treeNode2 = treeNode2.getParent()) {
                Object e = listIterator.previous();
                Object object = treeNode2.getDataObject();
                if (object.equals(e)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.locationToString();
        }

        private String locationToString() {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (Object e : this.myLocationPath) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append("/");
                }
                stringBuilder.append(e.toString());
            }
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (!(object instanceof CachedPredicate)) {
                return false;
            }
            CachedPredicate cachedPredicate = (CachedPredicate)object;
            LinkedList linkedList = cachedPredicate.getLocationPath();
            if (linkedList.size() != this.myLocationPath.size()) {
                return false;
            }
            ListIterator listIterator = this.myLocationPath.listIterator(this.myLocationPath.size());
            ListIterator listIterator2 = linkedList.listIterator(linkedList.size());
            while (listIterator.hasPrevious()) {
                Object e;
                Object e2 = listIterator.previous();
                if (e2.equals(e = listIterator2.previous())) continue;
                return false;
            }
            return true;
        }

        public PredicatedSchemaNode findNode(XsltMapper xsltMapper) {
            Object object;
            JTree jTree = xsltMapper.getMapperViewManager().getSourceView().getTree();
            assert (jTree != null);
            TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
            if (treeNode == null) {
                return null;
            }
            TreeNode treeNode2 = null;
            Iterator iterator = this.myLocationPath.iterator();
            if (iterator.hasNext()) {
                object = iterator.next();
                if (treeNode.getDataObject() == object) {
                    treeNode2 = treeNode;
                }
            }
            if (treeNode2 == null) {
                return null;
            }
            object = null;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                object = null;
                for (TreeNode treeNode3 : treeNode2.getChildren()) {
                    if (treeNode3.getDataObject() != e) continue;
                    object = treeNode3;
                    break;
                }
                if (object == null) {
                    return null;
                }
                treeNode2 = object;
            }
            assert (object instanceof PredicatedSchemaNode);
            return (PredicatedSchemaNode)object;
        }
    }
}

