/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.mapper.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.soa.mapper.common.IMapperEvent;
import org.netbeans.modules.soa.mapper.common.IMapperLink;
import org.netbeans.modules.soa.mapper.common.IMapperListener;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoid;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoidNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xpath.AbstractXPathModelHelper;
import org.netbeans.modules.xml.xpath.XPathNumericLiteral;
import org.netbeans.modules.xml.xpath.visitor.XPathVisitor;
import org.netbeans.modules.xslt.mapper.model.BranchConstructor;
import org.netbeans.modules.xslt.mapper.model.BuildExpressionVisitor;
import org.netbeans.modules.xslt.mapper.model.FindAffectedTargetNodesVisitor;
import org.netbeans.modules.xslt.mapper.model.ModelBridge;
import org.netbeans.modules.xslt.mapper.model.nodes.Node;
import org.netbeans.modules.xslt.mapper.model.nodes.TreeNode;
import org.netbeans.modules.xslt.mapper.model.targettree.SchemaNode;
import org.netbeans.modules.xslt.mapper.model.targettree.StylesheetNode;
import org.netbeans.modules.xslt.mapper.view.NodeCreatorVisitor;
import org.netbeans.modules.xslt.mapper.view.SetExpressionVisitor;
import org.netbeans.modules.xslt.mapper.view.XsltMapper;
import org.netbeans.modules.xslt.model.XslComponent;
import org.netbeans.modules.xslt.model.XslVisitor;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsltModelBridge
extends ModelBridge
implements IMapperListener {
    public XsltModelBridge(XsltMapper xsltMapper) {
        super(xsltMapper);
        super.subscribe((Model)xsltMapper.getContext().getXSLModel());
    }

    public void eventInvoked(IMapperEvent iMapperEvent) {
        if ("MapperEvt.LinkAdded".equals(iMapperEvent.getEventType()) || "MapperEvt.LinkDel".equals(iMapperEvent.getEventType())) {
            this.onGraphChanged(((IMapperLink)iMapperEvent.getTransferObject()).getEndNode());
        } else if ("MapperEvt.ReqUpdateNode".equals(iMapperEvent.getEventType())) {
            this.onGraphChanged((IMapperNode)iMapperEvent.getTransferObject());
        } else if ("MapperEvt.ReqNewNode".equals(iMapperEvent.getEventType())) {
            this.onMethoidAdded((IMethoidNode)iMapperEvent.getTransferObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onGraphChanged(IMapperNode iMapperNode) {
        if (this.getMapper().getBuilder().isUpdating()) {
            return;
        }
        Node node = null;
        if (iMapperNode instanceof IMapperTreeNode) {
            node = TreeNode.getNode((IMapperTreeNode)iMapperNode);
        } else if (iMapperNode instanceof IFieldNode) {
            node = (Node)((IFieldNode)iMapperNode).getGroupNode().getNodeObject();
        } else if (iMapperNode instanceof IMethoidNode) {
            node = (Node)((IMethoidNode)iMapperNode).getNodeObject();
        }
        if (node == null) {
            return;
        }
        Collection<? extends Node> collection = this.findAffectedTargetNodes(node);
        if (collection == null) {
            return;
        }
        for (Node node2 : collection) {
            SetExpressionVisitor setExpressionVisitor;
            Node node3;
            BuildExpressionVisitor buildExpressionVisitor = new BuildExpressionVisitor(this.getMapper().getContext());
            if (!node2.getPreviousNodes().isEmpty() && (node3 = node2.getPreviousNodes().get(0)) != null) {
                node3.accept(buildExpressionVisitor);
            }
            node3 = null;
            if (node2 instanceof SchemaNode && buildExpressionVisitor.getResult() != null && buildExpressionVisitor.getResult().getExpressionString() != null && buildExpressionVisitor.getResult().getExpressionString().length() > 0) {
                setExpressionVisitor = this.getMapper().getContext().getXSLModel();
                node3 = new BranchConstructor((SchemaNode)node2, this.getMapper()).construct();
            } else {
                node3 = (XslComponent)node2.getDataObject();
            }
            setExpressionVisitor = new SetExpressionVisitor(buildExpressionVisitor.getResult());
            if (node3 != null) {
                node3.getModel().startTransaction();
                try {
                    node3.accept((XslVisitor)setExpressionVisitor);
                    continue;
                }
                finally {
                    node3.getModel().endTransaction();
                    continue;
                }
            }
            assert (false) : "Trying to assign expression to non-xslt node";
        }
    }

    private void onMethoidAdded(IMethoidNode iMethoidNode) {
        int n;
        Object object;
        if (this.getMapper().getBuilder().isUpdating()) {
            return;
        }
        IMethoid iMethoid = (IMethoid)iMethoidNode.getMethoidObject();
        FileObject fileObject = (FileObject)iMethoid.getData();
        String string = fileObject.getName();
        if (string == null || "".equals(string.trim())) {
            return;
        }
        XPathNumericLiteral xPathNumericLiteral = null;
        if (string.equals("number-literal")) {
            xPathNumericLiteral = AbstractXPathModelHelper.getInstance().newXPathNumericLiteral((Number)new Long(0L));
        } else if (string.equals("duration-literal")) {
            xPathNumericLiteral = AbstractXPathModelHelper.getInstance().newXPathStringLiteral("P0Y0M0DT0H0M0S");
        } else if (string.equals("string-literal") || string.equals("xpath_expression")) {
            xPathNumericLiteral = AbstractXPathModelHelper.getInstance().newXPathStringLiteral("");
        } else if (fileObject.getAttribute("Function") != null) {
            object = (String)fileObject.getAttribute("Function");
            n = AbstractXPathModelHelper.getInstance().getFunctionType((String)object);
            xPathNumericLiteral = AbstractXPathModelHelper.getInstance().newXPathCoreFunction(n);
        } else if (fileObject.getAttribute("Operator") != null) {
            object = (String)fileObject.getAttribute("Operator");
            if ("=".equals(object)) {
                object = "==";
            }
            n = AbstractXPathModelHelper.getInstance().getOperatorType((String)object);
            xPathNumericLiteral = AbstractXPathModelHelper.getInstance().newXPathCoreOperation(n);
        }
        if (xPathNumericLiteral != null) {
            object = new NodeCreatorVisitor(this.getMapper());
            xPathNumericLiteral.accept((XPathVisitor)object);
            Node node = object.getResult();
            if (iMethoidNode != null) {
                node.setMapperNode((IMapperNode)iMethoidNode);
                iMethoidNode.setNodeObject((Object)node);
            }
        }
    }

    @Override
    protected void onModelChanged() {
        if (!this.checkErrors()) {
            return;
        }
        super.reloadTree(this.getMapper().getMapperViewManager().getDestView().getTree());
        this.getMapper().getBuilder().updateDiagram(true);
    }

    private Collection<? extends Node> findAffectedTargetNodes(Node node) {
        if (node instanceof TreeNode && ((TreeNode)node).isSourceViewNode()) {
            TreeNode treeNode = (TreeNode)this.getMapper().getMapperViewManager().getDestView().getTree().getModel().getRoot();
            if (treeNode == null) {
                return null;
            }
            FindAffectedTargetNodesVisitor findAffectedTargetNodesVisitor = new FindAffectedTargetNodesVisitor((TreeNode)node);
            treeNode.accept(findAffectedTargetNodesVisitor);
            Collection<StylesheetNode> collection = findAffectedTargetNodesVisitor.getResultList();
            return collection;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        HashSet<Node> hashSet = new HashSet<Node>();
        this.findOwnerNodes(node, hashSet, arrayList);
        return arrayList;
    }

    private void findOwnerNodes(Node node, Set<Node> set, List<Node> list) {
        if (node == null) {
            return;
        }
        if (set.contains(node)) {
            return;
        }
        set.add(node);
        IMapperNode iMapperNode = node.getMapperNode();
        if (iMapperNode instanceof IMapperTreeNode && ((IMapperTreeNode)iMapperNode).isDestTreeNode()) {
            if (!list.contains(node)) {
                list.add(node);
            }
            return;
        }
        for (Node node2 : node.getNextNodes()) {
            this.findOwnerNodes(node2, set, list);
        }
    }
}

