/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.MissingResourceException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.xml.namespace.QName;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bpel.editors.api.ui.valid.ErrorMessagesBundle;
import org.netbeans.modules.bpel.model.api.BPELElementsBuilder;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.Reply;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.api.references.BpelReferenceable;
import org.netbeans.modules.bpel.model.api.support.VisibilityScope;
import org.netbeans.modules.bpel.nodes.VariableNode;
import org.netbeans.modules.bpel.properties.Constants;
import org.netbeans.modules.bpel.properties.PropertyType;
import org.netbeans.modules.bpel.properties.ResolverUtility;
import org.netbeans.modules.bpel.properties.VirtualVariableContainer;
import org.netbeans.modules.bpel.properties.choosers.NewMessageVarChooser;
import org.netbeans.modules.bpel.properties.choosers.VariableChooserPanel;
import org.netbeans.modules.bpel.properties.editors.FormBundle;
import org.netbeans.modules.bpel.properties.editors.controls.MessageConfigurationController;
import org.netbeans.modules.bpel.properties.editors.controls.MessageExchangeController;
import org.netbeans.modules.bpel.properties.editors.controls.TreeNodeChooser;
import org.netbeans.modules.bpel.properties.editors.controls.filter.PreferredFaultFilter;
import org.netbeans.modules.bpel.properties.editors.controls.filter.VariableTypeFilter;
import org.netbeans.modules.bpel.properties.props.editors.FaultNamePropertyCustomizer;
import org.netbeans.modules.soa.ui.ExtendedLookup;
import org.netbeans.modules.soa.ui.UserNotification;
import org.netbeans.modules.soa.ui.form.CustomNodeEditor;
import org.netbeans.modules.soa.ui.form.EditorLifeCycleAdapter;
import org.netbeans.modules.soa.ui.form.valid.DefaultDialogDescriptor;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidator;
import org.netbeans.modules.soa.ui.form.valid.SoaDialogDisplayer;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.netbeans.modules.soa.ui.nodes.NodesTreeParams;
import org.netbeans.modules.xml.wsdl.model.Fault;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplyMainPanel
extends EditorLifeCycleAdapter
implements Validator.Provider {
    static final long serialVersionUID = 1L;
    private CustomNodeEditor<Reply> myEditor;
    private MessageConfigurationController mcc;
    private MessageExchangeController mec;
    private QName myFaultName;
    private VirtualVariableContainer currFaultVar;
    private DefaultValidator myValidator;
    private boolean useNormalOutput;
    private JButton btnChooseFaultName;
    private JButton btnChooseFaultVariable;
    private JButton btnChooseMessEx;
    private JButton btnChooseOutputVariable;
    private JButton btnNewFaultVariable;
    private JButton btnNewOutputVariable;
    private ButtonGroup buttonGroup1;
    private JComboBox cbxOperation;
    private JComboBox cbxPartnerLink;
    private JTextField fldFaultName;
    private JTextField fldFaultVariable;
    private JTextField fldMessageExchange;
    private JTextField fldName;
    private JTextField fldOutputVariable;
    private JLabel lblErrorMessage;
    private JLabel lblFaultName;
    private JLabel lblFaultVariable;
    private JLabel lblMessageExchange;
    private JLabel lblName;
    private JLabel lblOperation;
    private JLabel lblOutputVariable;
    private JLabel lblPartnerLink;
    private JRadioButton rbtnFaultResponse;
    private JRadioButton rbtnNormalResponse;

    public ReplyMainPanel(CustomNodeEditor<Reply> customNodeEditor) {
        this.myEditor = customNodeEditor;
        this.createContent();
    }

    public void createContent() {
        this.mcc = new MessageConfigurationController(this.myEditor);
        this.mcc.createContent();
        this.mcc.setVisibleVariables(false, true, false);
        this.mcc.useMyRole();
        this.mcc.setConfigurationListener(new MessageConfigurationController.ConfigurationListener(){

            public void partnerLinkChanged() {
                ReplyMainPanel.this.updateEnabledState();
                ReplyMainPanel.this.getValidator().revalidate(true);
            }

            public void operationChanged() {
                ReplyMainPanel.this.updateEnabledState();
                if (ReplyMainPanel.this.rbtnFaultResponse.isSelected()) {
                    ReplyMainPanel.this.presetFaultName();
                }
                ReplyMainPanel.this.getValidator().revalidate(true);
            }
        });
        this.mec = new MessageExchangeController(this.myEditor);
        this.mec.createContent();
        this.initComponents();
        this.bindControls2PropertyNames();
        this.lblMessageExchange.setVisible(false);
        this.fldMessageExchange.setVisible(false);
        this.btnChooseMessEx.setVisible(false);
        this.btnChooseFaultName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReplyMainPanel.this.chooseFaultName();
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object == ReplyMainPanel.this.rbtnFaultResponse) {
                    ReplyMainPanel.this.presetFaultName();
                }
                ReplyMainPanel.this.updateEnabledState();
                ReplyMainPanel.this.getValidator().revalidate(true);
            }
        };
        this.rbtnNormalResponse.addActionListener(actionListener);
        this.rbtnFaultResponse.addActionListener(actionListener);
        this.btnChooseFaultVariable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ReplyMainPanel.this.chooseFaultVariable();
            }
        });
        this.btnNewFaultVariable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VirtualVariableContainer virtualVariableContainer = ReplyMainPanel.this.prepareNewFaultVariable();
                if (virtualVariableContainer != null) {
                    ReplyMainPanel.this.setCurrFaultVar(virtualVariableContainer);
                }
            }
        });
        this.myEditor.getValidStateManager(true).addValidStateListener(new ValidStateManager.ValidStateListener(){

            public void stateChanged(ValidStateManager validStateManager, boolean bl) {
                if (validStateManager.isValid()) {
                    ReplyMainPanel.this.lblErrorMessage.setText("");
                } else {
                    ReplyMainPanel.this.lblErrorMessage.setText(validStateManager.getHtmlReasons());
                }
            }
        });
    }

    private void bindControls2PropertyNames() {
        this.fldName.putClientProperty("PropertyBinder", (Object)PropertyType.NAME);
    }

    public boolean initControls() {
        QName qName;
        Reply reply = (Reply)this.myEditor.getEditedObject();
        if (reply != null && (qName = reply.getFaultName()) != null) {
            this.setFaultName(qName);
            VariableDeclaration variableDeclaration = null;
            BpelReference bpelReference = reply.getVariable();
            if (bpelReference != null) {
                variableDeclaration = (VariableDeclaration)bpelReference.get();
            }
            Lookup lookup = this.myEditor.getLookup();
            VirtualVariableContainer virtualVariableContainer = new VirtualVariableContainer(variableDeclaration, lookup);
            this.setCurrFaultVar(virtualVariableContainer);
        }
        if (this.myFaultName != null) {
            this.rbtnFaultResponse.setSelected(true);
        } else {
            this.rbtnNormalResponse.setSelected(true);
        }
        this.updateEnabledState();
        this.mcc.initControls();
        this.mec.initControls();
        this.getValidator().revalidate(true);
        return true;
    }

    public boolean subscribeListeners() {
        this.mcc.subscribeListeners();
        this.mec.subscribeListeners();
        return true;
    }

    public boolean unsubscribeListeners() {
        this.mcc.unsubscribeListeners();
        this.mec.unsubscribeListeners();
        return true;
    }

    public boolean applyNewValues() throws VetoException {
        this.mcc.applyNewValues();
        this.mec.applyNewValues();
        Reply reply = (Reply)this.myEditor.getEditedObject();
        if (reply != null) {
            if (!this.useNormalOutput && this.myFaultName != null) {
                reply.setFaultName(this.myFaultName);
            } else {
                reply.removeFaultName();
            }
            if (!this.useNormalOutput && this.currFaultVar != null) {
                VariableDeclaration variableDeclaration = this.currFaultVar.createNewVariable();
                BpelReference bpelReference = reply.createReference((BpelReferenceable)variableDeclaration, VariableDeclaration.class);
                reply.setVariable(bpelReference);
            }
        }
        return true;
    }

    public boolean afterClose() {
        this.mcc.afterClose();
        this.mec.afterClose();
        return true;
    }

    private void setFaultName(QName qName) {
        this.myFaultName = qName;
        if (qName == null) {
            this.fldFaultName.setText("");
        } else {
            Reply reply = (Reply)this.myEditor.getEditedObject();
            String string = ResolverUtility.qName2DisplayText(this.myFaultName, (BpelEntity)reply);
            this.fldFaultName.setText(string);
        }
    }

    private void chooseFaultName() throws MissingResourceException {
        Object object;
        Lookup lookup = this.myEditor.getLookup();
        Collection<QName> collection = this.getPreferredFaults();
        if (collection != null && collection.size() != 0) {
            object = new PreferredFaultFilter(collection);
            lookup = new ExtendedLookup(lookup, new Object[]{object});
        }
        object = new FaultNamePropertyCustomizer(lookup);
        ((FaultNamePropertyCustomizer)object).initControls();
        if (this.myFaultName != null) {
            ((FaultNamePropertyCustomizer)object).setSelectedValue(this.myFaultName);
        }
        String string = NbBundle.getMessage(FormBundle.class, (String)"DLG_FaultNameChooserTitle");
        DefaultDialogDescriptor defaultDialogDescriptor = new DefaultDialogDescriptor(object, string);
        SoaDialogDisplayer.getDefault().notify((NotifyDescriptor)defaultDialogDescriptor);
        if (defaultDialogDescriptor.isOkHasPressed()) {
            QName qName = ((FaultNamePropertyCustomizer)object).getSelectedValue();
            if (qName instanceof QName) {
                this.setFaultName(qName);
            } else if (qName == null) {
                this.setFaultName(null);
            }
            this.updateEnabledState();
        }
    }

    private Collection<QName> getPreferredFaults() {
        HashSet<QName> hashSet = new HashSet<QName>();
        Object object = this.cbxOperation.getSelectedItem();
        if (object != null) {
            Operation operation = (Operation)object;
            String string = operation.getModel().getDefinitions().getTargetNamespace();
            Object var5_5 = null;
            Collection collection = operation.getFaults();
            for (Fault fault : collection) {
                QName qName = new QName(string, fault.getName());
                hashSet.add(qName);
            }
        }
        return hashSet;
    }

    private void presetFaultName() {
        Object object;
        if (this.myFaultName == null && (object = this.cbxOperation.getSelectedItem()) != null) {
            Operation operation = (Operation)object;
            Object var3_3 = null;
            Collection collection = operation.getFaults();
            Iterator iterator = collection.iterator();
            if (iterator.hasNext()) {
                Fault fault = (Fault)iterator.next();
                String string = fault.getName();
                String string2 = operation.getModel().getDefinitions().getTargetNamespace();
                QName qName = new QName(string2, string);
                this.setFaultName(qName);
            }
        }
    }

    private void updateEnabledState() {
        int n = this.cbxOperation.getSelectedIndex();
        if (n == -1) {
            this.lblFaultName.setEnabled(false);
            this.fldFaultName.setEnabled(false);
            this.btnChooseFaultName.setEnabled(false);
            this.lblFaultVariable.setEnabled(false);
            this.fldFaultVariable.setEnabled(false);
            this.btnNewFaultVariable.setEnabled(false);
            this.btnChooseFaultVariable.setEnabled(false);
        } else if (this.rbtnNormalResponse.isSelected()) {
            this.useNormalOutput = true;
            this.lblFaultName.setEnabled(false);
            this.fldFaultName.setEnabled(false);
            this.btnChooseFaultName.setEnabled(false);
            this.lblFaultVariable.setEnabled(false);
            this.fldFaultVariable.setEnabled(false);
            this.btnNewFaultVariable.setEnabled(false);
            this.btnChooseFaultVariable.setEnabled(false);
            this.lblOutputVariable.setEnabled(true);
            this.mcc.setOutputVarEnabled(true);
        } else {
            this.useNormalOutput = false;
            this.lblFaultName.setEnabled(true);
            this.fldFaultName.setEnabled(true);
            this.btnChooseFaultName.setEnabled(true);
            if (this.myFaultName == null) {
                this.lblFaultVariable.setEnabled(false);
                this.fldFaultVariable.setEnabled(false);
                this.btnNewFaultVariable.setEnabled(false);
                this.btnChooseFaultVariable.setEnabled(false);
            } else {
                this.lblFaultVariable.setEnabled(true);
                this.fldFaultVariable.setEnabled(true);
                this.btnChooseFaultVariable.setEnabled(true);
                this.btnNewFaultVariable.setEnabled(this.getRequiredFaultTypeRef() != null);
            }
            this.lblOutputVariable.setEnabled(false);
            this.mcc.setOutputVarEnabled(false);
        }
    }

    private void chooseFaultVariable() {
        Collection<QName> collection = this.getAllowedFaultTypesQName();
        if (collection.isEmpty()) {
            collection = null;
        }
        String string = NbBundle.getMessage(FormBundle.class, (String)"DLG_FaultVariableChooser");
        Lookup lookup = this.myEditor.getLookup();
        BpelEntity bpelEntity = (BpelEntity)this.myEditor.getEditedObject();
        VisibilityScope visibilityScope = new VisibilityScope(bpelEntity, lookup);
        VariableTypeFilter variableTypeFilter = new VariableTypeFilter(null, collection);
        variableTypeFilter.setShowAppropriateVarOnly(true);
        NodesTreeParams nodesTreeParams = new NodesTreeParams();
        nodesTreeParams.setTargetNodeClasses(new Class[]{VariableNode.class});
        nodesTreeParams.setLeafNodeClasses(new Class[]{VariableNode.class});
        ExtendedLookup extendedLookup = new ExtendedLookup(lookup, new Object[]{visibilityScope, variableTypeFilter, nodesTreeParams});
        VariableChooserPanel variableChooserPanel = new VariableChooserPanel((Lookup)extendedLookup);
        TreeNodeChooser treeNodeChooser = new TreeNodeChooser(variableChooserPanel);
        treeNodeChooser.initControls();
        if (this.currFaultVar != null && this.currFaultVar.isExisting()) {
            variableChooserPanel.setSelectedValue(this.currFaultVar.getVariableDeclaration());
        }
        DefaultDialogDescriptor defaultDialogDescriptor = new DefaultDialogDescriptor((Object)treeNodeChooser, string);
        SoaDialogDisplayer.getDefault().notify((NotifyDescriptor)defaultDialogDescriptor);
        if (defaultDialogDescriptor.isOkHasPressed()) {
            VariableDeclaration variableDeclaration = variableChooserPanel.getSelectedValue();
            VirtualVariableContainer virtualVariableContainer = new VirtualVariableContainer(variableDeclaration, lookup);
            this.setCurrFaultVar(virtualVariableContainer);
        }
    }

    private Collection<QName> getAllowedFaultTypesQName() {
        HashSet<QName> hashSet = new HashSet<QName>();
        Object object = this.cbxOperation.getSelectedItem();
        if (object == null || this.myFaultName == null) {
            return hashSet;
        }
        Operation operation = (Operation)object;
        Collection collection = operation.getFaults();
        WSDLModel wSDLModel = operation.getModel();
        String string = wSDLModel.getDefinitions().getTargetNamespace();
        if (!string.equals(this.myFaultName.getNamespaceURI())) {
            return hashSet;
        }
        String string2 = this.myFaultName.getLocalPart();
        for (Fault fault : collection) {
            QName qName;
            NamedComponentReference namedComponentReference;
            if (!fault.getName().equals(string2) || (namedComponentReference = fault.getMessage()) == null || (qName = namedComponentReference.getQName()) == null) continue;
            hashSet.add(qName);
        }
        return hashSet;
    }

    private VirtualVariableContainer prepareNewFaultVariable() {
        Lookup lookup = this.myEditor.getLookup();
        BpelModel bpelModel = (BpelModel)lookup.lookup(BpelModel.class);
        Process process = bpelModel.getProcess();
        BPELElementsBuilder bPELElementsBuilder = bpelModel.getBuilder();
        Operation operation = (Operation)this.cbxOperation.getSelectedItem();
        if (operation == null) {
            return null;
        }
        NamedComponentReference<Message> namedComponentReference = this.getRequiredFaultTypeRef();
        if (namedComponentReference == null) {
            String string = NbBundle.getMessage(FormBundle.class, (String)"MSG_FaultMessageNotSpecified");
            UserNotification.showMessageAsinc((String)string);
            return null;
        }
        BpelEntity bpelEntity = (BpelEntity)this.myEditor.getEditedObject();
        NewMessageVarChooser newMessageVarChooser = new NewMessageVarChooser(bpelEntity, this.myFaultName.getLocalPart(), (Message)namedComponentReference.get(), Constants.MessageDirection.FAULT);
        newMessageVarChooser.initControls();
        String string = NbBundle.getMessage(FormBundle.class, (String)"DLG_NewFaultVariable");
        DefaultDialogDescriptor defaultDialogDescriptor = new DefaultDialogDescriptor((Object)newMessageVarChooser, string);
        Dialog dialog = SoaDialogDisplayer.getDefault().createDialog((DialogDescriptor)defaultDialogDescriptor);
        dialog.setVisible(true);
        if (defaultDialogDescriptor.isOkHasPressed()) {
            return newMessageVarChooser.getSelectedValue();
        }
        return null;
    }

    public void setCurrFaultVar(VirtualVariableContainer virtualVariableContainer) {
        if (this.currFaultVar == null && virtualVariableContainer != null || this.currFaultVar != null && !this.currFaultVar.equals(virtualVariableContainer)) {
            this.currFaultVar = virtualVariableContainer;
            this.fldFaultVariable.setText(this.currFaultVar == null ? "" : this.currFaultVar.getName());
        }
    }

    public DefaultValidator getValidator() {
        if (this.myValidator == null) {
            this.myValidator = new DefaultValidator((ValidStateManager.Provider)this.myEditor, ErrorMessagesBundle.class){

                public void doFastValidation() {
                    Object object;
                    if (ReplyMainPanel.this.rbtnNormalResponse.isSelected() && (object = ReplyMainPanel.this.cbxOperation.getSelectedItem()) instanceof Operation && ((Operation)object).getOutput() == null) {
                        this.addReasonKey(Validator.Severity.ERROR, "ERR_OPERATION_NO_OUTPUT", new String[]{((Operation)object).getName()});
                    }
                }

                public void doDetailedValidation() {
                    if (ReplyMainPanel.this.rbtnFaultResponse.isSelected()) {
                        if (ReplyMainPanel.this.myFaultName == null) {
                            this.addReasonKey(Validator.Severity.ERROR, "ERR_FAULT_NAME_EMPTY");
                        }
                        this.isCorrectFaultType(ReplyMainPanel.this.currFaultVar);
                    }
                }

                private boolean isCorrectFaultType(VirtualVariableContainer virtualVariableContainer) {
                    NamedComponentReference namedComponentReference = ReplyMainPanel.this.getRequiredFaultTypeRef();
                    if (namedComponentReference != null) {
                        Object var3_3 = null;
                        Message message = null;
                        if (virtualVariableContainer != null) {
                            message = virtualVariableContainer.getType().getMessage();
                        }
                        if (message == null) {
                            this.addReasonKey(Validator.Severity.ERROR, "ERR_FAULT_VAR_EMPTY");
                            return false;
                        }
                        if (!((Message)namedComponentReference.get()).equals(message)) {
                            String string = ResolverUtility.qName2DisplayText(namedComponentReference.getQName());
                            String string2 = ResolverUtility.qName2DisplayText(virtualVariableContainer.getType().getTypeQName());
                            this.addReasonKey(Validator.Severity.ERROR, "ERR_FAULT_VAR_WRONG_TYPE", new String[]{string, string2});
                            return false;
                        }
                    }
                    return true;
                }
            };
        }
        return this.myValidator;
    }

    private boolean isFaultSpecifiedForOperation() {
        Object object = this.cbxOperation.getSelectedItem();
        if (object != null) {
            Operation operation = (Operation)object;
            Object var3_3 = null;
            Collection collection = operation.getFaults();
            if (collection != null && collection.size() > 0) {
                return true;
            }
        }
        return false;
    }

    private Collection<Message> getAllowedFaultTypes() {
        HashSet<Message> hashSet = new HashSet<Message>();
        Object object = this.cbxOperation.getSelectedItem();
        if (object != null) {
            Operation operation = (Operation)object;
            Object var4_4 = null;
            Collection collection = operation.getFaults();
            for (Fault fault : collection) {
                Message message;
                NamedComponentReference namedComponentReference = fault.getMessage();
                if (namedComponentReference == null || (message = (Message)namedComponentReference.get()) == null) continue;
                hashSet.add(message);
            }
        }
        return hashSet;
    }

    private NamedComponentReference<Message> getRequiredFaultTypeRef() {
        NamedComponentReference namedComponentReference = null;
        Object object = this.cbxOperation.getSelectedItem();
        if (object != null) {
            Operation operation = (Operation)object;
            String string = operation.getModel().getDefinitions().getTargetNamespace();
            if (this.myFaultName != null || string.equals(this.myFaultName.getNamespaceURI())) {
                Collection collection = operation.getFaults();
                for (Fault fault : collection) {
                    String string2;
                    if (fault == null || (string2 = fault.getName()) == null || !string2.equals(this.myFaultName.getLocalPart())) continue;
                    namedComponentReference = fault.getMessage();
                    break;
                }
            }
        }
        return namedComponentReference;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.lblName = new JLabel();
        this.fldName = new JTextField();
        this.lblMessageExchange = new JLabel();
        this.fldMessageExchange = this.mec.getFldMessageExchange();
        this.btnChooseMessEx = this.mec.getBtnChooseMsgEx();
        this.lblFaultName = new JLabel();
        this.fldFaultName = new JTextField();
        this.btnChooseFaultName = new JButton();
        this.lblPartnerLink = new JLabel();
        this.cbxPartnerLink = this.mcc.getCbxPartnerLink();
        this.lblOperation = new JLabel();
        this.cbxOperation = this.mcc.getCbxOperation();
        this.lblOutputVariable = new JLabel();
        this.fldOutputVariable = this.mcc.getFldOutputVariable();
        this.btnNewOutputVariable = this.mcc.getBtnNewOutputVariable();
        this.btnChooseOutputVariable = this.mcc.getBtnChooseOutputVariable();
        this.rbtnNormalResponse = new JRadioButton();
        this.rbtnFaultResponse = new JRadioButton();
        this.lblFaultVariable = new JLabel();
        this.fldFaultVariable = new JTextField();
        this.btnNewFaultVariable = new JButton();
        this.btnChooseFaultVariable = new JButton();
        this.lblErrorMessage = new JLabel();
        this.lblName.setLabelFor(this.fldName);
        this.lblName.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_Name"));
        this.fldName.setColumns(40);
        this.fldName.setName("");
        this.lblMessageExchange.setLabelFor(this.fldMessageExchange);
        this.lblMessageExchange.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_MessageExchange"));
        this.btnChooseMessEx.setText(NbBundle.getMessage(FormBundle.class, (String)"BTN_ChooseMessageExchange"));
        this.btnChooseMessEx.setMargin(new Insets(0, 4, 0, 4));
        this.lblFaultName.setLabelFor(this.fldFaultName);
        this.lblFaultName.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_FaultName"));
        this.fldFaultName.setEditable(false);
        this.btnChooseFaultName.setText(NbBundle.getMessage(FormBundle.class, (String)"BNT_ChooseFaultName"));
        this.btnChooseFaultName.setMargin(new Insets(0, 4, 0, 4));
        this.lblPartnerLink.setLabelFor(this.cbxPartnerLink);
        this.lblPartnerLink.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_PartnerLink"));
        this.lblOperation.setLabelFor(this.cbxOperation);
        this.lblOperation.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_Operation"));
        this.lblOutputVariable.setLabelFor(this.fldOutputVariable);
        this.lblOutputVariable.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_OutputVariable"));
        this.fldOutputVariable.setColumns(30);
        this.fldOutputVariable.setEditable(false);
        this.btnNewOutputVariable.setText(NbBundle.getMessage(FormBundle.class, (String)"BTN_CreateOutputVariable"));
        this.btnNewOutputVariable.setMargin(new Insets(0, 4, 0, 4));
        this.btnChooseOutputVariable.setText(NbBundle.getMessage(FormBundle.class, (String)"BTN_BrowseOutputVarible"));
        this.btnChooseOutputVariable.setMargin(new Insets(0, 2, 0, 2));
        this.buttonGroup1.add(this.rbtnNormalResponse);
        this.rbtnNormalResponse.setText(NbBundle.getMessage(FormBundle.class, (String)"RBTN_NormalResponse"));
        this.rbtnNormalResponse.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbtnNormalResponse.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroup1.add(this.rbtnFaultResponse);
        this.rbtnFaultResponse.setText(NbBundle.getMessage(FormBundle.class, (String)"RBTN_FaultResponse"));
        this.rbtnFaultResponse.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbtnFaultResponse.setMargin(new Insets(0, 0, 0, 0));
        this.lblFaultVariable.setLabelFor(this.fldFaultVariable);
        this.lblFaultVariable.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_FaultVariable"));
        this.fldFaultVariable.setColumns(30);
        this.fldFaultVariable.setEditable(false);
        this.btnNewFaultVariable.setText(NbBundle.getMessage(FormBundle.class, (String)"BTN_CreateFaultVariable"));
        this.btnNewFaultVariable.setMargin(new Insets(0, 4, 0, 4));
        this.btnChooseFaultVariable.setText(NbBundle.getMessage(FormBundle.class, (String)"BTN_BrowseFaultVarible"));
        this.btnChooseFaultVariable.setMargin(new Insets(0, 2, 0, 2));
        this.lblErrorMessage.setForeground(new Color(255, 0, 0));
        this.lblErrorMessage.setAlignmentX(0.5f);
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblErrorMessage, -1, 483, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblFaultName).add((Component)this.lblFaultVariable)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.fldFaultVariable, -1, 200, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnNewFaultVariable).addPreferredGap(0).add((Component)this.btnChooseFaultVariable)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.fldFaultName, -1, 280, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnChooseFaultName).addPreferredGap(0)))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblPartnerLink).add((Component)this.lblOperation).add((Component)this.lblName)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbxOperation, 0, 396, Short.MAX_VALUE).add((Component)this.cbxPartnerLink, 0, 396, Short.MAX_VALUE).add((Component)this.fldName, -1, 396, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(17, 17, 17).add((Component)this.lblOutputVariable).add(7, 7, 7).add((Component)this.fldOutputVariable, -1, 188, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnNewOutputVariable).addPreferredGap(0).add((Component)this.btnChooseOutputVariable)).add((Component)this.rbtnNormalResponse).add((Component)this.rbtnFaultResponse).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblMessageExchange).addPreferredGap(0).add((Component)this.fldMessageExchange, -1, 268, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnChooseMessEx).addPreferredGap(0))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblName).add((Component)this.fldName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblPartnerLink).add((Component)this.cbxPartnerLink, -2, -1, -2)).add(8, 8, 8).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblOperation).add((Component)this.cbxOperation, -2, -1, -2)).add(11, 11, 11).add((Component)this.rbtnNormalResponse).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblOutputVariable).add((Component)this.btnNewOutputVariable).add((Component)this.btnChooseOutputVariable).add((Component)this.fldOutputVariable, -2, -1, -2)).add(11, 11, 11).add((Component)this.rbtnFaultResponse).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblFaultName).add((Component)this.fldFaultName, -2, -1, -2).add((Component)this.btnChooseFaultName)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblFaultVariable).add((Component)this.btnNewFaultVariable).add((Component)this.btnChooseFaultVariable).add((Component)this.fldFaultVariable, -2, -1, -2)).add(11, 11, 11).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.fldMessageExchange, -2, -1, -2).add((Component)this.lblMessageExchange).add((Component)this.btnChooseMessEx)).addPreferredGap(0).add((Component)this.lblErrorMessage, -1, 27, Short.MAX_VALUE).addContainerGap()));
        this.lblName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_Name"));
        this.lblName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Name"));
        this.fldName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ReplyMainPanel.class, (String)"ACSN_TXTFLD_ReplyName"));
        this.fldName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReplyMainPanel.class, (String)"ACSD_TXTFLD_ReplyName"));
        this.lblMessageExchange.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_MessageExchange"));
        this.lblMessageExchange.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_MessageExchange"));
        this.fldMessageExchange.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ReplyMainPanel.class, (String)"ACSN_TXTFLD_MessageExchange"));
        this.fldMessageExchange.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReplyMainPanel.class, (String)"ACSD_TXTFLD_MessageExchange"));
        this.btnChooseMessEx.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_BTN_ChooseMessageExchange"));
        this.btnChooseMessEx.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_BTN_ChooseMessageExchange"));
        this.lblFaultName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_FaultName"));
        this.lblFaultName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_FaultName"));
        this.fldFaultName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ReplyMainPanel.class, (String)"ACSN_TXTFLD_FaultName"));
        this.fldFaultName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReplyMainPanel.class, (String)"ACSD_TXTFLD_FaultName"));
        this.btnChooseFaultName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_BNT_ChooseFaultName"));
        this.btnChooseFaultName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_BNT_ChooseFaultName"));
        this.lblPartnerLink.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_PartnerLink"));
        this.lblPartnerLink.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_PartnerLink"));
        this.cbxPartnerLink.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ReplyMainPanel.class, (String)"ACSN_CBX_PartnerLink"));
        this.cbxPartnerLink.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReplyMainPanel.class, (String)"ACSD_CBX_PartnerLink"));
        this.lblOperation.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_Operation"));
        this.lblOperation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Operation"));
        this.cbxOperation.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ReplyMainPanel.class, (String)"ACSN_CBX_Operation"));
        this.cbxOperation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReplyMainPanel.class, (String)"ACSD_CBX_Operation"));
        this.lblOutputVariable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_OutputVariable"));
        this.lblOutputVariable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_OutputVariable"));
        this.fldOutputVariable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ReplyMainPanel.class, (String)"ACSN_TXTFLD_OutputVariable"));
        this.fldOutputVariable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReplyMainPanel.class, (String)"ACSD_TXTFLD_OutputVariable"));
        this.btnNewOutputVariable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_BTN_CreateOutputVariable"));
        this.btnNewOutputVariable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_BTN_CreateOutputVariable"));
        this.btnChooseOutputVariable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_BTN_BrowseOutputVarible"));
        this.btnChooseOutputVariable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_BTN_BrowseOutputVarible"));
        this.rbtnNormalResponse.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_RBTN_NormalResponse"));
        this.rbtnNormalResponse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_RBTN_NormalResponse"));
        this.rbtnFaultResponse.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_RBTN_FaultResponse"));
        this.rbtnFaultResponse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_RBTN_FaultResponse"));
        this.lblFaultVariable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_FaultVariable"));
        this.lblFaultVariable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_FaultVariable"));
        this.fldFaultVariable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ReplyMainPanel.class, (String)"ACSN_TXTFLD_FaultVariable"));
        this.fldFaultVariable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReplyMainPanel.class, (String)"ACSD_TXTFLD_FaultVariable"));
        this.btnNewFaultVariable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_BTN_CreateFaultVariable"));
        this.btnNewFaultVariable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_BTN_CreateFaultVariable"));
        this.btnChooseFaultVariable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_BTN_BrowseFaultVarible"));
        this.btnChooseFaultVariable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_BTN_BrowseFaultVarible"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ReplyMainPanel.class, (String)"ACSN_LBL_Main_Tab"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReplyMainPanel.class, (String)"ACSD_LBL_Main_Tab"));
    }
}

