/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.choosers;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.SoftBevelBorder;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bpel.editors.api.Constants;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.nodes.ImportSchemaNode;
import org.netbeans.modules.bpel.nodes.MessagePartNode;
import org.netbeans.modules.bpel.nodes.MessageTypeNode;
import org.netbeans.modules.bpel.nodes.PrimitiveTypeNode;
import org.netbeans.modules.bpel.nodes.ReloadableChildren;
import org.netbeans.modules.bpel.nodes.SchemaComponentNode;
import org.netbeans.modules.bpel.nodes.SchemaFileNode;
import org.netbeans.modules.bpel.properties.NodeUtils;
import org.netbeans.modules.bpel.properties.PropAliasSelectionContainer;
import org.netbeans.modules.bpel.properties.PropertyNodeFactory;
import org.netbeans.modules.bpel.properties.ResolverUtility;
import org.netbeans.modules.bpel.properties.TypeContainer;
import org.netbeans.modules.bpel.properties.editors.FormBundle;
import org.netbeans.modules.bpel.properties.editors.controls.AbstractTreeChooserPanel;
import org.netbeans.modules.bpel.properties.editors.controls.filter.ChildTypeFilter;
import org.netbeans.modules.bpel.properties.editors.nodes.factory.PropertyAliasTypeChooserNodeFactory;
import org.netbeans.modules.soa.ui.ExtendedLookup;
import org.netbeans.modules.soa.ui.SoaUtil;
import org.netbeans.modules.soa.ui.UserNotification;
import org.netbeans.modules.soa.ui.axinodes.AxiomNode;
import org.netbeans.modules.soa.ui.axinodes.AxiomUtils;
import org.netbeans.modules.soa.ui.form.Reusable;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.netbeans.modules.soa.ui.nodes.NodeFactory;
import org.netbeans.modules.soa.ui.nodes.NodesTreeParams;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xpath.AbstractXPathModelHelper;
import org.netbeans.modules.xml.xpath.LocationStep;
import org.netbeans.modules.xml.xpath.XPathException;
import org.netbeans.modules.xml.xpath.XPathExpression;
import org.netbeans.modules.xml.xpath.XPathLocationPath;
import org.netbeans.modules.xml.xpath.XPathModel;
import org.netbeans.modules.xml.xpath.visitor.AbstractXPathVisitor;
import org.netbeans.modules.xml.xpath.visitor.XPathVisitor;
import org.openide.ErrorManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropAliasTypeChooserPanel
extends AbstractTreeChooserPanel<PropAliasSelectionContainer>
implements Reusable {
    static final long serialVersionUID = 1L;
    private WSDLModel myTargetWsdlModel;
    private JCheckBox chbShowImportedOnly;
    private JCheckBox chbSynchronous;
    private JTextArea fldQuery;
    private JLabel lblQuery;
    private JPanel pnlLookupProvider;
    private JScrollPane queryPanel;
    private JScrollPane treeView;

    public PropAliasTypeChooserPanel() {
    }

    public PropAliasTypeChooserPanel(WSDLModel wSDLModel, Lookup lookup) {
        super(lookup);
        this.myTargetWsdlModel = wSDLModel;
        this.createContent();
        this.initControls();
    }

    public void init(WSDLModel wSDLModel, Lookup lookup) {
        this.myTargetWsdlModel = wSDLModel;
        NodesTreeParams nodesTreeParams = new NodesTreeParams();
        nodesTreeParams.setTargetNodeClasses(new Class[]{MessageTypeNode.class, MessagePartNode.class, AxiomNode.class});
        ExtendedLookup extendedLookup = new ExtendedLookup(lookup, new Object[]{nodesTreeParams});
        this.setLookup((Lookup)extendedLookup);
        this.initControls();
    }

    @Override
    public void createContent() {
        this.initComponents();
        super.createContent();
        ((BeanTreeView)this.treeView).setRootVisible(true);
        ((BeanTreeView)this.treeView).setSelectionMode(1);
        ((BeanTreeView)this.treeView).setPopupAllowed(false);
        this.getExplorerManager().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PropAliasTypeChooserPanel.this.chbSynchronous.isSelected()) {
                    PropAliasTypeChooserPanel.this.synchronizeQueryWithTree();
                }
            }
        });
        this.chbShowImportedOnly.setSelected(true);
        this.chbSynchronous.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PropAliasTypeChooserPanel.this.chbSynchronous.isSelected()) {
                    PropAliasTypeChooserPanel.this.synchronizeQueryWithTree();
                }
            }
        });
        this.chbShowImportedOnly.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BpelModel bpelModel = (BpelModel)PropAliasTypeChooserPanel.this.getLookup().lookup(BpelModel.class);
                Process process = bpelModel.getProcess();
                BpelNode<Process> bpelNode = NodeUtils.findFirstNode(process, PropAliasTypeChooserPanel.this.getExplorerManager().getRootContext());
                Children children = bpelNode.getChildren();
                if (children instanceof ReloadableChildren) {
                    ((ReloadableChildren)children).reload();
                }
            }
        });
    }

    @Override
    public boolean afterClose() {
        super.afterClose();
        return true;
    }

    @Override
    protected Node constructRootNode() {
        Node node = null;
        BpelModel bpelModel = (BpelModel)this.getLookup().lookup(BpelModel.class);
        Process process = bpelModel.getProcess();
        PropertyAliasTypeChooserNodeFactory propertyAliasTypeChooserNodeFactory = new PropertyAliasTypeChooserNodeFactory((NodeFactory)PropertyNodeFactory.getInstance());
        ChildTypeFilter childTypeFilter = new ChildTypeFilter(){

            public boolean isPairAllowed(NodeType nodeType, NodeType nodeType2) {
                if (PropAliasTypeChooserPanel.this.chbShowImportedOnly.isSelected()) {
                    return !nodeType2.equals((Object)NodeType.WSDL_FILE) && !nodeType2.equals((Object)NodeType.SCHEMA_FILE);
                }
                return true;
            }
        };
        ExtendedLookup extendedLookup = new ExtendedLookup(this.getLookup(), new Object[]{childTypeFilter});
        node = propertyAliasTypeChooserNodeFactory.createNode(NodeType.PROCESS, process, (Lookup)extendedLookup);
        return node;
    }

    public PropAliasSelectionContainer getSelectedValue() {
        Node node = this.getSelectedNode();
        return this.processTree(node);
    }

    private PropAliasSelectionContainer processTree(Node node) {
        if (node instanceof AxiomNode) {
            for (Node node2 = node.getParentNode(); node2 != null; node2 = node2.getParentNode()) {
                if (node2 instanceof AxiomNode) {
                    continue;
                }
                return this.processTree(node2);
            }
        } else if (node instanceof SchemaComponentNode) {
            Object t = ((SchemaComponentNode)node).getReference();
            String string = this.fldQuery.getText();
            if (t instanceof GlobalElement) {
                return new PropAliasSelectionContainer(new TypeContainer((GlobalElement)t), string);
            }
            if (t instanceof GlobalType) {
                return new PropAliasSelectionContainer(new TypeContainer((GlobalType)t), string);
            }
        } else {
            if (node instanceof MessageTypeNode) {
                Message message = (Message)((MessageTypeNode)node).getReference();
                String string = this.fldQuery.getText();
                return new PropAliasSelectionContainer(new TypeContainer(message), string);
            }
            if (node instanceof MessagePartNode) {
                Part part = (Part)((MessagePartNode)node).getReference();
                String string = this.fldQuery.getText();
                return new PropAliasSelectionContainer(part, string);
            }
            if (node instanceof PrimitiveTypeNode) {
                GlobalSimpleType globalSimpleType = (GlobalSimpleType)((PrimitiveTypeNode)node).getReference();
                String string = this.fldQuery.getText();
                return new PropAliasSelectionContainer(new TypeContainer((GlobalType)globalSimpleType), string);
            }
        }
        return null;
    }

    public void setSelectedValue(PropAliasSelectionContainer propAliasSelectionContainer) {
        if (propAliasSelectionContainer == null) {
            this.setSelectedNode(null);
            return;
        }
        this.fldQuery.setText(propAliasSelectionContainer.getQueryContent());
        Constants.VariableStereotype variableStereotype = null;
        TypeContainer typeContainer = propAliasSelectionContainer.getTypeContainer();
        if (typeContainer != null && (variableStereotype = typeContainer.getStereotype()) == null) {
            this.setSelectedNode(null);
            String string = NbBundle.getMessage(FormBundle.class, (String)"ERR_TYPE_RESOLVE_PROBLEM", (Object)propAliasSelectionContainer.getTypeContainer().getRefString(), (Object)"");
            UserNotification.showMessageAsinc((String)string);
            return;
        }
        if (variableStereotype == null) {
            return;
        }
        switch (variableStereotype) {
            case MESSAGE: {
                String string;
                final Message message = propAliasSelectionContainer.getTypeContainer().getMessage();
                boolean bl = ResolverUtility.isModelImported((Model)message.getModel(), this.getLookup());
                if (!bl && this.chbShowImportedOnly.isSelected()) {
                    this.chbShowImportedOnly.setSelected(false);
                }
                NodeUtils.SearchVisitor searchVisitor = new NodeUtils.SearchVisitor(){

                    public boolean accept(Node node) {
                        Message message2;
                        return node instanceof MessageTypeNode && (message2 = (Message)((MessageTypeNode)node).getReference()) != null && message2.equals(message);
                    }

                    public boolean drillDeeper(Node node) {
                        return !(node instanceof MessageTypeNode) && !(node instanceof SchemaFileNode) && !(node instanceof ImportSchemaNode);
                    }
                };
                Object object = NodeUtils.findFirstNode(this.getExplorerManager().getRootContext(), searchVisitor, -1);
                Part part = propAliasSelectionContainer.getMessagePart();
                if (part != null) {
                    object = NodeUtils.findFirstNode(part, object, 1);
                }
                if ((string = propAliasSelectionContainer.getQueryContent()) != null && string.length() != 0) {
                    object = this.findNodeByQuery(string, (Node)object);
                }
                this.setSelectedNode((Node)object);
                break;
            }
        }
    }

    private Node findNodeByQuery(String string, Node node) {
        XPathModel xPathModel = AbstractXPathModelHelper.getInstance().newXPathModel();
        try {
            XPathExpression xPathExpression = xPathModel.parseExpression(string);
            class FindPathVisitor
            extends AbstractXPathVisitor {
                private XPathLocationPath myLocationPath;

                FindPathVisitor() {
                }

                public void visit(XPathLocationPath xPathLocationPath) {
                    this.myLocationPath = xPathLocationPath;
                }

                public XPathLocationPath getLocationPath() {
                    return this.myLocationPath;
                }
            }
            FindPathVisitor findPathVisitor = new FindPathVisitor();
            xPathExpression.accept((XPathVisitor)findPathVisitor);
            XPathLocationPath xPathLocationPath = findPathVisitor.getLocationPath();
            for (LocationStep locationStep : xPathLocationPath.getSteps()) {
                Node node2 = PropAliasTypeChooserPanel.findAxiNodeByName(locationStep.getString(), node, 1);
                if (node2 == null) continue;
                node = node2;
            }
        }
        catch (XPathException xPathException) {
            ErrorManager.getDefault().notify((Throwable)xPathException);
        }
        return node;
    }

    public static Node findAxiNodeByName(final String string, Node node, int n) {
        NodeUtils.SearchVisitor searchVisitor = new NodeUtils.SearchVisitor(){

            public boolean accept(Node node) {
                String string2;
                return node instanceof AxiomNode && string.equals(string2 = ((AxiomNode)node).getName());
            }

            public boolean drillDeeper(Node node) {
                return true;
            }
        };
        Node node2 = NodeUtils.findFirstNode(node, searchVisitor, n);
        return node2;
    }

    private void synchronizeQueryWithTree() {
        this.fldQuery.setText(this.calculateSimpleQueryByTreeSelection());
    }

    private String calculateSimpleQueryByTreeSelection() {
        assert (this.myTargetWsdlModel != null);
        String string = "";
        Node node = this.getSelectedNode();
        if (node != null && node instanceof AxiomNode) {
            AxiomNode axiomNode = (AxiomNode)node;
            AbstractDocumentComponent abstractDocumentComponent = (AbstractDocumentComponent)this.myTargetWsdlModel.getDefinitions();
            string = AxiomUtils.calculateSimpleXPath((AxiomNode)axiomNode, (AbstractDocumentComponent)abstractDocumentComponent);
        }
        return string;
    }

    @Override
    protected Validator createValidator() {
        return new MyValidator();
    }

    public Component getTreeComponent() {
        JTree jTree = (JTree)SoaUtil.lookForChildByClass((Container)this.treeView, JTree.class);
        return jTree;
    }

    private void initComponents() {
        this.pnlLookupProvider = new AbstractTreeChooserPanel.TreeWrapperPanel(this);
        this.treeView = new BeanTreeView();
        this.chbShowImportedOnly = new JCheckBox();
        this.queryPanel = new JScrollPane();
        this.fldQuery = new JTextArea();
        this.chbSynchronous = new JCheckBox();
        this.lblQuery = new JLabel();
        this.pnlLookupProvider.setFocusable(false);
        this.treeView.setBorder(new SoftBevelBorder(1));
        this.treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_TypeChooser"));
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_TypeChooser"));
        GroupLayout groupLayout = new GroupLayout((Container)this.pnlLookupProvider);
        this.pnlLookupProvider.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.treeView, -1, 273, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.treeView, -1, 207, Short.MAX_VALUE));
        this.chbShowImportedOnly.setText(NbBundle.getMessage(FormBundle.class, (String)"CHB_Show_Imported_Files_Only"));
        this.chbShowImportedOnly.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chbShowImportedOnly.setMargin(new Insets(0, 0, 0, 0));
        this.chbShowImportedOnly.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_CHB_Show_Imported_Files_Only"));
        this.chbShowImportedOnly.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_CHB_Show_Imported_Files_Only"));
        this.queryPanel.setHorizontalScrollBarPolicy(31);
        this.fldQuery.setColumns(20);
        this.fldQuery.setLineWrap(true);
        this.fldQuery.setRows(3);
        this.fldQuery.setWrapStyleWord(true);
        this.queryPanel.setViewportView(this.fldQuery);
        this.chbSynchronous.setText(NbBundle.getMessage(FormBundle.class, (String)"CHB_Synchronous"));
        this.chbSynchronous.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chbSynchronous.setMargin(new Insets(0, 0, 0, 0));
        this.chbSynchronous.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_CHB_Synchronous"));
        this.chbSynchronous.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_CHB_Synchronous"));
        this.lblQuery.setLabelFor(this.fldQuery);
        this.lblQuery.setText(NbBundle.getMessage(FormBundle.class, (String)"LBL_Query"));
        this.lblQuery.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_Type"));
        this.lblQuery.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Type"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.queryPanel, -1, 273, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.lblQuery).addPreferredGap(0, 70, Short.MAX_VALUE).add((Component)this.chbSynchronous)).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.chbShowImportedOnly).addContainerGap()).add((Component)this.pnlLookupProvider, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.pnlLookupProvider, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.chbShowImportedOnly).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.chbSynchronous).add((Component)this.lblQuery, -2, 16, -2)).addPreferredGap(0).add((Component)this.queryPanel, -2, 56, -2)));
    }

    private class MyValidator
    extends AbstractTreeChooserPanel.DefaultChooserValidator {
        private MyValidator() {
            super(PropAliasTypeChooserPanel.this);
        }

        protected String getIncorrectNodeSelectionReasonKey() {
            return "ERR_PROP_ALIAS_TYPE_NOT_SPECIFIED";
        }
    }
}

