/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties;

import java.util.Iterator;
import org.netbeans.modules.bpel.model.api.BPELElementsBuilder;
import org.netbeans.modules.bpel.model.api.BaseScope;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableContainer;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.bpel.model.api.references.SchemaReference;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.model.spi.FindHelper;
import org.netbeans.modules.bpel.properties.TypeContainer;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.xam.Reference;
import org.openide.util.Lookup;

public class VirtualVariableContainer {
    private String myName;
    private TypeContainer myType;
    private BaseScope myScope;
    private VariableDeclaration myVarDecl;
    private Lookup myLookup;

    public VirtualVariableContainer(String string, TypeContainer typeContainer, BaseScope baseScope) {
        this.myName = string;
        this.myType = typeContainer;
        this.myScope = baseScope;
    }

    public VirtualVariableContainer(VariableDeclaration variableDeclaration, Lookup lookup) {
        this.myVarDecl = variableDeclaration;
    }

    public String getName() {
        if (this.myVarDecl == null) {
            return this.myName;
        }
        return this.myVarDecl.getVariableName();
    }

    public TypeContainer getType() {
        if (this.myVarDecl == null) {
            return this.myType;
        }
        WSDLReference wSDLReference = this.myVarDecl.getMessageType();
        if (wSDLReference == null && (wSDLReference = this.myVarDecl.getType()) == null) {
            wSDLReference = this.myVarDecl.getElement();
        }
        if (wSDLReference != null) {
            return new TypeContainer((Reference)wSDLReference);
        }
        return null;
    }

    public BaseScope getScope() {
        Iterator iterator;
        if (this.myVarDecl == null) {
            return this.myScope;
        }
        FindHelper findHelper = (FindHelper)this.myLookup.lookup(FindHelper.class);
        if (findHelper != null && (iterator = findHelper.scopeIterator((BpelEntity)this.myVarDecl)).hasNext()) {
            return (BaseScope)iterator.next();
        }
        return null;
    }

    public VariableDeclaration getVariableDeclaration() {
        return this.myVarDecl;
    }

    public boolean isExisting() {
        return this.myVarDecl != null;
    }

    public VariableDeclaration createNewVariable() throws VetoException {
        if (this.myVarDecl != null) {
            return this.myVarDecl;
        }
        BpelModel bpelModel = this.myScope.getBpelModel();
        BPELElementsBuilder bPELElementsBuilder = bpelModel.getBuilder();
        VariableContainer variableContainer = this.myScope.getVariableContainer();
        if (variableContainer == null) {
            variableContainer = bPELElementsBuilder.createVariableContainer();
            this.myScope.setVariableContainer(variableContainer);
            variableContainer = this.myScope.getVariableContainer();
        }
        Variable variable = bPELElementsBuilder.createVariable();
        variableContainer.insertVariable(variable, 0);
        variable = variableContainer.getVariable(0);
        variable.setName(this.myName);
        if (this.myType != null) {
            switch (this.myType.getStereotype()) {
                case MESSAGE: {
                    Message message = this.myType.getMessage();
                    WSDLReference wSDLReference = variable.createWSDLReference((ReferenceableWSDLComponent)message, Message.class);
                    variable.setMessageType(wSDLReference);
                    break;
                }
                case PRIMITIVE_TYPE: 
                case GLOBAL_TYPE: 
                case GLOBAL_SIMPLE_TYPE: 
                case GLOBAL_COMPLEX_TYPE: {
                    GlobalType globalType = this.myType.getGlobalType();
                    SchemaReference schemaReference = variable.createSchemaReference((ReferenceableSchemaComponent)globalType, GlobalType.class);
                    variable.setType(schemaReference);
                    break;
                }
                case GLOBAL_ELEMENT: {
                    GlobalElement globalElement = this.myType.getGlobalElement();
                    SchemaReference schemaReference = variable.createSchemaReference((ReferenceableSchemaComponent)globalElement, GlobalElement.class);
                    variable.setElement(schemaReference);
                }
            }
        }
        return variable;
    }

    public boolean equals(Object object) {
        if (object instanceof VirtualVariableContainer) {
            boolean bl = false;
            VirtualVariableContainer virtualVariableContainer = (VirtualVariableContainer)object;
            boolean bl2 = this.isExisting();
            boolean bl3 = virtualVariableContainer.isExisting();
            if (bl2 && bl3) {
                bl = this.myVarDecl.equals(virtualVariableContainer.getVariableDeclaration());
            } else if (!bl2 && !bl3) {
                bl = this.getName().equals(virtualVariableContainer.getName()) && this.getScope().equals(virtualVariableContainer.getScope()) && this.getType().equals(virtualVariableContainer.getType());
            }
            return bl;
        }
        return false;
    }
}

