/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes.actions;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.netbeans.modules.bpel.editors.api.nodes.actions.BpelNodeTypedAction;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ui.XAMUtils;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public abstract class BpelNodeAction
extends NodeAction
implements BpelNodeTypedAction {
    boolean no_transaction = true;
    private String name;

    public BpelNodeAction() {
    }

    public BpelNodeAction(boolean bl) {
        this();
        this.no_transaction = bl;
    }

    protected abstract String getBundleName();

    protected abstract void performAction(BpelEntity[] var1);

    protected boolean enable(BpelEntity[] bpelEntityArray) {
        boolean bl;
        if (bpelEntityArray == null) {
            return false;
        }
        if (bpelEntityArray.length != 1) {
            return false;
        }
        if (bpelEntityArray[0] == null) {
            return false;
        }
        BpelModel bpelModel = bpelEntityArray[0].getBpelModel();
        if (bpelModel == null) {
            return false;
        }
        boolean bl2 = bl = !XAMUtils.isWritable((Model)bpelModel);
        return !bl || !this.isChangeAction();
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction(Node[] nodeArray) {
        final BpelEntity[] bpelEntityArray = BpelNodeAction.getBpelEntities(nodeArray);
        if (!this.enable(bpelEntityArray)) {
            return;
        }
        BpelModel bpelModel = this.getBpelModel(nodeArray[0]);
        if (bpelModel == null) {
            return;
        }
        try {
            if (this.no_transaction) {
                this.performAction(bpelEntityArray);
            } else {
                bpelModel.invoke((Callable)new Callable<Object>(){

                    @Override
                    public Object call() {
                        BpelNodeAction.this.performAction(bpelEntityArray);
                        return null;
                    }
                }, (Object)this);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    public boolean enable(Node[] bpelModel) {
        if (bpelModel == null || ((Node[])bpelModel).length < 1) {
            return false;
        }
        for (Node node : bpelModel) {
            if (node instanceof BpelNode) continue;
            return false;
        }
        BpelModel bpelModel2 = this.getBpelModel(bpelModel[0]);
        if (bpelModel2 == null) {
            return false;
        }
        int n = 0;
        if (bpelModel2.isIntransaction()) {
            return this.enable(BpelNodeAction.getBpelEntities((Node[])bpelModel));
        }
        try {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class CheckEnabled
            implements Runnable {
                public boolean enabled = false;
                final /* synthetic */ Node[] val$nodes;

                CheckEnabled() {
                    this.val$nodes = nodeArray;
                }

                @Override
                public void run() {
                    this.enabled = BpelNodeAction.this.enable(BpelNodeAction.getBpelEntities(this.val$nodes));
                }
            }
            CheckEnabled checkEnabled = new CheckEnabled();
            bpelModel2.invoke((Runnable)checkEnabled);
            return checkEnabled.enabled;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return false;
        }
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getBundleName();
        }
        return this.name;
    }

    public boolean isChangeAction() {
        return true;
    }

    public BpelModel getBpelModel(Node node) {
        Object t;
        BpelModel bpelModel = (BpelModel)node.getLookup().lookup(BpelModel.class);
        if (bpelModel == null && node instanceof BpelNode && (t = ((BpelNode)node).getReference()) instanceof BpelEntity) {
            bpelModel = ((BpelEntity)t).getBpelModel();
        }
        return bpelModel;
    }

    public BpelModel getBpelModel(BpelEntity bpelEntity) {
        return bpelEntity == null ? null : bpelEntity.getBpelModel();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected static final BpelEntity[] getBpelEntities(Node[] nodeArray) {
        ArrayList<BpelEntity> arrayList = new ArrayList<BpelEntity>();
        Object var2_2 = null;
        for (Node node : nodeArray) {
            if (!(node instanceof BpelNode)) continue;
            Object t = ((BpelNode)node).getReference();
            var2_2 = t;
            if (!(t instanceof BpelEntity)) continue;
            arrayList.add(var2_2);
        }
        Node[] nodeArray2 = arrayList.size() < 1 ? null : new BpelEntity[arrayList.size()];
        nodeArray2 = nodeArray2 == null ? null : (BpelEntity[])arrayList.toArray(nodeArray2);
        return nodeArray2;
    }
}

