/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.model.patterns;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.bpel.design.geometry.FBounds;
import org.netbeans.modules.bpel.design.geometry.FPath;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.geometry.FRange;
import org.netbeans.modules.bpel.design.layout.LayoutManager;
import org.netbeans.modules.bpel.design.model.DiagramModel;
import org.netbeans.modules.bpel.design.model.connections.Connection;
import org.netbeans.modules.bpel.design.model.connections.DefaultConnection;
import org.netbeans.modules.bpel.design.model.connections.Direction;
import org.netbeans.modules.bpel.design.model.elements.BorderElement;
import org.netbeans.modules.bpel.design.model.elements.GroupBorder;
import org.netbeans.modules.bpel.design.model.elements.NullBorder;
import org.netbeans.modules.bpel.design.model.elements.PlaceHolderElement;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.selection.PlaceHolder;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.model.api.Activity;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.ExtendableActivity;
import org.netbeans.modules.bpel.model.api.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequencePattern
extends CompositePattern {
    private PlaceHolderElement placeHolder;
    private List<Connection> connections = new ArrayList<Connection>();

    public SequencePattern(DiagramModel diagramModel) {
        super(diagramModel);
    }

    @Override
    public VisualElement getFirstElement() {
        BpelEntity[] bpelEntityArray = (BpelEntity[])((Sequence)this.getOMReference()).getActivities();
        if (bpelEntityArray.length > 0) {
            return this.getNestedPattern(bpelEntityArray[0]).getFirstElement();
        }
        return this.placeHolder;
    }

    @Override
    public VisualElement getLastElement() {
        BpelEntity[] bpelEntityArray = (BpelEntity[])((Sequence)this.getOMReference()).getActivities();
        if (bpelEntityArray.length > 0) {
            return this.getNestedPattern(bpelEntityArray[bpelEntityArray.length - 1]).getLastElement();
        }
        return this.placeHolder;
    }

    @Override
    public boolean isSelectable() {
        return this.getBorder() instanceof GroupBorder;
    }

    @Override
    public FBounds layoutPattern(LayoutManager layoutManager) {
        List<Pattern> list = super.getNestedPatterns();
        FRange fRange = new FRange(0.0);
        double d = 0.0;
        if (list.isEmpty()) {
            double d2 = this.placeHolder.getWidth() / 2.0;
            this.placeHolder.setLocation(-d2, 0.0);
            fRange.extend(-d2);
            fRange.extend(d2);
            d = this.placeHolder.getHeight();
        } else {
            BpelEntity[] bpelEntityArray;
            for (BpelEntity bpelEntity : bpelEntityArray = (BpelEntity[])((Sequence)this.getOMReference()).getActivities()) {
                Pattern pattern = this.getNestedPattern(bpelEntity);
                assert (pattern != null);
                FBounds fBounds = pattern.getBounds();
                FPoint fPoint = layoutManager.getOriginOffset(pattern);
                layoutManager.setPatternPosition(pattern, -fPoint.x, d);
                fRange.extend(-fPoint.x);
                fRange.extend(fBounds.width - fPoint.x);
                d += (double)(fBounds.height + 18.0f);
            }
            d -= 18.0;
        }
        this.getBorder().setClientRectangle(fRange.min, 0.0, fRange.getSize(), d);
        return this.getBorder().getBounds();
    }

    @Override
    protected void createElementsImpl() {
        BpelEntity[] bpelEntityArray;
        this.placeHolder = new PlaceHolderElement();
        this.appendElement(this.placeHolder);
        if (this.getModel().getFilters().showImplicitSequences()) {
            this.setBorder(new GroupBorder());
            this.registerTextElement(this.getBorder());
        } else {
            this.setBorder(new NullBorder());
        }
        for (BpelEntity bpelEntity : bpelEntityArray = (BpelEntity[])((Sequence)this.getOMReference()).getActivities()) {
            Pattern pattern = this.getModel().createPattern(bpelEntity);
            pattern.setParent(this);
        }
    }

    @Override
    public String getDefaultName() {
        return "Sequence";
    }

    @Override
    protected void onAppendPattern(Pattern pattern) {
        if (this.placeHolder.getPattern() != null) {
            this.removeElement(this.placeHolder);
        }
    }

    @Override
    protected void onRemovePattern(Pattern pattern) {
        if (this.getNestedPatterns().isEmpty()) {
            this.appendElement(this.placeHolder);
        }
    }

    @Override
    public void createPlaceholders(Pattern pattern, Collection<PlaceHolder> collection) {
        if (!(pattern.getOMReference() instanceof Activity)) {
            return;
        }
        BpelEntity[] bpelEntityArray = (BpelEntity[])((Sequence)this.getOMReference()).getActivities();
        if (bpelEntityArray.length > 0) {
            double d;
            Object object;
            Connection connection = this.getInboundConnection();
            Connection connection2 = this.getOutboundConnection();
            Pattern pattern2 = this.getNestedPattern(bpelEntityArray[0]);
            Pattern pattern3 = this.getNestedPattern(bpelEntityArray[bpelEntityArray.length - 1]);
            Connection connection3 = null;
            HashMap<Connection, Pattern> hashMap = new HashMap<Connection, Pattern>();
            if (connection != null) {
                connection3 = connection;
                hashMap.put(connection3, null);
            }
            for (int i = 0; i < this.connections.size(); ++i) {
                Pattern pattern4 = this.getNestedPattern(bpelEntityArray[i]);
                if (pattern4 != pattern) {
                    connection3 = this.connections.get(i);
                    hashMap.put(connection3, pattern4);
                    continue;
                }
                if (connection3 == null) continue;
                hashMap.remove(connection3);
            }
            if (pattern3 != pattern) {
                if (connection2 != null) {
                    hashMap.put(connection2, pattern3);
                }
            } else if (connection3 != null) {
                hashMap.remove(connection3);
            }
            for (Connection connection4 : hashMap.keySet()) {
                FPath fPath = connection4.getSegmentsForPattern(this);
                if (fPath == null) continue;
                collection.add(new ConnectionPlaceHolder(pattern, fPath, (Pattern)hashMap.get(connection4)));
            }
            if (connection == null && pattern2 != pattern) {
                object = this.getBorder();
                double d2 = ((VisualElement)object).getCenterX();
                d = ((VisualElement)object).getY() + (double)(((BorderElement)object).getInsets().top / 2.0f);
                collection.add(new FirstPlaceHolder(pattern, d2, d));
            }
            if (connection2 == null && pattern3 != pattern) {
                object = this.getBorder();
                double d3 = ((VisualElement)object).getCenterX();
                d = ((VisualElement)object).getY() + ((VisualElement)object).getHeight() - (double)(((BorderElement)object).getInsets().bottom / 2.0f);
                collection.add(new LastPlaceHolder(pattern, d3, d));
            }
        } else {
            collection.add(new InnerPlaceHolder(pattern));
        }
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SEQUENCE;
    }

    public void updateAccordingToViewFiltersStatus() {
        if (this.getModel().getFilters().showImplicitSequences()) {
            this.setBorder(new GroupBorder());
            this.registerTextElement(this.getBorder());
            this.setText(((Sequence)this.getOMReference()).getName());
        } else {
            this.setBorder(new NullBorder());
            this.registerTextElement(null);
        }
    }

    @Override
    public void reconnectElements() {
        BpelEntity[] bpelEntityArray = (BpelEntity[])((Sequence)this.getOMReference()).getActivities();
        this.ensureConnectionsCount(this.connections, bpelEntityArray.length - 1);
        for (int i = 0; i < bpelEntityArray.length - 1; ++i) {
            Pattern pattern = this.getNestedPattern(bpelEntityArray[i]);
            Pattern pattern2 = this.getNestedPattern(bpelEntityArray[i + 1]);
            VisualElement visualElement = pattern.getLastElement();
            VisualElement visualElement2 = pattern2.getFirstElement();
            this.connections.get(i).connect(visualElement, Direction.BOTTOM, visualElement2, Direction.TOP);
        }
    }

    private Connection getInboundConnection() {
        List<Connection> list = this.getFirstElement().getIncomingConnections();
        for (Connection connection : list) {
            Class<?> clazz = connection.getClass();
            if (clazz != Connection.class && clazz != DefaultConnection.class) continue;
            return connection;
        }
        return null;
    }

    private Connection getOutboundConnection() {
        List<Connection> list = this.getLastElement().getOutcomingConnections();
        for (Connection connection : list) {
            Class<?> clazz = connection.getClass();
            if (clazz != Connection.class && clazz != DefaultConnection.class) continue;
            return connection;
        }
        return null;
    }

    class InnerPlaceHolder
    extends PlaceHolder {
        public InnerPlaceHolder(Pattern pattern) {
            super((Pattern)SequencePattern.this, pattern, SequencePattern.this.placeHolder.getCenterX(), SequencePattern.this.placeHolder.getCenterY());
        }

        public void drop() {
            ((Sequence)SequencePattern.this.getOMReference()).addActivity((ExtendableActivity)((Activity)this.getDraggedPattern().getOMReference()));
        }
    }

    class ConnectionPlaceHolder
    extends PlaceHolder {
        private Pattern insertAfter;

        public ConnectionPlaceHolder(Pattern pattern, FPath fPath, Pattern pattern2) {
            super((Pattern)SequencePattern.this, pattern, fPath);
            this.insertAfter = pattern2;
        }

        public void drop() {
            Pattern pattern = this.getDraggedPattern();
            BpelEntity[] bpelEntityArray = (BpelEntity[])((Sequence)SequencePattern.this.getOMReference()).getActivities();
            int n = -1;
            if (this.insertAfter == null) {
                n = 0;
            } else {
                BpelEntity bpelEntity = this.insertAfter.getOMReference();
                for (int i = 0; i < bpelEntityArray.length; ++i) {
                    if (bpelEntityArray[i] != bpelEntity) continue;
                    n = i + 1;
                    break;
                }
            }
            ((Sequence)SequencePattern.this.getOMReference()).insertActivity((ExtendableActivity)((Activity)pattern.getOMReference()), n);
        }
    }

    class LastPlaceHolder
    extends PlaceHolder {
        public LastPlaceHolder(Pattern pattern, double d, double d2) {
            super((Pattern)SequencePattern.this, pattern, d, d2);
        }

        public void drop() {
            Pattern pattern = this.getDraggedPattern();
            Sequence sequence = (Sequence)SequencePattern.this.getOMReference();
            int n = sequence.getActivities().length;
            sequence.addActivity((ExtendableActivity)((Activity)pattern.getOMReference()));
        }
    }

    class FirstPlaceHolder
    extends PlaceHolder {
        public FirstPlaceHolder(Pattern pattern, double d, double d2) {
            super((Pattern)SequencePattern.this, pattern, d, d2);
        }

        public void drop() {
            Pattern pattern = this.getDraggedPattern();
            Sequence sequence = (Sequence)SequencePattern.this.getOMReference();
            sequence.insertActivity((ExtendableActivity)((Activity)pattern.getOMReference()), 0);
        }
    }
}

