/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.model.patterns;

import java.awt.geom.Area;
import org.netbeans.modules.bpel.design.geometry.FBounds;
import org.netbeans.modules.bpel.design.geometry.FInsets;
import org.netbeans.modules.bpel.design.layout.LayoutManager;
import org.netbeans.modules.bpel.design.model.DiagramModel;
import org.netbeans.modules.bpel.design.model.PartnerLinkHelper;
import org.netbeans.modules.bpel.design.model.connections.Connection;
import org.netbeans.modules.bpel.design.model.connections.Direction;
import org.netbeans.modules.bpel.design.model.elements.BorderElement;
import org.netbeans.modules.bpel.design.model.elements.ContentElement;
import org.netbeans.modules.bpel.design.model.elements.GroupBorder;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Catch;
import org.netbeans.modules.bpel.model.api.CatchAll;
import org.netbeans.modules.bpel.model.api.CompensationHandler;
import org.netbeans.modules.bpel.model.api.Invoke;

public class InvokePattern
extends CompositePattern {
    private VisualElement invokeElement;
    private VisualElement errorBadge;
    private VisualElement compensationBadge;
    private BorderElement borderElement;

    public InvokePattern(DiagramModel diagramModel) {
        super(diagramModel);
    }

    protected void onAppendPattern(Pattern pattern) {
        BpelEntity bpelEntity = pattern.getOMReference();
        if (bpelEntity instanceof Catch || bpelEntity instanceof CatchAll) {
            if (!this.errorBadge.hasPattern()) {
                this.appendElement(this.borderElement);
                this.appendElement(this.errorBadge);
            }
        } else if (bpelEntity instanceof CompensationHandler) {
            this.appendElement(this.compensationBadge);
        }
    }

    protected void onRemovePattern(Pattern pattern) {
        Invoke invoke = (Invoke)this.getOMReference();
        if (this.errorBadge.hasPattern() && invoke.sizeOfCathes() == 0 && invoke.getCatchAll() == null) {
            this.removeElement(this.borderElement);
            this.removeElement(this.errorBadge);
        } else if (this.compensationBadge.hasPattern() && invoke.getCompensationHandler() == null) {
            this.removeElement(this.compensationBadge);
        }
    }

    protected void createElementsImpl() {
        Pattern pattern;
        Object object;
        this.invokeElement = ContentElement.createInvoke();
        this.appendElement(this.invokeElement);
        this.registerTextElement(this.invokeElement);
        this.errorBadge = ContentElement.createFaultBadge();
        this.compensationBadge = ContentElement.createCompensateBadge();
        this.borderElement = new GroupBorder();
        Invoke invoke = (Invoke)this.getOMReference();
        int n = invoke.sizeOfCathes();
        for (int i = 0; i < n; ++i) {
            object = invoke.getCatch(i);
            pattern = this.getModel().createPattern((BpelEntity)object);
            pattern.setParent(this);
        }
        CatchAll catchAll = invoke.getCatchAll();
        if (catchAll != null) {
            object = this.getModel().createPattern((BpelEntity)catchAll);
            ((Pattern)object).setParent(this);
        }
        if ((object = invoke.getCompensationHandler()) != null) {
            pattern = this.getModel().createPattern((BpelEntity)object);
            pattern.setParent(this);
        }
    }

    public String getDefaultName() {
        return "Invoke";
    }

    public NodeType getNodeType() {
        return NodeType.INVOKE;
    }

    public void reconnectElements() {
        this.clearConnections();
        new PartnerLinkHelper(this.getModel()).updateMessageFlowLinks(this);
        if (this.errorBadge.getPattern() != null) {
            new Connection(this).connect(this.errorBadge, Direction.RIGHT, this.borderElement, Direction.TOP);
        }
        if (this.compensationBadge.getPattern() != null) {
            Invoke invoke = (Invoke)this.getOMReference();
            CompensationHandler compensationHandler = invoke.getCompensationHandler();
            new Connection(this).connect(this.compensationBadge, Direction.RIGHT, this.getNestedPattern((BpelEntity)compensationHandler).getFirstElement(), Direction.TOP);
        }
    }

    public VisualElement getFirstElement() {
        return this.invokeElement;
    }

    public VisualElement getLastElement() {
        return this.invokeElement;
    }

    public FBounds layoutPattern(LayoutManager layoutManager) {
        Object object;
        double d = -this.invokeElement.getWidth() - 12.0;
        double d2 = -this.invokeElement.getHeight();
        double d3 = d + this.invokeElement.getWidth();
        double d4 = d2 + this.invokeElement.getHeight();
        double d5 = (d + d3) / 2.0;
        double d6 = d3;
        double d7 = d2;
        double d8 = d4;
        this.invokeElement.setLocation(d, d2);
        this.setOrigin((d + d3) / 2.0, (d2 + d4) / 2.0);
        Invoke invoke = (Invoke)this.getOMReference();
        int n = invoke.sizeOfCathes();
        CatchAll catchAll = invoke.getCatchAll();
        CompensationHandler compensationHandler = invoke.getCompensationHandler();
        double d9 = 0.0;
        double d10 = 0.0;
        if (n > 0 || catchAll != null) {
            Object object2;
            object = this.borderElement.getInsets();
            double d11 = d9 + (double)((FInsets)object).left;
            double d12 = d10 + (double)((FInsets)object).top;
            double d13 = d11;
            double d14 = d12;
            for (int i = 0; i < n; ++i) {
                object2 = this.getNestedPattern((BpelEntity)invoke.getCatch(i));
                FBounds fBounds = ((Pattern)object2).getBounds();
                layoutManager.setPatternPosition((Pattern)object2, d13, d12);
                d14 = Math.max(d14, d12 + (double)fBounds.height);
                d13 += (double)(fBounds.width + 12.0f);
            }
            if (catchAll != null) {
                Pattern pattern = this.getNestedPattern((BpelEntity)catchAll);
                object2 = pattern.getBounds();
                layoutManager.setPatternPosition(pattern, d13, d12);
                d14 = Math.max(d14, d12 + (double)((FBounds)object2).height);
                d13 += (double)((FBounds)object2).width;
            } else {
                d13 -= 12.0;
            }
            this.borderElement.setSize((d13 += (double)((FInsets)object).right) - (d11 -= (double)((FInsets)object).left), (d14 += (double)((FInsets)object).left) - (d12 -= (double)((FInsets)object).top));
            this.borderElement.setLocation(d11, d12);
            d9 = d13;
            d3 = Math.max(d3, d13);
            d4 = Math.max(d4, d14);
        }
        if (compensationHandler != null) {
            if (d9 > 0.0) {
                d9 += 12.0;
            }
            object = this.getNestedPattern((BpelEntity)compensationHandler);
            FBounds fBounds = ((Pattern)object).getBounds();
            layoutManager.setPatternPosition((Pattern)object, d9, d10);
            d3 = Math.max(d3, d9 + (double)fBounds.width);
            d4 = Math.max(d4, d10 + (double)fBounds.height);
        }
        if (n > 0 || catchAll != null) {
            if (compensationHandler != null) {
                double d15 = 0.75 * d7 + 0.25 * d8;
                double d16 = 0.25 * d7 + 0.75 * d8;
                this.compensationBadge.setCenter(d6, d15);
                this.errorBadge.setCenter(d6, d16);
            } else {
                double d17 = 0.5 * (d7 + d8);
                double d18 = d6;
                this.errorBadge.setCenter(d18, d17);
            }
        } else if (compensationHandler != null) {
            double d19 = 0.5 * (d7 + d8);
            double d20 = d6;
            this.compensationBadge.setCenter(d20, d19);
        }
        return new FBounds(d, d2, d3 - d, d4 - d2);
    }

    public Area createOutline() {
        Area area = this.invokeElement.getShape().createArea();
        if (this.compensationBadge.getPattern() != null) {
            area.add(this.compensationBadge.getShape().createArea());
        }
        if (this.errorBadge.getPattern() != null) {
            area.add(this.errorBadge.getShape().createArea());
        }
        return area;
    }

    public boolean isCollapsable() {
        return false;
    }
}

