/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.model.elements;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import org.netbeans.modules.bpel.design.geometry.FEllipse;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.geometry.FRectangle;
import org.netbeans.modules.bpel.design.geometry.FRoumb;
import org.netbeans.modules.bpel.design.geometry.FShape;
import org.netbeans.modules.bpel.design.geometry.FStroke;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.elements.icons.ANDIcon2D;
import org.netbeans.modules.bpel.design.model.elements.icons.AssignIcon2D;
import org.netbeans.modules.bpel.design.model.elements.icons.CompensateBadgeIcon2D;
import org.netbeans.modules.bpel.design.model.elements.icons.CompensateIcon2D;
import org.netbeans.modules.bpel.design.model.elements.icons.CompensateScopeIcon2D;
import org.netbeans.modules.bpel.design.model.elements.icons.EndEventIcon2D;
import org.netbeans.modules.bpel.design.model.elements.icons.EventBadgeIcon2D;
import org.netbeans.modules.bpel.design.model.elements.icons.EventIcon2D;
import org.netbeans.modules.bpel.design.model.elements.icons.ExitIcon2D;
import org.netbeans.modules.bpel.design.model.elements.icons.FaultBadgeIcon2D;
import org.netbeans.modules.bpel.design.model.elements.icons.ForEachIcon2D;
import org.netbeans.modules.bpel.design.model.elements.icons.Icon2D;
import org.netbeans.modules.bpel.design.model.elements.icons.InvokeIcon2D;
import org.netbeans.modules.bpel.design.model.elements.icons.MessageIcon2D;
import org.netbeans.modules.bpel.design.model.elements.icons.ReThrowIcon2D;
import org.netbeans.modules.bpel.design.model.elements.icons.ReceiveIcon2D;
import org.netbeans.modules.bpel.design.model.elements.icons.RepeatUntilIcon2D;
import org.netbeans.modules.bpel.design.model.elements.icons.ReplyIcon2D;
import org.netbeans.modules.bpel.design.model.elements.icons.TerminationBadgeIcon2D;
import org.netbeans.modules.bpel.design.model.elements.icons.ThrowIcon2D;
import org.netbeans.modules.bpel.design.model.elements.icons.TimerIcon2D;
import org.netbeans.modules.bpel.design.model.elements.icons.WhileIcon2D;
import org.netbeans.modules.bpel.design.model.elements.icons.XORIcon2D;
import org.netbeans.modules.bpel.design.model.elements.icons.XORSmallIcon2D;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;

public class ContentElement
extends VisualElement {
    private Icon2D icon;
    public static final FShape BADGE_SHAPE = new FEllipse(16.0, 16.0);
    public static final FShape START_END_EVENT_SHAPE = new FEllipse(20.0, 20.0);
    public static final FShape EVENT_SHAPE = new FEllipse(28.0, 28.0);
    public static final FShape GATEWAY_SHAPE = new FRoumb(28.0, 28.0);
    public static final FShape SMALL_GATEWAY_SHAPE = new FRoumb(20.0, 20.0);
    public static final FShape TASK_SHAPE = new FRectangle(40.0, 28.0, 6.0);
    public static final FShape COLLAPSED_SHAPE = new FRectangle(28.0, 28.0, 6.0);
    private static final FStroke STROKE = new FStroke(1.0);
    public static final Paint STROKE_COLOR = new Color(0xA7A2A7);

    public ContentElement(Icon2D icon2D) {
        this(TASK_SHAPE, icon2D);
    }

    public ContentElement(FShape fShape, Icon2D icon2D) {
        super(fShape);
        this.icon = icon2D;
    }

    public void paint(Graphics2D graphics2D) {
        Object object;
        FShape fShape = this.shape;
        graphics2D.setPaint(new TexturePaint(GRADIENT_TEXTURE, fShape.getBounds2D()));
        graphics2D.fill(fShape);
        if (this.icon != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            object = fShape.getNormalizedCenter(graphics2D);
            graphics2D.translate(((FPoint)object).x, ((FPoint)object).y);
            this.icon.paint(graphics2D);
            graphics2D.translate(-((FPoint)object).x, -((FPoint)object).y);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setStroke(STROKE.createStroke(graphics2D));
        graphics2D.setPaint(STROKE_COLOR);
        graphics2D.draw(fShape);
        if (this.isPaintText()) {
            object = null;
            for (Pattern pattern = this.getPattern(); !(pattern == null || pattern instanceof CompositePattern && (object = ((CompositePattern)pattern).getBorder()) != null); pattern = pattern.getParent()) {
            }
            if (object != null) {
                double d = this.getCenterX();
                double d2 = ((VisualElement)object).getX();
                double d3 = d2 + ((VisualElement)object).getWidth();
                double d4 = Math.min(Math.abs(d3 - d), Math.abs(d2 - d)) - 4.0;
                if (d4 > 0.0) {
                    graphics2D.setPaint(this.getTextColor());
                    this.drawXCenteredString(graphics2D, this.getText(), d, this.getY() + this.getHeight(), d4 * 2.0);
                }
            }
        }
    }

    public void paintThumbnail(Graphics2D graphics2D) {
        FShape fShape = this.shape;
        graphics2D.setPaint(GRADIENT_TEXTURE_COLOR);
        graphics2D.fill(fShape);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setStroke(STROKE.createStroke(graphics2D));
        graphics2D.setPaint(STROKE_COLOR);
        graphics2D.draw(fShape);
    }

    public Icon2D getIcon() {
        return this.icon;
    }

    public static ContentElement createAssign() {
        return new ContentElement(TASK_SHAPE, AssignIcon2D.INSTANCE);
    }

    public static ContentElement createEmpty() {
        return new ContentElement(TASK_SHAPE, null);
    }

    public static ContentElement createReply() {
        return new ContentElement(TASK_SHAPE, ReplyIcon2D.INSTANCE);
    }

    public static ContentElement createInvoke() {
        return new ContentElement(TASK_SHAPE, InvokeIcon2D.INSTANCE);
    }

    public static ContentElement createReceive() {
        return new ContentElement(EVENT_SHAPE, ReceiveIcon2D.INSTANCE);
    }

    public static ContentElement createExit() {
        return new ContentElement(EVENT_SHAPE, ExitIcon2D.INSTANCE);
    }

    public static ContentElement createCompensate() {
        return new ContentElement(EVENT_SHAPE, CompensateIcon2D.INSTANCE);
    }

    public static ContentElement createCompensateScope() {
        return new ContentElement(EVENT_SHAPE, CompensateScopeIcon2D.INSTANCE);
    }

    public static ContentElement createWait() {
        return new ContentElement(EVENT_SHAPE, TimerIcon2D.INSTANCE);
    }

    public static ContentElement createCompensateBadge() {
        return new ContentElement(BADGE_SHAPE, CompensateBadgeIcon2D.INSTANCE);
    }

    public static ContentElement createFaultBadge() {
        return new ContentElement(BADGE_SHAPE, FaultBadgeIcon2D.INSTANCE);
    }

    public static ContentElement createEventBadge() {
        return new ContentElement(BADGE_SHAPE, EventBadgeIcon2D.INSTANCE);
    }

    public static ContentElement createTerminationBadge() {
        return new ContentElement(BADGE_SHAPE, TerminationBadgeIcon2D.INSTANCE);
    }

    public static ContentElement createMessageEvent() {
        return new ContentElement(EVENT_SHAPE, MessageIcon2D.INSTANCE);
    }

    public static ContentElement createTimerEvent() {
        return new ContentElement(EVENT_SHAPE, TimerIcon2D.INSTANCE);
    }

    public static ContentElement createThrow() {
        return new ContentElement(EVENT_SHAPE, ThrowIcon2D.INSTANCE);
    }

    public static ContentElement createReThrow() {
        return new ContentElement(EVENT_SHAPE, ReThrowIcon2D.INSTANCE);
    }

    public static ContentElement createEndEvent() {
        return new ContentElement(START_END_EVENT_SHAPE, EndEventIcon2D.INSTANCE);
    }

    public static ContentElement createStartEvent() {
        return new ContentElement(START_END_EVENT_SHAPE, null);
    }

    public static ContentElement createIfGateway() {
        return new ContentElement(GATEWAY_SHAPE, XORIcon2D.INSTANCE);
    }

    public static ContentElement createWhileGateway() {
        return new ContentElement(GATEWAY_SHAPE, WhileIcon2D.INSTANCE);
    }

    public static ContentElement createRepeatUntilGateway() {
        return new ContentElement(GATEWAY_SHAPE, RepeatUntilIcon2D.INSTANCE);
    }

    public static ContentElement createForEachGateway() {
        return new ContentElement(GATEWAY_SHAPE, ForEachIcon2D.INSTANCE);
    }

    public static ContentElement createPickGateway() {
        return new ContentElement(GATEWAY_SHAPE, EventIcon2D.INSTANCE);
    }

    public static ContentElement createFlowGateway() {
        return new ContentElement(GATEWAY_SHAPE, ANDIcon2D.INSTANCE);
    }

    public static ContentElement createElseIfGateway() {
        return new ContentElement(SMALL_GATEWAY_SHAPE, XORSmallIcon2D.INSTANCE);
    }
}

