/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.layout;

import java.util.ArrayList;
import org.netbeans.modules.bpel.design.geometry.FBounds;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.model.elements.BorderElement;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.PartnerLinksPattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;

public class LayoutManager {
    public static final float HMARGIN = 1.0f;
    public static final float VMARGIN = 1.0f;
    public static final float HSPACING = 12.0f;
    public static final float VSPACING = 18.0f;

    public void layout(Pattern pattern, float f, float f2) {
        if (pattern != null) {
            this.positionElements(pattern);
            this.setPatternPosition(pattern, f, f2);
        }
    }

    public void layout(Pattern pattern) {
        this.layout(pattern, 1.0f, 1.0f);
    }

    private void positionElements(Pattern pattern) {
        Object object;
        boolean bl = pattern instanceof CompositePattern;
        if (bl) {
            object = (CompositePattern)pattern;
            for (Pattern object2 : ((CompositePattern)object).getNestedPatterns()) {
                this.positionElements(object2);
            }
        }
        if ((object = pattern.layoutPattern(this)) == null) {
            ArrayList arrayList = new ArrayList();
            if (bl) {
                CompositePattern compositePattern = (CompositePattern)pattern;
                for (Pattern pattern2 : compositePattern.getNestedPatterns()) {
                    arrayList.add(pattern2.getBounds());
                }
                BorderElement borderElement = compositePattern.getBorder();
                if (borderElement != null) {
                    arrayList.add(borderElement.getBounds());
                }
            }
            for (VisualElement visualElement : pattern.getElements()) {
                arrayList.add(visualElement.getBounds());
            }
            object = new FBounds(arrayList);
        }
        pattern.setBounds((FBounds)object);
    }

    public static void translatePattern(Pattern pattern, double d, double d2) {
        if (pattern instanceof PartnerLinksPattern) {
            return;
        }
        FBounds fBounds = pattern.getBounds();
        for (VisualElement object : pattern.getElements()) {
            object.setLocation(object.getX() + d, object.getY() + d2);
        }
        if (pattern instanceof CompositePattern) {
            BorderElement borderElement = ((CompositePattern)pattern).getBorder();
            if (borderElement != null) {
                borderElement.setLocation(borderElement.getX() + d, borderElement.getY() + d2);
            }
            for (Pattern pattern2 : ((CompositePattern)pattern).getNestedPatterns()) {
                LayoutManager.translatePattern(pattern2, d, d2);
            }
        }
        pattern.setBounds(fBounds.translate(d, d2));
    }

    public FBounds setPatternPosition(Pattern pattern, double d, double d2) {
        FBounds fBounds = pattern.getBounds();
        LayoutManager.translatePattern(pattern, d - (double)fBounds.x, d2 - (double)fBounds.y);
        return pattern.getBounds();
    }

    public FBounds setPatternCenterPosition(Pattern pattern, double d, double d2) {
        FBounds fBounds = pattern.getBounds();
        LayoutManager.translatePattern(pattern, d - fBounds.getCenterX(), d2 - fBounds.getCenterY());
        return pattern.getBounds();
    }

    public FPoint getOriginOffset(Pattern pattern) {
        FPoint fPoint = pattern.getOrigin();
        FBounds fBounds = pattern.getBounds();
        if (fPoint == null) {
            fPoint = new FPoint(0.0, 0.0);
        }
        return new FPoint(fPoint.x - fBounds.x, fPoint.y - fBounds.y);
    }
}

