/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.geometry;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.netbeans.modules.bpel.design.geometry.FBounds;
import org.netbeans.modules.bpel.design.geometry.FIntersector;
import org.netbeans.modules.bpel.design.geometry.FPoint;

public abstract class FShape
extends FBounds
implements Shape {
    public FShape(double d, double d2) {
        super(d, d2);
    }

    public FShape(double d, double d2, double d3, double d4) {
        super(d, d2, d3, d4);
    }

    public FShape rebound(double d, double d2, double d3, double d4) {
        return this.reshape(d, d2, d3, d4);
    }

    public abstract FShape enlarge(double var1);

    public abstract FShape reshape(double var1, double var3, double var5, double var7);

    public FShape reshapeCentered(double d, double d2, double d3, double d4) {
        return this.reshape(d - d3 / 2.0, d2 - d4 / 2.0, d3, d4);
    }

    public FShape move(double d, double d2) {
        return this.reshape(d, d2, this.width, this.height);
    }

    public FShape moveCenter(double d, double d2) {
        return this.reshape(d - (double)this.width / 2.0, d2 - (double)this.height / 2.0, this.width, this.height);
    }

    public FShape resize(double d, double d2) {
        return this.reshape(this.x, this.y, d, d2);
    }

    public FShape resizeCentered(double d, double d2) {
        return this.reshapeCentered(this.getCenterX(), this.getCenterY(), d, d2);
    }

    public FShape translate(double d, double d2) {
        return this.reshape((double)this.x + d, (double)this.y + d2, this.width, this.height);
    }

    public abstract boolean intersect(FIntersector var1);

    public Area createArea() {
        return new Area(this);
    }

    public abstract PathIterator getPathIterator(AffineTransform var1);

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new FlatteningPathIterator(this.getPathIterator(affineTransform), d);
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Float(this.x, this.y, this.width, this.height);
    }

    public Rectangle getBounds() {
        int n = (int)Math.floor(this.x);
        int n2 = (int)Math.floor(this.y);
        int n3 = (int)Math.ceil(this.x + this.width);
        int n4 = (int)Math.ceil(this.y + this.height);
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        double d8;
        if (d3 < 0.0) {
            d8 = d + d3;
            d7 = d;
        } else {
            d8 = d;
            d7 = d + d3;
        }
        if (d4 < 0.0) {
            d6 = d2 + d4;
            d5 = d2;
        } else {
            d6 = d2;
            d5 = d2 + d4;
        }
        if ((double)(this.x + this.width) < d8) {
            return false;
        }
        if ((double)(this.y + this.height) < d6) {
            return false;
        }
        if (d7 < (double)this.x) {
            return false;
        }
        return !(d5 < (double)this.y);
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return this.contains(d, d2) && this.contains(d + d3, d2) && this.contains(d, d2 + d4) && this.contains(d + d3, d2 + d4);
    }

    public FPoint getNormalizedCenter(Graphics2D graphics2D) {
        return this.getNormalizedCenter(graphics2D.getTransform());
    }

    public FPoint getNormalizedCenter(AffineTransform affineTransform) {
        if (affineTransform == null) {
            return new FPoint(0.5 * (double)((int)this.x + (int)(this.x + this.width)), 0.5 * (double)((int)this.y + (int)(this.y + this.height)));
        }
        float[] fArray = new float[]{this.x, this.y, this.x + this.width, this.y + this.height};
        affineTransform.transform(fArray, 0, fArray, 0, 2);
        double[] dArray = new double[]{0.5 * (double)((int)fArray[0] + (int)fArray[2]) + 0.5, 0.5 * (double)((int)fArray[1] + (int)fArray[3]) + 0.5};
        try {
            affineTransform.inverseTransform(dArray, 0, dArray, 0, 1);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return this.getCenter();
        }
        return new FPoint(dArray[0], dArray[1]);
    }

    protected class EmptyPathIterator
    implements PathIterator {
        protected EmptyPathIterator() {
        }

        public int currentSegment(double[] dArray) {
            return 4;
        }

        public int currentSegment(float[] fArray) {
            return 4;
        }

        public void next() {
        }

        public boolean isDone() {
            return true;
        }

        public int getWindingRule() {
            return 1;
        }
    }

    protected class LinePathIterator
    implements PathIterator {
        private AffineTransform at;
        private int index = 0;

        public LinePathIterator(AffineTransform affineTransform) {
            this.at = affineTransform;
        }

        public int currentSegment(double[] dArray) {
            int n = 0;
            if (this.index == 0) {
                dArray[0] = FShape.this.x;
                dArray[1] = FShape.this.y;
                n = 0;
            } else {
                dArray[0] = FShape.this.x + FShape.this.width;
                dArray[1] = FShape.this.y + FShape.this.height;
                n = 1;
            }
            if (this.at != null) {
                this.at.transform(dArray, 0, dArray, 0, 1);
            }
            return n;
        }

        public int currentSegment(float[] fArray) {
            int n = 0;
            if (this.index == 0) {
                fArray[0] = FShape.this.x;
                fArray[1] = FShape.this.y;
                n = 0;
            } else {
                fArray[0] = FShape.this.x + FShape.this.width;
                fArray[1] = FShape.this.y + FShape.this.height;
                n = 1;
            }
            if (this.at != null) {
                this.at.transform(fArray, 0, fArray, 0, 1);
            }
            return n;
        }

        public void next() {
            ++this.index;
        }

        public boolean isDone() {
            return this.index > 1;
        }

        public int getWindingRule() {
            return 1;
        }
    }
}

