/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.actions.DesignModeAction;
import org.netbeans.modules.bpel.design.actions.PasteModeAction;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.selection.DiagramSelectionListener;
import org.netbeans.modules.bpel.design.selection.PlaceHolder;
import org.netbeans.modules.bpel.design.selection.PlaceHolderManager;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Process;
import org.openide.util.NbBundle;

public class CopyPasteHandler
implements MouseListener {
    private DesignView designView;
    private Pattern copiedPattern;
    private PlaceHolderManager[] managers;
    private PlaceHolder currentPlaceholder;
    private CopyAction actionCopy;
    private CutAction actionCut;
    private PasteAction actionPaste;

    public CopyPasteHandler(DesignView designView) {
        this.designView = designView;
        this.actionCopy = new CopyAction();
        this.actionCut = new CutAction();
        this.actionPaste = new PasteAction();
        this.managers = new PlaceHolderManager[]{designView.getConsumersView().getPlaceholderManager(), designView.getProcessView().getPlaceholderManager(), designView.getProvidersView().getPlaceholderManager()};
    }

    public void enterPasteMode(Pattern pattern) {
        this.copiedPattern = pattern;
        this.currentPlaceholder = null;
        for (PlaceHolderManager placeHolderManager : this.managers) {
            placeHolderManager.init(pattern);
            placeHolderManager.getDiagramView().addMouseListener(this);
        }
        this.tabNextPlaceholder(true);
        this.fireUpdateActionEnabled();
    }

    public void exitPasteMode() {
        this.copiedPattern = null;
        this.currentPlaceholder = null;
        for (PlaceHolderManager placeHolderManager : this.managers) {
            placeHolderManager.clear();
            placeHolderManager.getDiagramView().removeMouseListener(this);
        }
        this.fireUpdateActionEnabled();
    }

    public boolean isActive() {
        return this.copiedPattern != null;
    }

    public Action getCopyAction() {
        return this.actionCopy;
    }

    public Action getCutAction() {
        return this.actionCut;
    }

    public Action getPasteAction() {
        return this.actionPaste;
    }

    public void tabNextPlaceholder(boolean bl) {
        PlaceHolder placeHolder;
        ArrayList<PlaceHolder> arrayList = new ArrayList<PlaceHolder>();
        for (PlaceHolderManager placeHolderManager : this.managers) {
            List<PlaceHolder> list = placeHolderManager.getPlaceHolders();
            Collections.sort(list, new Comparator<PlaceHolder>(){

                @Override
                public int compare(PlaceHolder placeHolder, PlaceHolder placeHolder2) {
                    Rectangle rectangle = placeHolder.getShape().getBounds();
                    Rectangle rectangle2 = placeHolder2.getShape().getBounds();
                    return rectangle.x * rectangle.x + rectangle.y * rectangle.y - (rectangle2.x * rectangle2.x + rectangle2.y * rectangle2.y);
                }
            });
            arrayList.addAll(list);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        if (this.currentPlaceholder == null) {
            placeHolder = (PlaceHolder)arrayList.get(bl ? 0 : arrayList.size() - 1);
        } else {
            int n = arrayList.indexOf(this.currentPlaceholder);
            int n2 = n = bl ? n + 1 : n - 1;
            if (n < 0) {
                n = arrayList.size() - 1;
            } else if (n >= arrayList.size()) {
                n = 0;
            }
            placeHolder = (PlaceHolder)arrayList.get(n);
        }
        for (PlaceHolderManager placeHolderManager : this.managers) {
            placeHolderManager.setCurrentPlaceholder(placeHolder);
        }
        this.currentPlaceholder = placeHolder;
        if (this.currentPlaceholder != null) {
            for (PlaceHolderManager placeHolderManager : this.managers) {
                if (!placeHolderManager.getPlaceHolders().contains(this.currentPlaceholder)) continue;
                placeHolderManager.getDiagramView().scrollPlaceholderToView(this.currentPlaceholder);
                break;
            }
        }
    }

    private void fireUpdateActionEnabled() {
        this.actionPaste.fireUpdateActionEnabled();
        this.actionCopy.fireUpdateActionEnabled();
        this.actionCut.fireUpdateActionEnabled();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() instanceof DiagramView) {
            DiagramView diagramView = (DiagramView)mouseEvent.getComponent();
            List<PlaceHolder> list = diagramView.getPlaceholderManager().getPlaceHolders();
            FPoint fPoint = diagramView.convertScreenToDiagram(new Point(mouseEvent.getX(), mouseEvent.getY()));
            for (PlaceHolder placeHolder : list) {
                if (!placeHolder.contains(fPoint.x, fPoint.y)) continue;
                placeHolder.drop();
                break;
            }
            this.exitPasteMode();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    protected class CopyCutAction
    extends DesignModeAction
    implements DiagramSelectionListener {
        private boolean copy;

        public CopyCutAction(boolean bl) {
            super(CopyPasteHandler.this.designView);
            this.copy = bl;
            CopyPasteHandler.this.designView.getSelectionModel().addSelectionListener(this);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(bl ? 67 : 88, 128));
            this.putValue("Name", NbBundle.getMessage(CopyPasteHandler.class, (String)(bl ? "ACT_ClipboardCopy" : "ACT_ClipboardCut")));
        }

        public boolean isEnabled() {
            if (!super.isEnabled()) {
                return false;
            }
            BpelEntity bpelEntity = CopyPasteHandler.this.designView.getSelectionModel().getSelected();
            if (bpelEntity == null) {
                return false;
            }
            return !(bpelEntity instanceof Process);
        }

        private Pattern getPatternCopy(BpelEntity bpelEntity) {
            if (bpelEntity == null) {
                return null;
            }
            BpelEntity bpelEntity2 = this.copy ? bpelEntity.copy(new HashMap()) : bpelEntity.cut();
            return CopyPasteHandler.this.designView.getModel().createPattern(bpelEntity2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CopyPasteHandler.this.exitPasteMode();
            if (!this.isEnabled()) {
                return;
            }
            BpelEntity bpelEntity = CopyPasteHandler.this.designView.getSelectionModel().getSelected();
            Pattern pattern = this.getPatternCopy(bpelEntity);
            CopyPasteHandler.this.enterPasteMode(pattern);
        }

        public void selectionChanged(BpelEntity bpelEntity, BpelEntity bpelEntity2) {
            this.fireUpdateActionEnabled();
        }

        protected void fireUpdateActionEnabled() {
            this.firePropertyChange("enabled", new Boolean(!this.isEnabled()), new Boolean(this.isEnabled()));
        }
    }

    public class CutAction
    extends CopyCutAction {
        public CutAction() {
            super(false);
        }
    }

    public class CopyAction
    extends CopyCutAction {
        public CopyAction() {
            super(true);
        }
    }

    class PasteAction
    extends PasteModeAction {
        private static final long serialVersionUID = 1L;

        public PasteAction() {
            super(CopyPasteHandler.this.designView);
        }

        public boolean isEnabled() {
            if (!super.isEnabled()) {
                return false;
            }
            return CopyPasteHandler.this.currentPlaceholder != null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isEnabled()) {
                return;
            }
            CopyPasteHandler.this.currentPlaceholder.drop();
            CopyPasteHandler.this.exitPasteMode();
        }

        protected void fireUpdateActionEnabled() {
            this.firePropertyChange("enabled", new Boolean(!this.isEnabled()), new Boolean(this.isEnabled()));
        }
    }
}

