/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java_cup.runtime.Symbol;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParseEvent;
import org.netbeans.modules.gsf.api.ParseListener;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.PositionManager;
import org.netbeans.modules.gsf.api.SourceFileReader;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.php.editor.parser.ASTPHP5Parser;
import org.netbeans.modules.php.editor.parser.ASTPHP5Scanner;
import org.netbeans.modules.php.editor.parser.PHP5ErrorHandler;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.PHPPositionManager;
import org.netbeans.modules.php.editor.parser.Utils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTError;
import org.netbeans.modules.php.editor.parser.astnodes.Comment;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.project.api.PhpLanguageOptions;
import org.openide.filesystems.FileObject;

public class GSFPHPParser
implements Parser {
    private PositionManager positionManager = null;
    private static final Logger LOGGER = Logger.getLogger(GSFPHPParser.class.getName());
    private boolean shortTags = true;
    private boolean aspTags = false;

    public void parseFiles(Parser.Job job) {
        LOGGER.fine("parseFiles " + job.toString());
        ParseListener parseListener = job.listener;
        SourceFileReader sourceFileReader = job.reader;
        for (ParserFile parserFile : job.files) {
            Object object;
            Object object2;
            CharSequence charSequence;
            ParseEvent parseEvent = new ParseEvent(ParseEvent.Kind.PARSE, parserFile, null);
            job.listener.started(parseEvent);
            PHPParseResult pHPParseResult = null;
            PhpLanguageOptions.Properties properties = PhpLanguageOptions.getProperties((FileObject)parserFile.getFileObject());
            this.shortTags = properties.areShortTagsEnabled();
            this.aspTags = properties.areAspTagsEnabled();
            int n = 0;
            try {
                charSequence = sourceFileReader.read(parserFile);
                object2 = GSFPHPParser.asString(charSequence);
                n = ((String)object2).length();
                int n2 = sourceFileReader.getCaretOffset(parserFile);
                if (n2 != -1 && job.translatedSource != null) {
                    n2 = job.translatedSource.getAstOffset(n2);
                }
                LOGGER.fine("caretOffset: " + n2);
                object = new Context(parserFile, parseListener, (String)object2, n2, job.translatedSource);
                pHPParseResult = this.parseBuffer((Context)object, Sanitize.NONE, null);
            }
            catch (Exception exception) {
                parseListener.exception(exception);
                LOGGER.fine("Exception during parsing: " + exception);
                object2 = new ASTError(0, n);
                ArrayList<Statement> arrayList = new ArrayList<Statement>();
                arrayList.add((Statement)object2);
                object = new Program(0, n, arrayList, Collections.<Comment>emptyList());
                pHPParseResult = new PHPParseResult(this, parserFile, (Program)object, false);
            }
            charSequence = new ParseEvent(ParseEvent.Kind.PARSE, parserFile, (ParserResult)pHPParseResult);
            parseListener.finished((ParseEvent)charSequence);
        }
    }

    protected PHPParseResult parseBuffer(Context context, Sanitize sanitize, PHP5ErrorHandler pHP5ErrorHandler) throws Exception {
        PHPParseResult pHPParseResult;
        boolean bl = false;
        String string = context.source;
        if (pHP5ErrorHandler == null) {
            pHP5ErrorHandler = new PHP5ErrorHandler(context, this);
        }
        if (sanitize != Sanitize.NONE && sanitize != Sanitize.NEVER) {
            boolean bl2 = this.sanitizeSource(context, sanitize, pHP5ErrorHandler);
            if (bl2) {
                assert (context.sanitizedSource != null);
                bl = true;
                string = context.sanitizedSource;
            } else {
                return this.sanitize(context, sanitize, pHP5ErrorHandler);
            }
        }
        ASTPHP5Scanner aSTPHP5Scanner = new ASTPHP5Scanner(new StringReader(string), this.shortTags, this.aspTags);
        ASTPHP5Parser aSTPHP5Parser = new ASTPHP5Parser(aSTPHP5Scanner);
        if (!bl) {
            aSTPHP5Parser.setErrorHandler(pHP5ErrorHandler);
        } else {
            aSTPHP5Parser.setErrorHandler(null);
        }
        Symbol symbol = aSTPHP5Parser.parse();
        if (aSTPHP5Scanner.getCurlyBalance() != 0 && !bl) {
            this.sanitizeSource(context, Sanitize.MISSING_CURLY, null);
            if (context.sanitizedSource != null) {
                context.source = context.getSanitizedSource();
                string = context.source;
                aSTPHP5Scanner = new ASTPHP5Scanner(new StringReader(string), this.shortTags, this.aspTags);
                aSTPHP5Parser = new ASTPHP5Parser(aSTPHP5Scanner);
                symbol = aSTPHP5Parser.parse();
            }
        }
        if (symbol != null) {
            Program program = null;
            if (symbol.value instanceof Program) {
                program = (Program)symbol.value;
                List<Statement> list = program.getStatements();
                boolean bl3 = true;
                for (Statement statement : list) {
                    if (!(statement instanceof ASTError)) continue;
                    String string2 = "<?" + string.substring(statement.getStartOffset(), statement.getEndOffset()) + "?>";
                    ASTPHP5Scanner aSTPHP5Scanner2 = new ASTPHP5Scanner(new StringReader(string2), this.shortTags, this.aspTags);
                    Symbol symbol2 = aSTPHP5Scanner2.next_token();
                    while (symbol2.sym != 0) {
                        if (symbol2.sym == 46 || symbol2.sym == 33) {
                            bl3 = false;
                            break;
                        }
                        symbol2 = aSTPHP5Scanner2.next_token();
                    }
                    if (bl3) continue;
                    break;
                }
                pHPParseResult = bl3 ? new PHPParseResult(this, context.getFile(), program, true) : this.sanitize(context, sanitize, pHP5ErrorHandler);
            } else {
                LOGGER.fine("The parser value is not a Program: " + symbol.value);
                pHPParseResult = this.sanitize(context, sanitize, pHP5ErrorHandler);
            }
            if (!bl) {
                pHP5ErrorHandler.displaySyntaxErrors(program);
            }
        } else {
            pHPParseResult = this.sanitize(context, sanitize, pHP5ErrorHandler);
        }
        return pHPParseResult;
    }

    private boolean sanitizeSource(Context context, Sanitize sanitize, PHP5ErrorHandler pHP5ErrorHandler) {
        List<PHP5ErrorHandler.SyntaxError> list;
        if (sanitize == Sanitize.SYNTAX_ERROR_CURRENT && (list = pHP5ErrorHandler.getSyntaxErrors()).size() > 0) {
            int n;
            int n2;
            PHP5ErrorHandler.SyntaxError syntaxError = list.get(0);
            String string = context.sanitized == Sanitize.NONE ? context.source : context.sanitizedSource;
            String string2 = string.substring(n2 = syntaxError.getCurrentToken().left, n = syntaxError.getCurrentToken().right);
            if ("}".equals(string2)) {
                return false;
            }
            context.sanitizedSource = string.substring(0, n2) + Utils.getSpaces(n - n2) + string.substring(n);
            context.sanitizedRange = new OffsetRange(n2, n);
            return true;
        }
        if (sanitize == Sanitize.SYNTAX_ERROR_PREVIOUS && (list = pHP5ErrorHandler.getSyntaxErrors()).size() > 0) {
            int n;
            int n3;
            PHP5ErrorHandler.SyntaxError syntaxError = list.get(0);
            String string = context.source;
            if (string.substring(n3 = syntaxError.getPreviousToken().left, n = syntaxError.getPreviousToken().right).equals("}")) {
                return false;
            }
            context.sanitizedSource = string.substring(0, n3) + Utils.getSpaces(n - n3) + string.substring(n);
            context.sanitizedRange = new OffsetRange(n3, n);
            return true;
        }
        if (sanitize == Sanitize.SYNTAX_ERROR_PREVIOUS_LINE && (list = pHP5ErrorHandler.getSyntaxErrors()).size() > 0) {
            PHP5ErrorHandler.SyntaxError syntaxError = list.get(0);
            String string = context.source;
            int n = Utils.getRowEnd(string, syntaxError.getPreviousToken().right);
            int n4 = Utils.getRowStart(string, syntaxError.getPreviousToken().left);
            StringBuffer stringBuffer = new StringBuffer(n - n4);
            for (int i = n4; i < n; ++i) {
                if (string.charAt(i) == ' ' || string.charAt(i) == '}' || string.charAt(i) == '\n' || string.charAt(i) == '\r') {
                    stringBuffer.append(string.charAt(i));
                    continue;
                }
                stringBuffer.append(' ');
            }
            context.sanitizedSource = string.substring(0, n4) + stringBuffer.toString() + string.substring(n);
            context.sanitizedRange = new OffsetRange(n4, n);
            return true;
        }
        if (sanitize == Sanitize.EDITED_LINE && context.caretOffset > -1) {
            list = context.getSource();
            int n = context.caretOffset - 1;
            int n5 = context.caretOffset;
            char c = ((String)((Object)list)).charAt(n);
            while (n > 0 && c != '\n' && c != '\r' && c != '{' && c != '}') {
                c = ((String)((Object)list)).charAt(--n);
            }
            ++n;
            if (n5 < ((String)((Object)list)).length()) {
                c = ((String)((Object)list)).charAt(n5);
                while (n5 < ((String)((Object)list)).length() && c != '\n' && c != '\r' && c != '{' && c != '}') {
                    c = ((String)((Object)list)).charAt(++n5);
                }
            }
            context.sanitizedSource = ((String)((Object)list)).substring(0, n) + Utils.getSpaces(n5 - n) + ((String)((Object)list)).substring(n5);
            context.sanitizedRange = new OffsetRange(n, n5);
            return true;
        }
        if (sanitize == Sanitize.MISSING_CURLY) {
            return this.sanitizeCurly(context);
        }
        if (sanitize == Sanitize.SYNTAX_ERROR_BLOCK && (list = pHP5ErrorHandler.getSyntaxErrors()).size() > 0) {
            PHP5ErrorHandler.SyntaxError syntaxError = list.get(0);
            return this.sanitizeRemoveBlock(context, syntaxError.getCurrentToken().left);
        }
        return false;
    }

    protected boolean sanitizeCurly(Context context) {
        int n;
        String string = context.getSource();
        ASTPHP5Scanner aSTPHP5Scanner = new ASTPHP5Scanner(new StringReader(string), this.shortTags, this.aspTags);
        Symbol symbol = null;
        Symbol symbol2 = null;
        int n2 = 0;
        int n3 = 0;
        try {
            symbol2 = aSTPHP5Scanner.next_token();
            n = 0;
            int n4 = -1;
            while (symbol2.sym != 0) {
                switch (symbol2.sym) {
                    case 46: {
                        char c;
                        if (n == 0) {
                            n = 1;
                            break;
                        }
                        int n5 = symbol2.left;
                        int n6 = n3;
                        for (int i = 0; i < n6; ++i) {
                            c = string.charAt(--n5);
                            while (n5 > n4 && c != '}' && c != '\n' && c != '\r' && c != '\t' && c != ' ') {
                                c = string.charAt(--n5);
                            }
                            if (c == '}' || c == '{') continue;
                            string = string.substring(0, n5) + '}' + string.substring(n5 + 1);
                            --n3;
                        }
                        if (n3 > 0) {
                            c = string.charAt(--n5);
                            while (n5 > 0 && c != '}' && c != '\n' && c != '\r') {
                                c = string.charAt(--n5);
                            }
                            if (c == '}') {
                                c = string.charAt(--n5);
                            }
                            while (n5 < string.length() && n3 > 0 && (c == '\n' || c == '\r' || c == '\t' || c == ' ')) {
                                string = string.substring(0, n5) + '}' + string.substring(n5 + 1);
                                --n3;
                                c = string.charAt(--n5);
                            }
                        }
                        context.sanitizedSource = string;
                        break;
                    }
                    case 62: 
                    case 63: {
                        if (n != 0) {
                            ++n3;
                            n4 = symbol2.left;
                            break;
                        }
                        ++n2;
                        break;
                    }
                    case 64: {
                        if (n != 0) {
                            if (--n3 != 0) break;
                            n = 0;
                            break;
                        }
                        --n2;
                    }
                }
                if (symbol2.sym != 10) {
                    symbol = symbol2;
                }
                symbol2 = aSTPHP5Scanner.next_token();
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, "Exception during calculating missing }", iOException);
        }
        n = n2 + n3;
        if (n > 0 && symbol != null) {
            String string2 = string.substring(symbol.left, symbol.right).trim();
            if ("?>".equals(string2)) {
                context.sanitizedSource = string.substring(0, symbol.left) + Utils.getRepeatingChars('}', n) + string.substring(symbol.left);
                context.sanitizedRange = new OffsetRange(symbol.left, symbol.left + n);
                return true;
            }
            if (symbol2.sym == 0) {
                context.sanitizedSource = string.substring(0, symbol2.left) + Utils.getRepeatingChars('}', n) + string.substring(symbol2.left);
                context.sanitizedRange = new OffsetRange(symbol2.left, symbol2.left + n);
                return true;
            }
        }
        return false;
    }

    private boolean sanitizeRemoveBlock(Context context, int n) {
        String string = context.getSource();
        ASTPHP5Scanner aSTPHP5Scanner = new ASTPHP5Scanner(new StringReader(string), this.shortTags, this.aspTags);
        Symbol symbol = null;
        int n2 = -1;
        int n3 = -1;
        try {
            symbol = aSTPHP5Scanner.next_token();
            while (symbol.sym != 0 && n3 == -1) {
                if (symbol.sym == 63 && symbol.left <= n) {
                    n2 = symbol.right;
                }
                if (symbol.sym == 64 && symbol.left >= n) {
                    n3 = symbol.right - 1;
                }
                symbol = aSTPHP5Scanner.next_token();
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, "Exception during removing block", iOException);
        }
        if (n2 > -1 && n2 < n3) {
            context.sanitizedSource = string.substring(0, n2) + Utils.getSpaces(n3 - n2) + string.substring(n3);
            context.sanitizedRange = new OffsetRange(n2, n3);
            return true;
        }
        return false;
    }

    private PHPParseResult sanitize(Context context, Sanitize sanitize, PHP5ErrorHandler pHP5ErrorHandler) throws Exception {
        switch (sanitize) {
            case NONE: 
            case MISSING_CURLY: {
                return this.parseBuffer(context, Sanitize.SYNTAX_ERROR_CURRENT, pHP5ErrorHandler);
            }
            case SYNTAX_ERROR_CURRENT: {
                return this.parseBuffer(context, Sanitize.SYNTAX_ERROR_PREVIOUS, pHP5ErrorHandler);
            }
            case SYNTAX_ERROR_PREVIOUS: {
                return this.parseBuffer(context, Sanitize.SYNTAX_ERROR_PREVIOUS_LINE, pHP5ErrorHandler);
            }
            case SYNTAX_ERROR_PREVIOUS_LINE: {
                return this.parseBuffer(context, Sanitize.EDITED_LINE, pHP5ErrorHandler);
            }
            case EDITED_LINE: {
                return this.parseBuffer(context, Sanitize.SYNTAX_ERROR_BLOCK, pHP5ErrorHandler);
            }
        }
        int n = context.getSource().length();
        ASTError aSTError = new ASTError(0, n);
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        arrayList.add(aSTError);
        Program program = new Program(0, n, arrayList, Collections.<Comment>emptyList());
        return new PHPParseResult(this, context.getFile(), program, false);
    }

    private static String asString(CharSequence charSequence) {
        if (charSequence instanceof String) {
            return (String)charSequence;
        }
        return ((Object)charSequence).toString();
    }

    public PositionManager getPositionManager() {
        if (this.positionManager == null) {
            this.positionManager = new PHPPositionManager();
        }
        return this.positionManager;
    }

    public static class Context {
        private final ParserFile file;
        private final ParseListener listener;
        private int errorOffset;
        private String source;
        private String sanitizedSource;
        private OffsetRange sanitizedRange = OffsetRange.NONE;
        private String sanitizedContents;
        private int caretOffset;
        private Sanitize sanitized = Sanitize.NONE;
        private TranslatedSource translatedSource;

        public Context(ParserFile parserFile, ParseListener parseListener, String string, int n, TranslatedSource translatedSource) {
            this.file = parserFile;
            this.listener = parseListener;
            this.source = string;
            this.caretOffset = n;
            this.translatedSource = translatedSource;
        }

        public String toString() {
            return "PHPParser.Context(" + this.getFile().toString() + ")";
        }

        public OffsetRange getSanitizedRange() {
            return this.sanitizedRange;
        }

        public Sanitize getSanitized() {
            return this.sanitized;
        }

        public String getSanitizedSource() {
            return this.sanitizedSource;
        }

        public int getErrorOffset() {
            return this.errorOffset;
        }

        public ParseListener getListener() {
            return this.listener;
        }

        public ParserFile getFile() {
            return this.file;
        }

        public String getSource() {
            return this.source;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sanitize {
        NEVER,
        NONE,
        SYNTAX_ERROR_CURRENT,
        SYNTAX_ERROR_PREVIOUS,
        SYNTAX_ERROR_PREVIOUS_LINE,
        SYNTAX_ERROR_BLOCK,
        EDITED_DOT,
        ERROR_DOT,
        BLOCK_START,
        ERROR_LINE,
        EDITED_LINE,
        MISSING_CURLY;

    }
}

