/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.nav;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.IndexSearcher;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.spi.GsfUtilities;
import org.netbeans.modules.php.editor.PHPCompletionItem;
import org.netbeans.modules.php.editor.index.IndexedClass;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.IndexedElement;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.index.IndexedInterface;
import org.netbeans.modules.php.editor.index.IndexedVariable;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPTypeSearcher
implements IndexSearcher {
    public Set<? extends IndexSearcher.Descriptor> getSymbols(Index index, String string, NameKind nameKind, EnumSet<Index.SearchScope> enumSet, IndexSearcher.Helper helper) {
        PHPIndex pHPIndex = PHPIndex.get(index);
        HashSet<PHPTypeDescriptor> hashSet = new HashSet<PHPTypeDescriptor>();
        string = string.toLowerCase();
        nameKind = NameKind.CASE_INSENSITIVE_PREFIX;
        if (pHPIndex != null) {
            PHPTypeSearcher.addClasses(pHPIndex, string, nameKind, enumSet, helper, hashSet);
            PHPTypeSearcher.addInterfaces(pHPIndex, string, nameKind, enumSet, helper, hashSet);
            PHPTypeSearcher.addClassMembers(pHPIndex, PHPTypeSearcher.stripDollar(string), nameKind, enumSet, helper, hashSet);
            PHPTypeSearcher.addFunctions(pHPIndex, string, nameKind, enumSet, helper, hashSet);
            PHPTypeSearcher.addConstants(pHPIndex, string, nameKind, enumSet, helper, hashSet);
            PHPTypeSearcher.addTpLevelVariables(pHPIndex, PHPTypeSearcher.appendDollar(string), nameKind, enumSet, helper, hashSet);
        }
        return hashSet;
    }

    public Set<? extends IndexSearcher.Descriptor> getTypes(Index index, String string, NameKind nameKind, EnumSet<Index.SearchScope> enumSet, IndexSearcher.Helper helper) {
        PHPIndex pHPIndex = PHPIndex.get(index);
        HashSet<PHPTypeDescriptor> hashSet = new HashSet<PHPTypeDescriptor>();
        string = string.toLowerCase();
        nameKind = NameKind.CASE_INSENSITIVE_PREFIX;
        if (pHPIndex != null) {
            PHPTypeSearcher.addClasses(pHPIndex, string, nameKind, enumSet, helper, hashSet);
            PHPTypeSearcher.addInterfaces(pHPIndex, string, nameKind, enumSet, helper, hashSet);
        }
        return hashSet;
    }

    private static void addClassMembers(PHPIndex pHPIndex, String string, NameKind nameKind, EnumSet<Index.SearchScope> enumSet, IndexSearcher.Helper helper, Set<PHPTypeDescriptor> set) {
        Set<String> set2 = pHPIndex.typeNamesForIdentifier(string, null, NameKind.CASE_INSENSITIVE_PREFIX, enumSet);
        for (String string2 : set2) {
            for (IndexedClass indexedClass : pHPIndex.getClasses(null, string2, nameKind, enumSet)) {
                for (IndexedFunction indexedFunction : pHPIndex.getMethods(null, indexedClass.getName(), string, nameKind, -1)) {
                    set.add(new PHPTypeDescriptor(indexedFunction, indexedClass, helper));
                }
                for (IndexedConstant indexedConstant : pHPIndex.getAllFields(null, indexedClass.getName(), string, nameKind, -1)) {
                    set.add(new PHPTypeDescriptor(indexedConstant, indexedClass, helper));
                }
                for (IndexedConstant indexedConstant : pHPIndex.getAllClassConstants(null, indexedClass.getName(), string, nameKind)) {
                    set.add(new PHPTypeDescriptor(indexedConstant, indexedClass, helper));
                }
            }
        }
    }

    private static void addTpLevelVariables(PHPIndex pHPIndex, String string, NameKind nameKind, EnumSet<Index.SearchScope> enumSet, IndexSearcher.Helper helper, Set<PHPTypeDescriptor> set) {
        for (IndexedVariable indexedVariable : pHPIndex.getTopLevelVariables(null, string, nameKind, enumSet)) {
            set.add(new PHPTypeDescriptor(indexedVariable, helper));
        }
    }

    private static void addFunctions(PHPIndex pHPIndex, String string, NameKind nameKind, EnumSet<Index.SearchScope> enumSet, IndexSearcher.Helper helper, Set<PHPTypeDescriptor> set) {
        for (IndexedFunction indexedFunction : pHPIndex.getFunctions(null, string, nameKind, enumSet)) {
            set.add(new PHPTypeDescriptor(indexedFunction, helper));
        }
    }

    private static void addConstants(PHPIndex pHPIndex, String string, NameKind nameKind, EnumSet<Index.SearchScope> enumSet, IndexSearcher.Helper helper, Set<PHPTypeDescriptor> set) {
        for (IndexedConstant indexedConstant : pHPIndex.getConstants(null, string, nameKind, enumSet)) {
            set.add(new PHPTypeDescriptor(indexedConstant, helper));
        }
    }

    private static void addClasses(PHPIndex pHPIndex, String string, NameKind nameKind, EnumSet<Index.SearchScope> enumSet, IndexSearcher.Helper helper, Set<PHPTypeDescriptor> set) {
        for (IndexedClass indexedClass : pHPIndex.getClasses(null, string, nameKind, enumSet)) {
            set.add(new PHPTypeDescriptor(indexedClass, helper));
        }
    }

    private static void addInterfaces(PHPIndex pHPIndex, String string, NameKind nameKind, EnumSet<Index.SearchScope> enumSet, IndexSearcher.Helper helper, Set<PHPTypeDescriptor> set) {
        for (IndexedInterface indexedInterface : pHPIndex.getInterfaces(null, string, nameKind, enumSet)) {
            set.add(new PHPTypeDescriptor(indexedInterface, helper){

                public Icon getIcon() {
                    return PHPCompletionItem.getInterfaceIcon();
                }
            });
        }
    }

    private static String stripDollar(String string) {
        if (string.startsWith("$")) {
            return string.substring(1);
        }
        return string;
    }

    private static String appendDollar(String string) {
        if (!string.startsWith("$")) {
            return "$" + string;
        }
        return string;
    }

    private static class PHPTypeDescriptor
    extends IndexSearcher.Descriptor {
        private final IndexedElement element;
        private final IndexedElement enclosingClass;
        private String projectName;
        private Icon projectIcon;
        private final IndexSearcher.Helper helper;

        public PHPTypeDescriptor(IndexedElement indexedElement, IndexSearcher.Helper helper) {
            this(indexedElement, null, helper);
        }

        public PHPTypeDescriptor(IndexedElement indexedElement, IndexedElement indexedElement2, IndexSearcher.Helper helper) {
            this.element = indexedElement;
            this.enclosingClass = indexedElement2;
            this.helper = helper;
        }

        public Icon getIcon() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            return this.helper.getIcon((ElementHandle)this.element);
        }

        public String getTypeName() {
            return this.element.getName();
        }

        public String getProjectName() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectName;
        }

        private void initProjectInfo() {
            FileObject fileObject = this.element.getFileObject();
            if (fileObject != null) {
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                if (project != null) {
                    ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                    this.projectName = projectInformation.getDisplayName();
                    this.projectIcon = projectInformation.getIcon();
                }
            } else {
                Logger.getLogger(PHPTypeSearcher.class.getName()).fine("No fileobject for " + this.element.toString() + " with fileurl=" + this.element.getFilenameUrl());
            }
            if (this.projectName == null) {
                this.projectName = "";
            }
        }

        public Icon getProjectIcon() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectIcon;
        }

        public FileObject getFileObject() {
            return this.element.getFileObject();
        }

        public void open() {
            GsfUtilities.open((FileObject)this.element.getFileObject(), (int)this.element.getOffset(), (String)this.element.getName());
        }

        public String getContextName() {
            FileObject fileObject;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            if (this.enclosingClass != null) {
                stringBuilder.append(this.enclosingClass.getName());
                bl = true;
            }
            if ((fileObject = this.getFileObject()) != null) {
                if (bl) {
                    stringBuilder.append(" in ");
                }
                stringBuilder.append(FileUtil.getFileDisplayName((FileObject)fileObject));
            }
            if (stringBuilder.length() > 0) {
                return stringBuilder.toString();
            }
            return null;
        }

        public ElementHandle getElement() {
            return this.element;
        }

        public int getOffset() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getSimpleName() {
            return this.element.getName();
        }

        public String getOuterName() {
            return null;
        }
    }
}

