/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.index;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.annotations.NonNull;
import org.netbeans.modules.php.editor.index.IdentifierSignature;
import org.netbeans.modules.php.editor.index.IndexedClass;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.IndexedElement;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.index.IndexedInterface;
import org.netbeans.modules.php.editor.index.IndexedVariable;
import org.netbeans.modules.php.editor.index.Signature;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPIndex {
    public static final int ANY_ATTR = -1;
    private static String clusterUrl = null;
    private static final String CLUSTER_URL = "cluster:";
    static final Set<Index.SearchScope> ALL_SCOPE = EnumSet.allOf(Index.SearchScope.class);
    static final Set<Index.SearchScope> SOURCE_SCOPE = EnumSet.of(Index.SearchScope.SOURCE);
    private static final Set<String> TERMS_BASE = Collections.singleton("base");
    private static final Set<String> TERMS_CONST = Collections.singleton("const");
    private static final Set<String> TERMS_CLASS = Collections.singleton("clz");
    private static final Set<String> TERMS_VAR = Collections.singleton("var");
    private static final Set<String> TERMS_ALL = new HashSet<String>();
    private final Index index;
    private WeakHashMap<PHPParseResult, HashMap<String, Collection<String>>> includesCache;
    private WeakHashMap<PHPParseResult, HashMap<String, Boolean>> isReachableCache;
    private WeakHashMap<PHPParseResult, HashMap<String, Boolean>> isSystemFileCache;

    public PHPIndex(Index index) {
        TERMS_ALL.add("base");
        TERMS_ALL.add("const");
        TERMS_ALL.add("clz");
        TERMS_ALL.add("var");
        this.includesCache = new WeakHashMap();
        this.isReachableCache = new WeakHashMap();
        this.isSystemFileCache = new WeakHashMap();
        this.index = index;
    }

    public static PHPIndex get(Index index) {
        return new PHPIndex(index);
    }

    public Collection<IndexedElement> getAllTopLevel(PHPParseResult pHPParseResult, String string, NameKind nameKind) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        ArrayList<IndexedElement> arrayList = new ArrayList<IndexedElement>();
        ArrayList<IndexedFunction> arrayList2 = new ArrayList<IndexedFunction>();
        ArrayList<IndexedConstant> arrayList3 = new ArrayList<IndexedConstant>();
        ArrayList<IndexedClass> arrayList4 = new ArrayList<IndexedClass>();
        ArrayList<IndexedVariable> arrayList5 = new ArrayList<IndexedVariable>();
        this.search("top", string.toLowerCase(), NameKind.PREFIX, hashSet, ALL_SCOPE, TERMS_ALL);
        this.findFunctions(hashSet, nameKind, string, arrayList2);
        this.findConstants(hashSet, nameKind, string, arrayList3);
        this.findClasses(hashSet, nameKind, string, arrayList4);
        this.findTopVariables(hashSet, nameKind, string, arrayList5);
        arrayList.addAll(arrayList2);
        arrayList.addAll(arrayList3);
        arrayList.addAll(arrayList4);
        arrayList.addAll(arrayList5);
        return arrayList;
    }

    protected void findClasses(Set<Index.SearchResult> set, NameKind nameKind, String string, Collection<IndexedClass> collection) {
        for (Index.SearchResult searchResult : set) {
            String[] stringArray;
            if (searchResult.getPersistentUrl() == null || (stringArray = searchResult.getValues("clz")) == null) continue;
            for (String string2 : stringArray) {
                Signature signature = Signature.get(string2);
                String string3 = signature.string(1);
                if (nameKind == NameKind.PREFIX || nameKind == NameKind.CASE_INSENSITIVE_PREFIX ? !string3.toLowerCase().startsWith(string.toLowerCase()) : nameKind == NameKind.EXACT_NAME && !string3.toLowerCase().equals(string.toLowerCase())) continue;
                int n = signature.integer(2);
                String string4 = signature.string(3);
                string4 = string4.length() == 0 ? null : string4;
                IndexedClass indexedClass = new IndexedClass(string3, null, this, searchResult.getPersistentUrl(), string4, n, 0);
                collection.add(indexedClass);
            }
        }
    }

    protected void findConstants(Set<Index.SearchResult> set, NameKind nameKind, String string, Collection<IndexedConstant> collection) {
        for (Index.SearchResult searchResult : set) {
            String[] stringArray;
            if (searchResult.getPersistentUrl() == null || (stringArray = searchResult.getValues("const")) == null) continue;
            for (String string2 : stringArray) {
                Signature signature = Signature.get(string2);
                String string3 = signature.string(1);
                if ((nameKind == NameKind.PREFIX || nameKind == NameKind.CASE_INSENSITIVE_PREFIX) && !string3.startsWith(string)) continue;
                int n = signature.integer(2);
                IndexedConstant indexedConstant = new IndexedConstant(string3, null, this, searchResult.getPersistentUrl(), n, 0, null);
                collection.add(indexedConstant);
            }
        }
    }

    protected void findFunctions(Set<Index.SearchResult> set, NameKind nameKind, String string, Collection<IndexedFunction> collection) {
        for (Index.SearchResult searchResult : set) {
            String[] stringArray;
            if (searchResult.getPersistentUrl() == null || (stringArray = searchResult.getValues("base")) == null) continue;
            for (String string2 : stringArray) {
                Signature signature = Signature.get(string2);
                String string3 = signature.string(1);
                if (nameKind == NameKind.PREFIX || nameKind == NameKind.CASE_INSENSITIVE_PREFIX ? !string3.startsWith(string) : nameKind == NameKind.EXACT_NAME && !string3.equalsIgnoreCase(string)) continue;
                int n = signature.integer(3);
                String string4 = signature.string(2);
                IndexedFunction indexedFunction = new IndexedFunction(string3, null, this, searchResult.getPersistentUrl(), string4, n, 0, ElementKind.METHOD);
                int[] nArray = this.extractOptionalArgs(signature.string(4));
                indexedFunction.setOptionalArgs(nArray);
                collection.add(indexedFunction);
                String string5 = signature.string(5);
                string5 = string5.length() == 0 ? null : string5;
                indexedFunction.setReturnType(string5);
            }
        }
    }

    protected void findTopVariables(Set<Index.SearchResult> set, NameKind nameKind, String string, Collection<IndexedVariable> collection) {
        for (Index.SearchResult searchResult : set) {
            String[] stringArray;
            if (searchResult.getPersistentUrl() == null || (stringArray = searchResult.getValues("var")) == null) continue;
            for (String string2 : stringArray) {
                Signature signature = Signature.get(string2);
                String string3 = signature.string(1);
                if (nameKind != NameKind.PREFIX && nameKind != NameKind.CASE_INSENSITIVE_PREFIX ? nameKind == NameKind.EXACT_NAME && !string3.equals(string) : !string3.startsWith(string)) continue;
                String string4 = signature.string(2);
                string4 = string4.length() == 0 ? null : string4;
                int n = signature.integer(3);
                IndexedVariable indexedVariable = new IndexedVariable(string3, null, this, searchResult.getPersistentUrl(), n, 0, string4);
                collection.add(indexedVariable);
            }
        }
    }

    private boolean search(String string, String string2, NameKind nameKind, Set<Index.SearchResult> set, Set<Index.SearchScope> set2, Set<String> set3) {
        try {
            this.index.search(string, string2, nameKind, set2, set, set3);
            return true;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    public static void setClusterUrl(String string) {
        clusterUrl = string;
    }

    static String getPreindexUrl(String string) {
        String string2 = PHPIndex.getClusterUrl();
        if (string.startsWith(string2)) {
            return CLUSTER_URL + string.substring(string2.length());
        }
        return string;
    }

    public static FileObject getFileObject(String string) {
        try {
            if (string.startsWith(CLUSTER_URL)) {
                string = PHPIndex.getClusterUrl() + string.substring(CLUSTER_URL.length());
            }
            URL uRL = new URL(string);
            return URLMapper.findFileObject((URL)uRL);
        }
        catch (MalformedURLException malformedURLException) {
            Exceptions.printStackTrace((Throwable)malformedURLException);
            return null;
        }
    }

    static String getClusterUrl() {
        if (clusterUrl == null) {
            File file = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-javascript-editing.jar", null, false);
            if (file == null) {
                throw new RuntimeException("Can't find cluster");
            }
            file = new File(file.getParentFile().getParentFile().getAbsolutePath());
            try {
                file = file.getCanonicalFile();
                clusterUrl = file.toURI().toURL().toExternalForm();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return clusterUrl;
    }

    public Collection<IndexedConstant> getAllClassConstants(PHPParseResult pHPParseResult, String string, String string2, NameKind nameKind) {
        TreeMap<String, IndexedConstant> treeMap = new TreeMap<String, IndexedConstant>();
        File file = this.getCurrentFile(pHPParseResult);
        HashSet<String> hashSet = new HashSet<String>();
        for (String collection2 : this.getClassAncestors(pHPParseResult, string)) {
            for (IndexedConstant indexedConstant : this.getClassConstants(pHPParseResult, collection2, string2, nameKind)) {
                String string3 = indexedConstant.getName();
                if (treeMap.containsKey(string3) && !collection2.equals(string)) continue;
                treeMap.put(string3, indexedConstant);
                if (file == null || !file.equals(indexedConstant.getFile().getFile())) continue;
                hashSet.add(collection2);
            }
        }
        Collection<IndexedInterface> collection3 = this.getInterfaceTree(pHPParseResult, string);
        if (collection3 != null) {
            for (IndexedInterface indexedInterface : collection3) {
                for (IndexedConstant indexedConstant : this.getClassConstants(pHPParseResult, indexedInterface.getName(), string2, nameKind)) {
                    String string4 = indexedConstant.getName();
                    if (treeMap.containsKey(string4) && !indexedInterface.getName().equals(string)) continue;
                    treeMap.put(string4, indexedConstant);
                }
            }
        }
        Collection<IndexedConstant> collection = treeMap.values();
        this.filterClassMembers(collection, hashSet, file);
        return collection;
    }

    public Collection<IndexedFunction> getAllMethods(PHPParseResult pHPParseResult, String string, String string2, NameKind nameKind, int n) {
        TreeMap<String, IndexedFunction> treeMap = new TreeMap<String, IndexedFunction>();
        File file = this.getCurrentFile(pHPParseResult);
        HashSet<String> hashSet = new HashSet<String>();
        for (String object2 : this.getClassAncestors(pHPParseResult, string)) {
            int n2 = object2.equals(string) ? n : n & 0xFFFFFFFD;
            for (IndexedFunction indexedFunction : this.getMethods(pHPParseResult, object2, string2, nameKind, n2)) {
                String string3 = indexedFunction.getName();
                if (treeMap.containsKey(string3) && !object2.equals(string)) continue;
                treeMap.put(string3, indexedFunction);
                if (file == null || !file.equals(indexedFunction.getFile().getFile())) continue;
                hashSet.add(object2);
            }
        }
        Collection<IndexedInterface> collection = this.getInterfaceTree(pHPParseResult, string);
        if (collection != null) {
            for (IndexedInterface indexedInterface : collection) {
                String string4 = indexedInterface.getName();
                for (IndexedFunction indexedFunction : this.getMethods(pHPParseResult, string4, string2, nameKind, n)) {
                    String string5 = indexedFunction.getName();
                    if (treeMap.containsKey(string5) && !string4.equals(string)) continue;
                    treeMap.put(string5, indexedFunction);
                }
            }
        }
        Collection<IndexedFunction> collection2 = treeMap.values();
        this.filterClassMembers(collection2, hashSet, file);
        return collection2;
    }

    public Collection<IndexedConstant> getAllFields(PHPParseResult pHPParseResult, String string, String string2, NameKind nameKind, int n) {
        TreeMap<String, IndexedConstant> treeMap = new TreeMap<String, IndexedConstant>();
        File file = this.getCurrentFile(pHPParseResult);
        HashSet<String> hashSet = new HashSet<String>();
        for (String string3 : this.getClassAncestors(pHPParseResult, string)) {
            int n2 = string3.equals(string) ? n : n & 0xFFFFFFFD;
            for (IndexedConstant indexedConstant : this.getFields(pHPParseResult, string3, string2, nameKind, n2)) {
                String string4 = indexedConstant.getName();
                if (!treeMap.containsKey(string4) || string3.equals(string)) {
                    treeMap.put(string4, indexedConstant);
                }
                if (file == null || indexedConstant == null || !file.equals(indexedConstant.getFile().getFile())) continue;
                hashSet.add(string3);
            }
        }
        Collection collection = treeMap.values();
        this.filterClassMembers(collection, hashSet, file);
        return collection;
    }

    private File getCurrentFile(PHPParseResult pHPParseResult) {
        if (pHPParseResult != null && pHPParseResult.getFile() != null) {
            return pHPParseResult.getFile().getFile();
        }
        return null;
    }

    private void filterClassMembers(Collection<? extends IndexedElement> collection, Set<String> set, File file) {
        if (collection.size() > 0 && set.size() > 0) {
            Iterator<? extends IndexedElement> iterator = collection.iterator();
            while (iterator.hasNext()) {
                IndexedElement indexedElement = iterator.next();
                if (!set.contains(indexedElement.getIn()) || file.equals(indexedElement.getFile().getFile())) continue;
                iterator.remove();
            }
        }
    }

    @NonNull
    public Collection<String> getClassAncestors(PHPParseResult pHPParseResult, String string) {
        return this.getClassAncestors(pHPParseResult, string, new TreeSet<String>());
    }

    @NonNull
    private Collection<String> getClassAncestors(PHPParseResult pHPParseResult, String string, Collection<String> collection) {
        TreeSet<String> treeSet = new TreeSet<String>();
        if (collection.contains(string)) {
            return Collections.emptyList();
        }
        collection.add(string);
        LinkedList<String> linkedList = new LinkedList<String>();
        Collection<IndexedClass> collection2 = this.getClasses(pHPParseResult, string, NameKind.EXACT_NAME);
        if (collection2 != null) {
            for (IndexedClass object : collection2) {
                treeSet.add(object.getName());
                String string2 = object.getSuperClass();
                if (string2 == null) continue;
                linkedList.add(string2);
            }
        }
        for (String string3 : linkedList) {
            treeSet.addAll(this.getClassAncestors(pHPParseResult, string3, collection));
        }
        return treeSet;
    }

    public Collection<IndexedConstant> getClassConstants(PHPParseResult pHPParseResult, String string, String string2, NameKind nameKind) {
        ArrayList<IndexedConstant> arrayList = new ArrayList<IndexedConstant>();
        Map<String, String> map = this.getTypeSpecificSignatures(string, "clz.const", string2, nameKind, ALL_SCOPE);
        for (String string3 : map.keySet()) {
            Signature signature = Signature.get(string3);
            String string4 = signature.string(0);
            int n = signature.integer(1);
            IndexedConstant indexedConstant = new IndexedConstant(string4, string, this, map.get(string3), n, 0, null);
            arrayList.add(indexedConstant);
        }
        return arrayList;
    }

    public Collection<IndexedFunction> getMethods(PHPParseResult pHPParseResult, String string, String string2, NameKind nameKind, int n) {
        ArrayList<IndexedFunction> arrayList = new ArrayList<IndexedFunction>();
        Map<String, String> map = this.getTypeSpecificSignatures(string, "method", string2, nameKind, ALL_SCOPE);
        for (String string3 : map.keySet()) {
            Signature signature = Signature.get(string3);
            int n2 = signature.integer(5);
            if ((n2 & 7) == 0) {
                n2 |= 1;
            }
            if ((n2 & n) == 0) continue;
            String string4 = signature.string(0);
            String string5 = signature.string(1);
            int n3 = signature.integer(2);
            IndexedFunction indexedFunction = new IndexedFunction(string4, string, this, map.get(string3), string5, n3, n2, ElementKind.METHOD);
            int[] nArray = this.extractOptionalArgs(signature.string(3));
            indexedFunction.setOptionalArgs(nArray);
            String string6 = signature.string(4);
            string6 = string6.length() == 0 ? null : string6;
            indexedFunction.setReturnType(string6);
            arrayList.add(indexedFunction);
        }
        return arrayList;
    }

    public Collection<IndexedConstant> getFields(PHPParseResult pHPParseResult, String string, String string2, NameKind nameKind, int n) {
        ArrayList<IndexedConstant> arrayList = new ArrayList<IndexedConstant>();
        Map<String, String> map = this.getTypeSpecificSignatures(string, "field", string2, nameKind, ALL_SCOPE);
        for (String string3 : map.keySet()) {
            Signature signature = Signature.get(string3);
            int n2 = signature.integer(2);
            if ((n2 & 7) == 0) {
                n2 |= 1;
            }
            if ((n2 & n) == 0) continue;
            String string4 = "$" + signature.string(0);
            int n3 = signature.integer(1);
            String string5 = signature.string(3);
            if (string5.length() == 0) {
                string5 = null;
            }
            IndexedConstant indexedConstant = new IndexedConstant(string4, string, this, map.get(string3), n3, n2, string5, ElementKind.FIELD);
            arrayList.add(indexedConstant);
        }
        return arrayList;
    }

    private Map<String, String> getTypeSpecificSignatures(String string, String string2, String string3, NameKind nameKind, Set<Index.SearchScope> set) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string4 : new String[]{"clz", "iface"}) {
            this.search(string4, string.toLowerCase(), NameKind.PREFIX, hashSet, set, TERMS_BASE);
            for (Index.SearchResult searchResult : hashSet) {
                String[] stringArray = searchResult.getValues(string4);
                String[] stringArray2 = searchResult.getValues(string2);
                if (stringArray == null || stringArray2 == null) continue;
                assert (stringArray.length == 1);
                String string5 = PHPIndex.getSignatureItem(stringArray[0], 1);
                string5 = string5 != null ? string5.toLowerCase() : null;
                String string6 = searchResult.getPersistentUrl();
                if (!string.toLowerCase().equals(string5)) continue;
                for (String string7 : stringArray2) {
                    String string8 = PHPIndex.getSignatureItem(string7, 0);
                    if (!(nameKind == NameKind.CASE_INSENSITIVE_PREFIX && string8.toLowerCase().startsWith(string3.toLowerCase()) || nameKind == NameKind.PREFIX && string8.startsWith(string3)) && (nameKind != NameKind.EXACT_NAME || !string8.equals(string3))) continue;
                    hashMap.put(string7, string6);
                }
            }
        }
        return hashMap;
    }

    static String getSignatureItem(String string, int n) {
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (n2 == n) {
                for (int j = i; j < string.length(); ++j) {
                    c = string.charAt(j);
                    if (c != ';') continue;
                    return string.substring(i, j);
                }
            }
            if (c != ';') continue;
            ++n2;
        }
        return null;
    }

    public Collection<IndexedFunction> getFunctions(PHPParseResult pHPParseResult, String string, NameKind nameKind) {
        return this.getFunctions(pHPParseResult, string, nameKind, ALL_SCOPE);
    }

    public Collection<IndexedFunction> getFunctions(PHPParseResult pHPParseResult, String string, NameKind nameKind, Set<Index.SearchScope> set) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        ArrayList<IndexedFunction> arrayList = new ArrayList<IndexedFunction>();
        this.search("base", string.toLowerCase(), NameKind.PREFIX, hashSet, set, TERMS_BASE);
        this.findFunctions(hashSet, nameKind, string, arrayList);
        return arrayList;
    }

    public Collection<IndexedVariable> getTopLevelVariables(PHPParseResult pHPParseResult, String string, NameKind nameKind) {
        return this.getTopLevelVariables(pHPParseResult, string, nameKind, ALL_SCOPE);
    }

    public Collection<IndexedVariable> getTopLevelVariables(PHPParseResult pHPParseResult, String string, NameKind nameKind, Set<Index.SearchScope> set) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        ArrayList<IndexedVariable> arrayList = new ArrayList<IndexedVariable>();
        this.search("var", string.toLowerCase(), NameKind.PREFIX, hashSet, set, TERMS_VAR);
        this.findTopVariables(hashSet, nameKind, string, arrayList);
        return arrayList;
    }

    public Collection<IndexedConstant> getConstants(PHPParseResult pHPParseResult, String string, NameKind nameKind) {
        return this.getConstants(pHPParseResult, string, nameKind, ALL_SCOPE);
    }

    public Collection<IndexedConstant> getConstants(PHPParseResult pHPParseResult, String string, NameKind nameKind, Set<Index.SearchScope> set) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        ArrayList<IndexedConstant> arrayList = new ArrayList<IndexedConstant>();
        this.search("const", string.toLowerCase(), NameKind.PREFIX, hashSet, set, TERMS_CONST);
        this.findConstants(hashSet, nameKind, string, arrayList);
        return arrayList;
    }

    public Set<FileObject> filesWithIdentifiers(String string) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        HashSet<Index.SearchResult> hashSet2 = new HashSet<Index.SearchResult>();
        this.search("identifier_used", string.toLowerCase(), NameKind.PREFIX, hashSet2, ALL_SCOPE, TERMS_BASE);
        for (Index.SearchResult searchResult : hashSet2) {
            hashSet.add(FileUtil.toFileObject((File)new File(URI.create(searchResult.getPersistentUrl()))));
        }
        return hashSet;
    }

    public Set<String> typeNamesForIdentifier(String string, ElementKind elementKind, NameKind nameKind) {
        return this.typeNamesForIdentifier(string, elementKind, nameKind, ALL_SCOPE);
    }

    public Set<String> typeNamesForIdentifier(String string, ElementKind elementKind, NameKind nameKind, Set<Index.SearchScope> set) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<Index.SearchResult> hashSet2 = new HashSet<Index.SearchResult>();
        this.search("identifier_declaration", string.toLowerCase(), NameKind.PREFIX, hashSet2, set, TERMS_BASE);
        for (Index.SearchResult searchResult : hashSet2) {
            String[] stringArray;
            if (searchResult.getPersistentUrl() == null || (stringArray = searchResult.getValues("identifier_declaration")) == null) continue;
            block5: for (String string2 : stringArray) {
                IdentifierSignature identifierSignature = IdentifierSignature.createDeclaration(Signature.get(string2));
                if (!identifierSignature.isClassMember() && !identifierSignature.isIfaceMember() || identifierSignature.getTypeName() == null) continue;
                switch (nameKind) {
                    case CASE_INSENSITIVE_PREFIX: {
                        if (identifierSignature.getName().startsWith(string.toLowerCase())) break;
                        continue block5;
                    }
                    case PREFIX: {
                        if (identifierSignature.getName().startsWith(string)) break;
                        continue block5;
                    }
                    default: {
                        assert (false) : nameKind.toString();
                        continue block5;
                    }
                }
                if (elementKind == null) {
                    hashSet.add(identifierSignature.getTypeName());
                    continue;
                }
                if (elementKind.equals((Object)ElementKind.FIELD) && identifierSignature.isField()) {
                    hashSet.add(identifierSignature.getTypeName());
                    continue;
                }
                if (elementKind.equals((Object)ElementKind.METHOD) && identifierSignature.isMethod()) {
                    hashSet.add(identifierSignature.getTypeName());
                    continue;
                }
                if (!elementKind.equals((Object)ElementKind.CONSTANT) || !identifierSignature.isClassConstant()) continue;
                hashSet.add(identifierSignature.getTypeName());
            }
        }
        return hashSet;
    }

    public Collection<IndexedClass> getClasses(PHPParseResult pHPParseResult, String string, NameKind nameKind) {
        return this.getClasses(pHPParseResult, string, nameKind, ALL_SCOPE);
    }

    public Collection<IndexedClass> getClasses(PHPParseResult pHPParseResult, String string, NameKind nameKind, Set<Index.SearchScope> set) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        ArrayList<IndexedClass> arrayList = new ArrayList<IndexedClass>();
        this.search("clz", string.toLowerCase(), NameKind.PREFIX, hashSet, set, TERMS_CLASS);
        this.findClasses(hashSet, nameKind, string, arrayList);
        return arrayList;
    }

    public Collection<IndexedInterface> getInterfaces(PHPParseResult pHPParseResult, String string, NameKind nameKind) {
        return this.getInterfaces(pHPParseResult, string, nameKind, ALL_SCOPE);
    }

    public Collection<IndexedInterface> getInterfaces(PHPParseResult pHPParseResult, String string, NameKind nameKind, Set<Index.SearchScope> set) {
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        ArrayList<IndexedInterface> arrayList = new ArrayList<IndexedInterface>();
        if (string != null && string.trim().length() > 0) {
            this.search("iface", string.toLowerCase(), NameKind.PREFIX, hashSet, set, TERMS_BASE);
        } else {
            this.search("iface", string.toLowerCase(), NameKind.PREFIX, hashSet, set, null);
        }
        for (Index.SearchResult searchResult : hashSet) {
            String[] stringArray;
            if (searchResult.getPersistentUrl() == null || (stringArray = searchResult.getValues("iface")) == null) continue;
            for (String string2 : stringArray) {
                Signature signature = Signature.get(string2);
                String string3 = signature.string(1);
                if (nameKind == NameKind.PREFIX ? !string3.toLowerCase().startsWith(string.toLowerCase()) : nameKind == NameKind.EXACT_NAME && !string3.toLowerCase().equals(string.toLowerCase())) continue;
                int n = signature.integer(2);
                String[] stringArray2 = signature.string(3).split(",");
                IndexedInterface indexedInterface = new IndexedInterface(string3, null, this, searchResult.getPersistentUrl(), stringArray2, n, 0);
                arrayList.add(indexedInterface);
            }
        }
        return arrayList;
    }

    private Collection<IndexedInterface> getInterfaceTree(PHPParseResult pHPParseResult, String string) {
        ArrayList<IndexedInterface> arrayList = new ArrayList<IndexedInterface>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        TreeSet<String> treeSet = new TreeSet<String>(Collections.singleton(string));
        while (!treeSet.isEmpty()) {
            TreeSet<String> treeSet2 = new TreeSet<String>();
            for (String string2 : treeSet) {
                for (IndexedInterface indexedInterface : this.getInterfaces(pHPParseResult, string2, NameKind.EXACT_NAME)) {
                    arrayList.add(indexedInterface);
                    arrayList2.add(indexedInterface.getName());
                    for (String string3 : indexedInterface.getInterfaces()) {
                        if (arrayList2.contains(string3)) continue;
                        treeSet2.add(string3);
                    }
                }
            }
            treeSet.clear();
            treeSet.addAll(treeSet2);
        }
        return arrayList;
    }

    public Collection<String> getDirectIncludes(PHPParseResult pHPParseResult, String string) {
        assert (!string.startsWith("file:"));
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet<Index.SearchResult> hashSet = new HashSet<Index.SearchResult>();
        this.search("filename", "file:" + string, NameKind.EXACT_NAME, hashSet, ALL_SCOPE, TERMS_BASE);
        for (Index.SearchResult searchResult : hashSet) {
            String[] stringArray;
            if (searchResult.getPersistentUrl() == null || (stringArray = searchResult.getValues("include")) == null) continue;
            for (String string2 : stringArray) {
                for (String string3 : string2.split(";")) {
                    if (string3.length() <= 0) continue;
                    arrayList.add(string3);
                }
            }
        }
        return arrayList;
    }

    public Collection<String> getAllIncludes(PHPParseResult pHPParseResult, String string) {
        return this.getAllIncludes(pHPParseResult, string, new TreeSet<String>());
    }

    private Collection<String> getAllIncludes(PHPParseResult pHPParseResult, String string, Collection<String> collection) {
        Collection<String> collection2;
        HashMap<String, Collection<String>> hashMap = this.includesCache.get((Object)pHPParseResult);
        if (hashMap != null) {
            collection2 = hashMap.get(string);
            if (collection2 != null) {
                return collection2;
            }
        } else {
            hashMap = new HashMap();
            this.includesCache.put(pHPParseResult, hashMap);
        }
        collection2 = this.getAllIncludesImpl(pHPParseResult, string, collection);
        hashMap.put(string, collection2);
        return collection2;
    }

    private Collection<String> getAllIncludesImpl(PHPParseResult pHPParseResult, String string, Collection<String> collection) {
        TreeSet<String> treeSet = new TreeSet<String>();
        Collection<String> collection2 = this.getDirectIncludes(pHPParseResult, string);
        for (String string2 : collection2) {
            if (collection.contains(string2)) continue;
            collection.add(string2);
            treeSet.add(string2);
            treeSet.addAll(this.getAllIncludes(pHPParseResult, string2, collection));
        }
        return Collections.unmodifiableCollection(treeSet);
    }

    public boolean isReachable(PHPParseResult pHPParseResult, String string) {
        HashMap<String, Boolean> hashMap = this.isReachableCache.get((Object)pHPParseResult);
        if (hashMap != null) {
            Boolean bl = hashMap.get(string);
            if (bl != null) {
                return bl;
            }
        } else {
            hashMap = new HashMap();
            this.isReachableCache.put(pHPParseResult, hashMap);
        }
        boolean bl = this.isReachableImpl(pHPParseResult, string);
        hashMap.put(string, new Boolean(bl));
        return bl;
    }

    private boolean isReachableImpl(PHPParseResult pHPParseResult, String string) {
        if (this.isSystemFile(pHPParseResult, string)) {
            return true;
        }
        String string2 = null;
        try {
            string2 = pHPParseResult.getFile().getFileObject().getURL().toExternalForm();
            if (string.equals(string2)) {
                return true;
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
        }
        Collection<String> collection = this.getAllIncludes(pHPParseResult, PHPIndex.fileURLToAbsPath(string2));
        return collection.contains(PHPIndex.fileURLToAbsPath(string));
    }

    private boolean isSystemFile(PHPParseResult pHPParseResult, String string) {
        HashMap<String, Boolean> hashMap = this.isSystemFileCache.get((Object)pHPParseResult);
        if (hashMap != null) {
            Boolean bl = hashMap.get(string);
            if (bl != null) {
                return bl;
            }
        } else {
            hashMap = new HashMap();
            this.isSystemFileCache.put(pHPParseResult, hashMap);
        }
        boolean bl = this.isSystemFileImpl(pHPParseResult, string);
        hashMap.put(string, new Boolean(bl));
        return bl;
    }

    private boolean isSystemFileImpl(PHPParseResult pHPParseResult, String string) {
        try {
            File file = new File(new URI(string));
            if (!file.exists()) {
                return false;
            }
            FileObject fileObject = FileUtil.toFileObject((File)file);
            PhpSourcePath.FileType fileType = PhpSourcePath.getFileType((FileObject)fileObject);
            if (fileType == PhpSourcePath.FileType.INTERNAL || fileType == PhpSourcePath.FileType.INCLUDE) {
                return true;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            Exceptions.printStackTrace((Throwable)uRISyntaxException);
        }
        return false;
    }

    private static String fileURLToAbsPath(String string) {
        assert (string.startsWith("file:")) : string + " doesn't start with 'file:'";
        return string.substring("file:".length());
    }

    static String resolveRelativeURL(String string, String string2) {
        String string3;
        if (string2.startsWith("/")) {
            string3 = "/";
            string2 = string2.substring(1);
        } else {
            if (string == null || !string.startsWith("/")) {
                throw new IllegalArgumentException();
            }
            int n = (string = PHPIndex.resolveRelativeURL(null, string)).lastIndexOf(47);
            if (n == -1) {
                throw new IllegalArgumentException();
            }
            string3 = string.substring(0, n + 1);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("/")) {
                if (string3.endsWith("/")) continue;
                string3 = string3 + "/";
                continue;
            }
            if (string4.equals("") || string4.equals(".")) continue;
            if (string4.equals("..")) {
                String string5 = string3.substring(0, string3.length() - 1);
                int n = string5.lastIndexOf("/");
                if (n == -1) continue;
                string3 = string5.substring(0, n + 1);
                continue;
            }
            string3 = string3 + string4;
        }
        return string3;
    }

    private int[] extractOptionalArgs(String string) {
        if (string.length() == 0) {
            return new int[0];
        }
        String[] stringArray = string.split(",");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                nArray[i] = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(String.format("*** couldnt parse '%s', part %d", string, i));
            }
        }
        return nArray;
    }
}

