/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.AbstractListModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.support.DatabaseExplorerUIs;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.php.editor.codegen.DatabaseURL;
import org.netbeans.modules.php.editor.codegen.ui.CheckListener;
import org.netbeans.modules.php.editor.codegen.ui.CheckRenderer;
import org.netbeans.modules.php.editor.codegen.ui.ConnectionGeneratorPanel;
import org.netbeans.modules.php.editor.codegen.ui.ErrorLabel;
import org.netbeans.modules.php.editor.codegen.ui.ProgressPanel;
import org.netbeans.modules.php.editor.codegen.ui.Selectable;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableGeneratorPanel
extends JPanel {
    private DialogDescriptor descriptor;
    private DatabaseConnection dbconn;
    private Connection conn;
    private DatabaseMetaData dmd;
    private String table;
    private String lastErrorMessage;
    private JLabel columnLabel;
    private JList columnList;
    private JScrollPane columnScrollPane;
    private JLabel connVariableLabel;
    private JTextField connVariableTextField;
    private JComboBox dbconnComboBox;
    private JLabel dbconnLabel;
    private JLabel errorLabel;
    private JComboBox tableComboBox;
    private JLabel tableLabel;

    public static TableAndColumns selectTableAndColumns(String string) {
        TableGeneratorPanel tableGeneratorPanel = new TableGeneratorPanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)tableGeneratorPanel, NbBundle.getMessage(TableGeneratorPanel.class, (String)"MSG_SelectTableAndColumns"));
        tableGeneratorPanel.initialize(dialogDescriptor, string);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConnectionGeneratorPanel.class, (String)"ACSD_SelectColumns"));
        dialog.setVisible(true);
        dialog.dispose();
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            SQLIdentifiers.Quoter quoter = SQLIdentifiers.createQuoter((DatabaseMetaData)tableGeneratorPanel.dmd);
            return new TableAndColumns(quoter, tableGeneratorPanel.table, tableGeneratorPanel.getAllColumns(), tableGeneratorPanel.getSelectedColumns(), tableGeneratorPanel.getConnVariable());
        }
        return null;
    }

    private TableGeneratorPanel() {
        this.initComponents();
        this.columnList.setCellRenderer(new CheckRenderer());
        CheckListener checkListener = new CheckListener();
        this.columnList.addKeyListener(checkListener);
        this.columnList.addMouseListener(checkListener);
        this.connVariableTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                TableGeneratorPanel.this.updateErrorState();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                TableGeneratorPanel.this.updateErrorState();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                TableGeneratorPanel.this.updateErrorState();
            }
        });
    }

    private void initialize(DialogDescriptor dialogDescriptor, String string) {
        this.descriptor = dialogDescriptor;
        DatabaseExplorerUIs.connect((JComboBox)this.dbconnComboBox, (ConnectionManager)ConnectionManager.getDefault());
        this.connVariableTextField.setText(string);
        this.updateErrorState();
    }

    private String changeDatabaseConnection(DatabaseConnection databaseConnection) {
        DatabaseMetaData databaseMetaData;
        String string;
        String string2;
        this.dbconn = null;
        this.conn = null;
        this.dmd = null;
        this.tableComboBox.setModel(new DefaultComboBoxModel());
        this.columnList.setModel(new DefaultListModel());
        if (databaseConnection == null) {
            return null;
        }
        DatabaseURL databaseURL = DatabaseURL.detect(databaseConnection.getDatabaseURL());
        if (databaseURL == null || databaseURL.getServer() != DatabaseURL.Server.MYSQL) {
            return NbBundle.getMessage(TableGeneratorPanel.class, (String)"ERR_UnknownServer");
        }
        Connection connection = databaseConnection.getJDBCConnection();
        if (connection == null) {
            ConnectionManager.getDefault().showConnectionDialog(databaseConnection);
            connection = databaseConnection.getJDBCConnection();
        }
        if ((string2 = databaseConnection.getPassword()) == null || connection == null) {
            if (string2 == null) {
                return NbBundle.getMessage(TableGeneratorPanel.class, (String)"ERR_NoPassword");
            }
            return NbBundle.getMessage(TableGeneratorPanel.class, (String)"ERR_CouldNotConnect");
        }
        try {
            string = connection.getCatalog();
            databaseMetaData = connection.getMetaData();
        }
        catch (SQLException sQLException) {
            Exceptions.printStackTrace((Throwable)sQLException);
            return NbBundle.getMessage(TableGeneratorPanel.class, (String)"ERR_DatabaseMetadata");
        }
        ArrayList arrayList = new ArrayList();
        String string3 = this.extractTables(arrayList, databaseMetaData, string, databaseConnection.getSchema());
        if (string3 != null) {
            return string3;
        }
        Collections.sort(arrayList);
        this.dbconn = databaseConnection;
        this.conn = connection;
        this.dmd = databaseMetaData;
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (String string4 : arrayList) {
            defaultComboBoxModel.addElement(string4);
        }
        this.tableComboBox.setModel(defaultComboBoxModel);
        return null;
    }

    private String extractTables(final List<? super String> list, final DatabaseMetaData databaseMetaData, final String string, final String string2) {
        return TableGeneratorPanel.doWithProgress(NbBundle.getMessage(TableGeneratorPanel.class, (String)"MSG_ExtractingTables"), new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws Exception {
                try {
                    ResultSet resultSet = databaseMetaData.getTables(string, string2, "%", new String[]{"TABLE"});
                    try {
                        while (resultSet.next()) {
                            list.add(resultSet.getString("TABLE_NAME"));
                        }
                    }
                    finally {
                        resultSet.close();
                    }
                    return null;
                }
                catch (SQLException sQLException) {
                    Exceptions.printStackTrace((Throwable)sQLException);
                    return NbBundle.getMessage(TableGeneratorPanel.class, (String)"ERR_DatabaseMetadata");
                }
            }
        });
    }

    private String changeTable(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.extractColumns(string, arrayList);
        if (string2 != null) {
            return string2;
        }
        this.table = string;
        ColumnModel columnModel = new ColumnModel(arrayList);
        this.columnList.setModel(columnModel);
        int n = columnModel.getSize() > 0 ? 0 : -1;
        this.columnList.setSelectedIndex(n);
        return null;
    }

    private String extractColumns(final String string, final List<? super String> list) {
        return TableGeneratorPanel.doWithProgress(NbBundle.getMessage(TableGeneratorPanel.class, (String)"MSG_ExtractingColumns"), new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() {
                try {
                    ResultSet resultSet = TableGeneratorPanel.this.dmd.getColumns(TableGeneratorPanel.this.conn.getCatalog(), TableGeneratorPanel.this.dbconn.getSchema(), string, "%");
                    try {
                        while (resultSet.next()) {
                            list.add(resultSet.getString("COLUMN_NAME"));
                        }
                    }
                    finally {
                        resultSet.close();
                    }
                    return null;
                }
                catch (SQLException sQLException) {
                    Exceptions.printStackTrace((Throwable)sQLException);
                    return NbBundle.getMessage(TableGeneratorPanel.class, (String)"ERR_DatabaseMetadata");
                }
            }
        });
    }

    private void tableComboBoxSelectionChanged() {
        String string = (String)this.tableComboBox.getSelectedItem();
        this.lastErrorMessage = this.changeTable(string);
        this.updateErrorState();
    }

    private List<String> getSelectedColumns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ListModel listModel = this.columnList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            Selectable selectable;
            Object e = listModel.getElementAt(i);
            if (!(e instanceof Selectable) || !(selectable = (Selectable)e).isSelected()) continue;
            arrayList.add(selectable.getDisplayName());
        }
        return arrayList;
    }

    private List<String> getAllColumns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ListModel listModel = this.columnList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            Object e = listModel.getElementAt(i);
            if (!(e instanceof Selectable)) continue;
            Selectable selectable = (Selectable)e;
            arrayList.add(selectable.getDisplayName());
        }
        return arrayList;
    }

    private String getConnVariable() {
        return this.connVariableTextField.getText().trim();
    }

    private void updateErrorState() {
        this.tableComboBox.setEnabled(this.dbconn != null);
        this.columnList.setEnabled(this.tableComboBox.getSelectedItem() != null);
        if (this.lastErrorMessage != null) {
            this.setErrorMessage(this.lastErrorMessage);
            return;
        }
        if (this.dbconn == null) {
            this.setErrorMessage(NbBundle.getMessage(TableGeneratorPanel.class, (String)"ERR_SelectConnection"));
            return;
        }
        if (this.tableComboBox.getSelectedItem() == null) {
            this.setErrorMessage(NbBundle.getMessage(TableGeneratorPanel.class, (String)"ERR_SelectTable"));
            return;
        }
        if (this.getConnVariable().trim().length() == 0) {
            this.setErrorMessage(NbBundle.getMessage(TableGeneratorPanel.class, (String)"ERR_EnterConnVariable"));
            return;
        }
        this.setErrorMessage(null);
    }

    private void setErrorMessage(String string) {
        this.errorLabel.setText(string);
        this.descriptor.setValid(string == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T doWithProgress(String string, final Callable<? extends T> callable) {
        final ProgressPanel progressPanel = new ProgressPanel();
        progressPanel.setCancelVisible(false);
        progressPanel.setText(string);
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle(null);
        JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
        progressHandle.start();
        final ArrayList arrayList = new ArrayList(1);
        try {
            RequestProcessor.Task task = RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        try {
                            arrayList.add(callable.call());
                        }
                        catch (Exception exception) {
                            arrayList.add(null);
                            Exceptions.printStackTrace((Throwable)exception);
                        }
                        finally {
                            SwingUtilities.invokeLater(this);
                        }
                    } else {
                        progressPanel.close();
                    }
                }
            });
            progressPanel.open(jComponent);
            task.waitFinished();
        }
        finally {
            progressHandle.finish();
        }
        return (T)arrayList.get(0);
    }

    private void initComponents() {
        this.dbconnLabel = new JLabel();
        this.dbconnComboBox = new JComboBox();
        this.tableLabel = new JLabel();
        this.tableComboBox = new JComboBox();
        this.columnLabel = new JLabel();
        this.columnScrollPane = new JScrollPane();
        this.columnList = new JList();
        this.connVariableLabel = new JLabel();
        this.connVariableTextField = new JTextField();
        this.errorLabel = new ErrorLabel();
        this.dbconnLabel.setLabelFor(this.dbconnComboBox);
        Mnemonics.setLocalizedText((JLabel)this.dbconnLabel, (String)NbBundle.getMessage(TableGeneratorPanel.class, (String)"ConnectionGeneratorPanel.dbconnLabel.text"));
        this.dbconnComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableGeneratorPanel.this.dbconnComboBoxActionPerformed(actionEvent);
            }
        });
        this.tableLabel.setLabelFor(this.tableComboBox);
        Mnemonics.setLocalizedText((JLabel)this.tableLabel, (String)NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.tableLabel.text"));
        this.tableComboBox.setEnabled(false);
        this.tableComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableGeneratorPanel.this.tableComboBoxActionPerformed(actionEvent);
            }
        });
        this.columnLabel.setLabelFor(this.columnList);
        Mnemonics.setLocalizedText((JLabel)this.columnLabel, (String)NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.columnLabel.text"));
        this.columnList.setEnabled(false);
        this.columnScrollPane.setViewportView(this.columnList);
        this.columnList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.columnList.AccessibleContext.accessibleName"));
        this.columnList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.columnList.AccessibleContext.accessibleDescription"));
        this.connVariableLabel.setLabelFor(this.connVariableLabel);
        Mnemonics.setLocalizedText((JLabel)this.connVariableLabel, (String)NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.connVariableLabel.text"));
        this.connVariableTextField.setColumns(16);
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.errorLabel.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.columnScrollPane, -1, 437, Short.MAX_VALUE).add(1, (Component)this.dbconnLabel).add(1, (Component)this.dbconnComboBox, 0, 437, Short.MAX_VALUE).add(1, (Component)this.errorLabel).add(1, (Component)this.tableLabel).add(1, (Component)this.tableComboBox, 0, 437, Short.MAX_VALUE).add(1, (Component)this.columnLabel).add(1, (Component)this.connVariableTextField, -2, -1, -2).add(1, (Component)this.connVariableLabel)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.dbconnLabel).addPreferredGap(0).add((Component)this.dbconnComboBox, -2, -1, -2).addPreferredGap(0).add((Component)this.tableLabel).addPreferredGap(0).add((Component)this.tableComboBox, -2, -1, -2).addPreferredGap(0).add((Component)this.columnLabel).addPreferredGap(0).add((Component)this.columnScrollPane, -1, 201, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.connVariableLabel).addPreferredGap(0).add((Component)this.connVariableTextField, -2, -1, -2).addPreferredGap(1).add((Component)this.errorLabel).addContainerGap()));
        this.dbconnComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.dbconnComboBox.AccessibleContext.accessibleName"));
        this.dbconnComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.dbconnComboBox.AccessibleContext.accessibleDescription"));
        this.tableComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.tableComboBox.AccessibleContext.accessibleName"));
        this.tableComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.tableComboBox.AccessibleContext.accessibleDescription"));
        this.connVariableTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.connVariableTextField.AccessibleContext.accessibleName"));
        this.connVariableTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.connVariableTextField.AccessibleContext.accessibleDescription"));
    }

    private void dbconnComboBoxActionPerformed(ActionEvent actionEvent) {
        DatabaseConnection databaseConnection = null;
        Object object = this.dbconnComboBox.getSelectedItem();
        if (object instanceof DatabaseConnection) {
            databaseConnection = (DatabaseConnection)object;
        }
        this.lastErrorMessage = this.changeDatabaseConnection(databaseConnection);
        if (this.lastErrorMessage == null && this.dbconn != null) {
            this.tableComboBoxSelectionChanged();
        }
        this.updateErrorState();
    }

    private void tableComboBoxActionPerformed(ActionEvent actionEvent) {
        this.tableComboBoxSelectionChanged();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TableAndColumns {
        private final SQLIdentifiers.Quoter identifierQuoter;
        private final String table;
        private final List<String> allColumns;
        private final List<String> selectedColumns;
        private final String connVariable;

        private TableAndColumns(SQLIdentifiers.Quoter quoter, String string, List<String> list, List<String> list2, String string2) {
            this.identifierQuoter = quoter;
            this.table = string;
            this.allColumns = list;
            this.selectedColumns = list2;
            this.connVariable = string2;
        }

        public SQLIdentifiers.Quoter getIdentifierQuoter() {
            return this.identifierQuoter;
        }

        public String getTable() {
            return this.table;
        }

        public List<String> getAllColumns() {
            return this.allColumns;
        }

        public List<String> getSelectedColumns() {
            return this.selectedColumns;
        }

        public String getConnVariable() {
            return this.connVariable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ColumnModel
    extends AbstractListModel
    implements ChangeListener {
        private final List<Selectable> elements;

        public ColumnModel(List<String> list) {
            this.elements = new ArrayList<Selectable>(list.size());
            for (String string : list) {
                Selectable selectable = new Selectable(string);
                selectable.addChangeListener(this);
                this.elements.add(selectable);
            }
        }

        @Override
        public int getSize() {
            return this.elements.size();
        }

        @Override
        public Selectable getElementAt(int n) {
            return this.elements.get(n);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            for (int i = 0; i < this.elements.size(); ++i) {
                if (this.elements.get(i) != changeEvent.getSource()) continue;
                this.fireContentsChanged(this, i, i);
                break;
            }
        }
    }
}

