/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.common.palette;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.soa.mapper.basicmapper.util.MapperUtilities;
import org.netbeans.modules.soa.mapper.common.palette.PaletteCategoryNode;
import org.netbeans.modules.soa.mapper.common.palette.PaletteDialog;
import org.netbeans.modules.soa.mapper.common.palette.PaletteItem;
import org.netbeans.modules.soa.mapper.common.palette.PaletteItemNode;
import org.netbeans.modules.soa.mapper.common.palette.PaletteNode;
import org.netbeans.modules.soa.mapper.common.palette.PalettePanel;
import org.netbeans.modules.soa.mapper.common.ui.palette.IPaletteCategory;
import org.netbeans.modules.soa.mapper.common.ui.palette.IPaletteItem;
import org.netbeans.modules.soa.mapper.common.ui.palette.IPaletteManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class PaletteManager
implements IPaletteManager {
    private String mPaletteFolderName = "Palette";
    private PaletteItemNode mSelectedPaletteItem = null;
    private PropertyChangeSupport mPropertySupport;
    private PaletteNode mPaletteNode;
    private JComponent mPalette = new JPanel();
    private PalettePanel mPalettePane;
    private PaletteDialog mPaletteDialog;
    private PaletteCategoryNode[] mCategories = null;
    private PaletteItemNode[][] mItems = null;
    private Frame mFrame = null;
    private Component mComponent = null;
    private boolean mInitState = false;
    private int mCatNumber = -1;
    private static boolean showComponentsNames = true;
    public static final String PROP_SHOW_COMPONENTS_NAMES = "showComponentsNames";
    private static Logger mLogger = Logger.getLogger(PaletteManager.class.getName());
    private static final boolean TRACE = true;

    public void setFolder(String string) {
        PaletteManager.t("<init>-BEG");
        this.mPaletteFolderName = string;
        this.mPropertySupport = new PropertyChangeSupport(this);
        this.mPaletteNode = new PaletteNode(string);
        Integer n = (Integer)this.mPaletteNode.getNodeAttribute("TotalCategories");
        if (n != null) {
            this.mCatNumber = n;
        }
        this.mPalettePane = new PalettePanel(this);
        this.switchUI();
        PaletteManager.t("<init>-END");
    }

    public PaletteNode getPaletteRootNode() {
        return this.mPaletteNode;
    }

    public boolean isInitialized() {
        return this.mInitState;
    }

    private void getCategories() {
        PaletteManager.t("GetCategory: " + this.mCategories);
        if (this.mCategories != null) {
            return;
        }
        int n = 0;
        boolean bl = true;
        Node[] nodeArray = this.mPaletteNode.getCategoryNodes();
        PaletteManager.t(n + " GetCategory: got " + nodeArray.length + ", Total " + this.mCatNumber);
        if (this.mCatNumber > 0 && nodeArray.length < this.mCatNumber) {
            return;
        }
        if (nodeArray.length == 0) {
            bl = false;
        } else {
            ArrayList<Node> arrayList = new ArrayList<Node>(nodeArray.length);
            this.mItems = new PaletteItemNode[nodeArray.length][];
            for (int i = 0; i < nodeArray.length; ++i) {
                if (!(nodeArray[i] instanceof PaletteCategoryNode)) continue;
                arrayList.add(nodeArray[i]);
                PaletteCategoryNode paletteCategoryNode = (PaletteCategoryNode)nodeArray[i];
                this.mItems[i] = (PaletteItemNode[])paletteCategoryNode.getItemNodes();
            }
            this.mCategories = arrayList.toArray(new PaletteCategoryNode[arrayList.size()]);
        }
    }

    public IPaletteCategory[] getAllCategories() {
        if (this.mCategories == null) {
            this.getCategories();
        }
        return this.mCategories;
    }

    public IPaletteCategory getSelectedCategory() {
        return this.mPalettePane.getSelectedCategory();
    }

    public IPaletteItem[] getCategoryItems(IPaletteCategory iPaletteCategory) {
        if (iPaletteCategory == null) {
            return null;
        }
        int n = this.mPalettePane.getCategoryIndex(iPaletteCategory.getName());
        if (n < 0) {
            return null;
        }
        if (this.mItems[n] == null) {
            return null;
        }
        return this.mItems[n];
    }

    public int[] getCategorySelectedItemIndices(IPaletteCategory iPaletteCategory) {
        return this.mPalettePane.getCategorySelectedItemIndices(iPaletteCategory.getName());
    }

    public void showDialog() {
        if (!this.isInitialized()) {
            mLogger.fine("PaletteManager is initializing... Please wait. ");
            return;
        }
        if (this.mPaletteDialog == null) {
            if (this.mFrame == null) {
                this.mFrame = this.setFrame();
            }
            this.mPaletteDialog = new PaletteDialog(this.mFrame, this.mPalettePane);
        }
        if (this.mPaletteDialog != null) {
            this.mPaletteDialog.showDialog();
        }
    }

    public void showDialog(Component component) {
        if (!this.isInitialized()) {
            mLogger.fine("PaletteManager is initializing... Please wait. ");
            return;
        }
        if (this.mPaletteDialog == null) {
            if (this.mFrame == null) {
                this.mFrame = this.setFrame();
            }
            this.mPaletteDialog = new PaletteDialog(this.mFrame, this.mPalettePane);
        }
        if (this.mPaletteDialog != null) {
            this.mPaletteDialog.showDialog(component);
        }
    }

    public void showDialog(IPaletteCategory iPaletteCategory) {
        if (!this.isInitialized()) {
            mLogger.fine("PaletteManager is initializing... Please wait. ");
            return;
        }
        if (this.mPaletteDialog == null) {
            if (this.mFrame == null) {
                this.mFrame = this.setFrame();
            }
            this.mPaletteDialog = new PaletteDialog(this.mFrame, this.mPalettePane);
        }
        if (this.mPaletteDialog != null) {
            this.mPalettePane.setSelectedCategory(iPaletteCategory.getName());
            this.mPaletteDialog.showDialog();
        }
    }

    public void setFrame(Component component) {
        this.mComponent = component;
        this.mFrame = null;
        this.mPaletteDialog = null;
    }

    private Frame setFrame() {
        Component component = this.mComponent;
        Frame frame = WindowManager.getDefault().getMainWindow();
        if (this.mComponent == null) {
            return frame;
        }
        while (!(component instanceof Frame)) {
            if ((component = component.getParent()) != null) continue;
            return frame;
        }
        return (Frame)component;
    }

    public void selectAll(IPaletteCategory iPaletteCategory) {
        this.mPalettePane.selectAll(iPaletteCategory.getName());
    }

    public void clearAll(IPaletteCategory iPaletteCategory) {
        this.mPalettePane.clearAll(iPaletteCategory.getName());
    }

    public void selectItem(IPaletteCategory iPaletteCategory, IPaletteItem iPaletteItem) {
        this.mPalettePane.selectItem(iPaletteCategory.getName(), (PaletteItemNode)iPaletteItem);
    }

    public void clearItem(IPaletteCategory iPaletteCategory, IPaletteItem iPaletteItem) {
        this.mPalettePane.clearItem(iPaletteCategory.getName(), (PaletteItemNode)iPaletteItem);
    }

    public void setShowComponentsNames(boolean bl) {
        if (bl == showComponentsNames) {
            return;
        }
        showComponentsNames = bl;
    }

    public boolean getShowComponentsNames() {
        return showComponentsNames;
    }

    public Node getRootNode() {
        return this.mPaletteNode;
    }

    public Node[] getCategoryNodes() {
        if (this.mCategories == null) {
            this.getCategories();
        }
        return this.mCategories;
    }

    public Node[] getItemNodes(Node node) {
        if (!(node instanceof PaletteCategoryNode)) {
            return new Node[0];
        }
        PaletteManager.t("getItemNodes: " + ((PaletteCategoryNode)node).getValidItemNodes().length);
        for (int i = 0; i < this.mCategories.length; ++i) {
            if (node != this.mCategories[i]) continue;
            return this.mItems[i];
        }
        return new Node[0];
    }

    public JComponent getComponent() {
        return this.mPalette;
    }

    public PaletteItemNode getSelectedItem() {
        return this.mSelectedPaletteItem;
    }

    public void setSelectedItem(PaletteItemNode paletteItemNode) {
        PaletteManager.t("PM:setSelectedItem: " + (paletteItemNode == null ? "NULL" : MapperUtilities.cutAmpersand(paletteItemNode.getName())));
        if (paletteItemNode == null) {
            return;
        }
        if (paletteItemNode == this.mSelectedPaletteItem) {
            return;
        }
        PaletteItemNode paletteItemNode2 = this.mSelectedPaletteItem;
        this.mSelectedPaletteItem = paletteItemNode;
        this.mPropertySupport.firePropertyChange("Palette_selectedItem", paletteItemNode2, paletteItemNode);
    }

    public void setCheckedItem(PaletteItemNode paletteItemNode, boolean bl) {
        PaletteManager.t("PM:setCheckedItem: " + (paletteItemNode == null ? "NULL" : MapperUtilities.cutAmpersand(paletteItemNode.getName())));
        if (paletteItemNode == null) {
            return;
        }
        Object var3_3 = null;
        this.mPropertySupport.firePropertyChange(bl ? "Palette_checkedItem" : "Palette_uncheckedItem", var3_3, paletteItemNode);
    }

    public void setInitialized(boolean bl) {
        mLogger.fine(">>> PM-initialized: " + bl);
        boolean bl2 = this.mInitState;
        this.mInitState = bl;
        this.mPropertySupport.firePropertyChange("Palette_initialized", bl2, bl);
    }

    public static ResourceBundle getBundle() {
        return NbBundle.getBundle(PaletteManager.class);
    }

    public static PaletteItem createPaletteItem(Node node) {
        try {
            return new PaletteItem(node);
        }
        catch (InstantiationException instantiationException) {
            mLogger.log(Level.FINEST, "createPaletteItem-InstantiationException: ", instantiationException);
            return null;
        }
    }

    private void switchUI() {
        PaletteManager.t("switchUI-BEG");
        this.setSelectedItem(null);
        this.mPalette.removeAll();
        this.mPalette.setLayout(new BorderLayout());
        this.mPalette.add(this.mPalettePane);
        this.mPalette.revalidate();
        this.mPalette.repaint();
        PaletteManager.t("switchUI-END");
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.mPropertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.mPropertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    private static void t(String string) {
        if (string != null) {
            mLogger.fine("-----=====> PaletteManager: [" + Thread.currentThread().getName() + "] " + string);
        } else {
            mLogger.fine("");
        }
    }
}

