/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.common.palette;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.soa.mapper.common.palette.PaletteItemNode;
import org.netbeans.modules.soa.mapper.common.palette.PaletteManager;
import org.netbeans.modules.soa.mapper.common.ui.palette.IPaletteCategory;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.FileSystemAction;
import org.openide.actions.MoveDownAction;
import org.openide.actions.MoveUpAction;
import org.openide.actions.PasteAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ReorderAction;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public class PaletteCategoryNode
extends DataFolder.FolderNode
implements IPaletteCategory {
    private static String mIconURL = "com/stc/collabeditor/common/palette/resources/paletteCategory.gif";
    private static String mIcon32URL = "com/stc/collabeditor/common/palette/resources/paletteCategory32.gif";
    private static final Node.PropertySet[] NODE_PROPERTIES = new Node.PropertySet[0];
    private static SystemAction[] mStaticActions;
    private DataFolder mFolder;

    public PaletteCategoryNode(DataFolder dataFolder) {
        DataFolder dataFolder2 = dataFolder;
        dataFolder2.getClass();
        super(dataFolder2, (Children)new PaletteCategoryNodeChildren(dataFolder));
        this.mFolder = dataFolder;
        Object object = dataFolder.getPrimaryFile().getAttribute("categoryName");
        if (object != null && object instanceof String) {
            this.setName((String)object, false);
        } else {
            String string;
            String string2 = this.getName();
            if (!string2.equals(string = this.getDisplayName())) {
                this.setName(string, false);
            }
        }
    }

    public Object getCategoryAttribute(String string) {
        return this.mFolder.getPrimaryFile().getAttribute(string);
    }

    public void setName(String string) {
        this.setName(string, true);
    }

    public void setName(String string, boolean bl) {
        if (bl) {
            if (!PaletteCategoryNode.checkCategoryName(string, (Node)this)) {
                return;
            }
            try {
                DataObject dataObject = this.getDataObject();
                FileObject fileObject = dataObject.getPrimaryFile();
                String string2 = PaletteCategoryNode.convertToFolderName(string, fileObject.getName());
                fileObject.setAttribute("categoryName", null);
                dataObject.rename(string2);
                if (!string2.equals(string)) {
                    fileObject.setAttribute("categoryName", (Object)string);
                }
            }
            catch (IOException iOException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                ErrorManager.getDefault().annotate((Throwable)illegalArgumentException, (Throwable)iOException);
                throw illegalArgumentException;
            }
        }
        super.setName(string, false);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.options.component-palette");
    }

    public String getToolTip() {
        return this.getShortDescription().replace('-', '.');
    }

    public Node[] getItemNodes() {
        DataObject[] dataObjectArray = this.mFolder.getChildren();
        ArrayList<PaletteItemNode> arrayList = new ArrayList<PaletteItemNode>();
        for (int i = 0; i < dataObjectArray.length; ++i) {
            DataObject dataObject = dataObjectArray[i];
            if (dataObject == null) continue;
            PaletteItemNode paletteItemNode = new PaletteItemNode(dataObject.getNodeDelegate());
            arrayList.add(paletteItemNode);
        }
        return (Node[])arrayList.toArray(new PaletteItemNode[arrayList.size()]);
    }

    public Node[] getValidItemNodes() {
        Node[] nodeArray = this.getItemNodes();
        return nodeArray;
    }

    public Node.Cookie getCookie(Class clazz) {
        DataFolder dataFolder;
        if (Index.class.isAssignableFrom(clazz) && (dataFolder = (DataFolder)super.getCookie(DataFolder.class)) != null) {
            return new PaletteCategoryIndex(dataFolder, (Node)this, (PaletteCategoryNodeChildren)this.getChildren());
        }
        return super.getCookie(clazz);
    }

    public Image getIcon(int n) {
        if (n == 1 || n == 3) {
            return ImageUtilities.loadImage((String)mIconURL);
        }
        return ImageUtilities.loadImage((String)mIcon32URL);
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public NewType[] getNewTypes() {
        return new NewType[0];
    }

    public Action[] getActions(boolean bl) {
        if (mStaticActions == null) {
            mStaticActions = new SystemAction[]{SystemAction.get(FileSystemAction.class), null, SystemAction.get(MoveUpAction.class), SystemAction.get(MoveDownAction.class), SystemAction.get(ReorderAction.class), null, SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), SystemAction.get(RenameAction.class)};
        }
        return mStaticActions;
    }

    public Node.PropertySet[] getPropertySets() {
        return NODE_PROPERTIES;
    }

    protected void createPasteTypes(Transferable transferable, List list) {
        boolean bl;
        Node[] nodeArray = NodeTransfer.nodes((Transferable)transferable, (int)6);
        if (nodeArray == null) {
            bl = false;
            nodeArray = NodeTransfer.nodes((Transferable)transferable, (int)1);
            if (nodeArray == null) {
                return;
            }
        } else {
            bl = true;
        }
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        for (int i = 0; i < nodeArray.length; ++i) {
            FileObject fileObject;
            Node node = nodeArray[i];
            DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
            InstanceCookie instanceCookie = (InstanceCookie)node.getCookie(InstanceCookie.class);
            FileObject fileObject2 = fileObject = dataObject != null ? dataObject.getPrimaryFile() : null;
            if (this.getChildren().findChild(node.getName()) != null || dataObject == null || !dataObject.isValid() || instanceCookie == null || bl && !"instance".equals(fileObject.getExt()) && !"shadow".equals(fileObject.getExt())) continue;
            arrayList.add(dataObject);
        }
        if (!arrayList.isEmpty()) {
            list.add(new BeanPaste(arrayList, bl, false));
            if (!bl) {
                list.add(new BeanPaste(arrayList, bl, true));
            }
        }
    }

    static boolean checkCategoryName(String string, Node node) {
        boolean bl = false;
        if (string == null || "".equals(string)) {
            bl = true;
        } else {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '.' || c == ' ' && i + 1 == n) {
                    bl = true;
                    break;
                }
                if (c != ' ') break;
            }
        }
        if (bl) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)MessageFormat.format(PaletteManager.getBundle().getString("ERR_InvalidName"), string), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return false;
        }
        return true;
    }

    static String convertToFolderName(String string, String string2) {
        int n;
        if (string == null || "".equals(string)) {
            return null;
        }
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        char c = string.charAt(0);
        if (Character.isJavaIdentifierStart(c)) {
            stringBuffer.append(c);
            n = 1;
        } else {
            stringBuffer.append('_');
            n = 0;
        }
        while (n < n2) {
            c = string.charAt(n);
            if (Character.isJavaIdentifierPart(c)) {
                stringBuffer.append(c);
            }
            ++n;
        }
        String string3 = stringBuffer.toString();
        if ("_".equals(string3)) {
            string3 = "Category";
        }
        if (string3.equals(string2)) {
            return string3;
        }
        return string3;
    }

    private class BeanPaste
    extends PasteType {
        private List dataObjs;
        private boolean cut;
        private boolean createLink;

        public BeanPaste(List list, boolean bl, boolean bl2) {
            this.dataObjs = list;
            this.cut = bl;
            this.createLink = bl2;
        }

        public String getName() {
            return this.createLink ? PaletteManager.getBundle().getString("CTL_PasteLink") : PaletteManager.getBundle().getString("CTL_PasteBean");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(BeanPaste.class.getName());
        }

        public final Transferable paste() throws IOException {
            DataFolder dataFolder = PaletteCategoryNode.this.mFolder;
            for (DataObject dataObject : this.dataObjs) {
                Object object;
                FileObject fileObject = dataObject.getPrimaryFile();
                if (!this.createLink && ("instance".equals(fileObject.getExt()) || "shadow".equals(fileObject.getExt()))) {
                    object = fileObject.getAttribute("SystemFileSystem.icon");
                    Object object2 = fileObject.getAttribute("beaninfo");
                    if (this.cut) {
                        if (dataObject.isMoveAllowed()) {
                            dataObject.move(dataFolder);
                        } else {
                            dataObject = null;
                        }
                    } else {
                        dataObject = dataObject.copy(dataFolder);
                    }
                    if (dataObject == null) continue;
                    if (object != null) {
                        dataObject.getPrimaryFile().setAttribute("SystemFileSystem.icon", object);
                    }
                    if (object2 == null) continue;
                    dataObject.getPrimaryFile().setAttribute("beaninfo", object2);
                    continue;
                }
                if (this.cut) continue;
                if (!this.createLink && ("java".equals(fileObject.getExt()) || "class".equals(fileObject.getExt()))) {
                    object = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
                    continue;
                }
                dataObject.createShadow(dataFolder);
            }
            return null;
        }
    }

    static final class PaletteCategoryIndex
    extends DataFolder.Index {
        private PaletteCategoryNodeChildren children;

        PaletteCategoryIndex(DataFolder dataFolder, Node node, PaletteCategoryNodeChildren paletteCategoryNodeChildren) {
            super(dataFolder, node);
            this.children = paletteCategoryNodeChildren;
        }

        public int getNodesCount() {
            return this.children.getNodesCount();
        }

        public Node[] getNodes() {
            return this.children.getNodes();
        }
    }

    private static class PaletteCategoryNodeChildren
    extends FilterNode.Children {
        public PaletteCategoryNodeChildren(DataFolder dataFolder) {
            super(dataFolder.getNodeDelegate());
        }

        protected Node copyNode(Node node) {
            if (node.getCookie(DataObject.class) != null) {
                return new PaletteItemNode(node);
            }
            return node.cloneNode();
        }
    }
}

