/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo;

import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.AbstractCanvasLink;
import org.netbeans.modules.soa.mapper.basicmapper.canvas.jgo.util.DrawPort;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicViewManager;
import org.netbeans.modules.soa.mapper.common.basicmapper.canvas.gtk.ICanvasMapperLink;

public class BasicCanvasPort
extends JGoPort {
    private static Dimension NO_SIZE = new Dimension(0, 0);
    private static final JGoBrush BRUSH = JGoBrush.makeStockBrush((Color)new Color(255, 255, 255, 0));
    private boolean toggleLinkHighliting = false;
    private DrawPort mDrawPort;
    private JGoPen pen;

    public BasicCanvasPort() {
        this.setBrush(BRUSH);
    }

    public DrawPort getDrawPort() {
        return this.mDrawPort;
    }

    public void setPortObject(JGoObject jGoObject) {
        super.setPortObject(jGoObject);
        if (jGoObject instanceof DrawPort) {
            this.mDrawPort = (DrawPort)jGoObject;
        }
    }

    public int getLinkPosition() {
        if (this.mDrawPort != null) {
            if (this.mDrawPort.getFieldNode().getFieldNode().isInput()) {
                return 8;
            }
            if (this.mDrawPort.getFieldNode().getFieldNode().isOutput()) {
                return 4;
            }
        }
        return 0;
    }

    public Dimension getDrawSize() {
        if (this.mDrawPort != null) {
            return this.mDrawPort.getDrawSize();
        }
        return NO_SIZE;
    }

    public boolean doMouseEntered(int n, Point point, Point point2, JGoView jGoView) {
        if (this.getNumLinks() == 0) {
            return false;
        }
        JGoListPosition jGoListPosition = this.getFirstLinkPos();
        while (jGoListPosition != null) {
            JGoLink jGoLink = this.getLinkAtPos(jGoListPosition);
            if (jGoLink instanceof AbstractCanvasLink) {
                AbstractCanvasLink abstractCanvasLink = (AbstractCanvasLink)jGoLink;
                IBasicViewManager iBasicViewManager = abstractCanvasLink.getMapperCanvas().getParentView().getViewManager();
                if (!iBasicViewManager.isHighlightLink() || !iBasicViewManager.isToggleHighlighting()) break;
                abstractCanvasLink.startHighlighting();
            } else {
                if (this.pen == null) {
                    this.pen = jGoLink.getPen();
                }
                jGoLink.setPen(JGoPen.make((int)65535, (int)1, (Color)ICanvasMapperLink.DEFAULT_LINK_SELECTED_COLOR));
            }
            jGoListPosition = this.getNextLinkPos(jGoListPosition);
        }
        return true;
    }

    public boolean doMouseExited(int n, Point point, Point point2, JGoView jGoView) {
        if (this.getNumLinks() == 0) {
            return false;
        }
        JGoListPosition jGoListPosition = this.getFirstLinkPos();
        while (jGoListPosition != null) {
            JGoLink jGoLink = this.getLinkAtPos(jGoListPosition);
            if (jGoLink instanceof AbstractCanvasLink) {
                AbstractCanvasLink abstractCanvasLink = (AbstractCanvasLink)jGoLink;
                abstractCanvasLink.stopHighlighting();
            } else {
                jGoLink.setPen(this.pen);
            }
            jGoListPosition = this.getNextLinkPos(jGoListPosition);
        }
        return true;
    }
}

