/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.designtime.ext.componentgroup.util;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignInfo;
import com.sun.rave.designtime.ext.componentgroup.ColorWrapper;
import com.sun.rave.designtime.ext.componentgroup.ComponentGroup;
import com.sun.rave.designtime.ext.componentgroup.ComponentGroupDesignInfo;
import com.sun.rave.designtime.ext.componentgroup.ComponentGroupHolder;
import com.sun.rave.designtime.ext.componentgroup.impl.ColorWrapperImpl;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentGroupHelper {
    public static Color[] DEFAULT_COLOR_SET = new Color[]{Color.blue, Color.green, Color.red, Color.yellow, Color.magenta, Color.orange, Color.cyan, Color.pink, new Color(0, 0, 128), new Color(255, 250, 205), new Color(0, 100, 0), new Color(255, 228, 225), new Color(250, 128, 114), new Color(224, 255, 255), new Color(255, 105, 180), new Color(205, 92, 92), new Color(0, 0, 205), new Color(143, 188, 143), new Color(238, 221, 130), new Color(238, 130, 238), new Color(244, 238, 224), new Color(64, 224, 208), new Color(255, 218, 185), new Color(240, 128, 128), new Color(135, 206, 250), new Color(46, 139, 87), new Color(218, 165, 32), new Color(230, 230, 250), new Color(189, 183, 107), new Color(208, 32, 144), new Color(173, 255, 47), new Color(70, 130, 180), new Color(205, 133, 63), new Color(175, 238, 238), new Color(60, 179, 113), new Color(176, 196, 222), new Color(186, 85, 211), new Color(244, 164, 96), new Color(32, 178, 170), new Color(165, 42, 42), new Color(50, 205, 50)};

    public static String getComponentGroupColorKey(String holderName, String groupName) {
        return "componentGroupColor:" + holderName + ":" + groupName;
    }

    public static void populateColorGroupArray(DesignContext dcontext, ComponentGroupHolder[] holders, ComponentGroup[][] groupArr) {
        ComponentGroupHelper.populateColorModels(dcontext, holders, groupArr, null);
    }

    public static void populateColorMap(DesignContext dcontext, ComponentGroupHolder[] holders, Map<String, Color> colorMap) {
        ComponentGroupHelper.populateColorModels(dcontext, holders, null, colorMap);
    }

    public static void populateColorModels(DesignContext dcontext, ComponentGroupHolder[] holders, ComponentGroup[][] groupArr, Map<String, Color> colorMap) {
        if (holders == null || holders.length == 0) {
            return;
        }
        if (groupArr == null) {
            groupArr = new ComponentGroup[holders.length][];
        }
        if (colorMap == null) {
            colorMap = new HashMap<String, Color>();
        }
        ArrayList<ComponentGroup> unassignedComponentGroups = new ArrayList<ComponentGroup>();
        ArrayList<String> unassignedComponentGroupKeys = new ArrayList<String>();
        for (int h = 0; h < holders.length; ++h) {
            ComponentGroupHolder holder = holders[h];
            ComponentGroup[] groups = holder.getComponentGroups(dcontext);
            groupArr[h] = groups;
            if (groups == null) continue;
            for (int i = 0; i < groups.length; ++i) {
                String holderName = holder.getName();
                String name = groups[i].getName();
                String key = ComponentGroupHelper.getComponentGroupColorKey(holderName, name);
                Object o = dcontext.getContextData(key);
                Color color = null;
                if (o instanceof ColorWrapper) {
                    color = ((ColorWrapper)o).getColor();
                    if (color != null) {
                        Collection<Color> values = colorMap.values();
                        if (values.contains(color)) {
                            groups[i].setColor(null);
                            unassignedComponentGroups.add(groups[i]);
                            unassignedComponentGroupKeys.add(key);
                            continue;
                        }
                        colorMap.put(key, color);
                        continue;
                    }
                    unassignedComponentGroups.add(groups[i]);
                    unassignedComponentGroupKeys.add(key);
                    continue;
                }
                if (o instanceof String) {
                    ColorWrapperImpl cw = new ColorWrapperImpl((String)o);
                    color = cw.getColor();
                    if (color != null) {
                        dcontext.setContextData(key, (Object)cw);
                        Collection<Color> values = colorMap.values();
                        if (values.contains(color)) {
                            groups[i].setColor(null);
                            unassignedComponentGroups.add(groups[i]);
                            unassignedComponentGroupKeys.add(key);
                            continue;
                        }
                        colorMap.put(key, color);
                        continue;
                    }
                    unassignedComponentGroups.add(groups[i]);
                    unassignedComponentGroupKeys.add(key);
                    continue;
                }
                unassignedComponentGroups.add(groups[i]);
                unassignedComponentGroupKeys.add(key);
            }
        }
        for (int i = 0; i < unassignedComponentGroups.size(); ++i) {
            ComponentGroup group = (ComponentGroup)unassignedComponentGroups.get(i);
            String key = (String)unassignedComponentGroupKeys.get(i);
            Color c = ComponentGroupHelper.getLeastUsedColor(colorMap);
            group.setColor(c);
            colorMap.put(key, c);
        }
    }

    public static Color getMappedColor(String key, Map colorMap) {
        Color c = (Color)colorMap.get(key);
        if (c != null) {
            return c;
        }
        c = ComponentGroupHelper.getLeastUsedColor(colorMap);
        colorMap.put(key, c);
        return c;
    }

    private static Color getLeastUsedColor(Map colorMap) {
        HashMap<Color, Integer> timesUsed = new HashMap<Color, Integer>();
        for (Color c : colorMap.values()) {
            Integer times = (Integer)timesUsed.get(c);
            if (times == null) {
                timesUsed.put(c, new Integer(1));
                continue;
            }
            int t = times;
            timesUsed.put(c, new Integer(t + 1));
        }
        Color leastUsedColor = null;
        int leastTimesUsed = -1;
        for (int i = 0; i < DEFAULT_COLOR_SET.length; ++i) {
            Color c = DEFAULT_COLOR_SET[i];
            Integer times = (Integer)timesUsed.get(c);
            if (times == null) {
                return c;
            }
            int t = times;
            if (leastTimesUsed >= 0 && t >= leastTimesUsed) continue;
            leastTimesUsed = t;
            leastUsedColor = c;
        }
        return leastUsedColor;
    }

    public static ComponentGroupHolder[] getComponentGroupHolders(DesignContext dcontext) {
        DesignBean[] dcontextBeans = dcontext.getBeans();
        if (dcontextBeans == null || dcontextBeans.length == 0) {
            return null;
        }
        HashSet<String> designInfoSet = new HashSet<String>();
        ArrayList<ComponentGroupHolder> holderList = new ArrayList<ComponentGroupHolder>();
        for (int b = 0; b < dcontextBeans.length; ++b) {
            String designInfoClassName;
            DesignInfo designInfo = dcontextBeans[b].getDesignInfo();
            if (!(designInfo instanceof ComponentGroupDesignInfo) || designInfoSet.contains(designInfoClassName = designInfo.getClass().getName())) continue;
            designInfoSet.add(designInfoClassName);
            ComponentGroupDesignInfo componentGroupDesignInfo = (ComponentGroupDesignInfo)designInfo;
            ComponentGroupHolder[] designInfoHolders = componentGroupDesignInfo.getComponentGroupHolders();
            if (designInfoHolders == null) continue;
            holderList.addAll(Arrays.asList(designInfoHolders));
        }
        return holderList.toArray(new ComponentGroupHolder[holderList.size()]);
    }
}

